#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBooleanTexture_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCheckerboardSplatter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFastSplatter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGaussianSplatter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageCursor3D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRectilinearWipe_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageToPoints_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointLoad_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSampleFunction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkShepardMethod_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSliceCubes_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSurfaceReconstructionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTriangularTexture_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVoxelModeller_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkImagingHybridCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBooleanTexture_Init(csi);
  vtkCheckerboardSplatter_Init(csi);
  vtkFastSplatter_Init(csi);
  vtkGaussianSplatter_Init(csi);
  vtkImageCursor3D_Init(csi);
  vtkImageRectilinearWipe_Init(csi);
  vtkImageToPoints_Init(csi);
  vtkPointLoad_Init(csi);
  vtkSampleFunction_Init(csi);
  vtkShepardMethod_Init(csi);
  vtkSliceCubes_Init(csi);
  vtkSurfaceReconstructionFilter_Init(csi);
  vtkTriangularTexture_Init(csi);
  vtkVoxelModeller_Init(csi);
}
