// python wrapper for vtkNetworkAccessManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkNetworkAccessManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkNetworkAccessManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkNetworkAccessManager_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkNetworkAccessManager_ConnectionResult_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkNetworkAccessManager.ConnectionResult", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkNetworkAccessManager_ConnectionResult_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkNetworkAccessManager_ConnectionResult_Type, static_cast<int>(val));
}


static PyObject *
PyvtkNetworkAccessManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkNetworkAccessManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkNetworkAccessManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkNetworkAccessManager *tempr = vtkNetworkAccessManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkNetworkAccessManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkNetworkAccessManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkNetworkAccessManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkNetworkAccessManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_NewConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->NewConnection(temp0) :
      op->vtkNetworkAccessManager::NewConnection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkNetworkAccessManager_NewConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  typedef vtkNetworkAccessManager::ConnectionResult temp1_type;
  temp1_type temp1;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetEnumValue(temp1, "vtkNetworkAccessManager.ConnectionResult"))
  {
    vtkMultiProcessController *tempr = op->NewConnection(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkNetworkAccessManager_NewConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkNetworkAccessManager_NewConnection_s1(self, args);
    case 2:
      return PyvtkNetworkAccessManager_NewConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "NewConnection");
  return nullptr;
}


static PyObject *
PyvtkNetworkAccessManager_AbortPendingConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AbortPendingConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->AbortPendingConnection();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_ProcessEvents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessEvents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = op->ProcessEvents(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_GetNetworkEventsAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNetworkEventsAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    bool tempr = op->GetNetworkEventsAvailable();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_GetPendingConnectionsPresent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPendingConnectionsPresent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    bool tempr = op->GetPendingConnectionsPresent();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_DisableFurtherConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableFurtherConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->DisableFurtherConnections(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNetworkAccessManager_GetWrongConnectID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWrongConnectID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNetworkAccessManager *op = static_cast<vtkNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    bool tempr = op->GetWrongConnectID();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkNetworkAccessManager_Methods[] = {
  {"IsTypeOf", PyvtkNetworkAccessManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkNetworkAccessManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkNetworkAccessManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkNetworkAccessManager\nC++: static vtkNetworkAccessManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkNetworkAccessManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkNetworkAccessManager\nC++: vtkNetworkAccessManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkNetworkAccessManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkNetworkAccessManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"NewConnection", PyvtkNetworkAccessManager_NewConnection, METH_VARARGS,
   "NewConnection(self, url:str) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *NewConnection(\n    const char *url)\nNewConnection(self, url:str, result:ConnectionResult)\n    -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *NewConnection(\n    const char *url, ConnectionResult &result)\n\nCreates a new connection given the url. This call may block until\nthe connection can be established. To keep user-interfaces\nresponsive, one can listen to the vtkCommand::ProgressEvent fired\nperiodically by this class while waiting. The result arg provide\ninformation about the failure or sucess of the connection, see\nvtkNetworkAccessManager::ConnectionResult for possible values.\n\n* vtkNetworkAccessManager can  be waiting for atmost one\n  connection at a\n* time. Calling NewConnection() while another connection is\n  pending will\n* raise an error.\n\n* To abort the connection and cancel the waiting, simply call\n* AbortPendingConnection() in the vtkCommand::ProgressEvent\n  callback.\n\n* Returns the new connection instance on success, otherwise\n  nullptr.\n\n* URLs are of the following form:\n* \\<transport>://<address>\n* * tcp://<hostname>:<port>\n* * tcp://localhost:<port>/listen -- listen for connection on\n  port.\n* * tcp://localhost:<port>/listenmultiple -- listen for multiple\n* Examples:\n* * tcp://medea:12345\n* * tcp://localhost:12345/listen\n* * ssh://utkarsh@medea\n* * http://kitware-server/session?id=12322&authorization=12\n"},
  {"AbortPendingConnection", PyvtkNetworkAccessManager_AbortPendingConnection, METH_VARARGS,
   "AbortPendingConnection(self) -> None\nC++: virtual void AbortPendingConnection()\n\nUsed to abort pending connection creation, if any. Refer to\nNewConnection() for details.\n"},
  {"ProcessEvents", PyvtkNetworkAccessManager_ProcessEvents, METH_VARARGS,
   "ProcessEvents(self, timeout_msecs:int) -> int\nC++: virtual int ProcessEvents(unsigned long timeout_msecs)\n\nProcess any network activity.\n"},
  {"GetNetworkEventsAvailable", PyvtkNetworkAccessManager_GetNetworkEventsAvailable, METH_VARARGS,
   "GetNetworkEventsAvailable(self) -> bool\nC++: virtual bool GetNetworkEventsAvailable()\n\nPeeks to check if any activity is available. When this call\nreturns true, ProcessEvents() will always result in some activity\nprocessing if called afterword.\n"},
  {"GetPendingConnectionsPresent", PyvtkNetworkAccessManager_GetPendingConnectionsPresent, METH_VARARGS,
   "GetPendingConnectionsPresent(self) -> bool\nC++: virtual bool GetPendingConnectionsPresent()\n\nReturns true is the manager is currently waiting for any\nconnections.\n"},
  {"DisableFurtherConnections", PyvtkNetworkAccessManager_DisableFurtherConnections, METH_VARARGS,
   "DisableFurtherConnections(self, port:int, disable:bool) -> None\nC++: virtual void DisableFurtherConnections(int port,\n    bool disable)\n\nEnable/disable further connections for given port.\n"},
  {"GetWrongConnectID", PyvtkNetworkAccessManager_GetWrongConnectID, METH_VARARGS,
   "GetWrongConnectID(self) -> bool\nC++: virtual bool GetWrongConnectID()\n\nReturns true if the last check of connect ids was wrong.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkNetworkAccessManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("network_events_available"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkNetworkAccessManager_GetNetworkEventsAvailable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNetworkEventsAvailable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pending_connections_present"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkNetworkAccessManager_GetPendingConnectionsPresent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPendingConnectionsPresent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("wrong_connect_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkNetworkAccessManager_GetWrongConnectID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetWrongConnectID\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkNetworkAccessManager_Doc =
  "vtkNetworkAccessManager - vtkNetworkAccessManager is used to create\nnew connections and monitor activity of those connections.\n\n"
  "Superclass: vtkObject\n\n"
  "This is an abstract class that defines the interface. Concrete\n"
  "implementations of this class can be written to support tcp/ip socket\n"
  "or ssl or ssh based network connections among processes.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkNetworkAccessManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkNetworkAccessManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkNetworkAccessManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkNetworkAccessManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkNetworkAccessManager_Type, PyvtkNetworkAccessManager_Methods,
    "vtkNetworkAccessManager",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkNetworkAccessManager_ConnectionResult_Type);
  // members of vtkNetworkAccessManager::ConnectionResult
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyvtkNetworkAccessManager_ConnectionResult_Type.tp_dict = enumdict;

    typedef vtkNetworkAccessManager::ConnectionResult cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[5] = {
      { "CONNECTION_SUCCESS", cxx_enum_type::CONNECTION_SUCCESS },
      { "CONNECTION_TIMEOUT", cxx_enum_type::CONNECTION_TIMEOUT },
      { "CONNECTION_ABORT", cxx_enum_type::CONNECTION_ABORT },
      { "CONNECTION_HANDSHAKE_ERROR", cxx_enum_type::CONNECTION_HANDSHAKE_ERROR },
      { "CONNECTION_FAILURE", cxx_enum_type::CONNECTION_FAILURE },
    };

    for (int c = 0; c < 5; c++)
    {
      enumval = PyvtkNetworkAccessManager_ConnectionResult_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyvtkNetworkAccessManager_ConnectionResult_Type, "vtkNetworkAccessManager.ConnectionResult");

  o = (PyObject *)&PyvtkNetworkAccessManager_ConnectionResult_Type;
  if (PyDict_SetItemString(d, "ConnectionResult", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkNetworkAccessManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkNetworkAccessManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkNetworkAccessManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkNetworkAccessManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

