// python wrapper for vtkPVComparativeAnimationCue
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVComparativeAnimationCue.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVComparativeAnimationCue(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVComparativeAnimationCue_ClassNew(); }


static PyObject *
PyvtkPVComparativeAnimationCue_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVComparativeAnimationCue::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVComparativeAnimationCue::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVComparativeAnimationCue *tempr = vtkPVComparativeAnimationCue::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVComparativeAnimationCue *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVComparativeAnimationCue::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVComparativeAnimationCue::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVComparativeAnimationCue::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_SetAnimatedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimatedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetAnimatedProxy(temp0);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::SetAnimatedProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetAnimatedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimatedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetAnimatedProxy() :
      op->vtkPVComparativeAnimationCue::GetAnimatedProxy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_RemoveAnimatedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAnimatedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAnimatedProxy();
    }
    else
    {
      op->vtkPVComparativeAnimationCue::RemoveAnimatedProxy();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_SetAnimatedPropertyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimatedPropertyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimatedPropertyName(temp0);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::SetAnimatedPropertyName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetAnimatedPropertyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimatedPropertyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetAnimatedPropertyName() :
      op->vtkPVComparativeAnimationCue::GetAnimatedPropertyName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_SetAnimatedDomainName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimatedDomainName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimatedDomainName(temp0);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::SetAnimatedDomainName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetAnimatedDomainName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimatedDomainName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetAnimatedDomainName() :
      op->vtkPVComparativeAnimationCue::GetAnimatedDomainName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_SetAnimatedElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimatedElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimatedElement(temp0);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::SetAnimatedElement(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetAnimatedElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimatedElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAnimatedElement() :
      op->vtkPVComparativeAnimationCue::GetAnimatedElement());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_SetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnabled(temp0);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::SetEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnabled() :
      op->vtkPVComparativeAnimationCue::GetEnabled());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_EnabledOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnabledOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnabledOn();
    }
    else
    {
      op->vtkPVComparativeAnimationCue::EnabledOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_EnabledOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnabledOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnabledOff();
    }
    else
    {
      op->vtkPVComparativeAnimationCue::EnabledOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_UpdateXRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateXRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->UpdateXRange(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateXRange(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateXRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateXRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<double> store2(2*size2);
  double *temp2 = store2.Data();
  double *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  unsigned int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetArray(temp2, size2) &&
      ap.GetValue(temp3))
  {
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->UpdateXRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateXRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateXRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVComparativeAnimationCue_UpdateXRange_s1(self, args);
    case 4:
      return PyvtkPVComparativeAnimationCue_UpdateXRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UpdateXRange");
  return nullptr;
}


static PyObject *
PyvtkPVComparativeAnimationCue_UpdateYRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateYRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->UpdateYRange(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateYRange(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateYRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateYRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<double> store2(2*size2);
  double *temp2 = store2.Data();
  double *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  unsigned int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetArray(temp2, size2) &&
      ap.GetValue(temp3))
  {
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->UpdateYRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateYRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateYRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVComparativeAnimationCue_UpdateYRange_s1(self, args);
    case 4:
      return PyvtkPVComparativeAnimationCue_UpdateYRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UpdateYRange");
  return nullptr;
}


static PyObject *
PyvtkPVComparativeAnimationCue_UpdateWholeRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateWholeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->UpdateWholeRange(temp0, temp1);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateWholeRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateWholeRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateWholeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  unsigned int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetValue(temp2))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->UpdateWholeRange(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateWholeRange(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateWholeRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateWholeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  unsigned int temp2;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->UpdateWholeRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateWholeRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateWholeRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVComparativeAnimationCue_UpdateWholeRange_s1(self, args);
    case 3:
      return PyvtkPVComparativeAnimationCue_UpdateWholeRange_s2(self, args);
    case 4:
      return PyvtkPVComparativeAnimationCue_UpdateWholeRange_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UpdateWholeRange");
  return nullptr;
}


static PyObject *
PyvtkPVComparativeAnimationCue_UpdateValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->UpdateValue(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateValue(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<double> store2(2*size2);
  double *temp2 = store2.Data();
  double *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  unsigned int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      ap.GetValue(temp3))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->UpdateValue(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateValue(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVComparativeAnimationCue_UpdateValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVComparativeAnimationCue_UpdateValue_s1(self, args);
    case 4:
      return PyvtkPVComparativeAnimationCue_UpdateValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UpdateValue");
  return nullptr;
}


static PyObject *
PyvtkPVComparativeAnimationCue_UpdateAnimatedValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateAnimatedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->UpdateAnimatedValue(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVComparativeAnimationCue::UpdateAnimatedValue(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    double tempr = (ap.IsBound() ?
      op->GetValue(temp0, temp1, temp2, temp3) :
      op->vtkPVComparativeAnimationCue::GetValue(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_GetValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  unsigned int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    double *tempr = (ap.IsBound() ?
      op->GetValues(temp0, temp1, temp2, temp3, temp4) :
      op->vtkPVComparativeAnimationCue::GetValues(temp0, temp1, temp2, temp3, temp4));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(4, temp4);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_AppendCommandInfo(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AppendCommandInfo");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->AppendCommandInfo(temp0) :
      op->vtkPVComparativeAnimationCue::AppendCommandInfo(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVComparativeAnimationCue_LoadCommandInfo(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadCommandInfo");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVComparativeAnimationCue *op = static_cast<vtkPVComparativeAnimationCue *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    int tempr = (ap.IsBound() ?
      op->LoadCommandInfo(temp0) :
      op->vtkPVComparativeAnimationCue::LoadCommandInfo(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVComparativeAnimationCue_Methods[] = {
  {"IsTypeOf", PyvtkPVComparativeAnimationCue_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVComparativeAnimationCue_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVComparativeAnimationCue_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVComparativeAnimationCue\nC++: static vtkPVComparativeAnimationCue *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVComparativeAnimationCue_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVComparativeAnimationCue\nC++: vtkPVComparativeAnimationCue *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVComparativeAnimationCue_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVComparativeAnimationCue_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetAnimatedProxy", PyvtkPVComparativeAnimationCue_SetAnimatedProxy, METH_VARARGS,
   "SetAnimatedProxy(self, __a:vtkSMProxy) -> None\nC++: void SetAnimatedProxy(vtkSMProxy *)\n\nSet/Get the animated proxy.\n"},
  {"GetAnimatedProxy", PyvtkPVComparativeAnimationCue_GetAnimatedProxy, METH_VARARGS,
   "GetAnimatedProxy(self) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetAnimatedProxy()\n\n"},
  {"RemoveAnimatedProxy", PyvtkPVComparativeAnimationCue_RemoveAnimatedProxy, METH_VARARGS,
   "RemoveAnimatedProxy(self) -> None\nC++: void RemoveAnimatedProxy()\n\n"},
  {"SetAnimatedPropertyName", PyvtkPVComparativeAnimationCue_SetAnimatedPropertyName, METH_VARARGS,
   "SetAnimatedPropertyName(self, _arg:str) -> None\nC++: virtual void SetAnimatedPropertyName(const char *_arg)\n\nSet/Get the animated property name.\n"},
  {"GetAnimatedPropertyName", PyvtkPVComparativeAnimationCue_GetAnimatedPropertyName, METH_VARARGS,
   "GetAnimatedPropertyName(self) -> str\nC++: virtual char *GetAnimatedPropertyName()\n\n"},
  {"SetAnimatedDomainName", PyvtkPVComparativeAnimationCue_SetAnimatedDomainName, METH_VARARGS,
   "SetAnimatedDomainName(self, _arg:str) -> None\nC++: virtual void SetAnimatedDomainName(const char *_arg)\n\nSet/Get the animated domain name.\n"},
  {"GetAnimatedDomainName", PyvtkPVComparativeAnimationCue_GetAnimatedDomainName, METH_VARARGS,
   "GetAnimatedDomainName(self) -> str\nC++: virtual char *GetAnimatedDomainName()\n\n"},
  {"SetAnimatedElement", PyvtkPVComparativeAnimationCue_SetAnimatedElement, METH_VARARGS,
   "SetAnimatedElement(self, _arg:int) -> None\nC++: virtual void SetAnimatedElement(int _arg)\n\nThe index of the element of the property this cue animates. If\nthe index is -1, the cue will animate all the elements of the\nanimated property.\n"},
  {"GetAnimatedElement", PyvtkPVComparativeAnimationCue_GetAnimatedElement, METH_VARARGS,
   "GetAnimatedElement(self) -> int\nC++: virtual int GetAnimatedElement()\n\n"},
  {"SetEnabled", PyvtkPVComparativeAnimationCue_SetEnabled, METH_VARARGS,
   "SetEnabled(self, _arg:bool) -> None\nC++: virtual void SetEnabled(bool _arg)\n\nEnable/Disable the cue.\n"},
  {"GetEnabled", PyvtkPVComparativeAnimationCue_GetEnabled, METH_VARARGS,
   "GetEnabled(self) -> bool\nC++: virtual bool GetEnabled()\n\n"},
  {"EnabledOn", PyvtkPVComparativeAnimationCue_EnabledOn, METH_VARARGS,
   "EnabledOn(self) -> None\nC++: virtual void EnabledOn()\n\n"},
  {"EnabledOff", PyvtkPVComparativeAnimationCue_EnabledOff, METH_VARARGS,
   "EnabledOff(self) -> None\nC++: virtual void EnabledOff()\n\n"},
  {"UpdateXRange", PyvtkPVComparativeAnimationCue_UpdateXRange, METH_VARARGS,
   "UpdateXRange(self, y:int, minx:float, maxx:float) -> None\nC++: void UpdateXRange(int y, double minx, double maxx)\nUpdateXRange(self, y:int, minx:[float, ...], maxx:[float, ...],\n    numvalues:int) -> None\nC++: void UpdateXRange(int y, double *minx, double *maxx,\n    unsigned int numvalues)\n\nMethods use to fill up the values for the parameter over the\ncomparative grid. These are order dependent methods i.e. the\nresult of calling UpdateXRange() and then UpdateYRange() are\ndifferent from calling UpdateYRange() and then UpdateXRange().\nThese methods are convenience methods when the value can only be\na single value.\n"},
  {"UpdateYRange", PyvtkPVComparativeAnimationCue_UpdateYRange, METH_VARARGS,
   "UpdateYRange(self, x:int, miny:float, maxy:float) -> None\nC++: void UpdateYRange(int x, double miny, double maxy)\nUpdateYRange(self, x:int, minx:[float, ...], maxx:[float, ...],\n    numvalues:int) -> None\nC++: void UpdateYRange(int x, double *minx, double *maxx,\n    unsigned int numvalues)\n\n"},
  {"UpdateWholeRange", PyvtkPVComparativeAnimationCue_UpdateWholeRange, METH_VARARGS,
   "UpdateWholeRange(self, mint:float, maxt:float) -> None\nC++: void UpdateWholeRange(double mint, double maxt)\nUpdateWholeRange(self, mint:[float, ...], maxt:[float, ...],\n    numValues:int) -> None\nC++: void UpdateWholeRange(double *mint, double *maxt,\n    unsigned int numValues)\nUpdateWholeRange(self, mint:[float, ...], maxt:[float, ...],\n    numValues:int, vertical_first:bool) -> None\nC++: void UpdateWholeRange(double *mint, double *maxt,\n    unsigned int numValues, bool vertical_first)\n\n"},
  {"UpdateValue", PyvtkPVComparativeAnimationCue_UpdateValue, METH_VARARGS,
   "UpdateValue(self, x:int, y:int, value:float) -> None\nC++: void UpdateValue(int x, int y, double value)\nUpdateValue(self, x:int, y:int, value:[float, ...], numValues:int)\n     -> None\nC++: void UpdateValue(int x, int y, double *value,\n    unsigned int numValues)\n\n"},
  {"UpdateAnimatedValue", PyvtkPVComparativeAnimationCue_UpdateAnimatedValue, METH_VARARGS,
   "UpdateAnimatedValue(self, x:int, y:int, dx:int, dy:int) -> None\nC++: void UpdateAnimatedValue(int x, int y, int dx, int dy)\n\nUpdate the animated property's value based on those specified\nusing the Update.* methods. (x,y) is the location in the\ncomparative grid, while (dx, dy) are the dimensions of the\ncomparative grid.\n"},
  {"GetValue", PyvtkPVComparativeAnimationCue_GetValue, METH_VARARGS,
   "GetValue(self, x:int, y:int, dx:int, dy:int) -> float\nC++: double GetValue(int x, int y, int dx, int dy)\n\nComputes the value for a particular location in the comparative\ngrid. (x,y) is the location in the comparative grid, while (dx,\ndy) are the dimensions of the comparative grid.\n"},
  {"GetValues", PyvtkPVComparativeAnimationCue_GetValues, METH_VARARGS,
   "GetValues(self, x:int, y:int, dx:int, dy:int, numValues:int)\n    -> Pointer\nC++: double *GetValues(int x, int y, int dx, int dy,\n    unsigned int &numValues)\n\nNOTE: Returned values is only valid until the next call to this\nmethod. Return value is only valid when numValues > 0.\n"},
  {"AppendCommandInfo", PyvtkPVComparativeAnimationCue_AppendCommandInfo, METH_VARARGS,
   "AppendCommandInfo(self, proxyElem:vtkPVXMLElement)\n    -> vtkPVXMLElement\nC++: vtkPVXMLElement *AppendCommandInfo(\n    vtkPVXMLElement *proxyElem)\n\n"},
  {"LoadCommandInfo", PyvtkPVComparativeAnimationCue_LoadCommandInfo, METH_VARARGS,
   "LoadCommandInfo(self, proxyElement:vtkPVXMLElement) -> int\nC++: int LoadCommandInfo(vtkPVXMLElement *proxyElement)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVComparativeAnimationCue_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("animated_proxy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVComparativeAnimationCue_GetAnimatedProxy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedProxy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedProxy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimatedProxy/SetAnimatedProxy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animated_property_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVComparativeAnimationCue_GetAnimatedPropertyName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedPropertyName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedPropertyName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimatedPropertyName/SetAnimatedPropertyName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animated_domain_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVComparativeAnimationCue_GetAnimatedDomainName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedDomainName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedDomainName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimatedDomainName/SetAnimatedDomainName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animated_element"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVComparativeAnimationCue_GetAnimatedElement(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedElement(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVComparativeAnimationCue_SetAnimatedElement(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimatedElement/SetAnimatedElement\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enabled"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVComparativeAnimationCue_GetEnabled(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVComparativeAnimationCue_SetEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVComparativeAnimationCue_SetEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnabled/SetEnabled\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVComparativeAnimationCue_Doc =
  "vtkPVComparativeAnimationCue - cue used for parameter animation by\nthe comparative view.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVComparativeAnimationCue is a animation cue used for parameter\n"
  "animation by the ComparativeView. It provides a non-conventional API\n"
  "i.e. without using properties to allow the user to setup parameter\n"
  "values over the comparative grid.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVComparativeAnimationCue_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVComparativeAnimationCue", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVComparativeAnimationCue_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVComparativeAnimationCue_StaticNew()
{
  return vtkPVComparativeAnimationCue::New();
}

PyObject *PyvtkPVComparativeAnimationCue_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVComparativeAnimationCue_Type, PyvtkPVComparativeAnimationCue_Methods,
    "vtkPVComparativeAnimationCue",
 &PyvtkPVComparativeAnimationCue_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVComparativeAnimationCue_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVComparativeAnimationCue(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVComparativeAnimationCue_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVComparativeAnimationCue", o) != 0)
  {
    Py_DECREF(o);
  }

}

