// python wrapper for vtkPVCompositeRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVCompositeRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVCompositeRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVCompositeRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkCompositeRepresentation_ClassNew
extern "C" { PyObject *PyvtkCompositeRepresentation_ClassNew(); }
#define DECLARED_PyvtkCompositeRepresentation_ClassNew
#endif

static PyObject *
PyvtkPVCompositeRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVCompositeRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVCompositeRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVCompositeRepresentation *tempr = vtkPVCompositeRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVCompositeRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVCompositeRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVCompositeRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVCompositeRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetSelectionRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectionRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  vtkSelectionRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSelectionRepresentation"))
  {
    if (ap.IsBound())
    {
      op->SetSelectionRepresentation(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetSelectionRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetGridAxesRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridAxesRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  vtkPVGridAxes3DRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVGridAxes3DRepresentation"))
  {
    if (ap.IsBound())
    {
      op->SetGridAxesRepresentation(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetGridAxesRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetPolarAxesRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxesRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  vtkPolarAxesRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPolarAxesRepresentation"))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxesRepresentation(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetPolarAxesRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_MarkModified(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MarkModified");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MarkModified();
    }
    else
    {
      op->vtkPVCompositeRepresentation::MarkModified();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetSelectionVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectionVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectionVisibility(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetSelectionVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetPolarAxesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxesVisibility(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetPolarAxesVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetUpdateTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUpdateTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUpdateTime(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetUpdateTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetForceUseCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceUseCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceUseCache(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetForceUseCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetForcedCacheKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForcedCacheKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForcedCacheKey(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetForcedCacheKey(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetInputConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVCompositeRepresentation_SetInputConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetInputConnection(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetInputConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVCompositeRepresentation_SetInputConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVCompositeRepresentation_SetInputConnection_s1(self, args);
    case 1:
      return PyvtkPVCompositeRepresentation_SetInputConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputConnection");
  return nullptr;
}


static PyObject *
PyvtkPVCompositeRepresentation_AddInputConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkPVCompositeRepresentation::AddInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVCompositeRepresentation_AddInputConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddInputConnection(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::AddInputConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVCompositeRepresentation_AddInputConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVCompositeRepresentation_AddInputConnection_s1(self, args);
    case 1:
      return PyvtkPVCompositeRepresentation_AddInputConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddInputConnection");
  return nullptr;
}


static PyObject *
PyvtkPVCompositeRepresentation_RemoveInputConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->RemoveInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkPVCompositeRepresentation::RemoveInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVCompositeRepresentation_RemoveInputConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RemoveInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkPVCompositeRepresentation::RemoveInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVCompositeRepresentation_RemoveInputConnection_Methods[] = {
  {"RemoveInputConnection", PyvtkPVCompositeRepresentation_RemoveInputConnection_s1, METH_VARARGS,
   "@iV *vtkAlgorithmOutput"},
  {"RemoveInputConnection", PyvtkPVCompositeRepresentation_RemoveInputConnection_s2, METH_VARARGS,
   "@ii"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVCompositeRepresentation_RemoveInputConnection(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVCompositeRepresentation_RemoveInputConnection_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RemoveInputConnection");
  return nullptr;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetPointFieldDataArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointFieldDataArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointFieldDataArrayName(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetPointFieldDataArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_SetCellFieldDataArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellFieldDataArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellFieldDataArrayName(temp0);
    }
    else
    {
      op->vtkPVCompositeRepresentation::SetCellFieldDataArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCompositeRepresentation_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCompositeRepresentation *op = static_cast<vtkPVCompositeRepresentation *>(vp);

  unsigned int temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->Initialize(temp0, temp1) :
      op->vtkPVCompositeRepresentation::Initialize(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVCompositeRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkPVCompositeRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVCompositeRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVCompositeRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVCompositeRepresentation\nC++: static vtkPVCompositeRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVCompositeRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVCompositeRepresentation\nC++: vtkPVCompositeRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVCompositeRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVCompositeRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSelectionRepresentation", PyvtkPVCompositeRepresentation_SetSelectionRepresentation, METH_VARARGS,
   "SetSelectionRepresentation(self, __a:vtkSelectionRepresentation)\n    -> None\nC++: void SetSelectionRepresentation(vtkSelectionRepresentation *)\n\nThese must only be set during initialization before adding the\nrepresentation to any views or calling Update().\n"},
  {"SetGridAxesRepresentation", PyvtkPVCompositeRepresentation_SetGridAxesRepresentation, METH_VARARGS,
   "SetGridAxesRepresentation(self, __a:vtkPVGridAxes3DRepresentation)\n     -> None\nC++: void SetGridAxesRepresentation(\n    vtkPVGridAxes3DRepresentation *)\n\n"},
  {"SetPolarAxesRepresentation", PyvtkPVCompositeRepresentation_SetPolarAxesRepresentation, METH_VARARGS,
   "SetPolarAxesRepresentation(self, __a:vtkPolarAxesRepresentation)\n    -> None\nC++: void SetPolarAxesRepresentation(vtkPolarAxesRepresentation *)\n\nThis must only be set during initialization before adding the\nrepresentation to any views or calling Update().\n"},
  {"MarkModified", PyvtkPVCompositeRepresentation_MarkModified, METH_VARARGS,
   "MarkModified(self) -> None\nC++: void MarkModified() override;\n\nPropagate the modification to all internal representations.\n"},
  {"SetVisibility", PyvtkPVCompositeRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, visible:bool) -> None\nC++: void SetVisibility(bool visible) override;\n\nSet visibility of the representation. Overridden to update the\ncube-axes and selection visibilities.\n"},
  {"SetSelectionVisibility", PyvtkPVCompositeRepresentation_SetSelectionVisibility, METH_VARARGS,
   "SetSelectionVisibility(self, visible:bool) -> None\nC++: virtual void SetSelectionVisibility(bool visible)\n\nSet the selection visibility.\n"},
  {"SetPolarAxesVisibility", PyvtkPVCompositeRepresentation_SetPolarAxesVisibility, METH_VARARGS,
   "SetPolarAxesVisibility(self, visible:bool) -> None\nC++: virtual void SetPolarAxesVisibility(bool visible)\n\nSet the polar axes visibility.\n"},
  {"SetUpdateTime", PyvtkPVCompositeRepresentation_SetUpdateTime, METH_VARARGS,
   "SetUpdateTime(self, time:float) -> None\nC++: void SetUpdateTime(double time) override;\n\nPassed on to internal representations as well.\n"},
  {"SetForceUseCache", PyvtkPVCompositeRepresentation_SetForceUseCache, METH_VARARGS,
   "SetForceUseCache(self, val:bool) -> None\nC++: void SetForceUseCache(bool val) override;\n\n"},
  {"SetForcedCacheKey", PyvtkPVCompositeRepresentation_SetForcedCacheKey, METH_VARARGS,
   "SetForcedCacheKey(self, val:float) -> None\nC++: void SetForcedCacheKey(double val) override;\n\nGenerally, caching is within the purview of the vtkPVView (and\nsubclasses). However, a representation may choose to override\nthat caching by forcing specific caching parameters. This is\nprimarily intended for views like comparative view that rely on\ncaching to show multiple frames from the same pipeline at a time.\n"},
  {"SetInputConnection", PyvtkPVCompositeRepresentation_SetInputConnection, METH_VARARGS,
   "SetInputConnection(self, port:int, input:vtkAlgorithmOutput)\n    -> None\nC++: void SetInputConnection(int port, vtkAlgorithmOutput *input)\n    override;\nSetInputConnection(self, input:vtkAlgorithmOutput) -> None\nC++: void SetInputConnection(vtkAlgorithmOutput *input) override;\n\nOverridden to simply pass the input to the internal\nrepresentations. We won't need this if vtkPVDataRepresentation\ncorrectly respected in the arguments passed to it during\nProcessRequest() etc.\n"},
  {"AddInputConnection", PyvtkPVCompositeRepresentation_AddInputConnection, METH_VARARGS,
   "AddInputConnection(self, port:int, input:vtkAlgorithmOutput)\n    -> None\nC++: void AddInputConnection(int port, vtkAlgorithmOutput *input)\n    override;\nAddInputConnection(self, input:vtkAlgorithmOutput) -> None\nC++: void AddInputConnection(vtkAlgorithmOutput *input) override;\n\nAdd a connection to the given input port index.  See\nSetInputConnection() for details on input connections.  This\nmethod is the complement to RemoveInputConnection() in that it\nadds only the connection specified without affecting other\nconnections.  Typical usage is\n\n* filter2->AddInputConnection(0, filter1->GetOutputPort(0)).\n"},
  {"RemoveInputConnection", PyvtkPVCompositeRepresentation_RemoveInputConnection, METH_VARARGS,
   "RemoveInputConnection(self, port:int, input:vtkAlgorithmOutput)\n    -> None\nC++: void RemoveInputConnection(int port,\n    vtkAlgorithmOutput *input) override;\nRemoveInputConnection(self, port:int, idx:int) -> None\nC++: void RemoveInputConnection(int port, int idx) override;\n\nRemove a connection from the given input port index.  See\nSetInputConnection() for details on input connection.  This\nmethod is the complement to AddInputConnection() in that it\nremoves only the connection specified without affecting other\nconnections.  Typical usage is\n\n* filter2->RemoveInputConnection(0, filter1->GetOutputPort(0)).\n"},
  {"SetPointFieldDataArrayName", PyvtkPVCompositeRepresentation_SetPointFieldDataArrayName, METH_VARARGS,
   "SetPointFieldDataArrayName(self, __a:str) -> None\nC++: virtual void SetPointFieldDataArrayName(const char *)\n\nForwarded to vtkSelectionRepresentation.\n"},
  {"SetCellFieldDataArrayName", PyvtkPVCompositeRepresentation_SetCellFieldDataArrayName, METH_VARARGS,
   "SetCellFieldDataArrayName(self, __a:str) -> None\nC++: virtual void SetCellFieldDataArrayName(const char *)\n\n"},
  {"Initialize", PyvtkPVCompositeRepresentation_Initialize, METH_VARARGS,
   "Initialize(self, minIdAvailable:int, maxIdAvailable:int) -> int\nC++: unsigned int Initialize(unsigned int minIdAvailable,\n    unsigned int maxIdAvailable) override;\n\nOverride because of internal composite representations that need\nto be initialized as well.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVCompositeRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("selection_representation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetSelectionRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetSelectionRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSelectionRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grid_axes_representation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetGridAxesRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetGridAxesRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGridAxesRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axes_representation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetPolarAxesRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetPolarAxesRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxesRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selection_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetSelectionVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetSelectionVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSelectionVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axes_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetPolarAxesVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetPolarAxesVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxesVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("update_time"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetUpdateTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetUpdateTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUpdateTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_use_cache"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetForceUseCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetForceUseCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetForceUseCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("forced_cache_key"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetForcedCacheKey(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetForcedCacheKey(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetForcedCacheKey\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_connection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetInputConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetInputConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_field_data_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetPointFieldDataArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetPointFieldDataArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointFieldDataArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_field_data_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVCompositeRepresentation_SetCellFieldDataArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVCompositeRepresentation_SetCellFieldDataArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellFieldDataArrayName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVCompositeRepresentation_Doc =
  "vtkPVCompositeRepresentation - a data-representation used by ParaView.\n\n"
  "Superclass: vtkCompositeRepresentation\n\n"
  "vtkPVCompositeRepresentation is a data-representation used by\n"
  "ParaView for showing a type of data-set in the render view. It is a\n"
  "composite-representation with some fixed representations for showing\n"
  "things like selection and polar axes. This representation has 1 input\n"
  "port and it ensures that that input is passed on to the internal\n"
  "representations (except SelectionRepresentation and\n"
  "PolarAxesRepresentation) properly. For SelectionRepresentation and\n"
  "PolarAxesRepresentation the client is expected to setup the input\n"
  "(look at vtkSMPVRepresentationProxy).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVCompositeRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVCompositeRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVCompositeRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVCompositeRepresentation_StaticNew()
{
  return vtkPVCompositeRepresentation::New();
}

PyObject *PyvtkPVCompositeRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVCompositeRepresentation_Type, PyvtkPVCompositeRepresentation_Methods,
    "vtkPVCompositeRepresentation",
 &PyvtkPVCompositeRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkCompositeRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVCompositeRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVCompositeRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVCompositeRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVCompositeRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

