/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 114 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"

#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"
#line 90 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qmargins.sip"
#include <qmargins.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 154 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 41 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"


PyDoc_STRVAR(doc_QSizeF_transpose, "transpose(self)");

extern "C" {static PyObject *meth_QSizeF_transpose(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_transpose(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            sipCpp->transpose();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_transpose, doc_QSizeF_transpose);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_scale, "scale(self, s: QSizeF, mode: Qt.AspectRatioMode)\n"
"scale(self, w: float, h: float, mode: Qt.AspectRatioMode)");

extern "C" {static PyObject *meth_QSizeF_scale(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_scale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        ::Qt::AspectRatioMode a1;
        ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9E", &sipSelf, sipType_QSizeF, &sipCpp, sipType_QSizeF, &a0, sipType_Qt_AspectRatioMode, &a1))
        {
            sipCpp->scale(*a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::qreal a0;
        ::qreal a1;
        ::Qt::AspectRatioMode a2;
        ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BddE", &sipSelf, sipType_QSizeF, &sipCpp, &a0, &a1, sipType_Qt_AspectRatioMode, &a2))
        {
            sipCpp->scale(a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_scale, doc_QSizeF_scale);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QSizeF_isNull(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_isNull, doc_QSizeF_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QSizeF_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_isEmpty, doc_QSizeF_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QSizeF_isValid(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_isValid, doc_QSizeF_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_width, "width(self) -> float");

extern "C" {static PyObject *meth_QSizeF_width(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->width();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_width, doc_QSizeF_width);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_height, "height(self) -> float");

extern "C" {static PyObject *meth_QSizeF_height(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->height();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_height, doc_QSizeF_height);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_setWidth, "setWidth(self, w: float)");

extern "C" {static PyObject *meth_QSizeF_setWidth(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_setWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QSizeF, &sipCpp, &a0))
        {
            sipCpp->setWidth(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_setWidth, doc_QSizeF_setWidth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_setHeight, "setHeight(self, h: float)");

extern "C" {static PyObject *meth_QSizeF_setHeight(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_setHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QSizeF, &sipCpp, &a0))
        {
            sipCpp->setHeight(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_setHeight, doc_QSizeF_setHeight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_expandedTo, "expandedTo(self, otherSize: QSizeF) -> QSizeF");

extern "C" {static PyObject *meth_QSizeF_expandedTo(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_expandedTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QSizeF, &sipCpp, sipType_QSizeF, &a0))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->expandedTo(*a0));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_expandedTo, doc_QSizeF_expandedTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_boundedTo, "boundedTo(self, otherSize: QSizeF) -> QSizeF");

extern "C" {static PyObject *meth_QSizeF_boundedTo(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_boundedTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QSizeF, &sipCpp, sipType_QSizeF, &a0))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->boundedTo(*a0));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_boundedTo, doc_QSizeF_boundedTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_toSize, "toSize(self) -> QSize");

extern "C" {static PyObject *meth_QSizeF_toSize(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_toSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->toSize());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_toSize, doc_QSizeF_toSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_scaled, "scaled(self, s: QSizeF, mode: Qt.AspectRatioMode) -> QSizeF\n"
"scaled(self, w: float, h: float, mode: Qt.AspectRatioMode) -> QSizeF");

extern "C" {static PyObject *meth_QSizeF_scaled(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_scaled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        ::Qt::AspectRatioMode a1;
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9E", &sipSelf, sipType_QSizeF, &sipCpp, sipType_QSizeF, &a0, sipType_Qt_AspectRatioMode, &a1))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->scaled(*a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    {
        ::qreal a0;
        ::qreal a1;
        ::Qt::AspectRatioMode a2;
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BddE", &sipSelf, sipType_QSizeF, &sipCpp, &a0, &a1, sipType_Qt_AspectRatioMode, &a2))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->scaled(a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_scaled, doc_QSizeF_scaled);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_transposed, "transposed(self) -> QSizeF");

extern "C" {static PyObject *meth_QSizeF_transposed(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_transposed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSizeF, &sipCpp))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->transposed());

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_transposed, doc_QSizeF_transposed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_grownBy, "grownBy(self, m: QMarginsF) -> QSizeF");

extern "C" {static PyObject *meth_QSizeF_grownBy(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_grownBy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QMarginsF* a0;
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QSizeF, &sipCpp, sipType_QMarginsF, &a0))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->grownBy(*a0));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_grownBy, doc_QSizeF_grownBy);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSizeF_shrunkBy, "shrunkBy(self, m: QMarginsF) -> QSizeF");

extern "C" {static PyObject *meth_QSizeF_shrunkBy(PyObject *, PyObject *);}
static PyObject *meth_QSizeF_shrunkBy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QMarginsF* a0;
        const ::QSizeF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QSizeF, &sipCpp, sipType_QMarginsF, &a0))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->shrunkBy(*a0));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSizeF, sipName_shrunkBy, doc_QSizeF_shrunkBy);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QSizeF___eq__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSize* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSize, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QSizeF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSizeF, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QSizeF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QSizeF___ne__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSize* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSize, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QSizeF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSizeF, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QSizeF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QSizeF___add__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        const ::QSizeF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QSizeF, &a0, sipType_QSizeF, &a1))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF((*a0 + *a1));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QSizeF___sub__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        const ::QSizeF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QSizeF, &a0, sipType_QSizeF, &a1))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF((*a0 - *a1));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QSizeF___mul__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___mul__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        ::qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9d", sipType_QSizeF, &a0, &a1))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF((*a0 * a1));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    {
        ::qreal a0;
        const ::QSizeF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "dJ9", &a0, sipType_QSizeF, &a1))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF((a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QSizeF___truediv__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___truediv__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        ::qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9d", sipType_QSizeF, &a0, &a1))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF((*a0 / a1));

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QSizeF___itruediv__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___itruediv__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QSizeF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1d", &a0))
        {
            sipCpp->::QSizeF::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QSizeF___imul__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___imul__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QSizeF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1d", &a0))
        {
            sipCpp->::QSizeF::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QSizeF___isub__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___isub__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QSizeF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSizeF, &a0))
        {
            sipCpp->::QSizeF::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QSizeF___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QSizeF___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QSizeF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSizeF, &a0))
        {
            sipCpp->::QSizeF::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QSizeF___bool__(PyObject *);}
static int slot_QSizeF___bool__(PyObject *sipSelf)
{
    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 152 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
        sipRes = sipCpp->isValid();
#line 884 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QSizeF___repr__(PyObject *);}
static PyObject *slot_QSizeF___repr__(PyObject *sipSelf)
{
    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSizeF));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 129 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
        if (sipCpp->isNull())
        {
            sipRes = PyUnicode_FromString("PyQt6.QtCore.QSizeF()");
        }
        else
        {
            PyObject *w = PyFloat_FromDouble(sipCpp->width());
            PyObject *h = PyFloat_FromDouble(sipCpp->height());
        
            if (w && h)
                sipRes = PyUnicode_FromFormat(
                        "PyQt6.QtCore.QSizeF(%R, %R)", w, h);
        
            Py_XDECREF(w);
            Py_XDECREF(h);
        }
#line 924 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QSizeF(void *, int);}
static void release_QSizeF(void *sipCppV, int)
{
    delete reinterpret_cast< ::QSizeF *>(sipCppV);
}


extern "C" {static PyObject *pickle_QSizeF(void *);}
static PyObject *pickle_QSizeF(void *sipCppV)
{
    ::QSizeF *sipCpp = reinterpret_cast< ::QSizeF *>(sipCppV);
    PyObject *sipRes;

#line 118 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
    sipRes = Py_BuildValue("dd", sipCpp->width(), sipCpp->height());
#line 950 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQSizeF.cpp"

    return sipRes;
}


extern "C" {static void *array_QSizeF(Py_ssize_t);}
static void *array_QSizeF(Py_ssize_t sipNrElem)
{
    return new ::QSizeF[sipNrElem];
}


extern "C" {static void array_delete_QSizeF(void *);}
static void array_delete_QSizeF(void *sipCpp)
{
    delete[] reinterpret_cast< ::QSizeF *>(sipCpp);
}


extern "C" {static void assign_QSizeF(void *, Py_ssize_t, void *);}
static void assign_QSizeF(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QSizeF *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QSizeF *>(sipSrc);
}


extern "C" {static void *copy_QSizeF(const void *, Py_ssize_t);}
static void *copy_QSizeF(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QSizeF(reinterpret_cast<const ::QSizeF *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QSizeF(sipSimpleWrapper *);}
static void dealloc_QSizeF(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QSizeF(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QSizeF(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QSizeF(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QSizeF *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QSizeF();

            return sipCpp;
        }
    }

    {
        const ::QSize* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QSize, &a0))
        {
            sipCpp = new ::QSizeF(*a0);

            return sipCpp;
        }
    }

    {
        ::qreal a0;
        ::qreal a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "dd", &a0, &a1))
        {
            sipCpp = new ::QSizeF(a0, a1);

            return sipCpp;
        }
    }

    {
        const ::QSizeF* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QSizeF, &a0))
        {
            sipCpp = new ::QSizeF(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QSizeF[] = {
    {(void *)slot_QSizeF___eq__, eq_slot},
    {(void *)slot_QSizeF___ne__, ne_slot},
    {(void *)slot_QSizeF___add__, add_slot},
    {(void *)slot_QSizeF___sub__, sub_slot},
    {(void *)slot_QSizeF___mul__, mul_slot},
    {(void *)slot_QSizeF___truediv__, truediv_slot},
    {(void *)slot_QSizeF___itruediv__, itruediv_slot},
    {(void *)slot_QSizeF___imul__, imul_slot},
    {(void *)slot_QSizeF___isub__, isub_slot},
    {(void *)slot_QSizeF___iadd__, iadd_slot},
    {(void *)slot_QSizeF___bool__, bool_slot},
    {(void *)slot_QSizeF___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QSizeF[] = {
    {sipName_boundedTo, meth_QSizeF_boundedTo, METH_VARARGS, doc_QSizeF_boundedTo},
    {sipName_expandedTo, meth_QSizeF_expandedTo, METH_VARARGS, doc_QSizeF_expandedTo},
    {sipName_grownBy, meth_QSizeF_grownBy, METH_VARARGS, doc_QSizeF_grownBy},
    {sipName_height, meth_QSizeF_height, METH_VARARGS, doc_QSizeF_height},
    {sipName_isEmpty, meth_QSizeF_isEmpty, METH_VARARGS, doc_QSizeF_isEmpty},
    {sipName_isNull, meth_QSizeF_isNull, METH_VARARGS, doc_QSizeF_isNull},
    {sipName_isValid, meth_QSizeF_isValid, METH_VARARGS, doc_QSizeF_isValid},
    {sipName_scale, meth_QSizeF_scale, METH_VARARGS, doc_QSizeF_scale},
    {sipName_scaled, meth_QSizeF_scaled, METH_VARARGS, doc_QSizeF_scaled},
    {sipName_setHeight, meth_QSizeF_setHeight, METH_VARARGS, doc_QSizeF_setHeight},
    {sipName_setWidth, meth_QSizeF_setWidth, METH_VARARGS, doc_QSizeF_setWidth},
    {sipName_shrunkBy, meth_QSizeF_shrunkBy, METH_VARARGS, doc_QSizeF_shrunkBy},
    {sipName_toSize, meth_QSizeF_toSize, METH_VARARGS, doc_QSizeF_toSize},
    {sipName_transpose, meth_QSizeF_transpose, METH_VARARGS, doc_QSizeF_transpose},
    {sipName_transposed, meth_QSizeF_transposed, METH_VARARGS, doc_QSizeF_transposed},
    {sipName_width, meth_QSizeF_width, METH_VARARGS, doc_QSizeF_width}
};

PyDoc_STRVAR(doc_QSizeF, "\1QSizeF()\n"
"QSizeF(sz: QSize)\n"
"QSizeF(w: float, h: float)\n"
"QSizeF(a0: QSizeF)");


sipClassTypeDef sipTypeDef_QtCore_QSizeF = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QSizeF,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QSizeF,
        {0, 0, 1},
        16, methods_QSizeF,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QSizeF,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QSizeF,
    init_type_QSizeF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QSizeF,
    assign_QSizeF,
    array_QSizeF,
    copy_QSizeF,
    release_QSizeF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QSizeF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QSizeF,
    sizeof (::QSizeF),
};
