/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 418 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_std_pair.sip"
#include <utility>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCorestdpair24002400.cpp"



extern "C" {static void assign_std_pair_2400_2400(void *, Py_ssize_t, void *);}
static void assign_std_pair_2400_2400(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::std::pair< ::qreal, ::qreal> *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::std::pair< ::qreal, ::qreal> *>(sipSrc);
}


extern "C" {static void *array_std_pair_2400_2400(Py_ssize_t);}
static void *array_std_pair_2400_2400(Py_ssize_t sipNrElem)
{
    return new ::std::pair< ::qreal, ::qreal>[sipNrElem];
}


extern "C" {static void *copy_std_pair_2400_2400(const void *, Py_ssize_t);}
static void *copy_std_pair_2400_2400(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::std::pair< ::qreal, ::qreal>(reinterpret_cast<const ::std::pair< ::qreal, ::qreal> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_std_pair_2400_2400(void *, int, void *);}
static void release_std_pair_2400_2400(void *sipCppV, int, void *)
{
    ::std::pair< ::qreal, ::qreal> *sipCpp = reinterpret_cast< ::std::pair< ::qreal, ::qreal> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_std_pair_2400_2400(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_std_pair_2400_2400(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    ::std::pair< ::qreal, ::qreal> **sipCppPtr = reinterpret_cast< ::std::pair< ::qreal, ::qreal> **>(sipCppPtrV);

#line 426 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_std_pair.sip"
    if (!sipIsErr)
        return (PySequence_Check(sipPy) && !PyUnicode_Check(sipPy));

    Py_ssize_t len = PySequence_Size(sipPy);

    if (len != 2)
    {
        // A negative length should only be an internal error so let the
        // original exception stand.
        if (len >= 0)
            PyErr_Format(PyExc_TypeError,
                    "sequence has %zd elements but 2 elements are expected",
                    len);

        *sipIsErr = 1;

        return 0;
    }

    PyObject *firstobj = PySequence_GetItem(sipPy, 0);

    if (!firstobj)
    {
        *sipIsErr = 1;

        return 0;
    }

    PyErr_Clear();
    double first = PyFloat_AsDouble(firstobj);

    if (PyErr_Occurred())
    {
        PyErr_Format(PyExc_TypeError,
                "the first element has type '%s' but 'float' is expected",
                sipPyTypeName(Py_TYPE(firstobj)));

        *sipIsErr = 1;

        return 0;
    }

    PyObject *secondobj = PySequence_GetItem(sipPy, 1);

    if (!secondobj)
    {
        Py_DECREF(firstobj);
        *sipIsErr = 1;

        return 0;
    }

    PyErr_Clear();
    double second = PyFloat_AsDouble(secondobj);

    if (PyErr_Occurred())
    {
        PyErr_Format(PyExc_TypeError,
                "the second element has type '%s' but 'float' is expected",
                sipPyTypeName(Py_TYPE(secondobj)));

        Py_DECREF(secondobj);
        Py_DECREF(firstobj);
        *sipIsErr = 1;

        return 0;
    }

    *sipCppPtr = new std::pair<qreal, qreal>(first, second);;

    Py_DECREF(secondobj);
    Py_DECREF(firstobj);
 
    return sipGetState(sipTransferObj);
#line 144 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCorestdpair24002400.cpp"
}


extern "C" {static PyObject *convertFrom_std_pair_2400_2400(void *, PyObject *);}
static PyObject *convertFrom_std_pair_2400_2400(void *sipCppV, PyObject *)
{
    ::std::pair< ::qreal, ::qreal> *sipCpp = reinterpret_cast< ::std::pair< ::qreal, ::qreal> *>(sipCppV);

#line 422 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_std_pair.sip"
    return Py_BuildValue("(ff)", sipCpp->first, sipCpp->second);
#line 155 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCorestdpair24002400.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_std_pair_2400_2400 = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_13407,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_std_pair_2400_2400,
    array_std_pair_2400_2400,
    copy_std_pair_2400_2400,
    release_std_pair_2400_2400,
    convertTo_std_pair_2400_2400,
    convertFrom_std_pair_2400_2400
};
