/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtMultimedia.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qvideoframeformat.sip"
#include <qvideoframeformat.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrameFormat.cpp"

#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrameFormat.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qtvideo.sip"
#include <qtvideo.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrameFormat.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrameFormat.cpp"
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qimage.sip"
#include <qimage.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrameFormat.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrameFormat.cpp"


PyDoc_STRVAR(doc_QVideoFrameFormat_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrameFormat_isValid(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_isValid, doc_QVideoFrameFormat_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_pixelFormat, "pixelFormat(self) -> QVideoFrameFormat.PixelFormat");

extern "C" {static PyObject *meth_QVideoFrameFormat_pixelFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_pixelFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QVideoFrameFormat::PixelFormat sipRes;

            sipRes = sipCpp->pixelFormat();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_PixelFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_pixelFormat, doc_QVideoFrameFormat_pixelFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_frameSize, "frameSize(self) -> QSize");

extern "C" {static PyObject *meth_QVideoFrameFormat_frameSize(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_frameSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->frameSize());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_frameSize, doc_QVideoFrameFormat_frameSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setFrameSize, "setFrameSize(self, size: QSize)\n"
"setFrameSize(self, width: int, height: int)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setFrameSize(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setFrameSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSize* a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QSize, &a0))
        {
            sipCpp->setFrameSize(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, &a0, &a1))
        {
            sipCpp->setFrameSize(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setFrameSize, doc_QVideoFrameFormat_setFrameSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_frameWidth, "frameWidth(self) -> int");

extern "C" {static PyObject *meth_QVideoFrameFormat_frameWidth(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_frameWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->frameWidth();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_frameWidth, doc_QVideoFrameFormat_frameWidth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_frameHeight, "frameHeight(self) -> int");

extern "C" {static PyObject *meth_QVideoFrameFormat_frameHeight(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_frameHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->frameHeight();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_frameHeight, doc_QVideoFrameFormat_frameHeight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_planeCount, "planeCount(self) -> int");

extern "C" {static PyObject *meth_QVideoFrameFormat_planeCount(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_planeCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->planeCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_planeCount, doc_QVideoFrameFormat_planeCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_viewport, "viewport(self) -> QRect");

extern "C" {static PyObject *meth_QVideoFrameFormat_viewport(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_viewport(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QRect*sipRes;

            sipRes = new ::QRect(sipCpp->viewport());

            return sipConvertFromNewType(sipRes, sipType_QRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_viewport, doc_QVideoFrameFormat_viewport);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setViewport, "setViewport(self, viewport: QRect)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setViewport(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setViewport(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRect* a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QRect, &a0))
        {
            sipCpp->setViewport(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setViewport, doc_QVideoFrameFormat_setViewport);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_scanLineDirection, "scanLineDirection(self) -> QVideoFrameFormat.Direction");

extern "C" {static PyObject *meth_QVideoFrameFormat_scanLineDirection(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_scanLineDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QVideoFrameFormat::Direction sipRes;

            sipRes = sipCpp->scanLineDirection();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_Direction);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_scanLineDirection, doc_QVideoFrameFormat_scanLineDirection);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setScanLineDirection, "setScanLineDirection(self, direction: QVideoFrameFormat.Direction)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setScanLineDirection(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setScanLineDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::Direction a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QVideoFrameFormat_Direction, &a0))
        {
            sipCpp->setScanLineDirection(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setScanLineDirection, doc_QVideoFrameFormat_setScanLineDirection);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_frameRate, "frameRate(self) -> float");

extern "C" {static PyObject *meth_QVideoFrameFormat_frameRate(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_frameRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->frameRate();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_frameRate, doc_QVideoFrameFormat_frameRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setFrameRate, "setFrameRate(self, rate: float)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setFrameRate(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setFrameRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, &a0))
        {
            sipCpp->setFrameRate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setFrameRate, doc_QVideoFrameFormat_setFrameRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_yCbCrColorSpace, "yCbCrColorSpace(self) -> QVideoFrameFormat.YCbCrColorSpace");

extern "C" {static PyObject *meth_QVideoFrameFormat_yCbCrColorSpace(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_yCbCrColorSpace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QVideoFrameFormat::YCbCrColorSpace sipRes;

            sipRes = sipCpp->yCbCrColorSpace();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_YCbCrColorSpace);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_yCbCrColorSpace, doc_QVideoFrameFormat_yCbCrColorSpace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setYCbCrColorSpace, "setYCbCrColorSpace(self, colorSpace: QVideoFrameFormat.YCbCrColorSpace)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setYCbCrColorSpace(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setYCbCrColorSpace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::YCbCrColorSpace a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QVideoFrameFormat_YCbCrColorSpace, &a0))
        {
            sipCpp->setYCbCrColorSpace(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setYCbCrColorSpace, doc_QVideoFrameFormat_setYCbCrColorSpace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_isMirrored, "isMirrored(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrameFormat_isMirrored(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_isMirrored(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isMirrored();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_isMirrored, doc_QVideoFrameFormat_isMirrored);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setMirrored, "setMirrored(self, mirrored: bool)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setMirrored(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setMirrored(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, &a0))
        {
            sipCpp->setMirrored(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setMirrored, doc_QVideoFrameFormat_setMirrored);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_pixelFormatFromImageFormat, "pixelFormatFromImageFormat(format: QImage.Format) -> QVideoFrameFormat.PixelFormat");

extern "C" {static PyObject *meth_QVideoFrameFormat_pixelFormatFromImageFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_pixelFormatFromImageFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QImage::Format a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QImage_Format, &a0))
        {
            ::QVideoFrameFormat::PixelFormat sipRes;

            sipRes = ::QVideoFrameFormat::pixelFormatFromImageFormat(a0);

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_PixelFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_pixelFormatFromImageFormat, doc_QVideoFrameFormat_pixelFormatFromImageFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_imageFormatFromPixelFormat, "imageFormatFromPixelFormat(format: QVideoFrameFormat.PixelFormat) -> QImage.Format");

extern "C" {static PyObject *meth_QVideoFrameFormat_imageFormatFromPixelFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_imageFormatFromPixelFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::PixelFormat a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QVideoFrameFormat_PixelFormat, &a0))
        {
            ::QImage::Format sipRes;

            sipRes = ::QVideoFrameFormat::imageFormatFromPixelFormat(a0);

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QImage_Format);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_imageFormatFromPixelFormat, doc_QVideoFrameFormat_imageFormatFromPixelFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_pixelFormatToString, "pixelFormatToString(pixelFormat: QVideoFrameFormat.PixelFormat) -> str");

extern "C" {static PyObject *meth_QVideoFrameFormat_pixelFormatToString(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_pixelFormatToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::PixelFormat a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QVideoFrameFormat_PixelFormat, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QVideoFrameFormat::pixelFormatToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_pixelFormatToString, doc_QVideoFrameFormat_pixelFormatToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_colorSpace, "colorSpace(self) -> QVideoFrameFormat.ColorSpace");

extern "C" {static PyObject *meth_QVideoFrameFormat_colorSpace(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_colorSpace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QVideoFrameFormat::ColorSpace sipRes;

            sipRes = sipCpp->colorSpace();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_ColorSpace);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_colorSpace, doc_QVideoFrameFormat_colorSpace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setColorSpace, "setColorSpace(self, colorSpace: QVideoFrameFormat.ColorSpace)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setColorSpace(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setColorSpace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::ColorSpace a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QVideoFrameFormat_ColorSpace, &a0))
        {
            sipCpp->setColorSpace(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setColorSpace, doc_QVideoFrameFormat_setColorSpace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_colorTransfer, "colorTransfer(self) -> QVideoFrameFormat.ColorTransfer");

extern "C" {static PyObject *meth_QVideoFrameFormat_colorTransfer(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_colorTransfer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QVideoFrameFormat::ColorTransfer sipRes;

            sipRes = sipCpp->colorTransfer();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_ColorTransfer);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_colorTransfer, doc_QVideoFrameFormat_colorTransfer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setColorTransfer, "setColorTransfer(self, colorTransfer: QVideoFrameFormat.ColorTransfer)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setColorTransfer(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setColorTransfer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::ColorTransfer a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QVideoFrameFormat_ColorTransfer, &a0))
        {
            sipCpp->setColorTransfer(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setColorTransfer, doc_QVideoFrameFormat_setColorTransfer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_colorRange, "colorRange(self) -> QVideoFrameFormat.ColorRange");

extern "C" {static PyObject *meth_QVideoFrameFormat_colorRange(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_colorRange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QVideoFrameFormat::ColorRange sipRes;

            sipRes = sipCpp->colorRange();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_ColorRange);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_colorRange, doc_QVideoFrameFormat_colorRange);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setColorRange, "setColorRange(self, range: QVideoFrameFormat.ColorRange)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setColorRange(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setColorRange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrameFormat::ColorRange a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QVideoFrameFormat_ColorRange, &a0))
        {
            sipCpp->setColorRange(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setColorRange, doc_QVideoFrameFormat_setColorRange);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_streamFrameRate, "streamFrameRate(self) -> float");

extern "C" {static PyObject *meth_QVideoFrameFormat_streamFrameRate(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_streamFrameRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->streamFrameRate();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_streamFrameRate, doc_QVideoFrameFormat_streamFrameRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setStreamFrameRate, "setStreamFrameRate(self, rate: float)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setStreamFrameRate(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setStreamFrameRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, &a0))
        {
            sipCpp->setStreamFrameRate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setStreamFrameRate, doc_QVideoFrameFormat_setStreamFrameRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_rotation, "rotation(self) -> QtVideo.Rotation");

extern "C" {static PyObject *meth_QVideoFrameFormat_rotation(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_rotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrameFormat, &sipCpp))
        {
            ::QtVideo::Rotation sipRes;

            sipRes = sipCpp->rotation();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QtVideo_Rotation);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_rotation, doc_QVideoFrameFormat_rotation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrameFormat_setRotation, "setRotation(self, rotation: QtVideo.Rotation)");

extern "C" {static PyObject *meth_QVideoFrameFormat_setRotation(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrameFormat_setRotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QtVideo::Rotation a0;
        ::QVideoFrameFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrameFormat, &sipCpp, sipType_QtVideo_Rotation, &a0))
        {
            sipCpp->setRotation(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrameFormat, sipName_setRotation, doc_QVideoFrameFormat_setRotation);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVideoFrameFormat___ne__(PyObject *, PyObject *);}
static PyObject *slot_QVideoFrameFormat___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVideoFrameFormat *sipCpp = reinterpret_cast< ::QVideoFrameFormat *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVideoFrameFormat));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVideoFrameFormat, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QVideoFrameFormat::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ne_slot, sipType_QVideoFrameFormat, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVideoFrameFormat___eq__(PyObject *, PyObject *);}
static PyObject *slot_QVideoFrameFormat___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVideoFrameFormat *sipCpp = reinterpret_cast< ::QVideoFrameFormat *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVideoFrameFormat));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrameFormat* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVideoFrameFormat, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QVideoFrameFormat::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, eq_slot, sipType_QVideoFrameFormat, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QVideoFrameFormat(void *, int);}
static void release_QVideoFrameFormat(void *sipCppV, int)
{
    delete reinterpret_cast< ::QVideoFrameFormat *>(sipCppV);
}


extern "C" {static void *array_QVideoFrameFormat(Py_ssize_t);}
static void *array_QVideoFrameFormat(Py_ssize_t sipNrElem)
{
    return new ::QVideoFrameFormat[sipNrElem];
}


extern "C" {static void array_delete_QVideoFrameFormat(void *);}
static void array_delete_QVideoFrameFormat(void *sipCpp)
{
    delete[] reinterpret_cast< ::QVideoFrameFormat *>(sipCpp);
}


extern "C" {static void assign_QVideoFrameFormat(void *, Py_ssize_t, void *);}
static void assign_QVideoFrameFormat(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVideoFrameFormat *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVideoFrameFormat *>(sipSrc);
}


extern "C" {static void *copy_QVideoFrameFormat(const void *, Py_ssize_t);}
static void *copy_QVideoFrameFormat(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVideoFrameFormat(reinterpret_cast<const ::QVideoFrameFormat *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVideoFrameFormat(sipSimpleWrapper *);}
static void dealloc_QVideoFrameFormat(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QVideoFrameFormat(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QVideoFrameFormat(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QVideoFrameFormat(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QVideoFrameFormat *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QVideoFrameFormat();

            return sipCpp;
        }
    }

    {
        const ::QSize* a0;
        ::QVideoFrameFormat::PixelFormat a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9E", sipType_QSize, &a0, sipType_QVideoFrameFormat_PixelFormat, &a1))
        {
            sipCpp = new ::QVideoFrameFormat(*a0, a1);

            return sipCpp;
        }
    }

    {
        const ::QVideoFrameFormat* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVideoFrameFormat, &a0))
        {
            sipCpp = new ::QVideoFrameFormat(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVideoFrameFormat[] = {
    {(void *)slot_QVideoFrameFormat___ne__, ne_slot},
    {(void *)slot_QVideoFrameFormat___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVideoFrameFormat[] = {
    {sipName_colorRange, meth_QVideoFrameFormat_colorRange, METH_VARARGS, doc_QVideoFrameFormat_colorRange},
    {sipName_colorSpace, meth_QVideoFrameFormat_colorSpace, METH_VARARGS, doc_QVideoFrameFormat_colorSpace},
    {sipName_colorTransfer, meth_QVideoFrameFormat_colorTransfer, METH_VARARGS, doc_QVideoFrameFormat_colorTransfer},
    {sipName_frameHeight, meth_QVideoFrameFormat_frameHeight, METH_VARARGS, doc_QVideoFrameFormat_frameHeight},
    {sipName_frameRate, meth_QVideoFrameFormat_frameRate, METH_VARARGS, doc_QVideoFrameFormat_frameRate},
    {sipName_frameSize, meth_QVideoFrameFormat_frameSize, METH_VARARGS, doc_QVideoFrameFormat_frameSize},
    {sipName_frameWidth, meth_QVideoFrameFormat_frameWidth, METH_VARARGS, doc_QVideoFrameFormat_frameWidth},
    {sipName_imageFormatFromPixelFormat, meth_QVideoFrameFormat_imageFormatFromPixelFormat, METH_VARARGS, doc_QVideoFrameFormat_imageFormatFromPixelFormat},
    {sipName_isMirrored, meth_QVideoFrameFormat_isMirrored, METH_VARARGS, doc_QVideoFrameFormat_isMirrored},
    {sipName_isValid, meth_QVideoFrameFormat_isValid, METH_VARARGS, doc_QVideoFrameFormat_isValid},
    {sipName_pixelFormat, meth_QVideoFrameFormat_pixelFormat, METH_VARARGS, doc_QVideoFrameFormat_pixelFormat},
    {sipName_pixelFormatFromImageFormat, meth_QVideoFrameFormat_pixelFormatFromImageFormat, METH_VARARGS, doc_QVideoFrameFormat_pixelFormatFromImageFormat},
    {sipName_pixelFormatToString, meth_QVideoFrameFormat_pixelFormatToString, METH_VARARGS, doc_QVideoFrameFormat_pixelFormatToString},
    {sipName_planeCount, meth_QVideoFrameFormat_planeCount, METH_VARARGS, doc_QVideoFrameFormat_planeCount},
    {sipName_rotation, meth_QVideoFrameFormat_rotation, METH_VARARGS, doc_QVideoFrameFormat_rotation},
    {sipName_scanLineDirection, meth_QVideoFrameFormat_scanLineDirection, METH_VARARGS, doc_QVideoFrameFormat_scanLineDirection},
    {sipName_setColorRange, meth_QVideoFrameFormat_setColorRange, METH_VARARGS, doc_QVideoFrameFormat_setColorRange},
    {sipName_setColorSpace, meth_QVideoFrameFormat_setColorSpace, METH_VARARGS, doc_QVideoFrameFormat_setColorSpace},
    {sipName_setColorTransfer, meth_QVideoFrameFormat_setColorTransfer, METH_VARARGS, doc_QVideoFrameFormat_setColorTransfer},
    {sipName_setFrameRate, meth_QVideoFrameFormat_setFrameRate, METH_VARARGS, doc_QVideoFrameFormat_setFrameRate},
    {sipName_setFrameSize, meth_QVideoFrameFormat_setFrameSize, METH_VARARGS, doc_QVideoFrameFormat_setFrameSize},
    {sipName_setMirrored, meth_QVideoFrameFormat_setMirrored, METH_VARARGS, doc_QVideoFrameFormat_setMirrored},
    {sipName_setRotation, meth_QVideoFrameFormat_setRotation, METH_VARARGS, doc_QVideoFrameFormat_setRotation},
    {sipName_setScanLineDirection, meth_QVideoFrameFormat_setScanLineDirection, METH_VARARGS, doc_QVideoFrameFormat_setScanLineDirection},
    {sipName_setStreamFrameRate, meth_QVideoFrameFormat_setStreamFrameRate, METH_VARARGS, doc_QVideoFrameFormat_setStreamFrameRate},
    {sipName_setViewport, meth_QVideoFrameFormat_setViewport, METH_VARARGS, doc_QVideoFrameFormat_setViewport},
    {sipName_setYCbCrColorSpace, meth_QVideoFrameFormat_setYCbCrColorSpace, METH_VARARGS, doc_QVideoFrameFormat_setYCbCrColorSpace},
    {sipName_streamFrameRate, meth_QVideoFrameFormat_streamFrameRate, METH_VARARGS, doc_QVideoFrameFormat_streamFrameRate},
    {sipName_viewport, meth_QVideoFrameFormat_viewport, METH_VARARGS, doc_QVideoFrameFormat_viewport},
    {sipName_yCbCrColorSpace, meth_QVideoFrameFormat_yCbCrColorSpace, METH_VARARGS, doc_QVideoFrameFormat_yCbCrColorSpace}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QVideoFrameFormat[] = {
    {sipName_ColorRange_Unknown, static_cast<int>(::QVideoFrameFormat::ColorRange_Unknown)},
    {sipName_ColorRange_Video, static_cast<int>(::QVideoFrameFormat::ColorRange_Video)},
    {sipName_ColorRange_Full, static_cast<int>(::QVideoFrameFormat::ColorRange_Full)},
    {sipName_ColorSpace_Undefined, static_cast<int>(::QVideoFrameFormat::ColorSpace_Undefined)},
    {sipName_ColorSpace_BT601, static_cast<int>(::QVideoFrameFormat::ColorSpace_BT601)},
    {sipName_ColorSpace_BT709, static_cast<int>(::QVideoFrameFormat::ColorSpace_BT709)},
    {sipName_ColorSpace_AdobeRgb, static_cast<int>(::QVideoFrameFormat::ColorSpace_AdobeRgb)},
    {sipName_ColorSpace_BT2020, static_cast<int>(::QVideoFrameFormat::ColorSpace_BT2020)},
    {sipName_ColorTransfer_Unknown, static_cast<int>(::QVideoFrameFormat::ColorTransfer_Unknown)},
    {sipName_ColorTransfer_BT709, static_cast<int>(::QVideoFrameFormat::ColorTransfer_BT709)},
    {sipName_ColorTransfer_BT601, static_cast<int>(::QVideoFrameFormat::ColorTransfer_BT601)},
    {sipName_ColorTransfer_Linear, static_cast<int>(::QVideoFrameFormat::ColorTransfer_Linear)},
    {sipName_ColorTransfer_Gamma22, static_cast<int>(::QVideoFrameFormat::ColorTransfer_Gamma22)},
    {sipName_ColorTransfer_Gamma28, static_cast<int>(::QVideoFrameFormat::ColorTransfer_Gamma28)},
    {sipName_ColorTransfer_ST2084, static_cast<int>(::QVideoFrameFormat::ColorTransfer_ST2084)},
    {sipName_ColorTransfer_STD_B67, static_cast<int>(::QVideoFrameFormat::ColorTransfer_STD_B67)},
    {sipName_TopToBottom, static_cast<int>(::QVideoFrameFormat::TopToBottom)},
    {sipName_BottomToTop, static_cast<int>(::QVideoFrameFormat::BottomToTop)},
    {sipName_Format_Invalid, static_cast<int>(::QVideoFrameFormat::Format_Invalid)},
    {sipName_Format_YUV420P, static_cast<int>(::QVideoFrameFormat::Format_YUV420P)},
    {sipName_Format_YUV422P, static_cast<int>(::QVideoFrameFormat::Format_YUV422P)},
    {sipName_Format_YUV420P10, static_cast<int>(::QVideoFrameFormat::Format_YUV420P10)},
    {sipName_Format_YV12, static_cast<int>(::QVideoFrameFormat::Format_YV12)},
    {sipName_Format_UYVY, static_cast<int>(::QVideoFrameFormat::Format_UYVY)},
    {sipName_Format_YUYV, static_cast<int>(::QVideoFrameFormat::Format_YUYV)},
    {sipName_Format_NV12, static_cast<int>(::QVideoFrameFormat::Format_NV12)},
    {sipName_Format_NV21, static_cast<int>(::QVideoFrameFormat::Format_NV21)},
    {sipName_Format_IMC1, static_cast<int>(::QVideoFrameFormat::Format_IMC1)},
    {sipName_Format_IMC2, static_cast<int>(::QVideoFrameFormat::Format_IMC2)},
    {sipName_Format_IMC3, static_cast<int>(::QVideoFrameFormat::Format_IMC3)},
    {sipName_Format_IMC4, static_cast<int>(::QVideoFrameFormat::Format_IMC4)},
    {sipName_Format_Y8, static_cast<int>(::QVideoFrameFormat::Format_Y8)},
    {sipName_Format_Y16, static_cast<int>(::QVideoFrameFormat::Format_Y16)},
    {sipName_Format_P010, static_cast<int>(::QVideoFrameFormat::Format_P010)},
    {sipName_Format_P016, static_cast<int>(::QVideoFrameFormat::Format_P016)},
    {sipName_Format_Jpeg, static_cast<int>(::QVideoFrameFormat::Format_Jpeg)},
    {sipName_Format_SamplerExternalOES, static_cast<int>(::QVideoFrameFormat::Format_SamplerExternalOES)},
    {sipName_Format_ARGB8888, static_cast<int>(::QVideoFrameFormat::Format_ARGB8888)},
    {sipName_Format_ARGB8888_Premultiplied, static_cast<int>(::QVideoFrameFormat::Format_ARGB8888_Premultiplied)},
    {sipName_Format_XRGB8888, static_cast<int>(::QVideoFrameFormat::Format_XRGB8888)},
    {sipName_Format_BGRA8888, static_cast<int>(::QVideoFrameFormat::Format_BGRA8888)},
    {sipName_Format_BGRA8888_Premultiplied, static_cast<int>(::QVideoFrameFormat::Format_BGRA8888_Premultiplied)},
    {sipName_Format_BGRX8888, static_cast<int>(::QVideoFrameFormat::Format_BGRX8888)},
    {sipName_Format_ABGR8888, static_cast<int>(::QVideoFrameFormat::Format_ABGR8888)},
    {sipName_Format_XBGR8888, static_cast<int>(::QVideoFrameFormat::Format_XBGR8888)},
    {sipName_Format_RGBA8888, static_cast<int>(::QVideoFrameFormat::Format_RGBA8888)},
    {sipName_Format_RGBX8888, static_cast<int>(::QVideoFrameFormat::Format_RGBX8888)},
    {sipName_Format_AYUV, static_cast<int>(::QVideoFrameFormat::Format_AYUV)},
    {sipName_Format_AYUV_Premultiplied, static_cast<int>(::QVideoFrameFormat::Format_AYUV_Premultiplied)},
    {sipName_Format_SamplerRect, static_cast<int>(::QVideoFrameFormat::Format_SamplerRect)},
    {sipName_YCbCr_Undefined, static_cast<int>(::QVideoFrameFormat::YCbCr_Undefined)},
    {sipName_YCbCr_BT601, static_cast<int>(::QVideoFrameFormat::YCbCr_BT601)},
    {sipName_YCbCr_BT709, static_cast<int>(::QVideoFrameFormat::YCbCr_BT709)},
    {sipName_YCbCr_xvYCC601, static_cast<int>(::QVideoFrameFormat::YCbCr_xvYCC601)},
    {sipName_YCbCr_xvYCC709, static_cast<int>(::QVideoFrameFormat::YCbCr_xvYCC709)},
    {sipName_YCbCr_JPEG, static_cast<int>(::QVideoFrameFormat::YCbCr_JPEG)},
    {sipName_YCbCr_BT2020, static_cast<int>(::QVideoFrameFormat::YCbCr_BT2020)},
    {0, 0}
};

PyDoc_STRVAR(doc_QVideoFrameFormat, "\1QVideoFrameFormat()\n"
"QVideoFrameFormat(size: QSize, pixelFormat: QVideoFrameFormat.PixelFormat)\n"
"QVideoFrameFormat(format: QVideoFrameFormat)");


sipClassTypeDef sipTypeDef_QtMultimedia_QVideoFrameFormat = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QVideoFrameFormat,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QVideoFrameFormat,
        {0, 0, 1},
        30, methods_QVideoFrameFormat,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QVideoFrameFormat, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QVideoFrameFormat,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QVideoFrameFormat,
    init_type_QVideoFrameFormat,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QVideoFrameFormat,
    assign_QVideoFrameFormat,
    array_QVideoFrameFormat,
    copy_QVideoFrameFormat,
    release_QVideoFrameFormat,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QVideoFrameFormat,
    sizeof (::QVideoFrameFormat),
};
