/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6-Graphs.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGraphs.h"

#line 26 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/sip/QtGraphs/qxyseries.sip"
#include <qxyseries.h>
#line 29 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"

#line 30 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpoint.sip"
#include <qpoint.h>
#line 33 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtGui/qcolor.sip"
#include <qcolor.h>
#line 36 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtQml/qqmlcomponent.sip"
#include <qqmlcomponent.h>
#line 39 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 1094 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 42 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 45 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 110 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpoint.sip"
#include <qpoint.h>
#line 48 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 24 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 51 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 54 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/sip/QtGraphs/qabstractseries.sip"
#include <qabstractseries.h>
#line 57 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 37 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/sip/QtGraphs/qabstractseries.sip"
#include <qabstractseries.h>
#line 60 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 154 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 65 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 68 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 71 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 277 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 74 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 254 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 77 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qobject.sip"
#include <qobject.h>
#line 80 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 83 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 86 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 89 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 135 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 92 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 150 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 97 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qthread.sip"
#include <qthread.h>
#line 100 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qanystringview.sip"
#include <qanystringview.h>
#line 103 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 25 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qflags.sip"
#include <qglobal.h>
#line 106 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 109 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 112 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"


PyDoc_STRVAR(doc_QXYSeries_append, "append(self, x: float, y: float)\n"
"append(self, point: QPointF)\n"
"append(self, points: Iterable[QPointF])");

extern "C" {static PyObject *meth_QXYSeries_append(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, &a1))
        {
            sipCpp->append(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QPointF* a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->append(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QList< ::QPointF>* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QList_0100QPointF, &a0, &a0State))
        {
            sipCpp->append(*a0);
            sipReleaseType(const_cast<QList< ::QPointF> *>(a0), sipType_QList_0100QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_append, doc_QXYSeries_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_replace, "replace(self, oldX: float, oldY: float, newX: float, newY: float)\n"
"replace(self, oldPoint: QPointF, newPoint: QPointF)\n"
"replace(self, index: int, newX: float, newY: float)\n"
"replace(self, index: int, newPoint: QPointF)\n"
"replace(self, points: Iterable[QPointF])");

extern "C" {static PyObject *meth_QXYSeries_replace(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdddd", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, &a1, &a2, &a3))
        {
            sipCpp->replace(a0, a1, a2, a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QPointF* a0;
        ::QPointF* a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QPointF, &a0, sipType_QPointF, &a1))
        {
            sipCpp->replace(*a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::qsizetype a0;
        ::qreal a1;
        ::qreal a2;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bndd", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->replace(a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::qsizetype a0;
        ::QPointF* a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BnJ9", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, sipType_QPointF, &a1))
        {
            sipCpp->replace(a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QList< ::QPointF>* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QList_0100QPointF, &a0, &a0State))
        {
            sipCpp->replace(*a0);
            sipReleaseType(const_cast<QList< ::QPointF> *>(a0), sipType_QList_0100QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_replace, doc_QXYSeries_replace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_remove, "remove(self, x: float, y: float)\n"
"remove(self, point: QPointF)\n"
"remove(self, index: int)");

extern "C" {static PyObject *meth_QXYSeries_remove(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_remove(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, &a1))
        {
            sipCpp->remove(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QPointF* a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->remove(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::qsizetype a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QXYSeries, &sipCpp, &a0))
        {
            sipCpp->remove(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_remove, doc_QXYSeries_remove);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_insert, "insert(self, index: int, point: QPointF)");

extern "C" {static PyObject *meth_QXYSeries_insert(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QPointF* a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BnJ9", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, sipType_QPointF, &a1))
        {
            sipCpp->insert(a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_insert, doc_QXYSeries_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_clear, "clear(self)");

extern "C" {static PyObject *meth_QXYSeries_clear(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_clear, doc_QXYSeries_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_at, "at(self, index: int) -> QPointF");

extern "C" {static PyObject *meth_QXYSeries_at(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QXYSeries, &sipCpp, &a0))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->at(a0));

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_at, doc_QXYSeries_at);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_find, "find(self, point: QPointF) -> int");

extern "C" {static PyObject *meth_QXYSeries_find(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_find(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPointF* a0;
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QPointF, &a0))
        {
            ::qsizetype sipRes;

            sipRes = sipCpp->find(*a0);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_find, doc_QXYSeries_find);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_removeMultiple, "removeMultiple(self, index: int, count: int)");

extern "C" {static PyObject *meth_QXYSeries_removeMultiple(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_removeMultiple(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::qsizetype a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnn", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, &a1))
        {
            sipCpp->removeMultiple(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_removeMultiple, doc_QXYSeries_removeMultiple);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_take, "take(self, point: QPointF) -> bool");

extern "C" {static PyObject *meth_QXYSeries_take(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_take(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPointF* a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QPointF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->take(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_take, doc_QXYSeries_take);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_points, "points(self) -> list[QPointF]");

extern "C" {static PyObject *meth_QXYSeries_points(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_points(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            QList< ::QPointF>*sipRes;

            sipRes = new QList< ::QPointF>(sipCpp->points());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_points, doc_QXYSeries_points);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_setColor, "setColor(self, newColor: Union[QColor, Qt.GlobalColor, int])");

extern "C" {static PyObject *meth_QXYSeries_setColor(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_setColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QColor* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QColor, &a0, &a0State))
        {
            sipCpp->setColor(*a0);
            sipReleaseType(a0, sipType_QColor, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_setColor, doc_QXYSeries_setColor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_color, "color(self) -> QColor");

extern "C" {static PyObject *meth_QXYSeries_color(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_color(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            ::QColor*sipRes;

            sipRes = new ::QColor(sipCpp->color());

            return sipConvertFromNewType(sipRes, sipType_QColor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_color, doc_QXYSeries_color);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_setSelectedColor, "setSelectedColor(self, color: Union[QColor, Qt.GlobalColor, int])");

extern "C" {static PyObject *meth_QXYSeries_setSelectedColor(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_setSelectedColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QColor* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QColor, &a0, &a0State))
        {
            sipCpp->setSelectedColor(*a0);
            sipReleaseType(a0, sipType_QColor, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_setSelectedColor, doc_QXYSeries_setSelectedColor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_selectedColor, "selectedColor(self) -> QColor");

extern "C" {static PyObject *meth_QXYSeries_selectedColor(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_selectedColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            ::QColor*sipRes;

            sipRes = new ::QColor(sipCpp->selectedColor());

            return sipConvertFromNewType(sipRes, sipType_QColor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_selectedColor, doc_QXYSeries_selectedColor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_count, "count(self) -> int");

extern "C" {static PyObject *meth_QXYSeries_count(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            ::qsizetype sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_count, doc_QXYSeries_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_isPointSelected, "isPointSelected(self, index: int) -> bool");

extern "C" {static PyObject *meth_QXYSeries_isPointSelected(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_isPointSelected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QXYSeries, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->isPointSelected(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_isPointSelected, doc_QXYSeries_isPointSelected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_selectPoint, "selectPoint(self, index: int)");

extern "C" {static PyObject *meth_QXYSeries_selectPoint(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_selectPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QXYSeries, &sipCpp, &a0))
        {
            sipCpp->selectPoint(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_selectPoint, doc_QXYSeries_selectPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_deselectPoint, "deselectPoint(self, index: int)");

extern "C" {static PyObject *meth_QXYSeries_deselectPoint(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_deselectPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QXYSeries, &sipCpp, &a0))
        {
            sipCpp->deselectPoint(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_deselectPoint, doc_QXYSeries_deselectPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_setPointSelected, "setPointSelected(self, index: int, selected: bool)");

extern "C" {static PyObject *meth_QXYSeries_setPointSelected(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_setPointSelected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        bool a1;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnb", &sipSelf, sipType_QXYSeries, &sipCpp, &a0, &a1))
        {
            sipCpp->setPointSelected(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_setPointSelected, doc_QXYSeries_setPointSelected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_selectAllPoints, "selectAllPoints(self)");

extern "C" {static PyObject *meth_QXYSeries_selectAllPoints(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_selectAllPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            sipCpp->selectAllPoints();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_selectAllPoints, doc_QXYSeries_selectAllPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_deselectAllPoints, "deselectAllPoints(self)");

extern "C" {static PyObject *meth_QXYSeries_deselectAllPoints(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_deselectAllPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            sipCpp->deselectAllPoints();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_deselectAllPoints, doc_QXYSeries_deselectAllPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_selectPoints, "selectPoints(self, indexes: Iterable[int])");

extern "C" {static PyObject *meth_QXYSeries_selectPoints(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_selectPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QList< ::qsizetype>* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QList_3800, &a0, &a0State))
        {
            sipCpp->selectPoints(*a0);
            sipReleaseType(const_cast< ::QList< ::qsizetype> *>(a0), sipType_QList_3800, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_selectPoints, doc_QXYSeries_selectPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_deselectPoints, "deselectPoints(self, indexes: Iterable[int])");

extern "C" {static PyObject *meth_QXYSeries_deselectPoints(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_deselectPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QList< ::qsizetype>* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QList_3800, &a0, &a0State))
        {
            sipCpp->deselectPoints(*a0);
            sipReleaseType(const_cast< ::QList< ::qsizetype> *>(a0), sipType_QList_3800, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_deselectPoints, doc_QXYSeries_deselectPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_toggleSelection, "toggleSelection(self, indexes: Iterable[int])");

extern "C" {static PyObject *meth_QXYSeries_toggleSelection(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_toggleSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QList< ::qsizetype>* a0;
        int a0State = 0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QList_3800, &a0, &a0State))
        {
            sipCpp->toggleSelection(*a0);
            sipReleaseType(const_cast< ::QList< ::qsizetype> *>(a0), sipType_QList_3800, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_toggleSelection, doc_QXYSeries_toggleSelection);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_selectedPoints, "selectedPoints(self) -> list[int]");

extern "C" {static PyObject *meth_QXYSeries_selectedPoints(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_selectedPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            ::QList< ::qsizetype>*sipRes;

            sipRes = new ::QList< ::qsizetype>(sipCpp->selectedPoints());

            return sipConvertFromNewType(sipRes, sipType_QList_3800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_selectedPoints, doc_QXYSeries_selectedPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_pointDelegate, "pointDelegate(self) -> Optional[QQmlComponent]");

extern "C" {static PyObject *meth_QXYSeries_pointDelegate(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_pointDelegate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            ::QQmlComponent*sipRes;

            sipRes = sipCpp->pointDelegate();

            return sipConvertFromType(sipRes, sipType_QQmlComponent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_pointDelegate, doc_QXYSeries_pointDelegate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_setPointDelegate, "setPointDelegate(self, newPointDelegate: Optional[QQmlComponent])");

extern "C" {static PyObject *meth_QXYSeries_setPointDelegate(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_setPointDelegate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QQmlComponent* a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QXYSeries, &sipCpp, sipType_QQmlComponent, &a0))
        {
            sipCpp->setPointDelegate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_setPointDelegate, doc_QXYSeries_setPointDelegate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_isDraggable, "isDraggable(self) -> bool");

extern "C" {static PyObject *meth_QXYSeries_isDraggable(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_isDraggable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QXYSeries, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isDraggable();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_isDraggable, doc_QXYSeries_isDraggable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QXYSeries_setDraggable, "setDraggable(self, newDraggable: bool)");

extern "C" {static PyObject *meth_QXYSeries_setDraggable(PyObject *, PyObject *);}
static PyObject *meth_QXYSeries_setDraggable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QXYSeries *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QXYSeries, &sipCpp, &a0))
        {
            sipCpp->setDraggable(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QXYSeries, sipName_setDraggable, doc_QXYSeries_setDraggable);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QXYSeries___len__(PyObject *);}
static Py_ssize_t slot_QXYSeries___len__(PyObject *sipSelf)
{
    ::QXYSeries *sipCpp = reinterpret_cast< ::QXYSeries *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QXYSeries));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->count();
#line 1023 "/build/pyqt6-graphs/src/pyqt6_graphs-6.9.0/build/QtGraphs/sipQtGraphsQXYSeries.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QXYSeries(void *, const sipTypeDef *);}
static void *cast_QXYSeries(void *sipCppV, const sipTypeDef *targetType)
{
    ::QXYSeries *sipCpp = reinterpret_cast< ::QXYSeries *>(sipCppV);

    if (targetType == sipType_QXYSeries)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_QAbstractSeries)->ctd_cast(static_cast< ::QAbstractSeries *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QXYSeries(void *, int);}
static void release_QXYSeries(void *sipCppV, int)
{
    ::QXYSeries *sipCpp = reinterpret_cast< ::QXYSeries *>(sipCppV);

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();
}


extern "C" {static void dealloc_QXYSeries(sipSimpleWrapper *);}
static void dealloc_QXYSeries(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QXYSeries(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QXYSeries[] = {{11, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_QXYSeries[] = {
    {(void *)slot_QXYSeries___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QXYSeries[] = {
    {sipName_append, meth_QXYSeries_append, METH_VARARGS, doc_QXYSeries_append},
    {sipName_at, meth_QXYSeries_at, METH_VARARGS, doc_QXYSeries_at},
    {sipName_clear, meth_QXYSeries_clear, METH_VARARGS, doc_QXYSeries_clear},
    {sipName_color, meth_QXYSeries_color, METH_VARARGS, doc_QXYSeries_color},
    {sipName_count, meth_QXYSeries_count, METH_VARARGS, doc_QXYSeries_count},
    {sipName_deselectAllPoints, meth_QXYSeries_deselectAllPoints, METH_VARARGS, doc_QXYSeries_deselectAllPoints},
    {sipName_deselectPoint, meth_QXYSeries_deselectPoint, METH_VARARGS, doc_QXYSeries_deselectPoint},
    {sipName_deselectPoints, meth_QXYSeries_deselectPoints, METH_VARARGS, doc_QXYSeries_deselectPoints},
    {sipName_find, meth_QXYSeries_find, METH_VARARGS, doc_QXYSeries_find},
    {sipName_insert, meth_QXYSeries_insert, METH_VARARGS, doc_QXYSeries_insert},
    {sipName_isDraggable, meth_QXYSeries_isDraggable, METH_VARARGS, doc_QXYSeries_isDraggable},
    {sipName_isPointSelected, meth_QXYSeries_isPointSelected, METH_VARARGS, doc_QXYSeries_isPointSelected},
    {sipName_pointDelegate, meth_QXYSeries_pointDelegate, METH_VARARGS, doc_QXYSeries_pointDelegate},
    {sipName_points, meth_QXYSeries_points, METH_VARARGS, doc_QXYSeries_points},
    {sipName_remove, meth_QXYSeries_remove, METH_VARARGS, doc_QXYSeries_remove},
    {sipName_removeMultiple, meth_QXYSeries_removeMultiple, METH_VARARGS, doc_QXYSeries_removeMultiple},
    {sipName_replace, meth_QXYSeries_replace, METH_VARARGS, doc_QXYSeries_replace},
    {sipName_selectAllPoints, meth_QXYSeries_selectAllPoints, METH_VARARGS, doc_QXYSeries_selectAllPoints},
    {sipName_selectPoint, meth_QXYSeries_selectPoint, METH_VARARGS, doc_QXYSeries_selectPoint},
    {sipName_selectPoints, meth_QXYSeries_selectPoints, METH_VARARGS, doc_QXYSeries_selectPoints},
    {sipName_selectedColor, meth_QXYSeries_selectedColor, METH_VARARGS, doc_QXYSeries_selectedColor},
    {sipName_selectedPoints, meth_QXYSeries_selectedPoints, METH_VARARGS, doc_QXYSeries_selectedPoints},
    {sipName_setColor, meth_QXYSeries_setColor, METH_VARARGS, doc_QXYSeries_setColor},
    {sipName_setDraggable, meth_QXYSeries_setDraggable, METH_VARARGS, doc_QXYSeries_setDraggable},
    {sipName_setPointDelegate, meth_QXYSeries_setPointDelegate, METH_VARARGS, doc_QXYSeries_setPointDelegate},
    {sipName_setPointSelected, meth_QXYSeries_setPointSelected, METH_VARARGS, doc_QXYSeries_setPointSelected},
    {sipName_setSelectedColor, meth_QXYSeries_setSelectedColor, METH_VARARGS, doc_QXYSeries_setSelectedColor},
    {sipName_take, meth_QXYSeries_take, METH_VARARGS, doc_QXYSeries_take},
    {sipName_toggleSelection, meth_QXYSeries_toggleSelection, METH_VARARGS, doc_QXYSeries_toggleSelection}
};


/* Define this type's signals. */
static const pyqt6QtSignal signals_QXYSeries[] = {
    {"released(QPoint)", "\1released(self, point: QPoint)", SIP_NULLPTR, SIP_NULLPTR},
    {"pressed(QPoint)", "\1pressed(self, point: QPoint)", SIP_NULLPTR, SIP_NULLPTR},
    {"doubleClicked(QPoint)", "\1doubleClicked(self, point: QPoint)", SIP_NULLPTR, SIP_NULLPTR},
    {"clicked(QPoint)", "\1clicked(self, point: QPoint)", SIP_NULLPTR, SIP_NULLPTR},
    {"pointsAdded(qsizetype,qsizetype)", "\1pointsAdded(self, start: int, end: int)", SIP_NULLPTR, SIP_NULLPTR},
    {"countChanged()", "\1countChanged(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"draggableChanged()", "\1draggableChanged(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"pointDelegateChanged()", "\1pointDelegateChanged(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"selectedPointsChanged()", "\1selectedPointsChanged(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"pointsReplaced()", "\1pointsReplaced(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"selectedColorChanged(QColor)", "\1selectedColorChanged(self, color: Union[QColor, Qt.GlobalColor, int])", SIP_NULLPTR, SIP_NULLPTR},
    {"colorChanged(QColor)", "\1colorChanged(self, color: Union[QColor, Qt.GlobalColor, int])", SIP_NULLPTR, SIP_NULLPTR},
    {"pointReplaced(qsizetype)", "\1pointReplaced(self, index: int)", SIP_NULLPTR, SIP_NULLPTR},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt6ClassPluginDef plugin_QXYSeries = {
    &::QXYSeries::staticMetaObject,
    signals_QXYSeries,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGraphs_QXYSeries = {
    {
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QXYSeries,
        SIP_NULLPTR,
        &plugin_QXYSeries,
    },
    {
        sipNameNr_QXYSeries,
        {0, 0, 1},
        29, methods_QXYSeries,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    SIP_NULLPTR,
    -1,
    -1,
    supers_QXYSeries,
    slots_QXYSeries,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QXYSeries,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QXYSeries,
    cast_QXYSeries,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
