// components/services/storage/public/mojom/blob_storage_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace storage {
namespace mojom {
class BlobDataItemDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::BlobDataItemDataView> {
  using Data = ::storage::mojom::internal::BlobDataItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {


enum class BlobDataItemType : int32_t {
  
  kUnknown = 0,
  
  kCacheStorage = 1,
  
  kIndexedDB = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BlobDataItemType value);
inline bool IsKnownEnumValue(BlobDataItemType value) {
  return internal::BlobDataItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WriteBlobToFileResult : int32_t {
  
  kError = 0,
  
  kBadPath = 1,
  
  kInvalidBlob = 2,
  
  kIOError = 3,
  
  kTimestampError = 4,
  
  kSuccess = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, WriteBlobToFileResult value);
inline bool IsKnownEnumValue(WriteBlobToFileResult value) {
  return internal::WriteBlobToFileResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BlobDataItemReaderInterfaceBase {};

using BlobDataItemReaderPtrDataView =
    mojo::InterfacePtrDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderRequestDataView =
    mojo::InterfaceRequestDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BlobDataItemReaderInterfaceBase>;
class BlobStorageContextInterfaceBase {};

using BlobStorageContextPtrDataView =
    mojo::InterfacePtrDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextRequestDataView =
    mojo::InterfaceRequestDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BlobStorageContextInterfaceBase>;


class BlobDataItemDataView {
 public:
  BlobDataItemDataView() {}

  BlobDataItemDataView(
      internal::BlobDataItem_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::storage::mojom::BlobDataItemType>(
        data_value, output);
  }

  BlobDataItemType type() const {
    return static_cast<BlobDataItemType>(data_->type);
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t side_data_size() const {
    return data_->side_data_size;
  }
  inline void GetContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentType(UserType* output) {
    
    auto* pointer = data_->content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeReader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
            &data_->reader, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BlobDataItem_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

template <>
struct hash<::storage::mojom::BlobDataItemType>
    : public mojo::internal::EnumHashImpl<::storage::mojom::BlobDataItemType> {};

template <>
struct hash<::storage::mojom::WriteBlobToFileResult>
    : public mojo::internal::EnumHashImpl<::storage::mojom::WriteBlobToFileResult> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::storage::mojom::BlobDataItemType, ::storage::mojom::BlobDataItemType> {
  static ::storage::mojom::BlobDataItemType ToMojom(::storage::mojom::BlobDataItemType input) { return input; }
  static bool FromMojom(::storage::mojom::BlobDataItemType input, ::storage::mojom::BlobDataItemType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BlobDataItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::BlobDataItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::BlobDataItemType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::storage::mojom::WriteBlobToFileResult, ::storage::mojom::WriteBlobToFileResult> {
  static ::storage::mojom::WriteBlobToFileResult ToMojom(::storage::mojom::WriteBlobToFileResult input) { return input; }
  static bool FromMojom(::storage::mojom::WriteBlobToFileResult input, ::storage::mojom::WriteBlobToFileResult* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::WriteBlobToFileResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::WriteBlobToFileResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::WriteBlobToFileResult>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BlobDataItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BlobDataItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::BlobDataItem_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::storage::mojom::BlobDataItemType>(
        Traits::type(input), &(*output)->type);
    (*output)->size = Traits::size(input);
    (*output)->side_data_size = Traits::side_data_size(input);
    decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
    typename decltype((*output)->content_type)::BaseType::BufferWriter
        content_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_content_type, buffer, &content_type_writer, context);
    (*output)->content_type.Set(
        content_type_writer.is_null() ? nullptr : content_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_type in BlobDataItem struct");
    decltype(Traits::reader(input)) in_reader = Traits::reader(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
        in_reader, &(*output)->reader, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->reader),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid reader in BlobDataItem struct");
  }

  static bool Deserialize(::storage::mojom::internal::BlobDataItem_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::BlobDataItemDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void BlobDataItemDataView::GetContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_