// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class FrameSinkVideoConsumerFrameCallbacksProxy;

template <typename ImplRefTraits>
class FrameSinkVideoConsumerFrameCallbacksStub;

class FrameSinkVideoConsumerFrameCallbacksRequestValidator;


class  FrameSinkVideoConsumerFrameCallbacks
    : public FrameSinkVideoConsumerFrameCallbacksInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameSinkVideoConsumerFrameCallbacksInterfaceBase;
  using Proxy_ = FrameSinkVideoConsumerFrameCallbacksProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoConsumerFrameCallbacksStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoConsumerFrameCallbacksRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDoneMinVersion = 0,
    kProvideFeedbackMinVersion = 0,
  };
  virtual ~FrameSinkVideoConsumerFrameCallbacks() {}

  
  virtual void Done() = 0;

  
  virtual void ProvideFeedback(const ::media::VideoFrameFeedback& feedback) = 0;
};

class FrameSinkVideoConsumerProxy;

template <typename ImplRefTraits>
class FrameSinkVideoConsumerStub;

class FrameSinkVideoConsumerRequestValidator;


class  FrameSinkVideoConsumer
    : public FrameSinkVideoConsumerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameSinkVideoConsumerInterfaceBase;
  using Proxy_ = FrameSinkVideoConsumerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoConsumerStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoConsumerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFrameCapturedMinVersion = 0,
    kOnStoppedMinVersion = 0,
    kOnLogMinVersion = 0,
  };
  virtual ~FrameSinkVideoConsumer() {}

  
  virtual void OnFrameCaptured(::base::ReadOnlySharedMemoryRegion data, ::media::mojom::VideoFrameInfoPtr info, const ::gfx::Rect& content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> callbacks) = 0;

  
  virtual void OnStopped() = 0;

  
  virtual void OnLog(const std::string& message) = 0;
};

class FrameSinkVideoCapturerProxy;

template <typename ImplRefTraits>
class FrameSinkVideoCapturerStub;

class FrameSinkVideoCapturerRequestValidator;


class  FrameSinkVideoCapturer
    : public FrameSinkVideoCapturerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameSinkVideoCapturerInterfaceBase;
  using Proxy_ = FrameSinkVideoCapturerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoCapturerStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoCapturerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetFormatMinVersion = 0,
    kSetMinCapturePeriodMinVersion = 0,
    kSetMinSizeChangePeriodMinVersion = 0,
    kSetResolutionConstraintsMinVersion = 0,
    kSetAutoThrottlingEnabledMinVersion = 0,
    kChangeTargetMinVersion = 0,
    kStartMinVersion = 0,
    kStopMinVersion = 0,
    kRequestRefreshFrameMinVersion = 0,
    kCreateOverlayMinVersion = 0,
  };
  virtual ~FrameSinkVideoCapturer() {}

  
  virtual void SetFormat(::media::VideoPixelFormat format, const ::gfx::ColorSpace& color_space) = 0;

  
  virtual void SetMinCapturePeriod(::base::TimeDelta min_period) = 0;

  
  virtual void SetMinSizeChangePeriod(::base::TimeDelta min_period) = 0;

  
  virtual void SetResolutionConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool use_fixed_aspect_ratio) = 0;

  
  virtual void SetAutoThrottlingEnabled(bool enabled) = 0;

  
  virtual void ChangeTarget(const base::Optional<::viz::FrameSinkId>& frame_sink_id) = 0;

  
  virtual void Start(::mojo::PendingRemote<FrameSinkVideoConsumer> consumer) = 0;

  
  virtual void Stop() = 0;

  
  virtual void RequestRefreshFrame() = 0;

  
  virtual void CreateOverlay(int32_t stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> receiver) = 0;
};

class FrameSinkVideoCaptureOverlayProxy;

template <typename ImplRefTraits>
class FrameSinkVideoCaptureOverlayStub;

class FrameSinkVideoCaptureOverlayRequestValidator;


class  FrameSinkVideoCaptureOverlay
    : public FrameSinkVideoCaptureOverlayInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameSinkVideoCaptureOverlayInterfaceBase;
  using Proxy_ = FrameSinkVideoCaptureOverlayProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoCaptureOverlayStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoCaptureOverlayRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetImageAndBoundsMinVersion = 0,
    kSetBoundsMinVersion = 0,
  };
  virtual ~FrameSinkVideoCaptureOverlay() {}

  
  virtual void SetImageAndBounds(const ::SkBitmap& image, const ::gfx::RectF& bounds) = 0;

  
  virtual void SetBounds(const ::gfx::RectF& bounds) = 0;
};



class  FrameSinkVideoConsumerFrameCallbacksProxy
    : public FrameSinkVideoConsumerFrameCallbacks {
 public:
  using InterfaceType = FrameSinkVideoConsumerFrameCallbacks;

  explicit FrameSinkVideoConsumerFrameCallbacksProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Done() final;
  
  void ProvideFeedback(const ::media::VideoFrameFeedback& feedback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkVideoConsumerProxy
    : public FrameSinkVideoConsumer {
 public:
  using InterfaceType = FrameSinkVideoConsumer;

  explicit FrameSinkVideoConsumerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFrameCaptured(::base::ReadOnlySharedMemoryRegion data, ::media::mojom::VideoFrameInfoPtr info, const ::gfx::Rect& content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> callbacks) final;
  
  void OnStopped() final;
  
  void OnLog(const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkVideoCapturerProxy
    : public FrameSinkVideoCapturer {
 public:
  using InterfaceType = FrameSinkVideoCapturer;

  explicit FrameSinkVideoCapturerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFormat(::media::VideoPixelFormat format, const ::gfx::ColorSpace& color_space) final;
  
  void SetMinCapturePeriod(::base::TimeDelta min_period) final;
  
  void SetMinSizeChangePeriod(::base::TimeDelta min_period) final;
  
  void SetResolutionConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool use_fixed_aspect_ratio) final;
  
  void SetAutoThrottlingEnabled(bool enabled) final;
  
  void ChangeTarget(const base::Optional<::viz::FrameSinkId>& frame_sink_id) final;
  
  void Start(::mojo::PendingRemote<FrameSinkVideoConsumer> consumer) final;
  
  void Stop() final;
  
  void RequestRefreshFrame() final;
  
  void CreateOverlay(int32_t stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkVideoCaptureOverlayProxy
    : public FrameSinkVideoCaptureOverlay {
 public:
  using InterfaceType = FrameSinkVideoCaptureOverlay;

  explicit FrameSinkVideoCaptureOverlayProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetImageAndBounds(const ::SkBitmap& image, const ::gfx::RectF& bounds) final;
  
  void SetBounds(const ::gfx::RectF& bounds) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinkVideoConsumerFrameCallbacksStubDispatch {
 public:
  static bool Accept(FrameSinkVideoConsumerFrameCallbacks* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoConsumerFrameCallbacks* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoConsumerFrameCallbacks>>
class FrameSinkVideoConsumerFrameCallbacksStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoConsumerFrameCallbacksStub() {}
  ~FrameSinkVideoConsumerFrameCallbacksStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerFrameCallbacksStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerFrameCallbacksStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoConsumerStubDispatch {
 public:
  static bool Accept(FrameSinkVideoConsumer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoConsumer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoConsumer>>
class FrameSinkVideoConsumerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoConsumerStub() {}
  ~FrameSinkVideoConsumerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoCapturerStubDispatch {
 public:
  static bool Accept(FrameSinkVideoCapturer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoCapturer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoCapturer>>
class FrameSinkVideoCapturerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoCapturerStub() {}
  ~FrameSinkVideoCapturerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCapturerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCapturerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoCaptureOverlayStubDispatch {
 public:
  static bool Accept(FrameSinkVideoCaptureOverlay* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoCaptureOverlay* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoCaptureOverlay>>
class FrameSinkVideoCaptureOverlayStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoCaptureOverlayStub() {}
  ~FrameSinkVideoCaptureOverlayStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCaptureOverlayStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCaptureOverlayStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoConsumerFrameCallbacksRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkVideoConsumerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkVideoCapturerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkVideoCaptureOverlayRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_H_