// third_party/blink/public/mojom/badging/badging.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/badging/badging.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class BadgeValueDataView;


}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BadgeValueDataView> {
  using Data = ::blink::mojom::internal::BadgeValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class BadgeServiceInterfaceBase {};

using BadgeServicePtrDataView =
    mojo::InterfacePtrDataView<BadgeServiceInterfaceBase>;
using BadgeServiceRequestDataView =
    mojo::InterfaceRequestDataView<BadgeServiceInterfaceBase>;
using BadgeServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BadgeServiceInterfaceBase>;
using BadgeServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BadgeServiceInterfaceBase>;


class BadgeValueDataView {
 public:
  using Tag = internal::BadgeValue_Data::BadgeValue_Tag;

  BadgeValueDataView() {}

  BadgeValueDataView(
      internal::BadgeValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_flag() const { return data_->tag == Tag::FLAG; }
  uint8_t flag() const {
    DCHECK(is_flag());
    return data_->data.f_flag;
  }
  bool is_number() const { return data_->tag == Tag::NUMBER; }
  uint64_t number() const {
    DCHECK(is_number());
    return data_->data.f_number;
  }

 private:
  internal::BadgeValue_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BadgeValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::BadgeValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::BadgeValue_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::BadgeValue_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::BadgeValueDataView::Tag::FLAG: {
        decltype(Traits::flag(input))
            in_flag = Traits::flag(input);
        result->data.f_flag = in_flag;
        break;
      }
      case ::blink::mojom::BadgeValueDataView::Tag::NUMBER: {
        decltype(Traits::number(input))
            in_number = Traits::number(input);
        result->data.f_number = in_number;
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::BadgeValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BadgeValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_SHARED_H_