// third_party/blink/public/mojom/frame/navigation_initiator.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_NAVIGATION_INITIATOR_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_NAVIGATION_INITIATOR_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char NavigationInitiator::Name_[] = "blink.mojom.NavigationInitiator";

NavigationInitiatorProxy::NavigationInitiatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigationInitiatorProxy::SendViolationReport(
    ::network::mojom::blink::CSPViolationPtr in_violation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NavigationInitiator::SendViolationReport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_violation.is_null()) {
        raw_value->SetString("violation", "nullptr");
      } else {
        raw_value->BeginDictionary("violation");
        in_violation->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigationInitiator_SendViolationReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NavigationInitiator_SendViolationReport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->violation)::BaseType::BufferWriter
      violation_writer;
  mojo::internal::Serialize<::network::mojom::CSPViolationDataView>(
      in_violation, buffer, &violation_writer, &serialization_context);
  params->violation.Set(
      violation_writer.is_null() ? nullptr : violation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->violation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null violation in NavigationInitiator.SendViolationReport request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationInitiator::Name_);
  message.set_method_name("SendViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NavigationInitiatorStubDispatch::Accept(
    NavigationInitiator* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNavigationInitiator_SendViolationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NavigationInitiator::SendViolationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NavigationInitiator::SendViolationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigationInitiator_SendViolationReport_Params_Data* params =
          reinterpret_cast<internal::NavigationInitiator_SendViolationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::CSPViolationPtr p_violation{};
      NavigationInitiator_SendViolationReport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadViolation(&p_violation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationInitiator::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendViolationReport(
std::move(p_violation));
      return true;
    }
  }
  return false;
}

// static
bool NavigationInitiatorStubDispatch::AcceptWithResponder(
    NavigationInitiator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNavigationInitiator_SendViolationReport_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigationInitiatorValidationInfo[] = {
    {internal::kNavigationInitiator_SendViolationReport_Name,
     {&internal::NavigationInitiator_SendViolationReport_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NavigationInitiatorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NavigationInitiator::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNavigationInitiatorValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif