// third_party/blink/public/mojom/manifest/manifest.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink-forward.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-blink-forward.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_ManifestImageResource_Purpose_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ManifestImageResource_Purpose& value) {
    using utype = std::underlying_type<::blink::mojom::ManifestImageResource_Purpose>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ManifestImageResource_Purpose& left, const ::blink::mojom::ManifestImageResource_Purpose& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ManifestImageResource_Purpose>
    : public GenericHashTraits<::blink::mojom::ManifestImageResource_Purpose> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ManifestImageResource_Purpose& value) {
    return value == static_cast<::blink::mojom::ManifestImageResource_Purpose>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ManifestImageResource_Purpose& slot, bool) {
    slot = static_cast<::blink::mojom::ManifestImageResource_Purpose>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ManifestImageResource_Purpose& value) {
    return value == static_cast<::blink::mojom::ManifestImageResource_Purpose>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_ManifestShareTarget_Method_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ManifestShareTarget_Method& value) {
    using utype = std::underlying_type<::blink::mojom::ManifestShareTarget_Method>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ManifestShareTarget_Method& left, const ::blink::mojom::ManifestShareTarget_Method& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ManifestShareTarget_Method>
    : public GenericHashTraits<::blink::mojom::ManifestShareTarget_Method> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ManifestShareTarget_Method& value) {
    return value == static_cast<::blink::mojom::ManifestShareTarget_Method>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ManifestShareTarget_Method& slot, bool) {
    slot = static_cast<::blink::mojom::ManifestShareTarget_Method>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ManifestShareTarget_Method& value) {
    return value == static_cast<::blink::mojom::ManifestShareTarget_Method>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_ManifestShareTarget_Enctype_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ManifestShareTarget_Enctype& value) {
    using utype = std::underlying_type<::blink::mojom::ManifestShareTarget_Enctype>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ManifestShareTarget_Enctype& left, const ::blink::mojom::ManifestShareTarget_Enctype& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ManifestShareTarget_Enctype>
    : public GenericHashTraits<::blink::mojom::ManifestShareTarget_Enctype> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ManifestShareTarget_Enctype& value) {
    return value == static_cast<::blink::mojom::ManifestShareTarget_Enctype>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ManifestShareTarget_Enctype& slot, bool) {
    slot = static_cast<::blink::mojom::ManifestShareTarget_Enctype>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ManifestShareTarget_Enctype& value) {
    return value == static_cast<::blink::mojom::ManifestShareTarget_Enctype>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {















class PLATFORM_EXPORT ManifestError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestError, T>::value>;
  using DataView = ManifestErrorDataView;
  using Data_ = internal::ManifestError_Data;

  template <typename... Args>
  static ManifestErrorPtr New(Args&&... args) {
    return ManifestErrorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestErrorPtr From(const U& u) {
    return mojo::TypeConverter<ManifestErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestError>::Convert(*this);
  }


  ManifestError();

  ManifestError(
      const WTF::String& message,
      bool critical,
      uint32_t line,
      uint32_t column);

  ~ManifestError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestErrorPtr>
  ManifestErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestError::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestError_UnserializedMessageContext<
            UserType, ManifestError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestError::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestError::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestError_UnserializedMessageContext<
            UserType, ManifestError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestError::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String message;
  
  bool critical;
  
  uint32_t line;
  
  uint32_t column;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT Manifest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Manifest, T>::value>;
  using DataView = ManifestDataView;
  using Data_ = internal::Manifest_Data;

  template <typename... Args>
  static ManifestPtr New(Args&&... args) {
    return ManifestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestPtr From(const U& u) {
    return mojo::TypeConverter<ManifestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Manifest>::Convert(*this);
  }


  Manifest();

  Manifest(
      const ::WTF::String& name,
      const ::WTF::String& short_name,
      const ::blink::KURL& start_url,
      ::blink::mojom::blink::DisplayMode display,
      WTF::Vector<::blink::mojom::blink::DisplayMode> display_override,
      ::device::mojom::blink::ScreenOrientationLockType orientation,
      WTF::Vector<ManifestImageResourcePtr> icons,
      WTF::Vector<ManifestShortcutItemPtr> shortcuts,
      ManifestShareTargetPtr share_target,
      WTF::Vector<ManifestFileHandlerPtr> file_handlers,
      WTF::Vector<ManifestProtocolHandlerPtr> protocol_handlers,
      WTF::Vector<ManifestRelatedApplicationPtr> related_applications,
      bool prefer_related_applications,
      bool has_theme_color,
      uint32_t theme_color,
      bool has_background_color,
      uint32_t background_color,
      const ::WTF::String& gcm_sender_id,
      const ::blink::KURL& scope);

  ~Manifest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestPtr>
  ManifestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Manifest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Manifest::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Manifest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Manifest_UnserializedMessageContext<
            UserType, Manifest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Manifest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return Manifest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Manifest_UnserializedMessageContext<
            UserType, Manifest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Manifest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String name;
  
  ::WTF::String short_name;
  
  ::blink::KURL start_url;
  
  ::blink::mojom::blink::DisplayMode display;
  
  WTF::Vector<::blink::mojom::blink::DisplayMode> display_override;
  
  ::device::mojom::blink::ScreenOrientationLockType orientation;
  
  WTF::Vector<ManifestImageResourcePtr> icons;
  
  WTF::Vector<ManifestShortcutItemPtr> shortcuts;
  
  ManifestShareTargetPtr share_target;
  
  WTF::Vector<ManifestFileHandlerPtr> file_handlers;
  
  WTF::Vector<ManifestProtocolHandlerPtr> protocol_handlers;
  
  WTF::Vector<ManifestRelatedApplicationPtr> related_applications;
  
  bool prefer_related_applications;
  
  bool has_theme_color;
  
  uint32_t theme_color;
  
  bool has_background_color;
  
  uint32_t background_color;
  
  ::WTF::String gcm_sender_id;
  
  ::blink::KURL scope;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(Manifest);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestShortcutItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestShortcutItem, T>::value>;
  using DataView = ManifestShortcutItemDataView;
  using Data_ = internal::ManifestShortcutItem_Data;

  template <typename... Args>
  static ManifestShortcutItemPtr New(Args&&... args) {
    return ManifestShortcutItemPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestShortcutItemPtr From(const U& u) {
    return mojo::TypeConverter<ManifestShortcutItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestShortcutItem>::Convert(*this);
  }


  ManifestShortcutItem();

  ManifestShortcutItem(
      const ::WTF::String& name,
      const ::WTF::String& short_name,
      const ::WTF::String& description,
      const ::blink::KURL& url,
      WTF::Vector<ManifestImageResourcePtr> icons);

  ~ManifestShortcutItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestShortcutItemPtr>
  ManifestShortcutItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShortcutItem::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestShortcutItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestShortcutItem_UnserializedMessageContext<
            UserType, ManifestShortcutItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestShortcutItem::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestShortcutItem::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestShortcutItem_UnserializedMessageContext<
            UserType, ManifestShortcutItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestShortcutItem::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String name;
  
  ::WTF::String short_name;
  
  ::WTF::String description;
  
  ::blink::KURL url;
  
  WTF::Vector<ManifestImageResourcePtr> icons;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ManifestShortcutItem);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestImageResource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestImageResource, T>::value>;
  using DataView = ManifestImageResourceDataView;
  using Data_ = internal::ManifestImageResource_Data;
  using Purpose = ManifestImageResource_Purpose;

  template <typename... Args>
  static ManifestImageResourcePtr New(Args&&... args) {
    return ManifestImageResourcePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestImageResourcePtr From(const U& u) {
    return mojo::TypeConverter<ManifestImageResourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestImageResource>::Convert(*this);
  }


  ManifestImageResource();

  ManifestImageResource(
      const ::blink::KURL& src,
      const ::WTF::String& type,
      WTF::Vector<::gfx::Size> sizes,
      WTF::Vector<ManifestImageResource::Purpose> purpose);

  ~ManifestImageResource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestImageResourcePtr>
  ManifestImageResourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestImageResource::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestImageResource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestImageResource_UnserializedMessageContext<
            UserType, ManifestImageResource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestImageResource::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestImageResource::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestImageResource_UnserializedMessageContext<
            UserType, ManifestImageResource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestImageResource::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL src;
  
  ::WTF::String type;
  
  WTF::Vector<::gfx::Size> sizes;
  
  WTF::Vector<ManifestImageResource::Purpose> purpose;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestFileFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestFileFilter, T>::value>;
  using DataView = ManifestFileFilterDataView;
  using Data_ = internal::ManifestFileFilter_Data;

  template <typename... Args>
  static ManifestFileFilterPtr New(Args&&... args) {
    return ManifestFileFilterPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestFileFilterPtr From(const U& u) {
    return mojo::TypeConverter<ManifestFileFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestFileFilter>::Convert(*this);
  }


  ManifestFileFilter();

  ManifestFileFilter(
      const ::WTF::String& name,
      WTF::Vector<::WTF::String> accept);

  ~ManifestFileFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestFileFilterPtr>
  ManifestFileFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestFileFilter::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestFileFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestFileFilter_UnserializedMessageContext<
            UserType, ManifestFileFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestFileFilter::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestFileFilter::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestFileFilter_UnserializedMessageContext<
            UserType, ManifestFileFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestFileFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String name;
  
  WTF::Vector<::WTF::String> accept;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestProtocolHandler {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestProtocolHandler, T>::value>;
  using DataView = ManifestProtocolHandlerDataView;
  using Data_ = internal::ManifestProtocolHandler_Data;

  template <typename... Args>
  static ManifestProtocolHandlerPtr New(Args&&... args) {
    return ManifestProtocolHandlerPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestProtocolHandlerPtr From(const U& u) {
    return mojo::TypeConverter<ManifestProtocolHandlerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestProtocolHandler>::Convert(*this);
  }


  ManifestProtocolHandler();

  ManifestProtocolHandler(
      const ::WTF::String& protocol,
      const ::blink::KURL& url);

  ~ManifestProtocolHandler();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestProtocolHandlerPtr>
  ManifestProtocolHandlerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestProtocolHandler::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestProtocolHandler::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestProtocolHandler_UnserializedMessageContext<
            UserType, ManifestProtocolHandler::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestProtocolHandler::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestProtocolHandler::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestProtocolHandler_UnserializedMessageContext<
            UserType, ManifestProtocolHandler::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestProtocolHandler::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String protocol;
  
  ::blink::KURL url;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestRelatedApplication {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestRelatedApplication, T>::value>;
  using DataView = ManifestRelatedApplicationDataView;
  using Data_ = internal::ManifestRelatedApplication_Data;

  template <typename... Args>
  static ManifestRelatedApplicationPtr New(Args&&... args) {
    return ManifestRelatedApplicationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestRelatedApplicationPtr From(const U& u) {
    return mojo::TypeConverter<ManifestRelatedApplicationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestRelatedApplication>::Convert(*this);
  }


  ManifestRelatedApplication();

  ManifestRelatedApplication(
      const ::WTF::String& platform,
      const base::Optional<::blink::KURL>& url,
      const ::WTF::String& id);

  ~ManifestRelatedApplication();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestRelatedApplicationPtr>
  ManifestRelatedApplicationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestRelatedApplication::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestRelatedApplication::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestRelatedApplication_UnserializedMessageContext<
            UserType, ManifestRelatedApplication::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestRelatedApplication::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestRelatedApplication::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestRelatedApplication_UnserializedMessageContext<
            UserType, ManifestRelatedApplication::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestRelatedApplication::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String platform;
  
  base::Optional<::blink::KURL> url;
  
  ::WTF::String id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestShareTargetParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestShareTargetParams, T>::value>;
  using DataView = ManifestShareTargetParamsDataView;
  using Data_ = internal::ManifestShareTargetParams_Data;

  template <typename... Args>
  static ManifestShareTargetParamsPtr New(Args&&... args) {
    return ManifestShareTargetParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestShareTargetParamsPtr From(const U& u) {
    return mojo::TypeConverter<ManifestShareTargetParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestShareTargetParams>::Convert(*this);
  }


  ManifestShareTargetParams();

  ManifestShareTargetParams(
      const ::WTF::String& title,
      const ::WTF::String& text,
      const ::WTF::String& url,
      base::Optional<WTF::Vector<ManifestFileFilterPtr>> files);

  ~ManifestShareTargetParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestShareTargetParamsPtr>
  ManifestShareTargetParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShareTargetParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestShareTargetParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestShareTargetParams_UnserializedMessageContext<
            UserType, ManifestShareTargetParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestShareTargetParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestShareTargetParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestShareTargetParams_UnserializedMessageContext<
            UserType, ManifestShareTargetParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestShareTargetParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String title;
  
  ::WTF::String text;
  
  ::WTF::String url;
  
  base::Optional<WTF::Vector<ManifestFileFilterPtr>> files;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ManifestShareTargetParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestShareTarget {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestShareTarget, T>::value>;
  using DataView = ManifestShareTargetDataView;
  using Data_ = internal::ManifestShareTarget_Data;
  using Method = ManifestShareTarget_Method;
  using Enctype = ManifestShareTarget_Enctype;

  template <typename... Args>
  static ManifestShareTargetPtr New(Args&&... args) {
    return ManifestShareTargetPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestShareTargetPtr From(const U& u) {
    return mojo::TypeConverter<ManifestShareTargetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestShareTarget>::Convert(*this);
  }


  ManifestShareTarget();

  ManifestShareTarget(
      const ::blink::KURL& action,
      ManifestShareTarget::Method method,
      ManifestShareTarget::Enctype enctype,
      ManifestShareTargetParamsPtr params);

  ~ManifestShareTarget();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestShareTargetPtr>
  ManifestShareTargetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShareTarget::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestShareTarget::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestShareTarget_UnserializedMessageContext<
            UserType, ManifestShareTarget::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestShareTarget::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestShareTarget::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestShareTarget_UnserializedMessageContext<
            UserType, ManifestShareTarget::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestShareTarget::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL action;
  
  ManifestShareTarget::Method method;
  
  ManifestShareTarget::Enctype enctype;
  
  ManifestShareTargetParamsPtr params;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ManifestShareTarget);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestFileHandler {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestFileHandler, T>::value>;
  using DataView = ManifestFileHandlerDataView;
  using Data_ = internal::ManifestFileHandler_Data;

  template <typename... Args>
  static ManifestFileHandlerPtr New(Args&&... args) {
    return ManifestFileHandlerPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestFileHandlerPtr From(const U& u) {
    return mojo::TypeConverter<ManifestFileHandlerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestFileHandler>::Convert(*this);
  }


  ManifestFileHandler();

  ManifestFileHandler(
      const ::blink::KURL& action,
      const ::WTF::String& name,
      const WTF::HashMap<::WTF::String, WTF::Vector<::WTF::String>>& accept);

  ~ManifestFileHandler();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestFileHandlerPtr>
  ManifestFileHandlerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestFileHandler::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestFileHandler::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestFileHandler_UnserializedMessageContext<
            UserType, ManifestFileHandler::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestFileHandler::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestFileHandler::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestFileHandler_UnserializedMessageContext<
            UserType, ManifestFileHandler::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestFileHandler::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL action;
  
  ::WTF::String name;
  
  WTF::HashMap<::WTF::String, WTF::Vector<::WTF::String>> accept;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ManifestDebugInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestDebugInfo, T>::value>;
  using DataView = ManifestDebugInfoDataView;
  using Data_ = internal::ManifestDebugInfo_Data;

  template <typename... Args>
  static ManifestDebugInfoPtr New(Args&&... args) {
    return ManifestDebugInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestDebugInfoPtr From(const U& u) {
    return mojo::TypeConverter<ManifestDebugInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestDebugInfo>::Convert(*this);
  }


  ManifestDebugInfo();

  ManifestDebugInfo(
      WTF::Vector<ManifestErrorPtr> errors,
      const WTF::String& raw_manifest);

  ~ManifestDebugInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestDebugInfoPtr>
  ManifestDebugInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestDebugInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestDebugInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestDebugInfo_UnserializedMessageContext<
            UserType, ManifestDebugInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestDebugInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ManifestDebugInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestDebugInfo_UnserializedMessageContext<
            UserType, ManifestDebugInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestDebugInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<ManifestErrorPtr> errors;
  
  WTF::String raw_manifest;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ManifestDebugInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ManifestPtr Manifest::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(short_name),
      mojo::Clone(start_url),
      mojo::Clone(display),
      mojo::Clone(display_override),
      mojo::Clone(orientation),
      mojo::Clone(icons),
      mojo::Clone(shortcuts),
      mojo::Clone(share_target),
      mojo::Clone(file_handlers),
      mojo::Clone(protocol_handlers),
      mojo::Clone(related_applications),
      mojo::Clone(prefer_related_applications),
      mojo::Clone(has_theme_color),
      mojo::Clone(theme_color),
      mojo::Clone(has_background_color),
      mojo::Clone(background_color),
      mojo::Clone(gcm_sender_id),
      mojo::Clone(scope)
  );
}

template <typename T, Manifest::EnableIfSame<T>*>
bool Manifest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->short_name, other_struct.short_name))
    return false;
  if (!mojo::Equals(this->start_url, other_struct.start_url))
    return false;
  if (!mojo::Equals(this->display, other_struct.display))
    return false;
  if (!mojo::Equals(this->display_override, other_struct.display_override))
    return false;
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->shortcuts, other_struct.shortcuts))
    return false;
  if (!mojo::Equals(this->share_target, other_struct.share_target))
    return false;
  if (!mojo::Equals(this->file_handlers, other_struct.file_handlers))
    return false;
  if (!mojo::Equals(this->protocol_handlers, other_struct.protocol_handlers))
    return false;
  if (!mojo::Equals(this->related_applications, other_struct.related_applications))
    return false;
  if (!mojo::Equals(this->prefer_related_applications, other_struct.prefer_related_applications))
    return false;
  if (!mojo::Equals(this->has_theme_color, other_struct.has_theme_color))
    return false;
  if (!mojo::Equals(this->theme_color, other_struct.theme_color))
    return false;
  if (!mojo::Equals(this->has_background_color, other_struct.has_background_color))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->gcm_sender_id, other_struct.gcm_sender_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  return true;
}

template <typename T, Manifest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.short_name, rhs.short_name))
    return true;
  if (std::less<>{}(rhs.short_name, lhs.short_name))
    return false;
  if (std::less<>{}(lhs.start_url, rhs.start_url))
    return true;
  if (std::less<>{}(rhs.start_url, lhs.start_url))
    return false;
  if (std::less<>{}(lhs.display, rhs.display))
    return true;
  if (std::less<>{}(rhs.display, lhs.display))
    return false;
  if (std::less<>{}(lhs.display_override, rhs.display_override))
    return true;
  if (std::less<>{}(rhs.display_override, lhs.display_override))
    return false;
  if (std::less<>{}(lhs.orientation, rhs.orientation))
    return true;
  if (std::less<>{}(rhs.orientation, lhs.orientation))
    return false;
  if (std::less<>{}(lhs.icons, rhs.icons))
    return true;
  if (std::less<>{}(rhs.icons, lhs.icons))
    return false;
  if (std::less<>{}(lhs.shortcuts, rhs.shortcuts))
    return true;
  if (std::less<>{}(rhs.shortcuts, lhs.shortcuts))
    return false;
  if (std::less<>{}(lhs.share_target, rhs.share_target))
    return true;
  if (std::less<>{}(rhs.share_target, lhs.share_target))
    return false;
  if (std::less<>{}(lhs.file_handlers, rhs.file_handlers))
    return true;
  if (std::less<>{}(rhs.file_handlers, lhs.file_handlers))
    return false;
  if (std::less<>{}(lhs.protocol_handlers, rhs.protocol_handlers))
    return true;
  if (std::less<>{}(rhs.protocol_handlers, lhs.protocol_handlers))
    return false;
  if (std::less<>{}(lhs.related_applications, rhs.related_applications))
    return true;
  if (std::less<>{}(rhs.related_applications, lhs.related_applications))
    return false;
  if (std::less<>{}(lhs.prefer_related_applications, rhs.prefer_related_applications))
    return true;
  if (std::less<>{}(rhs.prefer_related_applications, lhs.prefer_related_applications))
    return false;
  if (std::less<>{}(lhs.has_theme_color, rhs.has_theme_color))
    return true;
  if (std::less<>{}(rhs.has_theme_color, lhs.has_theme_color))
    return false;
  if (std::less<>{}(lhs.theme_color, rhs.theme_color))
    return true;
  if (std::less<>{}(rhs.theme_color, lhs.theme_color))
    return false;
  if (std::less<>{}(lhs.has_background_color, rhs.has_background_color))
    return true;
  if (std::less<>{}(rhs.has_background_color, lhs.has_background_color))
    return false;
  if (std::less<>{}(lhs.background_color, rhs.background_color))
    return true;
  if (std::less<>{}(rhs.background_color, lhs.background_color))
    return false;
  if (std::less<>{}(lhs.gcm_sender_id, rhs.gcm_sender_id))
    return true;
  if (std::less<>{}(rhs.gcm_sender_id, lhs.gcm_sender_id))
    return false;
  if (std::less<>{}(lhs.scope, rhs.scope))
    return true;
  if (std::less<>{}(rhs.scope, lhs.scope))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestShortcutItemPtr ManifestShortcutItem::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(short_name),
      mojo::Clone(description),
      mojo::Clone(url),
      mojo::Clone(icons)
  );
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>*>
bool ManifestShortcutItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->short_name, other_struct.short_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  return true;
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.short_name, rhs.short_name))
    return true;
  if (std::less<>{}(rhs.short_name, lhs.short_name))
    return false;
  if (std::less<>{}(lhs.description, rhs.description))
    return true;
  if (std::less<>{}(rhs.description, lhs.description))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.icons, rhs.icons))
    return true;
  if (std::less<>{}(rhs.icons, lhs.icons))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestImageResourcePtr ManifestImageResource::Clone() const {
  return New(
      mojo::Clone(src),
      mojo::Clone(type),
      mojo::Clone(sizes),
      mojo::Clone(purpose)
  );
}

template <typename T, ManifestImageResource::EnableIfSame<T>*>
bool ManifestImageResource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->sizes, other_struct.sizes))
    return false;
  if (!mojo::Equals(this->purpose, other_struct.purpose))
    return false;
  return true;
}

template <typename T, ManifestImageResource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.src, rhs.src))
    return true;
  if (std::less<>{}(rhs.src, lhs.src))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.sizes, rhs.sizes))
    return true;
  if (std::less<>{}(rhs.sizes, lhs.sizes))
    return false;
  if (std::less<>{}(lhs.purpose, rhs.purpose))
    return true;
  if (std::less<>{}(rhs.purpose, lhs.purpose))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestFileFilterPtr ManifestFileFilter::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(accept)
  );
}

template <typename T, ManifestFileFilter::EnableIfSame<T>*>
bool ManifestFileFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->accept, other_struct.accept))
    return false;
  return true;
}

template <typename T, ManifestFileFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.accept, rhs.accept))
    return true;
  if (std::less<>{}(rhs.accept, lhs.accept))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestProtocolHandlerPtr ManifestProtocolHandler::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(url)
  );
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>*>
bool ManifestProtocolHandler::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.protocol, rhs.protocol))
    return true;
  if (std::less<>{}(rhs.protocol, lhs.protocol))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestRelatedApplicationPtr ManifestRelatedApplication::Clone() const {
  return New(
      mojo::Clone(platform),
      mojo::Clone(url),
      mojo::Clone(id)
  );
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>*>
bool ManifestRelatedApplication::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->platform, other_struct.platform))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.platform, rhs.platform))
    return true;
  if (std::less<>{}(rhs.platform, lhs.platform))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestShareTargetParamsPtr ManifestShareTargetParams::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(text),
      mojo::Clone(url),
      mojo::Clone(files)
  );
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>*>
bool ManifestShareTargetParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->files, other_struct.files))
    return false;
  return true;
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.text, rhs.text))
    return true;
  if (std::less<>{}(rhs.text, lhs.text))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.files, rhs.files))
    return true;
  if (std::less<>{}(rhs.files, lhs.files))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestShareTargetPtr ManifestShareTarget::Clone() const {
  return New(
      mojo::Clone(action),
      mojo::Clone(method),
      mojo::Clone(enctype),
      mojo::Clone(params)
  );
}

template <typename T, ManifestShareTarget::EnableIfSame<T>*>
bool ManifestShareTarget::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->enctype, other_struct.enctype))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, ManifestShareTarget::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.action, rhs.action))
    return true;
  if (std::less<>{}(rhs.action, lhs.action))
    return false;
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.enctype, rhs.enctype))
    return true;
  if (std::less<>{}(rhs.enctype, lhs.enctype))
    return false;
  if (std::less<>{}(lhs.params, rhs.params))
    return true;
  if (std::less<>{}(rhs.params, lhs.params))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestFileHandlerPtr ManifestFileHandler::Clone() const {
  return New(
      mojo::Clone(action),
      mojo::Clone(name),
      mojo::Clone(accept)
  );
}

template <typename T, ManifestFileHandler::EnableIfSame<T>*>
bool ManifestFileHandler::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->accept, other_struct.accept))
    return false;
  return true;
}

template <typename T, ManifestFileHandler::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.action, rhs.action))
    return true;
  if (std::less<>{}(rhs.action, lhs.action))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.accept, rhs.accept))
    return true;
  if (std::less<>{}(rhs.accept, lhs.accept))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestDebugInfoPtr ManifestDebugInfo::Clone() const {
  return New(
      mojo::Clone(errors),
      mojo::Clone(raw_manifest)
  );
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>*>
bool ManifestDebugInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->errors, other_struct.errors))
    return false;
  if (!mojo::Equals(this->raw_manifest, other_struct.raw_manifest))
    return false;
  return true;
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.errors, rhs.errors))
    return true;
  if (std::less<>{}(rhs.errors, lhs.errors))
    return false;
  if (std::less<>{}(lhs.raw_manifest, rhs.raw_manifest))
    return true;
  if (std::less<>{}(rhs.raw_manifest, lhs.raw_manifest))
    return false;
  return false;
}
template <typename StructPtrType>
ManifestErrorPtr ManifestError::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(critical),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, ManifestError::EnableIfSame<T>*>
bool ManifestError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->critical, other_struct.critical))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, ManifestError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.message, rhs.message))
    return true;
  if (std::less<>{}(rhs.message, lhs.message))
    return false;
  if (std::less<>{}(lhs.critical, rhs.critical))
    return true;
  if (std::less<>{}(rhs.critical, lhs.critical))
    return false;
  if (std::less<>{}(lhs.line, rhs.line))
    return true;
  if (std::less<>{}(rhs.line, lhs.line))
    return false;
  if (std::less<>{}(lhs.column, rhs.column))
    return true;
  if (std::less<>{}(rhs.column, lhs.column))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::Manifest::DataView,
                                         ::blink::mojom::blink::ManifestPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::Manifest::name)& name(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::Manifest::short_name)& short_name(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->short_name;
  }

  static const decltype(::blink::mojom::blink::Manifest::start_url)& start_url(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->start_url;
  }

  static decltype(::blink::mojom::blink::Manifest::display) display(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->display;
  }

  static const decltype(::blink::mojom::blink::Manifest::display_override)& display_override(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->display_override;
  }

  static decltype(::blink::mojom::blink::Manifest::orientation) orientation(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->orientation;
  }

  static const decltype(::blink::mojom::blink::Manifest::icons)& icons(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::blink::Manifest::shortcuts)& shortcuts(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->shortcuts;
  }

  static const decltype(::blink::mojom::blink::Manifest::share_target)& share_target(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->share_target;
  }

  static const decltype(::blink::mojom::blink::Manifest::file_handlers)& file_handlers(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->file_handlers;
  }

  static const decltype(::blink::mojom::blink::Manifest::protocol_handlers)& protocol_handlers(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->protocol_handlers;
  }

  static const decltype(::blink::mojom::blink::Manifest::related_applications)& related_applications(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->related_applications;
  }

  static decltype(::blink::mojom::blink::Manifest::prefer_related_applications) prefer_related_applications(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->prefer_related_applications;
  }

  static decltype(::blink::mojom::blink::Manifest::has_theme_color) has_theme_color(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->has_theme_color;
  }

  static decltype(::blink::mojom::blink::Manifest::theme_color) theme_color(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->theme_color;
  }

  static decltype(::blink::mojom::blink::Manifest::has_background_color) has_background_color(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->has_background_color;
  }

  static decltype(::blink::mojom::blink::Manifest::background_color) background_color(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->background_color;
  }

  static const decltype(::blink::mojom::blink::Manifest::gcm_sender_id)& gcm_sender_id(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->gcm_sender_id;
  }

  static const decltype(::blink::mojom::blink::Manifest::scope)& scope(
      const ::blink::mojom::blink::ManifestPtr& input) {
    return input->scope;
  }

  static bool Read(::blink::mojom::blink::Manifest::DataView input, ::blink::mojom::blink::ManifestPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestShortcutItem::DataView,
                                         ::blink::mojom::blink::ManifestShortcutItemPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestShortcutItemPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestShortcutItemPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestShortcutItem::name)& name(
      const ::blink::mojom::blink::ManifestShortcutItemPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::ManifestShortcutItem::short_name)& short_name(
      const ::blink::mojom::blink::ManifestShortcutItemPtr& input) {
    return input->short_name;
  }

  static const decltype(::blink::mojom::blink::ManifestShortcutItem::description)& description(
      const ::blink::mojom::blink::ManifestShortcutItemPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::blink::ManifestShortcutItem::url)& url(
      const ::blink::mojom::blink::ManifestShortcutItemPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::ManifestShortcutItem::icons)& icons(
      const ::blink::mojom::blink::ManifestShortcutItemPtr& input) {
    return input->icons;
  }

  static bool Read(::blink::mojom::blink::ManifestShortcutItem::DataView input, ::blink::mojom::blink::ManifestShortcutItemPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestImageResource::DataView,
                                         ::blink::mojom::blink::ManifestImageResourcePtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestImageResourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestImageResourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestImageResource::src)& src(
      const ::blink::mojom::blink::ManifestImageResourcePtr& input) {
    return input->src;
  }

  static const decltype(::blink::mojom::blink::ManifestImageResource::type)& type(
      const ::blink::mojom::blink::ManifestImageResourcePtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::ManifestImageResource::sizes)& sizes(
      const ::blink::mojom::blink::ManifestImageResourcePtr& input) {
    return input->sizes;
  }

  static const decltype(::blink::mojom::blink::ManifestImageResource::purpose)& purpose(
      const ::blink::mojom::blink::ManifestImageResourcePtr& input) {
    return input->purpose;
  }

  static bool Read(::blink::mojom::blink::ManifestImageResource::DataView input, ::blink::mojom::blink::ManifestImageResourcePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestFileFilter::DataView,
                                         ::blink::mojom::blink::ManifestFileFilterPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestFileFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestFileFilterPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestFileFilter::name)& name(
      const ::blink::mojom::blink::ManifestFileFilterPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::ManifestFileFilter::accept)& accept(
      const ::blink::mojom::blink::ManifestFileFilterPtr& input) {
    return input->accept;
  }

  static bool Read(::blink::mojom::blink::ManifestFileFilter::DataView input, ::blink::mojom::blink::ManifestFileFilterPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestProtocolHandler::DataView,
                                         ::blink::mojom::blink::ManifestProtocolHandlerPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestProtocolHandlerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestProtocolHandlerPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestProtocolHandler::protocol)& protocol(
      const ::blink::mojom::blink::ManifestProtocolHandlerPtr& input) {
    return input->protocol;
  }

  static const decltype(::blink::mojom::blink::ManifestProtocolHandler::url)& url(
      const ::blink::mojom::blink::ManifestProtocolHandlerPtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::blink::ManifestProtocolHandler::DataView input, ::blink::mojom::blink::ManifestProtocolHandlerPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestRelatedApplication::DataView,
                                         ::blink::mojom::blink::ManifestRelatedApplicationPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestRelatedApplicationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestRelatedApplicationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestRelatedApplication::platform)& platform(
      const ::blink::mojom::blink::ManifestRelatedApplicationPtr& input) {
    return input->platform;
  }

  static const decltype(::blink::mojom::blink::ManifestRelatedApplication::url)& url(
      const ::blink::mojom::blink::ManifestRelatedApplicationPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::ManifestRelatedApplication::id)& id(
      const ::blink::mojom::blink::ManifestRelatedApplicationPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::blink::ManifestRelatedApplication::DataView input, ::blink::mojom::blink::ManifestRelatedApplicationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestShareTargetParams::DataView,
                                         ::blink::mojom::blink::ManifestShareTargetParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestShareTargetParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestShareTargetParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestShareTargetParams::title)& title(
      const ::blink::mojom::blink::ManifestShareTargetParamsPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::blink::ManifestShareTargetParams::text)& text(
      const ::blink::mojom::blink::ManifestShareTargetParamsPtr& input) {
    return input->text;
  }

  static const decltype(::blink::mojom::blink::ManifestShareTargetParams::url)& url(
      const ::blink::mojom::blink::ManifestShareTargetParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::ManifestShareTargetParams::files)& files(
      const ::blink::mojom::blink::ManifestShareTargetParamsPtr& input) {
    return input->files;
  }

  static bool Read(::blink::mojom::blink::ManifestShareTargetParams::DataView input, ::blink::mojom::blink::ManifestShareTargetParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestShareTarget::DataView,
                                         ::blink::mojom::blink::ManifestShareTargetPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestShareTargetPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestShareTargetPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestShareTarget::action)& action(
      const ::blink::mojom::blink::ManifestShareTargetPtr& input) {
    return input->action;
  }

  static decltype(::blink::mojom::blink::ManifestShareTarget::method) method(
      const ::blink::mojom::blink::ManifestShareTargetPtr& input) {
    return input->method;
  }

  static decltype(::blink::mojom::blink::ManifestShareTarget::enctype) enctype(
      const ::blink::mojom::blink::ManifestShareTargetPtr& input) {
    return input->enctype;
  }

  static const decltype(::blink::mojom::blink::ManifestShareTarget::params)& params(
      const ::blink::mojom::blink::ManifestShareTargetPtr& input) {
    return input->params;
  }

  static bool Read(::blink::mojom::blink::ManifestShareTarget::DataView input, ::blink::mojom::blink::ManifestShareTargetPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestFileHandler::DataView,
                                         ::blink::mojom::blink::ManifestFileHandlerPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestFileHandlerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestFileHandlerPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestFileHandler::action)& action(
      const ::blink::mojom::blink::ManifestFileHandlerPtr& input) {
    return input->action;
  }

  static const decltype(::blink::mojom::blink::ManifestFileHandler::name)& name(
      const ::blink::mojom::blink::ManifestFileHandlerPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::ManifestFileHandler::accept)& accept(
      const ::blink::mojom::blink::ManifestFileHandlerPtr& input) {
    return input->accept;
  }

  static bool Read(::blink::mojom::blink::ManifestFileHandler::DataView input, ::blink::mojom::blink::ManifestFileHandlerPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestDebugInfo::DataView,
                                         ::blink::mojom::blink::ManifestDebugInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestDebugInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestDebugInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestDebugInfo::errors)& errors(
      const ::blink::mojom::blink::ManifestDebugInfoPtr& input) {
    return input->errors;
  }

  static const decltype(::blink::mojom::blink::ManifestDebugInfo::raw_manifest)& raw_manifest(
      const ::blink::mojom::blink::ManifestDebugInfoPtr& input) {
    return input->raw_manifest;
  }

  static bool Read(::blink::mojom::blink::ManifestDebugInfo::DataView input, ::blink::mojom::blink::ManifestDebugInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ManifestError::DataView,
                                         ::blink::mojom::blink::ManifestErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestErrorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ManifestError::message)& message(
      const ::blink::mojom::blink::ManifestErrorPtr& input) {
    return input->message;
  }

  static decltype(::blink::mojom::blink::ManifestError::critical) critical(
      const ::blink::mojom::blink::ManifestErrorPtr& input) {
    return input->critical;
  }

  static decltype(::blink::mojom::blink::ManifestError::line) line(
      const ::blink::mojom::blink::ManifestErrorPtr& input) {
    return input->line;
  }

  static decltype(::blink::mojom::blink::ManifestError::column) column(
      const ::blink::mojom::blink::ManifestErrorPtr& input) {
    return input->column;
  }

  static bool Read(::blink::mojom::blink::ManifestError::DataView input, ::blink::mojom::blink::ManifestErrorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_BLINK_H_