// media/mojo/mojom/content_decryption_module.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/content_decryption_module.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/content_decryption_module.mojom-params-data.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared-message-ids.h"

#include "media/mojo/mojom/content_decryption_module.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
CdmPromiseResult::CdmPromiseResult()
    : success(),
      exception(),
      system_code(),
      error_message() {}

CdmPromiseResult::CdmPromiseResult(
    bool success_in,
    ::media::CdmPromise::Exception exception_in,
    uint32_t system_code_in,
    const std::string& error_message_in)
    : success(std::move(success_in)),
      exception(std::move(exception_in)),
      system_code(std::move(system_code_in)),
      error_message(std::move(error_message_in)) {}

CdmPromiseResult::~CdmPromiseResult() = default;

void CdmPromiseResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("success", this->success);
  value->SetInteger("exception", static_cast<int>(this->exception));
  value->SetString("system_code", base::NumberToString(this->system_code));
  value->SetString("error_message", this->error_message);
}

bool CdmPromiseResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CdmKeyInformation::CdmKeyInformation()
    : key_id(),
      status(),
      system_code() {}

CdmKeyInformation::CdmKeyInformation(
    std::vector<uint8_t> key_id_in,
    ::media::CdmKeyInformation::KeyStatus status_in,
    uint32_t system_code_in)
    : key_id(std::move(key_id_in)),
      status(std::move(status_in)),
      system_code(std::move(system_code_in)) {}

CdmKeyInformation::~CdmKeyInformation() = default;

void CdmKeyInformation::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("key_id");
  for (const auto& item0 : this->key_id) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetInteger("status", static_cast<int>(this->status));
  value->SetString("system_code", base::NumberToString(this->system_code));
}

bool CdmKeyInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ContentDecryptionModule::Name_[] = "media.mojom.ContentDecryptionModule";

class ContentDecryptionModule_SetServerCertificate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_SetServerCertificate_ForwardToCallback(
      ContentDecryptionModule::SetServerCertificateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::SetServerCertificateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_SetServerCertificate_ForwardToCallback);
};

class ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback(
      ContentDecryptionModule::GetStatusForPolicyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::GetStatusForPolicyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback);
};

class ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback(
      ContentDecryptionModule::CreateSessionAndGenerateRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::CreateSessionAndGenerateRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback);
};

class ContentDecryptionModule_LoadSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_LoadSession_ForwardToCallback(
      ContentDecryptionModule::LoadSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::LoadSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_LoadSession_ForwardToCallback);
};

class ContentDecryptionModule_UpdateSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_UpdateSession_ForwardToCallback(
      ContentDecryptionModule::UpdateSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::UpdateSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_UpdateSession_ForwardToCallback);
};

class ContentDecryptionModule_CloseSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_CloseSession_ForwardToCallback(
      ContentDecryptionModule::CloseSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::CloseSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_CloseSession_ForwardToCallback);
};

class ContentDecryptionModule_RemoveSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_RemoveSession_ForwardToCallback(
      ContentDecryptionModule::RemoveSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::RemoveSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_RemoveSession_ForwardToCallback);
};

ContentDecryptionModuleProxy::ContentDecryptionModuleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentDecryptionModuleProxy::SetClient(
    ::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::SetClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_SetClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_SetClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::ContentDecryptionModuleClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in ContentDecryptionModule.SetClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContentDecryptionModuleProxy::SetServerCertificate(
    const std::vector<uint8_t>& in_certificate_data, SetServerCertificateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::SetServerCertificate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("certificate_data");
      for (const auto& item0 : in_certificate_data) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_SetServerCertificate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_SetServerCertificate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->certificate_data)::BaseType::BufferWriter
      certificate_data_writer;
  const mojo::internal::ContainerValidateParams certificate_data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_certificate_data, buffer, &certificate_data_writer, &certificate_data_validate_params,
      &serialization_context);
  params->certificate_data.Set(
      certificate_data_writer.is_null() ? nullptr : certificate_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->certificate_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null certificate_data in ContentDecryptionModule.SetServerCertificate request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("SetServerCertificate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_SetServerCertificate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentDecryptionModuleProxy::GetStatusForPolicy(
    ::media::HdcpVersion in_min_hdcp_version, GetStatusForPolicyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::GetStatusForPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("min_hdcp_version", static_cast<int>(in_min_hdcp_version));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_GetStatusForPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::HdcpVersion>(
      in_min_hdcp_version, &params->min_hdcp_version);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("GetStatusForPolicy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentDecryptionModuleProxy::CreateSessionAndGenerateRequest(
    ::media::CdmSessionType in_session_type, ::media::EmeInitDataType in_init_data_type, const std::vector<uint8_t>& in_init_data, CreateSessionAndGenerateRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("session_type", static_cast<int>(in_session_type));
      raw_value->SetInteger("init_data_type", static_cast<int>(in_init_data_type));
      raw_value->BeginArray("init_data");
      for (const auto& item0 : in_init_data) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_CreateSessionAndGenerateRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::CdmSessionType>(
      in_session_type, &params->session_type);
  mojo::internal::Serialize<::media::mojom::EmeInitDataType>(
      in_init_data_type, &params->init_data_type);
  typename decltype(params->init_data)::BaseType::BufferWriter
      init_data_writer;
  const mojo::internal::ContainerValidateParams init_data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_init_data, buffer, &init_data_writer, &init_data_validate_params,
      &serialization_context);
  params->init_data.Set(
      init_data_writer.is_null() ? nullptr : init_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->init_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null init_data in ContentDecryptionModule.CreateSessionAndGenerateRequest request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CreateSessionAndGenerateRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentDecryptionModuleProxy::LoadSession(
    ::media::CdmSessionType in_session_type, const std::string& in_session_id, LoadSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::LoadSession", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("session_type", static_cast<int>(in_session_type));
      raw_value->SetString("session_id", in_session_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_LoadSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_LoadSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::CdmSessionType>(
      in_session_type, &params->session_type);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModule.LoadSession request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("LoadSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_LoadSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentDecryptionModuleProxy::UpdateSession(
    const std::string& in_session_id, const std::vector<uint8_t>& in_response, UpdateSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::UpdateSession", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      raw_value->BeginArray("response");
      for (const auto& item0 : in_response) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_UpdateSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_UpdateSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModule.UpdateSession request");
  typename decltype(params->response)::BaseType::BufferWriter
      response_writer;
  const mojo::internal::ContainerValidateParams response_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_response, buffer, &response_writer, &response_validate_params,
      &serialization_context);
  params->response.Set(
      response_writer.is_null() ? nullptr : response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in ContentDecryptionModule.UpdateSession request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("UpdateSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_UpdateSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentDecryptionModuleProxy::CloseSession(
    const std::string& in_session_id, CloseSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::CloseSession", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_CloseSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_CloseSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModule.CloseSession request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CloseSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_CloseSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentDecryptionModuleProxy::RemoveSession(
    const std::string& in_session_id, RemoveSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModule::RemoveSession", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_RemoveSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_RemoveSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModule.RemoveSession request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("RemoveSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_RemoveSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ContentDecryptionModule_SetServerCertificate_ProxyToResponder {
 public:
  static ContentDecryptionModule::SetServerCertificateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_SetServerCertificate_ProxyToResponder> proxy(
        new ContentDecryptionModule_SetServerCertificate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_SetServerCertificate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_SetServerCertificate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_SetServerCertificate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::SetServerCertificateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_SetServerCertificate_ProxyToResponder);
};

bool ContentDecryptionModule_SetServerCertificate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::SetServerCertificateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_SetServerCertificate_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ContentDecryptionModule_SetServerCertificate_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::SetServerCertificateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_SetServerCertificate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::SetServerCertificateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("SetServerCertificate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder {
 public:
  static ContentDecryptionModule::GetStatusForPolicyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder> proxy(
        new ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::GetStatusForPolicyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result, ::media::CdmKeyInformation::KeyStatus in_key_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder);
};

bool ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::GetStatusForPolicyCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ::media::CdmKeyInformation::KeyStatus p_key_status{};
  ContentDecryptionModule_GetStatusForPolicy_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadKeyStatus(&p_key_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_key_status));
  return true;
}

void ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result, ::media::CdmKeyInformation::KeyStatus in_key_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::GetStatusForPolicyCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetInteger("key_status", static_cast<int>(in_key_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_GetStatusForPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<::media::mojom::CdmKeyStatus>(
      in_key_status, &params->key_status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::GetStatusForPolicyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("GetStatusForPolicy");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder {
 public:
  static ContentDecryptionModule::CreateSessionAndGenerateRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder> proxy(
        new ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::CreateSessionAndGenerateRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result, const std::string& in_session_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder);
};

bool ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequestCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  std::string p_session_id{};
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadSessionId(&p_session_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_session_id));
  return true;
}

void ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequestCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("session_id", in_session_id);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_CreateSessionAndGenerateRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CreateSessionAndGenerateRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_LoadSession_ProxyToResponder {
 public:
  static ContentDecryptionModule::LoadSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_LoadSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_LoadSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_LoadSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_LoadSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_LoadSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::LoadSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result, const std::string& in_session_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_LoadSession_ProxyToResponder);
};

bool ContentDecryptionModule_LoadSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::LoadSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_LoadSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_LoadSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  std::string p_session_id{};
  ContentDecryptionModule_LoadSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadSessionId(&p_session_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_session_id));
  return true;
}

void ContentDecryptionModule_LoadSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::LoadSessionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("session_id", in_session_id);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_LoadSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_LoadSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::LoadSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("LoadSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_UpdateSession_ProxyToResponder {
 public:
  static ContentDecryptionModule::UpdateSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_UpdateSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_UpdateSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_UpdateSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_UpdateSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_UpdateSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::UpdateSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_UpdateSession_ProxyToResponder);
};

bool ContentDecryptionModule_UpdateSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::UpdateSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_UpdateSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ContentDecryptionModule_UpdateSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::UpdateSessionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_UpdateSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::UpdateSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("UpdateSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_CloseSession_ProxyToResponder {
 public:
  static ContentDecryptionModule::CloseSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_CloseSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_CloseSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_CloseSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_CloseSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_CloseSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::CloseSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_CloseSession_ProxyToResponder);
};

bool ContentDecryptionModule_CloseSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::CloseSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_CloseSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_CloseSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_CloseSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ContentDecryptionModule_CloseSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::CloseSessionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_CloseSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_CloseSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::CloseSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CloseSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_RemoveSession_ProxyToResponder {
 public:
  static ContentDecryptionModule::RemoveSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentDecryptionModule_RemoveSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_RemoveSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentDecryptionModule_RemoveSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_RemoveSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentDecryptionModule_RemoveSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentDecryptionModule::RemoveSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentDecryptionModule_RemoveSession_ProxyToResponder);
};

bool ContentDecryptionModule_RemoveSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::ContentDecryptionModule::RemoveSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_RemoveSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ContentDecryptionModule_RemoveSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::ContentDecryptionModule::RemoveSessionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModule_RemoveSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::ContentDecryptionModule::RemoveSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("RemoveSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContentDecryptionModuleStubDispatch::Accept(
    ContentDecryptionModule* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kContentDecryptionModule_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentDecryptionModule_SetClient_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModule_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> p_client{};
      ContentDecryptionModule_SetClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kContentDecryptionModule_SetServerCertificate_Name: {
      break;
    }
    case internal::kContentDecryptionModule_GetStatusForPolicy_Name: {
      break;
    }
    case internal::kContentDecryptionModule_CreateSessionAndGenerateRequest_Name: {
      break;
    }
    case internal::kContentDecryptionModule_LoadSession_Name: {
      break;
    }
    case internal::kContentDecryptionModule_UpdateSession_Name: {
      break;
    }
    case internal::kContentDecryptionModule_CloseSession_Name: {
      break;
    }
    case internal::kContentDecryptionModule_RemoveSession_Name: {
      break;
    }
  }
  return false;
}

// static
bool ContentDecryptionModuleStubDispatch::AcceptWithResponder(
    ContentDecryptionModule* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kContentDecryptionModule_SetClient_Name: {
      break;
    }
    case internal::kContentDecryptionModule_SetServerCertificate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::SetServerCertificate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::SetServerCertificate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_SetServerCertificate_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_SetServerCertificate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_certificate_data{};
      ContentDecryptionModule_SetServerCertificate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCertificateData(&p_certificate_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 1, false);
        return false;
      }
      ContentDecryptionModule::SetServerCertificateCallback callback =
          ContentDecryptionModule_SetServerCertificate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetServerCertificate(
std::move(p_certificate_data), std::move(callback));
      return true;
    }
    case internal::kContentDecryptionModule_GetStatusForPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::GetStatusForPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::GetStatusForPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::HdcpVersion p_min_hdcp_version{};
      ContentDecryptionModule_GetStatusForPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMinHdcpVersion(&p_min_hdcp_version))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 2, false);
        return false;
      }
      ContentDecryptionModule::GetStatusForPolicyCallback callback =
          ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStatusForPolicy(
std::move(p_min_hdcp_version), std::move(callback));
      return true;
    }
    case internal::kContentDecryptionModule_CreateSessionAndGenerateRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::CdmSessionType p_session_type{};
      ::media::EmeInitDataType p_init_data_type{};
      std::vector<uint8_t> p_init_data{};
      ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionType(&p_session_type))
        success = false;
      if (success && !input_data_view.ReadInitDataType(&p_init_data_type))
        success = false;
      if (success && !input_data_view.ReadInitData(&p_init_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 3, false);
        return false;
      }
      ContentDecryptionModule::CreateSessionAndGenerateRequestCallback callback =
          ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSessionAndGenerateRequest(
std::move(p_session_type), 
std::move(p_init_data_type), 
std::move(p_init_data), std::move(callback));
      return true;
    }
    case internal::kContentDecryptionModule_LoadSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::LoadSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::LoadSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_LoadSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_LoadSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::CdmSessionType p_session_type{};
      std::string p_session_id{};
      ContentDecryptionModule_LoadSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionType(&p_session_type))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 4, false);
        return false;
      }
      ContentDecryptionModule::LoadSessionCallback callback =
          ContentDecryptionModule_LoadSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadSession(
std::move(p_session_type), 
std::move(p_session_id), std::move(callback));
      return true;
    }
    case internal::kContentDecryptionModule_UpdateSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::UpdateSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::UpdateSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_UpdateSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_UpdateSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      std::vector<uint8_t> p_response{};
      ContentDecryptionModule_UpdateSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 5, false);
        return false;
      }
      ContentDecryptionModule::UpdateSessionCallback callback =
          ContentDecryptionModule_UpdateSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSession(
std::move(p_session_id), 
std::move(p_response), std::move(callback));
      return true;
    }
    case internal::kContentDecryptionModule_CloseSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::CloseSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::CloseSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_CloseSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_CloseSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      ContentDecryptionModule_CloseSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 6, false);
        return false;
      }
      ContentDecryptionModule::CloseSessionCallback callback =
          ContentDecryptionModule_CloseSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseSession(
std::move(p_session_id), std::move(callback));
      return true;
    }
    case internal::kContentDecryptionModule_RemoveSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModule::RemoveSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModule::RemoveSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentDecryptionModule_RemoveSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_RemoveSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      ContentDecryptionModule_RemoveSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 7, false);
        return false;
      }
      ContentDecryptionModule::RemoveSessionCallback callback =
          ContentDecryptionModule_RemoveSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSession(
std::move(p_session_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kContentDecryptionModuleValidationInfo[] = {
    {internal::kContentDecryptionModule_SetClient_Name,
     {&internal::ContentDecryptionModule_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kContentDecryptionModule_SetServerCertificate_Name,
     {&internal::ContentDecryptionModule_SetServerCertificate_Params_Data::Validate,
      &internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data::Validate}},
    {internal::kContentDecryptionModule_GetStatusForPolicy_Name,
     {&internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data::Validate,
      &internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data::Validate}},
    {internal::kContentDecryptionModule_CreateSessionAndGenerateRequest_Name,
     {&internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data::Validate,
      &internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data::Validate}},
    {internal::kContentDecryptionModule_LoadSession_Name,
     {&internal::ContentDecryptionModule_LoadSession_Params_Data::Validate,
      &internal::ContentDecryptionModule_LoadSession_ResponseParams_Data::Validate}},
    {internal::kContentDecryptionModule_UpdateSession_Name,
     {&internal::ContentDecryptionModule_UpdateSession_Params_Data::Validate,
      &internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data::Validate}},
    {internal::kContentDecryptionModule_CloseSession_Name,
     {&internal::ContentDecryptionModule_CloseSession_Params_Data::Validate,
      &internal::ContentDecryptionModule_CloseSession_ResponseParams_Data::Validate}},
    {internal::kContentDecryptionModule_RemoveSession_Name,
     {&internal::ContentDecryptionModule_RemoveSession_Params_Data::Validate,
      &internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data::Validate}},
};

bool ContentDecryptionModuleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::ContentDecryptionModule::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kContentDecryptionModuleValidationInfo);
}

bool ContentDecryptionModuleResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::ContentDecryptionModule::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kContentDecryptionModuleValidationInfo);

}
const char ContentDecryptionModuleClient::Name_[] = "media.mojom.ContentDecryptionModuleClient";

ContentDecryptionModuleClientProxy::ContentDecryptionModuleClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentDecryptionModuleClientProxy::OnSessionMessage(
    const std::string& in_session_id, ::media::CdmMessageType in_message_type, const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModuleClient::OnSessionMessage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      raw_value->SetInteger("message_type", static_cast<int>(in_message_type));
      raw_value->BeginArray("message");
      for (const auto& item0 : in_message) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModuleClient_OnSessionMessage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModuleClient.OnSessionMessage request");
  mojo::internal::Serialize<::media::mojom::CdmMessageType>(
      in_message_type, &params->message_type);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_message, buffer, &message_writer, &message_validate_params,
      &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ContentDecryptionModuleClient.OnSessionMessage request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContentDecryptionModuleClientProxy::OnSessionClosed(
    const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModuleClient::OnSessionClosed", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModuleClient_OnSessionClosed_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModuleClient.OnSessionClosed request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContentDecryptionModuleClientProxy::OnSessionKeysChange(
    const std::string& in_session_id, bool in_has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> in_keys_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      raw_value->SetBoolean("has_additional_usable_key", in_has_additional_usable_key);
      raw_value->BeginArray("keys_info");
      for (const auto& item0 : in_keys_info) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::media::CdmKeyInformation>>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModuleClient_OnSessionKeysChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModuleClient.OnSessionKeysChange request");
  params->has_additional_usable_key = in_has_additional_usable_key;
  typename decltype(params->keys_info)::BaseType::BufferWriter
      keys_info_writer;
  const mojo::internal::ContainerValidateParams keys_info_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::CdmKeyInformationDataView>>(
      in_keys_info, buffer, &keys_info_writer, &keys_info_validate_params,
      &serialization_context);
  params->keys_info.Set(
      keys_info_writer.is_null() ? nullptr : keys_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys_info in ContentDecryptionModuleClient.OnSessionKeysChange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionKeysChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContentDecryptionModuleClientProxy::OnSessionExpirationUpdate(
    const std::string& in_session_id, double in_new_expiry_time_sec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("session_id", in_session_id);
      raw_value->SetDouble("new_expiry_time_sec", in_new_expiry_time_sec);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentDecryptionModuleClient_OnSessionExpirationUpdate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session_id)::BaseType::BufferWriter
      session_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id, buffer, &session_id_writer, &serialization_context);
  params->session_id.Set(
      session_id_writer.is_null() ? nullptr : session_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in ContentDecryptionModuleClient.OnSessionExpirationUpdate request");
  params->new_expiry_time_sec = in_new_expiry_time_sec;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionExpirationUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ContentDecryptionModuleClientStubDispatch::Accept(
    ContentDecryptionModuleClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kContentDecryptionModuleClient_OnSessionMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      ::media::CdmMessageType p_message_type{};
      std::vector<uint8_t> p_message{};
      ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadMessageType(&p_message_type))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionMessage(
std::move(p_session_id), 
std::move(p_message_type), 
std::move(p_message));
      return true;
    }
    case internal::kContentDecryptionModuleClient_OnSessionClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      ContentDecryptionModuleClient_OnSessionClosed_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionClosed(
std::move(p_session_id));
      return true;
    }
    case internal::kContentDecryptionModuleClient_OnSessionKeysChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      bool p_has_additional_usable_key{};
      std::vector<::std::unique_ptr<::media::CdmKeyInformation>> p_keys_info{};
      ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success)
        p_has_additional_usable_key = input_data_view.has_additional_usable_key();
      if (success && !input_data_view.ReadKeysInfo(&p_keys_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionKeysChange(
std::move(p_session_id), 
std::move(p_has_additional_usable_key), 
std::move(p_keys_info));
      return true;
    }
    case internal::kContentDecryptionModuleClient_OnSessionExpirationUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_session_id{};
      double p_new_expiry_time_sec{};
      ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success)
        p_new_expiry_time_sec = input_data_view.new_expiry_time_sec();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionExpirationUpdate(
std::move(p_session_id), 
std::move(p_new_expiry_time_sec));
      return true;
    }
  }
  return false;
}

// static
bool ContentDecryptionModuleClientStubDispatch::AcceptWithResponder(
    ContentDecryptionModuleClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kContentDecryptionModuleClient_OnSessionMessage_Name: {
      break;
    }
    case internal::kContentDecryptionModuleClient_OnSessionClosed_Name: {
      break;
    }
    case internal::kContentDecryptionModuleClient_OnSessionKeysChange_Name: {
      break;
    }
    case internal::kContentDecryptionModuleClient_OnSessionExpirationUpdate_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kContentDecryptionModuleClientValidationInfo[] = {
    {internal::kContentDecryptionModuleClient_OnSessionMessage_Name,
     {&internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kContentDecryptionModuleClient_OnSessionClosed_Name,
     {&internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kContentDecryptionModuleClient_OnSessionKeysChange_Name,
     {&internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kContentDecryptionModuleClient_OnSessionExpirationUpdate_Name,
     {&internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ContentDecryptionModuleClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::ContentDecryptionModuleClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kContentDecryptionModuleClientValidationInfo);
}

const char CdmFactory::Name_[] = "media.mojom.CdmFactory";

class CdmFactory_CreateCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmFactory_CreateCdm_ForwardToCallback(
      CdmFactory::CreateCdmCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CdmFactory::CreateCdmCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CdmFactory_CreateCdm_ForwardToCallback);
};

CdmFactoryProxy::CdmFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmFactoryProxy::CreateCdm(
    const std::string& in_key_system, const ::media::CdmConfig& in_cdm_config, CreateCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmFactory::CreateCdm", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("key_system", in_key_system);
      raw_value->SetString("cdm_config", base::trace_event::ValueToString(in_cdm_config, "<value of type const ::media::CdmConfig&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCdmFactory_CreateCdm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::CdmFactory_CreateCdm_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->key_system)::BaseType::BufferWriter
      key_system_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_system, buffer, &key_system_writer, &serialization_context);
  params->key_system.Set(
      key_system_writer.is_null() ? nullptr : key_system_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_system.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_system in CdmFactory.CreateCdm request");
  typename decltype(params->cdm_config)::BaseType::BufferWriter
      cdm_config_writer;
  mojo::internal::Serialize<::media::mojom::CdmConfigDataView>(
      in_cdm_config, buffer, &cdm_config_writer, &serialization_context);
  params->cdm_config.Set(
      cdm_config_writer.is_null() ? nullptr : cdm_config_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_config in CdmFactory.CreateCdm request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFactory::Name_);
  message.set_method_name("CreateCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmFactory_CreateCdm_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CdmFactory_CreateCdm_ProxyToResponder {
 public:
  static CdmFactory::CreateCdmCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CdmFactory_CreateCdm_ProxyToResponder> proxy(
        new CdmFactory_CreateCdm_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CdmFactory_CreateCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmFactory_CreateCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CdmFactory_CreateCdm_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmFactory::CreateCdmCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<ContentDecryptionModule> in_cdm, const base::Optional<::base::UnguessableToken>& in_cdm_id, ::mojo::PendingRemote<::media::mojom::Decryptor> in_decryptor, const std::string& in_error_message);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CdmFactory_CreateCdm_ProxyToResponder);
};

bool CdmFactory_CreateCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::CdmFactory::CreateCdmCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CdmFactory_CreateCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmFactory_CreateCdm_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::PendingRemote<ContentDecryptionModule> p_cdm{};
  base::Optional<::base::UnguessableToken> p_cdm_id{};
  ::mojo::PendingRemote<::media::mojom::Decryptor> p_decryptor{};
  std::string p_error_message{};
  CdmFactory_CreateCdm_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success) {
    p_cdm =
        input_data_view.TakeCdm<decltype(p_cdm)>();
  }
  if (success && !input_data_view.ReadCdmId(&p_cdm_id))
    success = false;
  if (success) {
    p_decryptor =
        input_data_view.TakeDecryptor<decltype(p_decryptor)>();
  }
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cdm), 
std::move(p_cdm_id), 
std::move(p_decryptor), 
std::move(p_error_message));
  return true;
}

void CdmFactory_CreateCdm_ProxyToResponder::Run(
    ::mojo::PendingRemote<ContentDecryptionModule> in_cdm, const base::Optional<::base::UnguessableToken>& in_cdm_id, ::mojo::PendingRemote<::media::mojom::Decryptor> in_decryptor, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::CdmFactory::CreateCdmCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("cdm", in_cdm.is_valid());
      raw_value->SetString("cdm_id", base::trace_event::ValueToString(in_cdm_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetBoolean("decryptor", in_decryptor.is_valid());
      raw_value->SetString("error_message", in_error_message);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCdmFactory_CreateCdm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::CdmFactory_CreateCdm_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ContentDecryptionModuleInterfaceBase>>(
      in_cdm, &params->cdm, &serialization_context);
  typename decltype(params->cdm_id)::BaseType::BufferWriter
      cdm_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cdm_id, buffer, &cdm_id_writer, &serialization_context);
  params->cdm_id.Set(
      cdm_id_writer.is_null() ? nullptr : cdm_id_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
      in_decryptor, &params->decryptor, &serialization_context);
  typename decltype(params->error_message)::BaseType::BufferWriter
      error_message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, buffer, &error_message_writer, &serialization_context);
  params->error_message.Set(
      error_message_writer.is_null() ? nullptr : error_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::CdmFactory::CreateCdmCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFactory::Name_);
  message.set_method_name("CreateCdm");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmFactoryStubDispatch::Accept(
    CdmFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCdmFactory_CreateCdm_Name: {
      break;
    }
  }
  return false;
}

// static
bool CdmFactoryStubDispatch::AcceptWithResponder(
    CdmFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCdmFactory_CreateCdm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmFactory::CreateCdm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmFactory::CreateCdm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CdmFactory_CreateCdm_Params_Data* params =
          reinterpret_cast<
              internal::CdmFactory_CreateCdm_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_key_system{};
      ::media::CdmConfig p_cdm_config{};
      CdmFactory_CreateCdm_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKeySystem(&p_key_system))
        success = false;
      if (success && !input_data_view.ReadCdmConfig(&p_cdm_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmFactory::Name_, 0, false);
        return false;
      }
      CdmFactory::CreateCdmCallback callback =
          CdmFactory_CreateCdm_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdm(
std::move(p_key_system), 
std::move(p_cdm_config), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmFactoryValidationInfo[] = {
    {internal::kCdmFactory_CreateCdm_Name,
     {&internal::CdmFactory_CreateCdm_Params_Data::Validate,
      &internal::CdmFactory_CreateCdm_ResponseParams_Data::Validate}},
};

bool CdmFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::CdmFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmFactoryValidationInfo);
}

bool CdmFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::CdmFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCdmFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::CdmPromiseResult::DataView, ::media::mojom::CdmPromiseResultPtr>::Read(
    ::media::mojom::CdmPromiseResult::DataView input,
    ::media::mojom::CdmPromiseResultPtr* output) {
  bool success = true;
  ::media::mojom::CdmPromiseResultPtr result(::media::mojom::CdmPromiseResult::New());
  
      if (success)
        result->success = input.success();
      if (success && !input.ReadException(&result->exception))
        success = false;
      if (success)
        result->system_code = input.system_code();
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::CdmKeyInformation::DataView, ::media::mojom::CdmKeyInformationPtr>::Read(
    ::media::mojom::CdmKeyInformation::DataView input,
    ::media::mojom::CdmKeyInformationPtr* output) {
  bool success = true;
  ::media::mojom::CdmKeyInformationPtr result(::media::mojom::CdmKeyInformation::New());
  
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->system_code = input.system_code();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif