// services/viz/privileged/mojom/gl/gpu_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace viz {
namespace mojom {
namespace internal {
class  GpuService_EstablishGpuChannel_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_EstablishGpuChannel_Params_Data));
      new (data()) GpuService_EstablishGpuChannel_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_EstablishGpuChannel_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_EstablishGpuChannel_Params_Data>(index_);
    }
    GpuService_EstablishGpuChannel_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t is_gpu_host : 1;
  uint8_t cache_shaders_on_disk : 1;
  uint8_t pad2_[3];
  uint64_t client_tracing_id;

 private:
  GpuService_EstablishGpuChannel_Params_Data();
  ~GpuService_EstablishGpuChannel_Params_Data() = delete;
};
static_assert(sizeof(GpuService_EstablishGpuChannel_Params_Data) == 24,
              "Bad sizeof(GpuService_EstablishGpuChannel_Params_Data)");
class  GpuService_EstablishGpuChannel_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_EstablishGpuChannel_ResponseParams_Data));
      new (data()) GpuService_EstablishGpuChannel_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_EstablishGpuChannel_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_EstablishGpuChannel_ResponseParams_Data>(index_);
    }
    GpuService_EstablishGpuChannel_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data channel_handle;
  uint8_t padfinal_[4];

 private:
  GpuService_EstablishGpuChannel_ResponseParams_Data();
  ~GpuService_EstablishGpuChannel_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_EstablishGpuChannel_ResponseParams_Data) == 16,
              "Bad sizeof(GpuService_EstablishGpuChannel_ResponseParams_Data)");
class  GpuService_CloseChannel_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_CloseChannel_Params_Data));
      new (data()) GpuService_CloseChannel_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_CloseChannel_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_CloseChannel_Params_Data>(index_);
    }
    GpuService_CloseChannel_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t padfinal_[4];

 private:
  GpuService_CloseChannel_Params_Data();
  ~GpuService_CloseChannel_Params_Data() = delete;
};
static_assert(sizeof(GpuService_CloseChannel_Params_Data) == 16,
              "Bad sizeof(GpuService_CloseChannel_Params_Data)");
class  GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data));
      new (data()) GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data>(index_);
    }
    GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data vea_provider;
  uint8_t padfinal_[4];

 private:
  GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data();
  ~GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data() = delete;
};
static_assert(sizeof(GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data) == 16,
              "Bad sizeof(GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data)");
class  GpuService_CreateGpuMemoryBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_CreateGpuMemoryBuffer_Params_Data));
      new (data()) GpuService_CreateGpuMemoryBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_CreateGpuMemoryBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_CreateGpuMemoryBuffer_Params_Data>(index_);
    }
    GpuService_CreateGpuMemoryBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferId_Data> id;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;
  int32_t format;
  int32_t usage;
  int32_t client_id;
  uint8_t pad4_[4];
  mojo::internal::Pointer<::gpu::mojom::internal::SurfaceHandle_Data> surface_handle;

 private:
  GpuService_CreateGpuMemoryBuffer_Params_Data();
  ~GpuService_CreateGpuMemoryBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuService_CreateGpuMemoryBuffer_Params_Data) == 48,
              "Bad sizeof(GpuService_CreateGpuMemoryBuffer_Params_Data)");
class  GpuService_CreateGpuMemoryBuffer_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_CreateGpuMemoryBuffer_ResponseParams_Data));
      new (data()) GpuService_CreateGpuMemoryBuffer_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_CreateGpuMemoryBuffer_ResponseParams_Data>(index_);
    }
    GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> buffer_handle;

 private:
  GpuService_CreateGpuMemoryBuffer_ResponseParams_Data();
  ~GpuService_CreateGpuMemoryBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_CreateGpuMemoryBuffer_ResponseParams_Data) == 16,
              "Bad sizeof(GpuService_CreateGpuMemoryBuffer_ResponseParams_Data)");
class  GpuService_DestroyGpuMemoryBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_DestroyGpuMemoryBuffer_Params_Data));
      new (data()) GpuService_DestroyGpuMemoryBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_DestroyGpuMemoryBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_DestroyGpuMemoryBuffer_Params_Data>(index_);
    }
    GpuService_DestroyGpuMemoryBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferId_Data> id;
  int32_t client_id;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;

 private:
  GpuService_DestroyGpuMemoryBuffer_Params_Data();
  ~GpuService_DestroyGpuMemoryBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DestroyGpuMemoryBuffer_Params_Data) == 32,
              "Bad sizeof(GpuService_DestroyGpuMemoryBuffer_Params_Data)");
class  GpuService_GetVideoMemoryUsageStats_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_GetVideoMemoryUsageStats_Params_Data));
      new (data()) GpuService_GetVideoMemoryUsageStats_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_GetVideoMemoryUsageStats_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_GetVideoMemoryUsageStats_Params_Data>(index_);
    }
    GpuService_GetVideoMemoryUsageStats_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_GetVideoMemoryUsageStats_Params_Data();
  ~GpuService_GetVideoMemoryUsageStats_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GetVideoMemoryUsageStats_Params_Data) == 8,
              "Bad sizeof(GpuService_GetVideoMemoryUsageStats_Params_Data)");
class  GpuService_GetVideoMemoryUsageStats_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_GetVideoMemoryUsageStats_ResponseParams_Data));
      new (data()) GpuService_GetVideoMemoryUsageStats_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_GetVideoMemoryUsageStats_ResponseParams_Data>(index_);
    }
    GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::VideoMemoryUsageStats_Data> stats;

 private:
  GpuService_GetVideoMemoryUsageStats_ResponseParams_Data();
  ~GpuService_GetVideoMemoryUsageStats_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_GetVideoMemoryUsageStats_ResponseParams_Data) == 16,
              "Bad sizeof(GpuService_GetVideoMemoryUsageStats_ResponseParams_Data)");
class  GpuService_StartPeakMemoryMonitor_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_StartPeakMemoryMonitor_Params_Data));
      new (data()) GpuService_StartPeakMemoryMonitor_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_StartPeakMemoryMonitor_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_StartPeakMemoryMonitor_Params_Data>(index_);
    }
    GpuService_StartPeakMemoryMonitor_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t sequence_num;
  uint8_t padfinal_[4];

 private:
  GpuService_StartPeakMemoryMonitor_Params_Data();
  ~GpuService_StartPeakMemoryMonitor_Params_Data() = delete;
};
static_assert(sizeof(GpuService_StartPeakMemoryMonitor_Params_Data) == 16,
              "Bad sizeof(GpuService_StartPeakMemoryMonitor_Params_Data)");
class  GpuService_GetPeakMemoryUsage_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_GetPeakMemoryUsage_Params_Data));
      new (data()) GpuService_GetPeakMemoryUsage_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_GetPeakMemoryUsage_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_GetPeakMemoryUsage_Params_Data>(index_);
    }
    GpuService_GetPeakMemoryUsage_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t sequence_num;
  uint8_t padfinal_[4];

 private:
  GpuService_GetPeakMemoryUsage_Params_Data();
  ~GpuService_GetPeakMemoryUsage_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GetPeakMemoryUsage_Params_Data) == 16,
              "Bad sizeof(GpuService_GetPeakMemoryUsage_Params_Data)");
class  GpuService_GetPeakMemoryUsage_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_GetPeakMemoryUsage_ResponseParams_Data));
      new (data()) GpuService_GetPeakMemoryUsage_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_GetPeakMemoryUsage_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_GetPeakMemoryUsage_ResponseParams_Data>(index_);
    }
    GpuService_GetPeakMemoryUsage_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t memory_usage;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, uint64_t>> memory_per_allocation_source;

 private:
  GpuService_GetPeakMemoryUsage_ResponseParams_Data();
  ~GpuService_GetPeakMemoryUsage_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_GetPeakMemoryUsage_ResponseParams_Data) == 24,
              "Bad sizeof(GpuService_GetPeakMemoryUsage_ResponseParams_Data)");
class  GpuService_RequestHDRStatus_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_RequestHDRStatus_Params_Data));
      new (data()) GpuService_RequestHDRStatus_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_RequestHDRStatus_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_RequestHDRStatus_Params_Data>(index_);
    }
    GpuService_RequestHDRStatus_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_RequestHDRStatus_Params_Data();
  ~GpuService_RequestHDRStatus_Params_Data() = delete;
};
static_assert(sizeof(GpuService_RequestHDRStatus_Params_Data) == 8,
              "Bad sizeof(GpuService_RequestHDRStatus_Params_Data)");
class  GpuService_RequestHDRStatus_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_RequestHDRStatus_ResponseParams_Data));
      new (data()) GpuService_RequestHDRStatus_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_RequestHDRStatus_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_RequestHDRStatus_ResponseParams_Data>(index_);
    }
    GpuService_RequestHDRStatus_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t hdr_enabled : 1;
  uint8_t padfinal_[7];

 private:
  GpuService_RequestHDRStatus_ResponseParams_Data();
  ~GpuService_RequestHDRStatus_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_RequestHDRStatus_ResponseParams_Data) == 16,
              "Bad sizeof(GpuService_RequestHDRStatus_ResponseParams_Data)");
class  GpuService_LoadedShader_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_LoadedShader_Params_Data));
      new (data()) GpuService_LoadedShader_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_LoadedShader_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_LoadedShader_Params_Data>(index_);
    }
    GpuService_LoadedShader_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> key;
  mojo::internal::Pointer<mojo::internal::String_Data> data;

 private:
  GpuService_LoadedShader_Params_Data();
  ~GpuService_LoadedShader_Params_Data() = delete;
};
static_assert(sizeof(GpuService_LoadedShader_Params_Data) == 32,
              "Bad sizeof(GpuService_LoadedShader_Params_Data)");
class  GpuService_WakeUpGpu_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_WakeUpGpu_Params_Data));
      new (data()) GpuService_WakeUpGpu_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_WakeUpGpu_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_WakeUpGpu_Params_Data>(index_);
    }
    GpuService_WakeUpGpu_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_WakeUpGpu_Params_Data();
  ~GpuService_WakeUpGpu_Params_Data() = delete;
};
static_assert(sizeof(GpuService_WakeUpGpu_Params_Data) == 8,
              "Bad sizeof(GpuService_WakeUpGpu_Params_Data)");
class  GpuService_GpuSwitched_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_GpuSwitched_Params_Data));
      new (data()) GpuService_GpuSwitched_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_GpuSwitched_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_GpuSwitched_Params_Data>(index_);
    }
    GpuService_GpuSwitched_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t active_gpu_heuristic;
  uint8_t padfinal_[4];

 private:
  GpuService_GpuSwitched_Params_Data();
  ~GpuService_GpuSwitched_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GpuSwitched_Params_Data) == 16,
              "Bad sizeof(GpuService_GpuSwitched_Params_Data)");
class  GpuService_DisplayAdded_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_DisplayAdded_Params_Data));
      new (data()) GpuService_DisplayAdded_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_DisplayAdded_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_DisplayAdded_Params_Data>(index_);
    }
    GpuService_DisplayAdded_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_DisplayAdded_Params_Data();
  ~GpuService_DisplayAdded_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DisplayAdded_Params_Data) == 8,
              "Bad sizeof(GpuService_DisplayAdded_Params_Data)");
class  GpuService_DisplayRemoved_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_DisplayRemoved_Params_Data));
      new (data()) GpuService_DisplayRemoved_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_DisplayRemoved_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_DisplayRemoved_Params_Data>(index_);
    }
    GpuService_DisplayRemoved_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_DisplayRemoved_Params_Data();
  ~GpuService_DisplayRemoved_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DisplayRemoved_Params_Data) == 8,
              "Bad sizeof(GpuService_DisplayRemoved_Params_Data)");
class  GpuService_DestroyAllChannels_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_DestroyAllChannels_Params_Data));
      new (data()) GpuService_DestroyAllChannels_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_DestroyAllChannels_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_DestroyAllChannels_Params_Data>(index_);
    }
    GpuService_DestroyAllChannels_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_DestroyAllChannels_Params_Data();
  ~GpuService_DestroyAllChannels_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DestroyAllChannels_Params_Data) == 8,
              "Bad sizeof(GpuService_DestroyAllChannels_Params_Data)");
class  GpuService_OnBackgroundCleanup_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_OnBackgroundCleanup_Params_Data));
      new (data()) GpuService_OnBackgroundCleanup_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_OnBackgroundCleanup_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_OnBackgroundCleanup_Params_Data>(index_);
    }
    GpuService_OnBackgroundCleanup_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_OnBackgroundCleanup_Params_Data();
  ~GpuService_OnBackgroundCleanup_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnBackgroundCleanup_Params_Data) == 8,
              "Bad sizeof(GpuService_OnBackgroundCleanup_Params_Data)");
class  GpuService_OnBackgrounded_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_OnBackgrounded_Params_Data));
      new (data()) GpuService_OnBackgrounded_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_OnBackgrounded_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_OnBackgrounded_Params_Data>(index_);
    }
    GpuService_OnBackgrounded_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_OnBackgrounded_Params_Data();
  ~GpuService_OnBackgrounded_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnBackgrounded_Params_Data) == 8,
              "Bad sizeof(GpuService_OnBackgrounded_Params_Data)");
class  GpuService_OnForegrounded_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_OnForegrounded_Params_Data));
      new (data()) GpuService_OnForegrounded_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_OnForegrounded_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_OnForegrounded_Params_Data>(index_);
    }
    GpuService_OnForegrounded_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_OnForegrounded_Params_Data();
  ~GpuService_OnForegrounded_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnForegrounded_Params_Data) == 8,
              "Bad sizeof(GpuService_OnForegrounded_Params_Data)");
class  GpuService_OnMemoryPressure_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_OnMemoryPressure_Params_Data));
      new (data()) GpuService_OnMemoryPressure_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_OnMemoryPressure_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_OnMemoryPressure_Params_Data>(index_);
    }
    GpuService_OnMemoryPressure_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t level;
  uint8_t padfinal_[4];

 private:
  GpuService_OnMemoryPressure_Params_Data();
  ~GpuService_OnMemoryPressure_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnMemoryPressure_Params_Data) == 16,
              "Bad sizeof(GpuService_OnMemoryPressure_Params_Data)");
class  GpuService_Crash_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_Crash_Params_Data));
      new (data()) GpuService_Crash_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_Crash_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_Crash_Params_Data>(index_);
    }
    GpuService_Crash_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_Crash_Params_Data();
  ~GpuService_Crash_Params_Data() = delete;
};
static_assert(sizeof(GpuService_Crash_Params_Data) == 8,
              "Bad sizeof(GpuService_Crash_Params_Data)");
class  GpuService_Hang_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_Hang_Params_Data));
      new (data()) GpuService_Hang_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_Hang_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_Hang_Params_Data>(index_);
    }
    GpuService_Hang_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_Hang_Params_Data();
  ~GpuService_Hang_Params_Data() = delete;
};
static_assert(sizeof(GpuService_Hang_Params_Data) == 8,
              "Bad sizeof(GpuService_Hang_Params_Data)");
class  GpuService_ThrowJavaException_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_ThrowJavaException_Params_Data));
      new (data()) GpuService_ThrowJavaException_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_ThrowJavaException_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_ThrowJavaException_Params_Data>(index_);
    }
    GpuService_ThrowJavaException_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_ThrowJavaException_Params_Data();
  ~GpuService_ThrowJavaException_Params_Data() = delete;
};
static_assert(sizeof(GpuService_ThrowJavaException_Params_Data) == 8,
              "Bad sizeof(GpuService_ThrowJavaException_Params_Data)");
class  GpuService_Stop_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_Stop_Params_Data));
      new (data()) GpuService_Stop_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_Stop_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_Stop_Params_Data>(index_);
    }
    GpuService_Stop_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_Stop_Params_Data();
  ~GpuService_Stop_Params_Data() = delete;
};
static_assert(sizeof(GpuService_Stop_Params_Data) == 8,
              "Bad sizeof(GpuService_Stop_Params_Data)");
class  GpuService_Stop_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuService_Stop_ResponseParams_Data));
      new (data()) GpuService_Stop_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuService_Stop_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuService_Stop_ResponseParams_Data>(index_);
    }
    GpuService_Stop_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuService_Stop_ResponseParams_Data();
  ~GpuService_Stop_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_Stop_ResponseParams_Data) == 8,
              "Bad sizeof(GpuService_Stop_ResponseParams_Data)");

}  // namespace internal


class GpuService_EstablishGpuChannel_ParamsDataView {
 public:
  GpuService_EstablishGpuChannel_ParamsDataView() {}

  GpuService_EstablishGpuChannel_ParamsDataView(
      internal::GpuService_EstablishGpuChannel_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  uint64_t client_tracing_id() const {
    return data_->client_tracing_id;
  }
  bool is_gpu_host() const {
    return data_->is_gpu_host;
  }
  bool cache_shaders_on_disk() const {
    return data_->cache_shaders_on_disk;
  }
 private:
  internal::GpuService_EstablishGpuChannel_Params_Data* data_ = nullptr;
};



class GpuService_EstablishGpuChannel_ResponseParamsDataView {
 public:
  GpuService_EstablishGpuChannel_ResponseParamsDataView() {}

  GpuService_EstablishGpuChannel_ResponseParamsDataView(
      internal::GpuService_EstablishGpuChannel_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  mojo::ScopedMessagePipeHandle TakeChannelHandle() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->channel_handle, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_CloseChannel_ParamsDataView {
 public:
  GpuService_CloseChannel_ParamsDataView() {}

  GpuService_CloseChannel_ParamsDataView(
      internal::GpuService_CloseChannel_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
 private:
  internal::GpuService_CloseChannel_Params_Data* data_ = nullptr;
};



class GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView {
 public:
  GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView() {}

  GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView(
      internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeVeaProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
            &data_->vea_provider, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_CreateGpuMemoryBuffer_ParamsDataView {
 public:
  GpuService_CreateGpuMemoryBuffer_ParamsDataView() {}

  GpuService_CreateGpuMemoryBuffer_ParamsDataView(
      internal::GpuService_CreateGpuMemoryBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::gfx::mojom::GpuMemoryBufferIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        pointer, output, context_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::gfx::mojom::BufferFormat>(
        data_value, output);
  }

  ::gfx::mojom::BufferFormat format() const {
    return static_cast<::gfx::mojom::BufferFormat>(data_->format);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUsage(UserType* output) const {
    auto data_value = data_->usage;
    return mojo::internal::Deserialize<::gfx::mojom::BufferUsage>(
        data_value, output);
  }

  ::gfx::mojom::BufferUsage usage() const {
    return static_cast<::gfx::mojom::BufferUsage>(data_->usage);
  }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetSurfaceHandleDataView(
      ::gpu::mojom::SurfaceHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSurfaceHandle(UserType* output) {
    
    auto* pointer = data_->surface_handle.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SurfaceHandleDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuService_CreateGpuMemoryBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView {
 public:
  GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView() {}

  GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView(
      internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBufferHandle(UserType* output) {
    
    auto* pointer = data_->buffer_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_DestroyGpuMemoryBuffer_ParamsDataView {
 public:
  GpuService_DestroyGpuMemoryBuffer_ParamsDataView() {}

  GpuService_DestroyGpuMemoryBuffer_ParamsDataView(
      internal::GpuService_DestroyGpuMemoryBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::gfx::mojom::GpuMemoryBufferIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        pointer, output, context_);
  }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuService_DestroyGpuMemoryBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_GetVideoMemoryUsageStats_ParamsDataView {
 public:
  GpuService_GetVideoMemoryUsageStats_ParamsDataView() {}

  GpuService_GetVideoMemoryUsageStats_ParamsDataView(
      internal::GpuService_GetVideoMemoryUsageStats_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_GetVideoMemoryUsageStats_Params_Data* data_ = nullptr;
};



class GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView {
 public:
  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView() {}

  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView(
      internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetStatsDataView(
      ::gpu::mojom::VideoMemoryUsageStatsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStats(UserType* output) {
    
    auto* pointer = data_->stats.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VideoMemoryUsageStatsDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_StartPeakMemoryMonitor_ParamsDataView {
 public:
  GpuService_StartPeakMemoryMonitor_ParamsDataView() {}

  GpuService_StartPeakMemoryMonitor_ParamsDataView(
      internal::GpuService_StartPeakMemoryMonitor_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t sequence_num() const {
    return data_->sequence_num;
  }
 private:
  internal::GpuService_StartPeakMemoryMonitor_Params_Data* data_ = nullptr;
};



class GpuService_GetPeakMemoryUsage_ParamsDataView {
 public:
  GpuService_GetPeakMemoryUsage_ParamsDataView() {}

  GpuService_GetPeakMemoryUsage_ParamsDataView(
      internal::GpuService_GetPeakMemoryUsage_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t sequence_num() const {
    return data_->sequence_num;
  }
 private:
  internal::GpuService_GetPeakMemoryUsage_Params_Data* data_ = nullptr;
};



class GpuService_GetPeakMemoryUsage_ResponseParamsDataView {
 public:
  GpuService_GetPeakMemoryUsage_ResponseParamsDataView() {}

  GpuService_GetPeakMemoryUsage_ResponseParamsDataView(
      internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t memory_usage() const {
    return data_->memory_usage;
  }
  inline void GetMemoryPerAllocationSourceDataView(
      mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMemoryPerAllocationSource(UserType* output) {
    
    auto* pointer = data_->memory_per_allocation_source.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>>(
        pointer, output, context_);
  }
 private:
  internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_RequestHDRStatus_ParamsDataView {
 public:
  GpuService_RequestHDRStatus_ParamsDataView() {}

  GpuService_RequestHDRStatus_ParamsDataView(
      internal::GpuService_RequestHDRStatus_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_RequestHDRStatus_Params_Data* data_ = nullptr;
};



class GpuService_RequestHDRStatus_ResponseParamsDataView {
 public:
  GpuService_RequestHDRStatus_ResponseParamsDataView() {}

  GpuService_RequestHDRStatus_ResponseParamsDataView(
      internal::GpuService_RequestHDRStatus_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool hdr_enabled() const {
    return data_->hdr_enabled;
  }
 private:
  internal::GpuService_RequestHDRStatus_ResponseParams_Data* data_ = nullptr;
};



class GpuService_LoadedShader_ParamsDataView {
 public:
  GpuService_LoadedShader_ParamsDataView() {}

  GpuService_LoadedShader_ParamsDataView(
      internal::GpuService_LoadedShader_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuService_LoadedShader_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuService_WakeUpGpu_ParamsDataView {
 public:
  GpuService_WakeUpGpu_ParamsDataView() {}

  GpuService_WakeUpGpu_ParamsDataView(
      internal::GpuService_WakeUpGpu_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_WakeUpGpu_Params_Data* data_ = nullptr;
};



class GpuService_GpuSwitched_ParamsDataView {
 public:
  GpuService_GpuSwitched_ParamsDataView() {}

  GpuService_GpuSwitched_ParamsDataView(
      internal::GpuService_GpuSwitched_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadActiveGpuHeuristic(UserType* output) const {
    auto data_value = data_->active_gpu_heuristic;
    return mojo::internal::Deserialize<::gl::mojom::GpuPreference>(
        data_value, output);
  }

  ::gl::mojom::GpuPreference active_gpu_heuristic() const {
    return static_cast<::gl::mojom::GpuPreference>(data_->active_gpu_heuristic);
  }
 private:
  internal::GpuService_GpuSwitched_Params_Data* data_ = nullptr;
};



class GpuService_DisplayAdded_ParamsDataView {
 public:
  GpuService_DisplayAdded_ParamsDataView() {}

  GpuService_DisplayAdded_ParamsDataView(
      internal::GpuService_DisplayAdded_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DisplayAdded_Params_Data* data_ = nullptr;
};



class GpuService_DisplayRemoved_ParamsDataView {
 public:
  GpuService_DisplayRemoved_ParamsDataView() {}

  GpuService_DisplayRemoved_ParamsDataView(
      internal::GpuService_DisplayRemoved_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DisplayRemoved_Params_Data* data_ = nullptr;
};



class GpuService_DestroyAllChannels_ParamsDataView {
 public:
  GpuService_DestroyAllChannels_ParamsDataView() {}

  GpuService_DestroyAllChannels_ParamsDataView(
      internal::GpuService_DestroyAllChannels_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DestroyAllChannels_Params_Data* data_ = nullptr;
};



class GpuService_OnBackgroundCleanup_ParamsDataView {
 public:
  GpuService_OnBackgroundCleanup_ParamsDataView() {}

  GpuService_OnBackgroundCleanup_ParamsDataView(
      internal::GpuService_OnBackgroundCleanup_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_OnBackgroundCleanup_Params_Data* data_ = nullptr;
};



class GpuService_OnBackgrounded_ParamsDataView {
 public:
  GpuService_OnBackgrounded_ParamsDataView() {}

  GpuService_OnBackgrounded_ParamsDataView(
      internal::GpuService_OnBackgrounded_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_OnBackgrounded_Params_Data* data_ = nullptr;
};



class GpuService_OnForegrounded_ParamsDataView {
 public:
  GpuService_OnForegrounded_ParamsDataView() {}

  GpuService_OnForegrounded_ParamsDataView(
      internal::GpuService_OnForegrounded_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_OnForegrounded_Params_Data* data_ = nullptr;
};



class GpuService_OnMemoryPressure_ParamsDataView {
 public:
  GpuService_OnMemoryPressure_ParamsDataView() {}

  GpuService_OnMemoryPressure_ParamsDataView(
      internal::GpuService_OnMemoryPressure_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLevel(UserType* output) const {
    auto data_value = data_->level;
    return mojo::internal::Deserialize<::mojo_base::mojom::MemoryPressureLevel>(
        data_value, output);
  }

  ::mojo_base::mojom::MemoryPressureLevel level() const {
    return static_cast<::mojo_base::mojom::MemoryPressureLevel>(data_->level);
  }
 private:
  internal::GpuService_OnMemoryPressure_Params_Data* data_ = nullptr;
};



class GpuService_Crash_ParamsDataView {
 public:
  GpuService_Crash_ParamsDataView() {}

  GpuService_Crash_ParamsDataView(
      internal::GpuService_Crash_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_Crash_Params_Data* data_ = nullptr;
};



class GpuService_Hang_ParamsDataView {
 public:
  GpuService_Hang_ParamsDataView() {}

  GpuService_Hang_ParamsDataView(
      internal::GpuService_Hang_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_Hang_Params_Data* data_ = nullptr;
};



class GpuService_ThrowJavaException_ParamsDataView {
 public:
  GpuService_ThrowJavaException_ParamsDataView() {}

  GpuService_ThrowJavaException_ParamsDataView(
      internal::GpuService_ThrowJavaException_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_ThrowJavaException_Params_Data* data_ = nullptr;
};



class GpuService_Stop_ParamsDataView {
 public:
  GpuService_Stop_ParamsDataView() {}

  GpuService_Stop_ParamsDataView(
      internal::GpuService_Stop_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_Stop_Params_Data* data_ = nullptr;
};



class GpuService_Stop_ResponseParamsDataView {
 public:
  GpuService_Stop_ResponseParamsDataView() {}

  GpuService_Stop_ResponseParamsDataView(
      internal::GpuService_Stop_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_Stop_ResponseParams_Data* data_ = nullptr;
};










inline void GpuService_CreateGpuMemoryBuffer_ParamsDataView::GetIdDataView(
    ::gfx::mojom::GpuMemoryBufferIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::gfx::mojom::GpuMemoryBufferIdDataView(pointer, context_);
}
inline void GpuService_CreateGpuMemoryBuffer_ParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void GpuService_CreateGpuMemoryBuffer_ParamsDataView::GetSurfaceHandleDataView(
    ::gpu::mojom::SurfaceHandleDataView* output) {
  auto pointer = data_->surface_handle.Get();
  *output = ::gpu::mojom::SurfaceHandleDataView(pointer, context_);
}


inline void GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView::GetBufferHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->buffer_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, context_);
}


inline void GpuService_DestroyGpuMemoryBuffer_ParamsDataView::GetIdDataView(
    ::gfx::mojom::GpuMemoryBufferIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::gfx::mojom::GpuMemoryBufferIdDataView(pointer, context_);
}
inline void GpuService_DestroyGpuMemoryBuffer_ParamsDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, context_);
}




inline void GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView::GetStatsDataView(
    ::gpu::mojom::VideoMemoryUsageStatsDataView* output) {
  auto pointer = data_->stats.Get();
  *output = ::gpu::mojom::VideoMemoryUsageStatsDataView(pointer, context_);
}






inline void GpuService_GetPeakMemoryUsage_ResponseParamsDataView::GetMemoryPerAllocationSourceDataView(
    mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>* output) {
  auto pointer = data_->memory_per_allocation_source.Get();
  *output = mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>(pointer, context_);
}






inline void GpuService_LoadedShader_ParamsDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void GpuService_LoadedShader_ParamsDataView::GetDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->data.Get();
  *output = mojo::StringDataView(pointer, context_);
}





























}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_PARAMS_DATA_H_