/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "QtOAIBaseApi.h"
#include "QtOAIHttpRequest.h"

#include <QtCore/QDir>
#include <QtCore/qjsonarray.h>
#include <QtCore/qjsondocument.h>
#include <QtNetwork/qhttpmultipart.h>
#include <QtNetwork/qnetworkaccessmanager.h>
#include <QtNetwork/qnetworkrequestfactory.h>
#include <QtNetwork/qrestaccessmanager.h>

QT_BEGIN_NAMESPACE
using namespace Qt::StringLiterals;
QT_END_NAMESPACE

namespace QtCommonOpenAPI {

QtOAIBaseApi::QtOAIBaseApi(QObject *parent)
    : QObject(parent),
      m_workingDirectory(QDir::currentPath()),
      m_manager(nullptr),
      m_restManager(nullptr),
      m_networkFactory(nullptr),
      m_isResponseCompressionEnabled(false),
      m_isRequestCompressionEnabled(false)
{
    if (!m_manager) {
        m_manager = std::make_shared<QNetworkAccessManager>();
    }
    if (!m_restManager) {
        m_restManager = std::make_shared<QRestAccessManager>(m_manager.get(), this);
    }
    if (!m_networkFactory) {
        m_networkFactory = std::make_shared<QNetworkRequestFactory>();
    }
}

QtOAIBaseApi::~QtOAIBaseApi()
{
}

QtOAIBaseApi::ServerError QtOAIBaseApi::setDefaultServerValue(int serverIndex, const QString &operation, const QString &variable, const QString &value)
{
    auto it = m_serverConfigs.find(operation);

    if (it == m_serverConfigs.end()) {
        return ServerError::OperationNotFound;
    } else if (serverIndex  >= it.value().size()) {
        return ServerError::ServerIndexNotFound;
    }

    return m_serverConfigs[operation][serverIndex].setDefaultValue(variable,value);
}

QtOAIBaseApi::ServerError QtOAIBaseApi::setServerIndex(const QString &operation, int serverIndex)
{
    if (!m_serverIndices.contains(operation))
        return ServerError::OperationNotFound;

    if (serverIndex >= m_serverConfigs.find(operation).value().size())
        return ServerError::ServerIndexNotFound;

    m_serverIndices[operation] = serverIndex;
    return ServerError::NoError;
}

void QtOAIBaseApi::setApiKey(const QString &apiKeyName, const QString &apiKey)
{
    m_apiKeys.insert(apiKeyName, apiKey);
}

void QtOAIBaseApi::setBearerToken(const QString &token)
{
    m_bearerToken = token;
}

void QtOAIBaseApi::setUsername(const QString &username)
{
    m_username = username;
}

void QtOAIBaseApi::setPassword(const QString &password)
{
    m_password = password;
}

void QtOAIBaseApi::setTimeOut(std::chrono::milliseconds timeOut)
{
    m_networkFactory->setTransferTimeout(timeOut);
}

#if QT_CONFIG(ssl)
void QtOAIBaseApi::setSslConfiguration(QSslConfiguration config)
{
    m_networkFactory->setSslConfiguration(config);
}
#endif // ssl

void QtOAIBaseApi::setWorkingDirectory(const QString &path)
{
    m_workingDirectory = path;
}

void QtOAIBaseApi::setNetworkAccessResources(std::shared_ptr<QNetworkAccessManager> manager, std::shared_ptr<QRestAccessManager> ram)
{
    if (manager == m_manager)
        return;
    if (!manager || !ram || (manager.get() != ram->networkAccessManager()))
        qCritical() << "Network resources are not valid.";
    m_manager.reset();
    m_restManager.reset();
    m_manager = manager;
    m_restManager = ram;
}

void QtOAIBaseApi::setNetworkRequestFactory(std::shared_ptr<QNetworkRequestFactory> factory)
{
    if (m_networkFactory == factory)
        return;
    if (!factory)
        qCritical() << "New network factory cannot be null.";
    m_networkFactory.reset();
    m_networkFactory = factory;
}

/**
 * Appends a new ServerConfiguration to the config map for a specific operation.
 * @param operation The id to the target operation.
 * @param urlTemplate A string that contains the URL template of the server
 * @param description A String that describes the server
 * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
 * returns the index of the new server config on success and std::nullopt if the operation is not found
 */
std::optional<int> QtOAIBaseApi::addServerConfiguration(const QString &operation, const QString &urlTemplate, const QString &description, const QMap<QString, QtOAIServerVariable> &variables)
{
    if (m_serverConfigs.contains(operation)) {
        m_serverConfigs[operation].append(QtOAIServerConfiguration(
                    urlTemplate,
                    description,
                    variables));
        return m_serverConfigs[operation].size()-1;
    }

    return std::nullopt; // ServerError::OperationNotFound
}

/**
 * Appends a new ServerConfiguration to the config map for all operations and sets the index to that server.
 * @param urlTemplate A string that contains the URL template of the server
 * @param description A String that describes the server
 * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
 */
QtOAIBaseApi::ServerError QtOAIBaseApi::setNewServerForAllOperations(const QString &urlTemplate, const QString &description, const QMap<QString, QtOAIServerVariable> &variables)
{
    QtOAIBaseApi::ServerError err = ServerError::ServerIndexNotFound;

    for (auto keyIt = m_serverIndices.keyBegin(); keyIt != m_serverIndices.keyEnd(); keyIt++) {
        err = setNewServer(*keyIt, urlTemplate, description, variables);
        if (err != ServerError::NoError) // Mark failure but continue with other operations
            qWarning() <<"Failed to set server configuration for " << *keyIt << " operation. Error:" << errorString(err);
    }

    return err;
}

/**
 * Appends a new ServerConfiguration to the config map for an operation and sets the index to that server.
 * @param operation A name of user operation
 * @param urlTemplate A string that contains the URL template of the server
 * @param description A String that describes the server
 * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
 */
QtOAIBaseApi::ServerError QtOAIBaseApi::setNewServer(const QString &operation, const QString &urlTemplate, const QString &description, const QMap<QString, QtOAIServerVariable> &variables)
{
    std::optional<int> serverIndex = addServerConfiguration(operation, urlTemplate, description, variables);

    if (!serverIndex.has_value()) // operation was not found in m_serverConfigs
        return ServerError::OperationNotFound;

    return setServerIndex(operation, serverIndex.value());
}

void QtOAIBaseApi::setHeader(QHttpHeaders::WellKnownHeader key, QAnyStringView value)
{
    if (m_networkFactory->commonHeaders().values(key).contains(value))
        return;
    QHttpHeaders headers = m_networkFactory->commonHeaders();
    headers.replaceOrAppend(key, value);
    m_networkFactory->setCommonHeaders(std::move(headers));
}

void QtOAIBaseApi::setHeader(QAnyStringView key, QAnyStringView value)
{
    if (m_networkFactory->commonHeaders().values(key).contains(value))
        return;
    QHttpHeaders headers = m_networkFactory->commonHeaders();
    headers.replaceOrAppend(key, value);
    m_networkFactory->setCommonHeaders(std::move(headers));
}

void QtOAIBaseApi::enableRequestCompression()
{
    m_isRequestCompressionEnabled = true;
}

void QtOAIBaseApi::enableResponseCompression()
{
    m_isResponseCompressionEnabled = true;
}

QString QtOAIBaseApi::errorString(ServerError error) const
{
    switch (error) {
    case ServerError::NoError:
        return "No Error"_L1;
    case ServerError::ServerVariableNotFound:
        return "Server Variable Not Found"_L1;
    case ServerError::EnumValueNotFound:
        return "Enum Value Not Found"_L1;
    case ServerError::OperationNotFound:
        return "Operation Not Found"_L1;
    case ServerError::ServerIndexNotFound:
        return "Server Index Not Found"_L1;
    }
    Q_UNREACHABLE_RETURN(QString());
}

QNetworkReply *QtOAIBaseApi::execute(QtOAIHttpRequestInput &input, QNetworkRequest &request, QByteArray &requestContent)
{
    bool isMultiPartMode = (input.m_multiPart.get() && input.m_varLayout == QtOAIHttpRequestVarLayout::MULTIPART);
    QNetworkReply *reply = nullptr;
    if (input.m_httpMethod == "GET"_L1) {
        reply = m_restManager->get(request);
    } else if (input.m_httpMethod == "POST"_L1) {
        if (isMultiPartMode)
            reply = m_restManager->post(request, input.m_multiPart.release());
        else
            reply = m_restManager->post(request, requestContent);
    } else if (input.m_httpMethod == "PUT"_L1) {
        if (isMultiPartMode)
            reply = m_restManager->put(request, input.m_multiPart.release());
        else
            reply = m_restManager->put(request, requestContent);
    } else if (input.m_httpMethod == "HEAD"_L1) {
        reply = m_restManager->head(request);
    } else if (input.m_httpMethod == "DELETE"_L1) {
        reply = m_restManager->deleteResource(request);
    } else {
        if (isMultiPartMode)
            reply = m_restManager->sendCustomRequest(request, input.m_httpMethod.toLatin1(), input.m_multiPart.release());
        else
            reply = m_restManager->sendCustomRequest(request, input.m_httpMethod.toLatin1(), requestContent);
    }
    return reply;
}

} // namespace QtCommonOpenAPI

