
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_conditional_ace.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/security.h"
static PyTypeObject ace_condition_result_Type;
static PyTypeObject ace_condition_int_Type;
static PyTypeObject ace_condition_unicode_Type;
static PyTypeObject ace_condition_sid_Type;
static PyTypeObject ace_condition_composite_Type;
static PyTypeObject ace_condition_op_Type;
static PyTypeObject ace_condition_sddl_op_Type;
static PyTypeObject ace_condition_token_data_Type;
static PyTypeObject ace_condition_token_Type;
static PyTypeObject ace_condition_script_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;

static PyObject *py_ace_condition_result_get_value(PyObject *obj, void *closure)
{
	struct ace_condition_result *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = PyLong_FromLongLong(object->value);
	return py_value;
}

static int py_ace_condition_result_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_result *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->value));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->value = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_result_getsetters[] = {
	{
		.name = discard_const_p(char, "value"),
		.get = py_ace_condition_result_get_value,
		.set = py_ace_condition_result_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type int64")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_result_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_result, type);
}


static PyTypeObject ace_condition_result_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_result",
	.tp_getset = py_ace_condition_result_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_result_new,
};


static PyObject *py_ace_condition_int_get_value(PyObject *obj, void *closure)
{
	struct ace_condition_int *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = PyLong_FromLongLong(object->value);
	return py_value;
}

static int py_ace_condition_int_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_int *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->value));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->value = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ace_condition_int_get_sign(PyObject *obj, void *closure)
{
	struct ace_condition_int *object = pytalloc_get_ptr(obj);
	PyObject *py_sign;
	py_sign = PyLong_FromLong((uint16_t)(object->sign));
	return py_sign;
}

static int py_ace_condition_int_set_sign(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_int *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sign");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sign));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sign = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ace_condition_int_get_base(PyObject *obj, void *closure)
{
	struct ace_condition_int *object = pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = PyLong_FromLong((uint16_t)(object->base));
	return py_base;
}

static int py_ace_condition_int_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_int *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->base");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->base));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->base = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_int_getsetters[] = {
	{
		.name = discard_const_p(char, "value"),
		.get = py_ace_condition_int_get_value,
		.set = py_ace_condition_int_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type int64")
	},
	{
		.name = discard_const_p(char, "sign"),
		.get = py_ace_condition_int_get_sign,
		.set = py_ace_condition_int_set_sign,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "base"),
		.get = py_ace_condition_int_get_base,
		.set = py_ace_condition_int_set_base,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_int_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_int, type);
}

static PyObject *py_ace_condition_int_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ace_condition_int *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ace_condition_int);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ace_condition_int_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_int *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_int);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_int);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ace_condition_int_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_int *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_int, "ace_condition_int", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_int, "ace_condition_int", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ace_condition_int_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ace_condition_int_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_int_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_int_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ace_condition_int_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_int",
	.tp_getset = py_ace_condition_int_getsetters,
	.tp_methods = py_ace_condition_int_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_int_new,
};


static PyObject *py_ace_condition_unicode_get_value(PyObject *obj, void *closure)
{
	struct ace_condition_unicode *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = PyString_FromStringOrNULL(object->value);
	return py_value;
}

static int py_ace_condition_unicode_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_unicode *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->value = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_ace_condition_unicode_getsetters[] = {
	{
		.name = discard_const_p(char, "value"),
		.get = py_ace_condition_unicode_get_value,
		.set = py_ace_condition_unicode_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_unicode_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_unicode, type);
}

static PyObject *py_ace_condition_unicode_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ace_condition_unicode *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ace_condition_unicode);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ace_condition_unicode_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_unicode *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_unicode);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_unicode);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ace_condition_unicode_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_unicode *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_unicode, "ace_condition_unicode", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_unicode, "ace_condition_unicode", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ace_condition_unicode_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ace_condition_unicode_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_unicode_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_unicode_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ace_condition_unicode_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_unicode",
	.tp_getset = py_ace_condition_unicode_getsetters,
	.tp_methods = py_ace_condition_unicode_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_unicode_new,
};


static PyObject *py_ace_condition_sid_get_sid(PyObject *obj, void *closure)
{
	struct ace_condition_sid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_ace_condition_sid_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_sid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_ace_condition_sid_getsetters[] = {
	{
		.name = discard_const_p(char, "sid"),
		.get = py_ace_condition_sid_get_sid,
		.set = py_ace_condition_sid_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_sid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_sid, type);
}

static PyObject *py_ace_condition_sid_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ace_condition_sid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ace_condition_sid);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ace_condition_sid_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_sid *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_sid);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_sid);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ace_condition_sid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_sid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_sid, "ace_condition_sid", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_sid, "ace_condition_sid", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ace_condition_sid_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ace_condition_sid_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_sid_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_sid_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ace_condition_sid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_sid",
	.tp_getset = py_ace_condition_sid_getsetters,
	.tp_methods = py_ace_condition_sid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_sid_new,
};


static PyObject *py_ace_condition_composite_get_tokens(PyObject *obj, void *closure)
{
	struct ace_condition_composite *object = pytalloc_get_ptr(obj);
	PyObject *py_tokens;
	if (object->tokens == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tokens == NULL) {
		py_tokens = Py_None;
		Py_INCREF(py_tokens);
	} else {
		py_tokens = pytalloc_reference_ex(&ace_condition_token_Type, object->tokens, object->tokens);
	}
	return py_tokens;
}

static int py_ace_condition_composite_set_tokens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_composite *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tokens));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tokens");
		return -1;
	}
	if (value == Py_None) {
		object->tokens = NULL;
	} else {
		object->tokens = NULL;
		PY_CHECK_TYPE(&ace_condition_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->tokens = (struct ace_condition_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_ace_condition_composite_get_n_members(PyObject *obj, void *closure)
{
	struct ace_condition_composite *object = pytalloc_get_ptr(obj);
	PyObject *py_n_members;
	py_n_members = PyLong_FromUnsignedLongLong((uint32_t)(object->n_members));
	return py_n_members;
}

static int py_ace_condition_composite_set_n_members(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_composite *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->n_members");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->n_members));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->n_members = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_composite_getsetters[] = {
	{
		.name = discard_const_p(char, "tokens"),
		.get = py_ace_condition_composite_get_tokens,
		.set = py_ace_condition_composite_set_tokens,
		.doc = discard_const_p(char, "PIDL-generated element of base type ace_condition_token")
	},
	{
		.name = discard_const_p(char, "n_members"),
		.get = py_ace_condition_composite_get_n_members,
		.set = py_ace_condition_composite_set_n_members,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_composite_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_composite, type);
}


static PyTypeObject ace_condition_composite_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_composite",
	.tp_getset = py_ace_condition_composite_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_composite_new,
};


static PyObject *py_ace_condition_op_get_sddl_position(PyObject *obj, void *closure)
{
	struct ace_condition_op *object = pytalloc_get_ptr(obj);
	PyObject *py_sddl_position;
	py_sddl_position = PyLong_FromUnsignedLongLong((uint32_t)(object->sddl_position));
	return py_sddl_position;
}

static int py_ace_condition_op_set_sddl_position(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_op *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sddl_position");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sddl_position));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sddl_position = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_op_getsetters[] = {
	{
		.name = discard_const_p(char, "sddl_position"),
		.get = py_ace_condition_op_get_sddl_position,
		.set = py_ace_condition_op_set_sddl_position,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_op_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_op, type);
}


static PyTypeObject ace_condition_op_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_op",
	.tp_getset = py_ace_condition_op_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_op_new,
};


static PyObject *py_ace_condition_sddl_op_get_start(PyObject *obj, void *closure)
{
	struct ace_condition_sddl_op *object = pytalloc_get_ptr(obj);
	PyObject *py_start;
	py_start = PyLong_FromUnsignedLongLong((uint32_t)(object->start));
	return py_start;
}

static int py_ace_condition_sddl_op_set_start(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_sddl_op *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->start");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->start));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->start = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ace_condition_sddl_op_get_position(PyObject *obj, void *closure)
{
	struct ace_condition_sddl_op *object = pytalloc_get_ptr(obj);
	PyObject *py_position;
	py_position = PyLong_FromUnsignedLongLong((uint32_t)(object->position));
	return py_position;
}

static int py_ace_condition_sddl_op_set_position(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_sddl_op *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->position");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->position));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->position = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_sddl_op_getsetters[] = {
	{
		.name = discard_const_p(char, "start"),
		.get = py_ace_condition_sddl_op_get_start,
		.set = py_ace_condition_sddl_op_set_start,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "position"),
		.get = py_ace_condition_sddl_op_get_position,
		.set = py_ace_condition_sddl_op_set_position,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_sddl_op_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_sddl_op, type);
}


static PyTypeObject ace_condition_sddl_op_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_sddl_op",
	.tp_getset = py_ace_condition_sddl_op_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_sddl_op_new,
};

static PyObject *py_import_ace_condition_token_data(TALLOC_CTX *mem_ctx, int level, union ace_condition_token_data *in)
{
	PyObject *ret;

	switch (level) {
		case CONDITIONAL_ACE_TOKEN_SID:
			ret = pytalloc_reference_ex(&ace_condition_sid_Type, mem_ctx, &in->sid);
			return ret;

		case CONDITIONAL_ACE_TOKEN_COMPOSITE:
			ret = pytalloc_reference_ex(&ace_condition_composite_Type, mem_ctx, &in->composite);
			return ret;

		case CONDITIONAL_ACE_TOKEN_OCTET_STRING:
			ret = PyBytes_FromStringAndSize((char *)(in->bytes).data, (in->bytes).length);
			return ret;

		case CONDITIONAL_ACE_TOKEN_UNICODE:
			ret = pytalloc_reference_ex(&ace_condition_unicode_Type, mem_ctx, &in->unicode);
			return ret;

		case CONDITIONAL_ACE_LOCAL_ATTRIBUTE:
			ret = pytalloc_reference_ex(&ace_condition_unicode_Type, mem_ctx, &in->local_attr);
			return ret;

		case CONDITIONAL_ACE_USER_ATTRIBUTE:
			ret = pytalloc_reference_ex(&ace_condition_unicode_Type, mem_ctx, &in->user_attr);
			return ret;

		case CONDITIONAL_ACE_DEVICE_ATTRIBUTE:
			ret = pytalloc_reference_ex(&ace_condition_unicode_Type, mem_ctx, &in->device_attr);
			return ret;

		case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE:
			ret = pytalloc_reference_ex(&ace_condition_unicode_Type, mem_ctx, &in->resource_attr);
			return ret;

		case CONDITIONAL_ACE_TOKEN_INT64:
			ret = pytalloc_reference_ex(&ace_condition_int_Type, mem_ctx, &in->int64);
			return ret;

		case CONDITIONAL_ACE_TOKEN_INT32:
			ret = pytalloc_reference_ex(&ace_condition_int_Type, mem_ctx, &in->int32);
			return ret;

		case CONDITIONAL_ACE_TOKEN_INT16:
			ret = pytalloc_reference_ex(&ace_condition_int_Type, mem_ctx, &in->int16);
			return ret;

		case CONDITIONAL_ACE_TOKEN_INT8:
			ret = pytalloc_reference_ex(&ace_condition_int_Type, mem_ctx, &in->int8);
			return ret;

		case CONDITIONAL_ACE_SAMBA_SDDL_PAREN:
			ret = pytalloc_reference_ex(&ace_condition_sddl_op_Type, mem_ctx, &in->sddl_op);
			return ret;

		case CONDITIONAL_ACE_SAMBA_RESULT_BOOL:
			ret = pytalloc_reference_ex(&ace_condition_result_Type, mem_ctx, &in->result);
			return ret;

		case CONDITIONAL_ACE_SAMBA_RESULT_NULL:
			ret = pytalloc_reference_ex(&ace_condition_result_Type, mem_ctx, &in->result_null);
			return ret;

		case CONDITIONAL_ACE_SAMBA_RESULT_ERROR:
			ret = pytalloc_reference_ex(&ace_condition_result_Type, mem_ctx, &in->result_error);
			return ret;

		case CONDITIONAL_ACE_TOKEN_MEMBER_OF:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->member_of);
			return ret;

		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->device_member_of);
			return ret;

		case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->member_of_any);
			return ret;

		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->device_member_of_any);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_member_of);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_device_member_of);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_member_of_any);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_device_member_of_any);
			return ret;

		case CONDITIONAL_ACE_TOKEN_EQUAL:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->equal);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_EQUAL:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_equal);
			return ret;

		case CONDITIONAL_ACE_TOKEN_LESS_THAN:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->less_than);
			return ret;

		case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->less_or_equal);
			return ret;

		case CONDITIONAL_ACE_TOKEN_GREATER_THAN:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->greater_than);
			return ret;

		case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->greater_or_equal);
			return ret;

		case CONDITIONAL_ACE_TOKEN_CONTAINS:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->contains);
			return ret;

		case CONDITIONAL_ACE_TOKEN_ANY_OF:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->any_of);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_contains);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_any_of);
			return ret;

		case CONDITIONAL_ACE_TOKEN_AND:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->and);
			return ret;

		case CONDITIONAL_ACE_TOKEN_OR:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->or);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not);
			return ret;

		case CONDITIONAL_ACE_TOKEN_EXISTS:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->exists);
			return ret;

		case CONDITIONAL_ACE_TOKEN_NOT_EXISTS:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->not_exists);
			return ret;

		default:
			ret = pytalloc_reference_ex(&ace_condition_op_Type, mem_ctx, &in->op);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ace_condition_token_data *py_export_ace_condition_token_data(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ace_condition_token_data *ret = talloc_zero(mem_ctx, union ace_condition_token_data);
	switch (level) {
		case CONDITIONAL_ACE_TOKEN_SID:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sid");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_sid_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->sid = *(struct ace_condition_sid *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_COMPOSITE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->composite");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_composite_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->composite = *(struct ace_condition_composite *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_OCTET_STRING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->bytes");
				talloc_free(ret); return NULL;
			}
			ret->bytes = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case CONDITIONAL_ACE_TOKEN_UNICODE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->unicode");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_unicode_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->unicode = *(struct ace_condition_unicode *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_LOCAL_ATTRIBUTE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->local_attr");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_unicode_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->local_attr = *(struct ace_condition_unicode *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_USER_ATTRIBUTE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->user_attr");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_unicode_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->user_attr = *(struct ace_condition_unicode *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_DEVICE_ATTRIBUTE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->device_attr");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_unicode_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->device_attr = *(struct ace_condition_unicode *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->resource_attr");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_unicode_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->resource_attr = *(struct ace_condition_unicode *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_INT64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->int64");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_int_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->int64 = *(struct ace_condition_int *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_INT32:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->int32");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_int_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->int32 = *(struct ace_condition_int *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_INT16:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->int16");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_int_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->int16 = *(struct ace_condition_int *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_INT8:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->int8");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_int_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->int8 = *(struct ace_condition_int *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_SAMBA_SDDL_PAREN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sddl_op");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_sddl_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->sddl_op = *(struct ace_condition_sddl_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_SAMBA_RESULT_BOOL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->result");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_result_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->result = *(struct ace_condition_result *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_SAMBA_RESULT_NULL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->result_null");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_result_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->result_null = *(struct ace_condition_result *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_SAMBA_RESULT_ERROR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->result_error");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_result_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->result_error = *(struct ace_condition_result *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_MEMBER_OF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->member_of");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->member_of = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->device_member_of");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->device_member_of = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->member_of_any");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->member_of_any = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->device_member_of_any");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->device_member_of_any = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_member_of");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_member_of = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_device_member_of");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_device_member_of = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_member_of_any");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_member_of_any = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_device_member_of_any");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_device_member_of_any = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_EQUAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->equal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->equal = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_EQUAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_equal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_equal = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_LESS_THAN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->less_than");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->less_than = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->less_or_equal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->less_or_equal = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_GREATER_THAN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->greater_than");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->greater_than = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->greater_or_equal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->greater_or_equal = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_CONTAINS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->contains");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->contains = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_ANY_OF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->any_of");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->any_of = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_contains");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_contains = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_any_of");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_any_of = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_AND:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->and");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->and = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_OR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->or");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->or = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_EXISTS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->exists");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->exists = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		case CONDITIONAL_ACE_TOKEN_NOT_EXISTS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->not_exists");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->not_exists = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->op");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ace_condition_op_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->op = *(struct ace_condition_op *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_ace_condition_token_data_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ace_condition_token_data *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ace_condition_token_data *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ace_condition_token_data!");
		return NULL;
	}

	return py_import_ace_condition_token_data(mem_ctx, level, in);
}

static PyObject *py_ace_condition_token_data_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ace_condition_token_data *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ace_condition_token_data(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ace_condition_token_data_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_token_data_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_token_data_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ace_condition_token_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ace_condition_token_data_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_token_data",
	.tp_getset = NULL,
	.tp_methods = py_ace_condition_token_data_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_token_data_new,
};


static PyObject *py_ace_condition_token_get_data(PyObject *obj, void *closure)
{
	struct ace_condition_token *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&ace_condition_token_data_Type, pytalloc_get_mem_ctx(obj), object->type, &object->data, "union ace_condition_token_data");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_ace_condition_token_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	{
		union ace_condition_token_data *data_switch_0;
		data_switch_0 = (union ace_condition_token_data *)pyrpc_export_union(&ace_condition_token_data_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union ace_condition_token_data");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyObject *py_ace_condition_token_get_flags(PyObject *obj, void *closure)
{
	struct ace_condition_token *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_ace_condition_token_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ace_condition_token_get_type(PyObject *obj, void *closure)
{
	struct ace_condition_token *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_ace_condition_token_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_token_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_ace_condition_token_get_data,
		.set = py_ace_condition_token_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type ace_condition_token_data")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_ace_condition_token_get_flags,
		.set = py_ace_condition_token_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_ace_condition_token_get_type,
		.set = py_ace_condition_token_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type token_type")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_token_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_token, type);
}

static PyObject *py_ace_condition_token_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ace_condition_token *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ace_condition_token);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ace_condition_token_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_token *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_token);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_token);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ace_condition_token_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_token *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_token, "ace_condition_token", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_token, "ace_condition_token", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ace_condition_token_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ace_condition_token_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_token_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_token_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ace_condition_token_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_token",
	.tp_getset = py_ace_condition_token_getsetters,
	.tp_methods = py_ace_condition_token_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_token_new,
};


static PyObject *py_ace_condition_script_get_tokens(PyObject *obj, void *closure)
{
	struct ace_condition_script *object = pytalloc_get_ptr(obj);
	PyObject *py_tokens;
	if (object->tokens == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tokens == NULL) {
		py_tokens = Py_None;
		Py_INCREF(py_tokens);
	} else {
		py_tokens = pytalloc_reference_ex(&ace_condition_token_Type, object->tokens, object->tokens);
	}
	return py_tokens;
}

static int py_ace_condition_script_set_tokens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_script *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tokens));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tokens");
		return -1;
	}
	if (value == Py_None) {
		object->tokens = NULL;
	} else {
		object->tokens = NULL;
		PY_CHECK_TYPE(&ace_condition_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->tokens = (struct ace_condition_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_ace_condition_script_get_length(PyObject *obj, void *closure)
{
	struct ace_condition_script *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_ace_condition_script_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ace_condition_script *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ace_condition_script_getsetters[] = {
	{
		.name = discard_const_p(char, "tokens"),
		.get = py_ace_condition_script_get_tokens,
		.set = py_ace_condition_script_set_tokens,
		.doc = discard_const_p(char, "PIDL-generated element of base type ace_condition_token")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_ace_condition_script_get_length,
		.set = py_ace_condition_script_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_ace_condition_script_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ace_condition_script, type);
}

static PyObject *py_ace_condition_script_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ace_condition_script *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ace_condition_script);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ace_condition_script_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_script *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_script);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ace_condition_script);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ace_condition_script_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ace_condition_script *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_script, "ace_condition_script", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ace_condition_script, "ace_condition_script", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ace_condition_script_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ace_condition_script_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_script_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ace_condition_script_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ace_condition_script_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "conditional_ace.ace_condition_script",
	.tp_getset = py_ace_condition_script_getsetters,
	.tp_methods = py_ace_condition_script_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ace_condition_script_new,
};

static PyMethodDef conditional_ace_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "conditional_ace",
	.m_doc = "conditional_ace DCE/RPC",
	.m_size = -1,
	.m_methods = conditional_ace_methods,
};
MODULE_INIT_FUNC(conditional_ace)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	ace_condition_result_Type.tp_base = BaseObject_Type;
	ace_condition_result_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_int_Type.tp_base = BaseObject_Type;
	ace_condition_int_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_unicode_Type.tp_base = BaseObject_Type;
	ace_condition_unicode_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_sid_Type.tp_base = BaseObject_Type;
	ace_condition_sid_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_composite_Type.tp_base = BaseObject_Type;
	ace_condition_composite_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_op_Type.tp_base = BaseObject_Type;
	ace_condition_op_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_sddl_op_Type.tp_base = BaseObject_Type;
	ace_condition_sddl_op_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_token_data_Type.tp_base = BaseObject_Type;
	ace_condition_token_data_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_token_Type.tp_base = BaseObject_Type;
	ace_condition_token_Type.tp_basicsize = pytalloc_BaseObject_size();

	ace_condition_script_Type.tp_base = BaseObject_Type;
	ace_condition_script_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&ace_condition_result_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_int_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_unicode_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_sid_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_composite_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_op_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_sddl_op_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_token_data_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_token_Type) < 0)
		goto out;
	if (PyType_Ready(&ace_condition_script_Type) < 0)
		goto out;
#ifdef PY_ACE_CONDITION_RESULT_PATCH
	PY_ACE_CONDITION_RESULT_PATCH(&ace_condition_result_Type);
#endif
#ifdef PY_ACE_CONDITION_INT_PATCH
	PY_ACE_CONDITION_INT_PATCH(&ace_condition_int_Type);
#endif
#ifdef PY_ACE_CONDITION_UNICODE_PATCH
	PY_ACE_CONDITION_UNICODE_PATCH(&ace_condition_unicode_Type);
#endif
#ifdef PY_ACE_CONDITION_SID_PATCH
	PY_ACE_CONDITION_SID_PATCH(&ace_condition_sid_Type);
#endif
#ifdef PY_ACE_CONDITION_COMPOSITE_PATCH
	PY_ACE_CONDITION_COMPOSITE_PATCH(&ace_condition_composite_Type);
#endif
#ifdef PY_ACE_CONDITION_OP_PATCH
	PY_ACE_CONDITION_OP_PATCH(&ace_condition_op_Type);
#endif
#ifdef PY_ACE_CONDITION_SDDL_OP_PATCH
	PY_ACE_CONDITION_SDDL_OP_PATCH(&ace_condition_sddl_op_Type);
#endif
#ifdef PY_ACE_CONDITION_TOKEN_DATA_PATCH
	PY_ACE_CONDITION_TOKEN_DATA_PATCH(&ace_condition_token_data_Type);
#endif
#ifdef PY_ACE_CONDITION_TOKEN_PATCH
	PY_ACE_CONDITION_TOKEN_PATCH(&ace_condition_token_Type);
#endif
#ifdef PY_ACE_CONDITION_SCRIPT_PATCH
	PY_ACE_CONDITION_SCRIPT_PATCH(&ace_condition_script_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "CONDITIONAL_ACE_FLAG_TOKEN_FROM_ATTR", PyLong_FromUnsignedLongLong((uint32_t)(UINT32_C(1)<<31)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_MAX_LENGTH", PyLong_FromUnsignedLongLong(10000));
	PyModule_AddObject(m, "CONDITIONAL_ACE_MAX_TOKENS", PyLong_FromUnsignedLongLong(2000));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_INVALID_OR_PADDING", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_INVALID_OR_PADDING)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_INT8", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_INT8)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_INT16", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_INT16)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_INT32", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_INT32)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_INT64", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_INT64)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_UNICODE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_UNICODE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_OCTET_STRING", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_OCTET_STRING)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_COMPOSITE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_COMPOSITE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_SID", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_SID)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_LOCAL_ATTRIBUTE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_LOCAL_ATTRIBUTE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_USER_ATTRIBUTE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_USER_ATTRIBUTE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_RESOURCE_ATTRIBUTE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_RESOURCE_ATTRIBUTE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_DEVICE_ATTRIBUTE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_DEVICE_ATTRIBUTE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_MEMBER_OF", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_MEMBER_OF)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_EQUAL", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_EQUAL)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_EQUAL", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_EQUAL)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_LESS_THAN", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_LESS_THAN)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_GREATER_THAN", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_GREATER_THAN)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_CONTAINS", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_CONTAINS)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_ANY_OF", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_ANY_OF)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_CONTAINS", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_CONTAINS)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_ANY_OF", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_ANY_OF)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_EXISTS", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_EXISTS)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT_EXISTS", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT_EXISTS)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_NOT", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_NOT)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_AND", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_AND)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_TOKEN_OR", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_TOKEN_OR)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_SAMBA_RESULT_BOOL", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_SAMBA_RESULT_BOOL)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_SAMBA_RESULT_NULL", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_SAMBA_RESULT_NULL)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_SAMBA_RESULT_ERROR", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_SAMBA_RESULT_ERROR)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_SAMBA_SDDL_PAREN", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_SAMBA_SDDL_PAREN)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_SAMBA_SDDL_PAREN_END", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_SAMBA_SDDL_PAREN_END)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_INT_BASE_8", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_INT_BASE_8)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_INT_BASE_10", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_INT_BASE_10)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_INT_BASE_16", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_INT_BASE_16)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_INT_SIGN_POSITIVE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_INT_SIGN_POSITIVE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_INT_SIGN_NEGATIVE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_INT_SIGN_NEGATIVE)));
	PyModule_AddObject(m, "CONDITIONAL_ACE_INT_SIGN_NONE", PyLong_FromLong((uint16_t)(CONDITIONAL_ACE_INT_SIGN_NONE)));
	PyModule_AddObject(m, "ACE_CONDITION_FALSE", PyLong_FromLong((uint16_t)(ACE_CONDITION_FALSE)));
	PyModule_AddObject(m, "ACE_CONDITION_TRUE", PyLong_FromLong((uint16_t)(ACE_CONDITION_TRUE)));
	PyModule_AddObject(m, "ACE_CONDITION_UNKNOWN", PyLong_FromLong((uint16_t)(ACE_CONDITION_UNKNOWN)));
	PyModule_AddObject(m, "ACE_CONDITION_FLAG_ALLOW_DEVICE", PyLong_FromLong((uint16_t)(ACE_CONDITION_FLAG_ALLOW_DEVICE)));
	Py_INCREF((PyObject *)(void *)&ace_condition_result_Type);
	PyModule_AddObject(m, "ace_condition_result", (PyObject *)(void *)&ace_condition_result_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_int_Type);
	PyModule_AddObject(m, "ace_condition_int", (PyObject *)(void *)&ace_condition_int_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_unicode_Type);
	PyModule_AddObject(m, "ace_condition_unicode", (PyObject *)(void *)&ace_condition_unicode_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_sid_Type);
	PyModule_AddObject(m, "ace_condition_sid", (PyObject *)(void *)&ace_condition_sid_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_composite_Type);
	PyModule_AddObject(m, "ace_condition_composite", (PyObject *)(void *)&ace_condition_composite_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_op_Type);
	PyModule_AddObject(m, "ace_condition_op", (PyObject *)(void *)&ace_condition_op_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_sddl_op_Type);
	PyModule_AddObject(m, "ace_condition_sddl_op", (PyObject *)(void *)&ace_condition_sddl_op_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_token_data_Type);
	PyModule_AddObject(m, "ace_condition_token_data", (PyObject *)(void *)&ace_condition_token_data_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_token_Type);
	PyModule_AddObject(m, "ace_condition_token", (PyObject *)(void *)&ace_condition_token_Type);
	Py_INCREF((PyObject *)(void *)&ace_condition_script_Type);
	PyModule_AddObject(m, "ace_condition_script", (PyObject *)(void *)&ace_condition_script_Type);
#ifdef PY_MOD_CONDITIONAL_ACE_PATCH
	PY_MOD_CONDITIONAL_ACE_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	return m;

}
