/* CameraTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CameraTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gudev/gudev.h>
#include <gphoto2/gphoto2-context.h>
#include <shotwell-gphoto-helper.h>
#include <gphoto2/gphoto2-abilities-list.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gphoto2/gphoto2-list.h>
#include <gphoto2/gphoto2-camera.h>
#include <gobject/gvaluecollector.h>

#define CAMERA_TABLE_UPDATE_DELAY_MSEC 1000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CAMERA_TABLE (camera_table_get_type ())
#define CAMERA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CAMERA_TABLE, CameraTable))
#define CAMERA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CAMERA_TABLE, CameraTableClass))
#define IS_CAMERA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CAMERA_TABLE))
#define IS_CAMERA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CAMERA_TABLE))
#define CAMERA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CAMERA_TABLE, CameraTableClass))

typedef struct _CameraTable CameraTable;
typedef struct _CameraTableClass CameraTableClass;
typedef struct _CameraTablePrivate CameraTablePrivate;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;

#define TYPE_DISCOVERED_CAMERA (discovered_camera_get_type ())
#define DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCamera))
#define DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))
#define IS_DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISCOVERED_CAMERA))
#define IS_DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISCOVERED_CAMERA))
#define DISCOVERED_CAMERA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))

typedef struct _DiscoveredCamera DiscoveredCamera;
typedef struct _DiscoveredCameraClass DiscoveredCameraClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
#define _gp_abilities_list_free0(var) ((var == NULL) ? NULL : (var = (gp_abilities_list_free (var), NULL)))
typedef void (*OneShotCallback) (gpointer user_data);

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;

#define TYPE_GPHOTO_ERROR (gphoto_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _camera_table_unref0(var) ((var == NULL) ? NULL : (var = (camera_table_unref (var), NULL)))
#define _gp_port_info_list_free0(var) ((var == NULL) ? NULL : (var = (gp_port_info_list_free (var), NULL)))
#define _gp_list_unref0(var) ((var == NULL) ? NULL : (var = (gp_list_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DiscoveredCameraPrivate DiscoveredCameraPrivate;
#define _discovered_camera_unref0(var) ((var == NULL) ? NULL : (var = (discovered_camera_unref (var), NULL)))
typedef struct _ParamSpecCameraTable ParamSpecCameraTable;
enum  {
	CAMERA_TABLE_CAMERA_ADDED_SIGNAL,
	CAMERA_TABLE_CAMERA_REMOVED_SIGNAL,
	CAMERA_TABLE_NUM_SIGNALS
};
static guint camera_table_signals[CAMERA_TABLE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CameraTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CameraTablePrivate * priv;
};

struct _CameraTableClass {
	GTypeClass parent_class;
	void (*finalize) (CameraTable *self);
};

struct _CameraTablePrivate {
	GUdevClient* client;
	OneShotScheduler* camera_update_scheduler;
	GPContext* null_context;
	CameraAbilitiesList* abilities_list;
	GVolumeMonitor* volume_monitor;
	GeeHashMap* camera_map;
};

typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()

struct _DiscoveredCamera {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DiscoveredCameraPrivate * priv;
	Camera* gcamera;
	gchar* uri;
	gchar* display_name;
	gchar* icon;
};

struct _DiscoveredCameraClass {
	GTypeClass parent_class;
	void (*finalize) (DiscoveredCamera *self);
};

struct _ParamSpecCameraTable {
	GParamSpec parent_instance;
};

static gint CameraTable_private_offset;
static gpointer camera_table_parent_class = NULL;
static CameraTable* camera_table_instance;
static CameraTable* camera_table_instance = NULL;

VALA_EXTERN gpointer camera_table_ref (gpointer instance);
VALA_EXTERN void camera_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_camera_table (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_camera_table (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_camera_table (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_camera_table (const GValue* value);
VALA_EXTERN GType camera_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraTable, camera_table_unref)
VALA_EXTERN gpointer one_shot_scheduler_ref (gpointer instance);
VALA_EXTERN void one_shot_scheduler_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_one_shot_scheduler (const GValue* value);
VALA_EXTERN GType one_shot_scheduler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OneShotScheduler, one_shot_scheduler_unref)
VALA_EXTERN gpointer discovered_camera_ref (gpointer instance);
VALA_EXTERN void discovered_camera_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_discovered_camera (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_discovered_camera (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_discovered_camera (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_discovered_camera (const GValue* value);
VALA_EXTERN GType discovered_camera_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DiscoveredCamera, discovered_camera_unref)
static CameraTable* camera_table_new (void);
static CameraTable* camera_table_construct (GType object_type);
static void camera_table_on_update_cameras (CameraTable* self);
static void _camera_table_on_update_cameras_one_shot_callback (gpointer self);
VALA_EXTERN OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          gpointer callback_target);
VALA_EXTERN OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                gpointer callback_target);
static void camera_table_on_udev_event (CameraTable* self,
                                 const gchar* action,
                                 GUdevDevice* device);
static void _camera_table_on_udev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                       const gchar* action,
                                                       GUdevDevice* device,
                                                       gpointer self);
VALA_EXTERN void camera_table_on_volume_changed (CameraTable* self,
                                     GVolume* volume);
static void _camera_table_on_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                      GVolume* volume,
                                                                      gpointer self);
static void _camera_table_on_volume_changed_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self);
static gboolean camera_table_delayed_init (CameraTable* self);
static gboolean _camera_table_delayed_init_gsource_func (gpointer self);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN GType library_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryWindow, g_object_unref)
VALA_EXTERN void library_window_set_page_switching_enabled (LibraryWindow* self,
                                                gboolean should_enable);
VALA_EXTERN GQuark gphoto_error_quark (void);
VALA_EXTERN GType gphoto_error_get_type (void) G_GNUC_CONST ;
static void camera_table_init_camera_table (CameraTable* self,
                                     GError** error);
static void camera_table_update_camera_table (CameraTable* self,
                                       GError** error);
VALA_EXTERN CameraTable* camera_table_get_instance (void);
VALA_EXTERN GeeIterable* camera_table_get_cameras (CameraTable* self);
VALA_EXTERN gint camera_table_get_count (CameraTable* self);
VALA_EXTERN DiscoveredCamera* camera_table_get_for_uri (CameraTable* self,
                                            const gchar* uri);
static void camera_table_do_op (CameraTable* self,
                         int res,
                         const gchar* op,
                         GError** error);
VALA_EXTERN gchar* camera_table_get_port_uri (const gchar* port);
static void _vala_array_add66 (DiscoveredCamera** * array,
                        gint* length,
                        gint* size,
                        DiscoveredCamera* value);
VALA_EXTERN DiscoveredCamera* discovered_camera_new (const gchar* name,
                                         const gchar* port,
                                         GPPortInfo port_info,
                                         CameraAbilities camera_abilities,
                                         GError** error);
VALA_EXTERN DiscoveredCamera* discovered_camera_construct (GType object_type,
                                               const gchar* name,
                                               const gchar* port,
                                               GPPortInfo port_info,
                                               CameraAbilities camera_abilities,
                                               GError** error);
VALA_EXTERN void one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                       guint msec,
                                       gboolean reschedule);
static void g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void camera_table_finalize (CameraTable * obj);
static GType camera_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* CAMERA_TABLE_SUBSYSTEMS[3] = {"usb", "block", NULL};

static inline gpointer
camera_table_get_instance_private (CameraTable* self)
{
	return G_STRUCT_MEMBER_P (self, CameraTable_private_offset);
}

static void
_camera_table_on_update_cameras_one_shot_callback (gpointer self)
{
	camera_table_on_update_cameras ((CameraTable*) self);
}

static void
_camera_table_on_udev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                  const gchar* action,
                                                  GUdevDevice* device,
                                                  gpointer self)
{
	camera_table_on_udev_event ((CameraTable*) self, action, device);
}

static void
_camera_table_on_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                 GVolume* volume,
                                                                 gpointer self)
{
	camera_table_on_volume_changed ((CameraTable*) self, volume);
}

static void
_camera_table_on_volume_changed_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                               GVolume* volume,
                                                               gpointer self)
{
	camera_table_on_volume_changed ((CameraTable*) self, volume);
}

static gboolean
_camera_table_delayed_init_gsource_func (gpointer self)
{
	gboolean result;
	result = camera_table_delayed_init ((CameraTable*) self);
	return result;
}

static CameraTable*
camera_table_construct (GType object_type)
{
	CameraTable* self = NULL;
	OneShotScheduler* _tmp0_;
	GUdevClient* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
	self = (CameraTable*) g_type_create_instance (object_type);
	_tmp0_ = one_shot_scheduler_new ("CameraTable update scheduler", _camera_table_on_update_cameras_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->camera_update_scheduler);
	self->priv->camera_update_scheduler = _tmp0_;
	_tmp1_ = self->priv->client;
	g_signal_connect (_tmp1_, "uevent", (GCallback) _camera_table_on_udev_event_g_udev_client_uevent, self);
	_tmp2_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp2_;
	_tmp3_ = self->priv->volume_monitor;
	g_signal_connect (_tmp3_, "volume-changed", (GCallback) _camera_table_on_volume_changed_g_volume_monitor_volume_changed, self);
	_tmp4_ = self->priv->volume_monitor;
	g_signal_connect (_tmp4_, "volume-added", (GCallback) _camera_table_on_volume_changed_g_volume_monitor_volume_added, self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _camera_table_delayed_init_gsource_func, camera_table_ref (self), camera_table_unref);
	return self;
}

static CameraTable*
camera_table_new (void)
{
	return camera_table_construct (TYPE_CAMERA_TABLE);
}

static gboolean
camera_table_delayed_init (CameraTable* self)
{
	AppWindow* _tmp0_;
	LibraryWindow* _tmp1_;
	AppWindow* _tmp10_;
	LibraryWindow* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_CAMERA_TABLE (self), FALSE);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_WINDOW, LibraryWindow);
	library_window_set_page_switching_enabled (_tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
	{
		camera_table_init_camera_table (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				goto __catch0_gphoto_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	goto __finally0;
	__catch0_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("CameraTable.vala:58: Unable to initialize camera table: %s", _tmp4_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	{
		camera_table_update_camera_table (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				goto __catch1_gphoto_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally1;
	__catch1_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("CameraTable.vala:66: Unable to update camera table: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = app_window_get_instance ();
	_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_LIBRARY_WINDOW, LibraryWindow);
	library_window_set_page_switching_enabled (_tmp11_, TRUE);
	_g_object_unref0 (_tmp11_);
	result = FALSE;
	return result;
}

static gpointer
_camera_table_ref0 (gpointer self)
{
	return self ? camera_table_ref (self) : NULL;
}

CameraTable*
camera_table_get_instance (void)
{
	CameraTable* _tmp0_;
	CameraTable* _tmp2_;
	CameraTable* _tmp3_;
	CameraTable* result;
	_tmp0_ = camera_table_instance;
	if (_tmp0_ == NULL) {
		CameraTable* _tmp1_;
		_tmp1_ = camera_table_new ();
		_camera_table_unref0 (camera_table_instance);
		camera_table_instance = _tmp1_;
	}
	_tmp2_ = camera_table_instance;
	_tmp3_ = _camera_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GeeIterable*
camera_table_get_cameras (CameraTable* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterable* result;
	g_return_val_if_fail (IS_CAMERA_TABLE (self), NULL);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
	return result;
}

gint
camera_table_get_count (CameraTable* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (IS_CAMERA_TABLE (self), 0);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

DiscoveredCamera*
camera_table_get_for_uri (CameraTable* self,
                          const gchar* uri)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DiscoveredCamera* result;
	g_return_val_if_fail (IS_CAMERA_TABLE (self), NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), uri);
	result = (DiscoveredCamera*) _tmp1_;
	return result;
}

static void
camera_table_do_op (CameraTable* self,
                    int res,
                    const gchar* op,
                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_CAMERA_TABLE (self));
	g_return_if_fail (op != NULL);
	if (res != GP_OK) {
		const gchar* _tmp0_;
		GError* _tmp1_;
		_tmp0_ = gp_port_result_as_string (res);
		_tmp1_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Unable to %s: %s", (gint) res, op, _tmp0_);
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
camera_table_init_camera_table (CameraTable* self,
                                GError** error)
{
	CameraAbilitiesList* _tmp0_ = NULL;
	int _tmp1_;
	CameraAbilitiesList* _tmp2_;
	GPContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_CAMERA_TABLE (self));
	_tmp1_ = gp_abilities_list_new (&_tmp0_);
	_gp_abilities_list_free0 (self->priv->abilities_list);
	self->priv->abilities_list = _tmp0_;
	camera_table_do_op (self, _tmp1_, "create camera abilities list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = self->priv->abilities_list;
	_tmp3_ = self->priv->null_context;
	camera_table_do_op (self, gp_abilities_list_load (_tmp2_, _tmp3_), "load camera abilities list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gchar*
camera_table_get_port_uri (const gchar* port)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (port != NULL, NULL);
	_tmp0_ = g_strdup_printf ("gphoto2://[%s]/", port);
	result = _tmp0_;
	return result;
}

static gpointer
_discovered_camera_ref0 (gpointer self)
{
	return self ? discovered_camera_ref (self) : NULL;
}

static void
_vala_array_add66 (DiscoveredCamera** * array,
                   gint* length,
                   gint* size,
                   DiscoveredCamera* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DiscoveredCamera*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
camera_table_update_camera_table (CameraTable* self,
                                  GError** error)
{
	GPPortInfoList* port_info_list = NULL;
	GPPortInfoList* _tmp0_ = NULL;
	int _tmp1_;
	GPPortInfoList* _tmp2_;
	CameraList* camera_list = NULL;
	CameraList* _tmp3_ = NULL;
	int _tmp4_;
	CameraAbilitiesList* _tmp5_;
	GPPortInfoList* _tmp6_;
	CameraList* _tmp7_;
	GPContext* _tmp8_;
	GeeHashMap* detected_map = NULL;
	GeeHashMap* _tmp9_;
	DiscoveredCamera** missing = NULL;
	DiscoveredCamera** _tmp27_;
	gint missing_length1;
	gint _missing_size_;
	DiscoveredCamera** _tmp55_;
	gint _tmp55__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_CAMERA_TABLE (self));
	_tmp1_ = gp_port_info_list_new (&_tmp0_);
	_gp_port_info_list_free0 (port_info_list);
	port_info_list = _tmp0_;
	camera_table_do_op (self, _tmp1_, "create port list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = port_info_list;
	camera_table_do_op (self, gp_port_info_list_load (_tmp2_), "load port list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = gp_list_new (&_tmp3_);
	_gp_list_unref0 (camera_list);
	camera_list = _tmp3_;
	camera_table_do_op (self, _tmp4_, "create camera list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = self->priv->abilities_list;
	_tmp6_ = port_info_list;
	_tmp7_ = camera_list;
	_tmp8_ = self->priv->null_context;
	camera_table_do_op (self, gp_abilities_list_detect (_tmp5_, _tmp6_, _tmp7_, _tmp8_), "detect cameras", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	detected_map = _tmp9_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				CameraList* _tmp12_;
				gchar* name = NULL;
				CameraList* _tmp13_;
				const gchar* _tmp14_ = NULL;
				int _tmp15_;
				gchar* _tmp16_;
				gchar* port = NULL;
				CameraList* _tmp17_;
				const gchar* _tmp18_ = NULL;
				int _tmp19_;
				gchar* _tmp20_;
				CameraList* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				GeeHashMap* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = ctr;
					ctr = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = camera_list;
				if (!(ctr < gp_list_count (_tmp12_))) {
					break;
				}
				_tmp13_ = camera_list;
				_tmp15_ = gp_list_get_name (_tmp13_, ctr, &_tmp14_);
				_g_free0 (name);
				_tmp16_ = g_strdup (_tmp14_);
				name = _tmp16_;
				camera_table_do_op (self, _tmp15_, "get detected camera name", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (name);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp17_ = camera_list;
				_tmp19_ = gp_list_get_value (_tmp17_, ctr, &_tmp18_);
				_g_free0 (port);
				_tmp20_ = g_strdup (_tmp18_);
				port = _tmp20_;
				camera_table_do_op (self, _tmp19_, "get detected camera port", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (port);
						_g_free0 (name);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (port);
						_g_free0 (name);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp21_ = camera_list;
				_tmp22_ = name;
				_tmp23_ = port;
				g_debug ("CameraTable.vala:128: Detected %d/%d %s @ %s", ctr + 1, gp_list_count (_tmp21_), _tmp22_, _tmp23_);
				_tmp24_ = detected_map;
				_tmp25_ = port;
				_tmp26_ = name;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp25_, _tmp26_);
				_g_free0 (port);
				_g_free0 (name);
			}
		}
	}
	_tmp27_ = g_new0 (DiscoveredCamera*, 0 + 1);
	missing = _tmp27_;
	missing_length1 = 0;
	_missing_size_ = missing_length1;
	{
		GeeIterator* _camera_it = NULL;
		GeeHashMap* _tmp28_;
		GeeCollection* _tmp29_;
		GeeCollection* _tmp30_;
		GeeCollection* _tmp31_;
		GeeIterator* _tmp32_;
		GeeIterator* _tmp33_;
		_tmp28_ = self->priv->camera_map;
		_tmp29_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_camera_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			DiscoveredCamera* camera = NULL;
			GeeIterator* _tmp35_;
			gpointer _tmp36_;
			GPPortInfo port_info = {0};
			gchar* tmp_path = NULL;
			DiscoveredCamera* _tmp37_;
			Camera* _tmp38_;
			GPPortInfo _tmp39_ = {0};
			int _tmp40_;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			CameraAbilities abilities = {0};
			DiscoveredCamera* _tmp43_;
			Camera* _tmp44_;
			CameraAbilities _tmp45_ = {0};
			int _tmp46_;
			GeeHashMap* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			DiscoveredCamera* _tmp53_;
			DiscoveredCamera* _tmp54_;
			_tmp34_ = _camera_it;
			if (!gee_iterator_next (_tmp34_)) {
				break;
			}
			_tmp35_ = _camera_it;
			_tmp36_ = gee_iterator_get (_tmp35_);
			camera = (DiscoveredCamera*) _tmp36_;
			_tmp37_ = camera;
			_tmp38_ = _tmp37_->gcamera;
			_tmp40_ = gp_camera_get_port_info (_tmp38_, &_tmp39_);
			 (port_info);
			port_info = _tmp39_;
			camera_table_do_op (self, _tmp40_, "retrieve missing camera port information", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			gp_port_info_get_path (port_info, &_tmp41_);
			_g_free0 (tmp_path);
			_tmp42_ = g_strdup (_tmp41_);
			tmp_path = _tmp42_;
			_tmp43_ = camera;
			_tmp44_ = _tmp43_->gcamera;
			_tmp46_ = gp_camera_get_abilities (_tmp44_, &_tmp45_);
			 (abilities);
			abilities = _tmp45_;
			camera_table_do_op (self, _tmp46_, "retrieve camera abilities", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					 (abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					 (abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp47_ = detected_map;
			_tmp48_ = tmp_path;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp48_)) {
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp49_ = abilities.model;
				_tmp50_ = tmp_path;
				g_debug ("CameraTable.vala:148: Found camera for %s @ %s in detected map", _tmp49_, _tmp50_);
				 (abilities);
				_g_free0 (tmp_path);
				 (port_info);
				_discovered_camera_unref0 (camera);
				continue;
			}
			_tmp51_ = abilities.model;
			_tmp52_ = tmp_path;
			g_debug ("CameraTable.vala:153: %s @ %s missing", _tmp51_, _tmp52_);
			_tmp53_ = camera;
			_tmp54_ = _discovered_camera_ref0 (_tmp53_);
			_vala_array_add66 (&missing, &missing_length1, &_missing_size_, _tmp54_);
			 (abilities);
			_g_free0 (tmp_path);
			 (port_info);
			_discovered_camera_unref0 (camera);
		}
		_g_object_unref0 (_camera_it);
	}
	_tmp55_ = missing;
	_tmp55__length1 = missing_length1;
	{
		DiscoveredCamera** camera_collection = NULL;
		gint camera_collection_length1 = 0;
		gint _camera_collection_size_ = 0;
		gint camera_it = 0;
		camera_collection = _tmp55_;
		camera_collection_length1 = _tmp55__length1;
		for (camera_it = 0; camera_it < camera_collection_length1; camera_it = camera_it + 1) {
			DiscoveredCamera* _tmp56_;
			DiscoveredCamera* camera = NULL;
			_tmp56_ = _discovered_camera_ref0 (camera_collection[camera_it]);
			camera = _tmp56_;
			{
				GPPortInfo port_info = {0};
				gchar* tmp_path = NULL;
				DiscoveredCamera* _tmp57_;
				Camera* _tmp58_;
				GPPortInfo _tmp59_ = {0};
				int _tmp60_;
				const gchar* _tmp61_ = NULL;
				gchar* _tmp62_;
				CameraAbilities abilities = {0};
				DiscoveredCamera* _tmp63_;
				Camera* _tmp64_;
				CameraAbilities _tmp65_ = {0};
				int _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				GeeHashMap* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				DiscoveredCamera* _tmp73_;
				_tmp57_ = camera;
				_tmp58_ = _tmp57_->gcamera;
				_tmp60_ = gp_camera_get_port_info (_tmp58_, &_tmp59_);
				 (port_info);
				port_info = _tmp59_;
				camera_table_do_op (self, _tmp60_, "retrieve missing camera port information", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				gp_port_info_get_path (port_info, &_tmp61_);
				_g_free0 (tmp_path);
				_tmp62_ = g_strdup (_tmp61_);
				tmp_path = _tmp62_;
				_tmp63_ = camera;
				_tmp64_ = _tmp63_->gcamera;
				_tmp66_ = gp_camera_get_abilities (_tmp64_, &_tmp65_);
				 (abilities);
				abilities = _tmp65_;
				camera_table_do_op (self, _tmp66_, "retrieve missing camera abilities", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						 (abilities);
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						 (abilities);
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp67_ = abilities.model;
				_tmp68_ = tmp_path;
				g_debug ("CameraTable.vala:170: Removing from camera table: %s @ %s", _tmp67_, _tmp68_);
				_tmp69_ = self->priv->camera_map;
				_tmp70_ = tmp_path;
				_tmp71_ = camera_table_get_port_uri (_tmp70_);
				_tmp72_ = _tmp71_;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp72_, NULL);
				_g_free0 (_tmp72_);
				_tmp73_ = camera;
				g_signal_emit (self, camera_table_signals[CAMERA_TABLE_CAMERA_REMOVED_SIGNAL], 0, _tmp73_);
				 (abilities);
				_g_free0 (tmp_path);
				 (port_info);
				_discovered_camera_unref0 (camera);
			}
		}
	}
	{
		GeeIterator* _port_it = NULL;
		GeeHashMap* _tmp74_;
		GeeSet* _tmp75_;
		GeeSet* _tmp76_;
		GeeSet* _tmp77_;
		GeeIterator* _tmp78_;
		GeeIterator* _tmp79_;
		_tmp74_ = detected_map;
		_tmp75_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp76_ = _tmp75_;
		_tmp77_ = _tmp76_;
		_tmp78_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp79_ = _tmp78_;
		_g_object_unref0 (_tmp77_);
		_port_it = _tmp79_;
		while (TRUE) {
			GeeIterator* _tmp80_;
			gchar* port = NULL;
			GeeIterator* _tmp81_;
			gpointer _tmp82_;
			gchar* name = NULL;
			GeeHashMap* _tmp83_;
			const gchar* _tmp84_;
			gpointer _tmp85_;
			gchar* uri = NULL;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			GeeHashMap* _tmp88_;
			const gchar* _tmp89_;
			gint index = 0;
			GPPortInfoList* _tmp92_;
			const gchar* _tmp93_;
			GPPortInfo port_info = {0};
			gchar* tmp_path = NULL;
			GPPortInfoList* _tmp97_;
			GPPortInfo _tmp98_ = {0};
			int _tmp99_;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			const gchar* _tmp103_ = NULL;
			gchar* _tmp104_;
			const gchar* _tmp105_;
			const gchar* _tmp106_;
			CameraAbilitiesList* _tmp107_;
			const gchar* _tmp108_;
			CameraAbilities camera_abilities = {0};
			CameraAbilitiesList* _tmp112_;
			CameraAbilities _tmp113_ = {0};
			int _tmp114_;
			const gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			const gchar* _tmp118_;
			const gchar* _tmp119_;
			DiscoveredCamera* camera = NULL;
			const gchar* _tmp120_;
			const gchar* _tmp121_;
			DiscoveredCamera* _tmp122_;
			GeeHashMap* _tmp123_;
			const gchar* _tmp124_;
			DiscoveredCamera* _tmp125_;
			DiscoveredCamera* _tmp126_;
			_tmp80_ = _port_it;
			if (!gee_iterator_next (_tmp80_)) {
				break;
			}
			_tmp81_ = _port_it;
			_tmp82_ = gee_iterator_get (_tmp81_);
			port = (gchar*) _tmp82_;
			_tmp83_ = detected_map;
			_tmp84_ = port;
			_tmp85_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp84_);
			name = (gchar*) _tmp85_;
			_tmp86_ = port;
			_tmp87_ = camera_table_get_port_uri (_tmp86_);
			uri = _tmp87_;
			_tmp88_ = self->priv->camera_map;
			_tmp89_ = uri;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp89_)) {
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				_tmp90_ = name;
				_tmp91_ = port;
				g_debug ("CameraTable.vala:184: %s @ %s already registered, skipping", _tmp90_, _tmp91_);
				_g_free0 (uri);
				_g_free0 (name);
				_g_free0 (port);
				continue;
			}
			_tmp92_ = port_info_list;
			_tmp93_ = port;
			index = gp_port_info_list_lookup_path (_tmp92_, _tmp93_);
			if (index < 0) {
				const gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp94_ = port;
				_tmp95_ = g_strdup_printf ("lookup port %s", _tmp94_);
				_tmp96_ = _tmp95_;
				camera_table_do_op (self, (int) index, _tmp96_, &_inner_error0_);
				_g_free0 (_tmp96_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (uri);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (uri);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_tmp97_ = port_info_list;
			_tmp99_ = gp_port_info_list_get_info (_tmp97_, index, &_tmp98_);
			 (port_info);
			port_info = _tmp98_;
			_tmp100_ = port;
			_tmp101_ = g_strdup_printf ("get port info for %s", _tmp100_);
			_tmp102_ = _tmp101_;
			camera_table_do_op (self, _tmp99_, _tmp102_, &_inner_error0_);
			_g_free0 (_tmp102_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (uri);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (uri);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			gp_port_info_get_path (port_info, &_tmp103_);
			_g_free0 (tmp_path);
			_tmp104_ = g_strdup (_tmp103_);
			tmp_path = _tmp104_;
			_tmp105_ = port;
			_tmp106_ = tmp_path;
			_vala_assert (g_strcmp0 (_tmp105_, _tmp106_) == 0, "port == tmp_path");
			_tmp107_ = self->priv->abilities_list;
			_tmp108_ = name;
			index = gp_abilities_list_lookup_model (_tmp107_, _tmp108_);
			if (index < 0) {
				const gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				_tmp109_ = name;
				_tmp110_ = g_strdup_printf ("lookup camera model %s", _tmp109_);
				_tmp111_ = _tmp110_;
				camera_table_do_op (self, (int) index, _tmp111_, &_inner_error0_);
				_g_free0 (_tmp111_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (tmp_path);
						 (port_info);
						_g_free0 (uri);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (tmp_path);
						 (port_info);
						_g_free0 (uri);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_tmp112_ = self->priv->abilities_list;
			_tmp114_ = gp_abilities_list_get_abilities (_tmp112_, index, &_tmp113_);
			 (camera_abilities);
			camera_abilities = _tmp113_;
			_tmp115_ = name;
			_tmp116_ = g_strdup_printf ("lookup camera abilities for %s", _tmp115_);
			_tmp117_ = _tmp116_;
			camera_table_do_op (self, _tmp114_, _tmp117_, &_inner_error0_);
			_g_free0 (_tmp117_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (uri);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (uri);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp118_ = name;
			_tmp119_ = port;
			g_debug ("CameraTable.vala:210: Adding to camera table: %s @ %s", _tmp118_, _tmp119_);
			_tmp120_ = name;
			_tmp121_ = port;
			_tmp122_ = discovered_camera_new (_tmp120_, _tmp121_, port_info, camera_abilities, &_inner_error0_);
			camera = _tmp122_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (uri);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (uri);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp123_ = self->priv->camera_map;
			_tmp124_ = uri;
			_tmp125_ = camera;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp124_, _tmp125_);
			_tmp126_ = camera;
			g_signal_emit (self, camera_table_signals[CAMERA_TABLE_CAMERA_ADDED_SIGNAL], 0, _tmp126_);
			_discovered_camera_unref0 (camera);
			 (camera_abilities);
			_g_free0 (tmp_path);
			 (port_info);
			_g_free0 (uri);
			_g_free0 (name);
			_g_free0 (port);
		}
		_g_object_unref0 (_port_it);
	}
	missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
	_g_object_unref0 (detected_map);
	_gp_list_unref0 (camera_list);
	_gp_port_info_list_free0 (port_info_list);
}

static void
camera_table_on_udev_event (CameraTable* self,
                            const gchar* action,
                            GUdevDevice* device)
{
	const gchar* _tmp0_;
	OneShotScheduler* _tmp1_;
	g_return_if_fail (IS_CAMERA_TABLE (self));
	g_return_if_fail (action != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (device, g_udev_device_get_type ()));
	_tmp0_ = g_udev_device_get_name (device);
	g_debug ("CameraTable.vala:221: udev event: %s on %s", action, _tmp0_);
	_tmp1_ = self->priv->camera_update_scheduler;
	one_shot_scheduler_after_timeout (_tmp1_, (guint) CAMERA_TABLE_UPDATE_DELAY_MSEC, TRUE);
}

void
camera_table_on_volume_changed (CameraTable* self,
                                GVolume* volume)
{
	OneShotScheduler* _tmp0_;
	g_return_if_fail (IS_CAMERA_TABLE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (volume, g_volume_get_type ()));
	_tmp0_ = self->priv->camera_update_scheduler;
	one_shot_scheduler_after_timeout (_tmp0_, (guint) CAMERA_TABLE_UPDATE_DELAY_MSEC, TRUE);
}

static void
camera_table_on_update_cameras (CameraTable* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_CAMERA_TABLE (self));
	{
		CameraTable* _tmp0_;
		CameraTable* _tmp1_;
		_tmp0_ = camera_table_get_instance ();
		_tmp1_ = _tmp0_;
		camera_table_update_camera_table (_tmp1_, &_inner_error0_);
		_camera_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				goto __catch0_gphoto_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("CameraTable.vala:237: Error updating camera table: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DISCOVERED_CAMERA) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__DISCOVERED_CAMERA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DISCOVERED_CAMERA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_discovered_camera (param_values + 1), data2);
}

static void
value_camera_table_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_camera_table_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		camera_table_unref (value->data[0].v_pointer);
	}
}

static void
value_camera_table_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = camera_table_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_camera_table_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_camera_table_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CameraTable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = camera_table_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_camera_table_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	CameraTable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = camera_table_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_camera_table (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecCameraTable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CAMERA_TABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_camera_table (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_camera_table (GValue* value,
                        gpointer v_object)
{
	CameraTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CAMERA_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		camera_table_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		camera_table_unref (old);
	}
}

void
value_take_camera_table (GValue* value,
                         gpointer v_object)
{
	CameraTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CAMERA_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		camera_table_unref (old);
	}
}

static void
camera_table_class_init (CameraTableClass * klass,
                         gpointer klass_data)
{
	camera_table_parent_class = g_type_class_peek_parent (klass);
	((CameraTableClass *) klass)->finalize = camera_table_finalize;
	g_type_class_adjust_private_offset (klass, &CameraTable_private_offset);
	camera_table_signals[CAMERA_TABLE_CAMERA_ADDED_SIGNAL] = g_signal_new ("camera-added", TYPE_CAMERA_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA, G_TYPE_NONE, 1, TYPE_DISCOVERED_CAMERA);
	camera_table_signals[CAMERA_TABLE_CAMERA_REMOVED_SIGNAL] = g_signal_new ("camera-removed", TYPE_CAMERA_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA, G_TYPE_NONE, 1, TYPE_DISCOVERED_CAMERA);
}

static void
camera_table_instance_init (CameraTable * self,
                            gpointer klass)
{
	GUdevClient* _tmp0_;
	GPContext* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = camera_table_get_instance_private (self);
	_tmp0_ = g_udev_client_new (CAMERA_TABLE_SUBSYSTEMS);
	self->priv->client = _tmp0_;
	self->priv->camera_update_scheduler = NULL;
	_tmp1_ = gp_context_new ();
	self->priv->null_context = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_DISCOVERED_CAMERA, (GBoxedCopyFunc) discovered_camera_ref, (GDestroyNotify) discovered_camera_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->camera_map = _tmp2_;
	self->ref_count = 1;
}

static void
camera_table_finalize (CameraTable * obj)
{
	CameraTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CAMERA_TABLE, CameraTable);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->client);
	_one_shot_scheduler_unref0 (self->priv->camera_update_scheduler);
	_gp_context_unref0 (self->priv->null_context);
	_gp_abilities_list_free0 (self->priv->abilities_list);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->camera_map);
}

static GType
camera_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_camera_table_init, value_camera_table_free_value, value_camera_table_copy_value, value_camera_table_peek_pointer, "p", value_camera_table_collect_value, "p", value_camera_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CameraTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraTable), 0, (GInstanceInitFunc) camera_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType camera_table_type_id;
	camera_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CameraTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CameraTable_private_offset = g_type_add_instance_private (camera_table_type_id, sizeof (CameraTablePrivate));
	return camera_table_type_id;
}

GType
camera_table_get_type (void)
{
	static volatile gsize camera_table_type_id__once = 0;
	if (g_once_init_enter (&camera_table_type_id__once)) {
		GType camera_table_type_id;
		camera_table_type_id = camera_table_get_type_once ();
		g_once_init_leave (&camera_table_type_id__once, camera_table_type_id);
	}
	return camera_table_type_id__once;
}

gpointer
camera_table_ref (gpointer instance)
{
	CameraTable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
camera_table_unref (gpointer instance)
{
	CameraTable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CAMERA_TABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

