/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ContainerStatusApplyConfiguration represents a declarative configuration of the ContainerStatus type for use
// with apply.
//
// ContainerStatus contains details for the current status of this container.
type ContainerStatusApplyConfiguration struct {
	// Name is a DNS_LABEL representing the unique name of the container.
	// Each container in a pod must have a unique name across all container types.
	// Cannot be updated.
	Name *string `json:"name,omitempty"`
	// State holds details about the container's current condition.
	State *ContainerStateApplyConfiguration `json:"state,omitempty"`
	// LastTerminationState holds the last termination state of the container to
	// help debug container crashes and restarts. This field is not
	// populated if the container is still running and RestartCount is 0.
	LastTerminationState *ContainerStateApplyConfiguration `json:"lastState,omitempty"`
	// Ready specifies whether the container is currently passing its readiness check.
	// The value will change as readiness probes keep executing. If no readiness
	// probes are specified, this field defaults to true once the container is
	// fully started (see Started field).
	//
	// The value is typically used to determine whether a container is ready to
	// accept traffic.
	Ready *bool `json:"ready,omitempty"`
	// RestartCount holds the number of times the container has been restarted.
	// Kubelet makes an effort to always increment the value, but there
	// are cases when the state may be lost due to node restarts and then the value
	// may be reset to 0. The value is never negative.
	RestartCount *int32 `json:"restartCount,omitempty"`
	// Image is the name of container image that the container is running.
	// The container image may not match the image used in the PodSpec,
	// as it may have been resolved by the runtime.
	// More info: https://kubernetes.io/docs/concepts/containers/images.
	Image *string `json:"image,omitempty"`
	// ImageID is the image ID of the container's image. The image ID may not
	// match the image ID of the image used in the PodSpec, as it may have been
	// resolved by the runtime.
	ImageID *string `json:"imageID,omitempty"`
	// ContainerID is the ID of the container in the format '<type>://<container_id>'.
	// Where type is a container runtime identifier, returned from Version call of CRI API
	// (for example "containerd").
	ContainerID *string `json:"containerID,omitempty"`
	// Started indicates whether the container has finished its postStart lifecycle hook
	// and passed its startup probe.
	// Initialized as false, becomes true after startupProbe is considered
	// successful. Resets to false when the container is restarted, or if kubelet
	// loses state temporarily. In both cases, startup probes will run again.
	// Is always true when no startupProbe is defined and container is running and
	// has passed the postStart lifecycle hook. The null value must be treated the
	// same as false.
	Started *bool `json:"started,omitempty"`
	// AllocatedResources represents the compute resources allocated for this container by the
	// node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission
	// and after successfully admitting desired pod resize.
	AllocatedResources *corev1.ResourceList `json:"allocatedResources,omitempty"`
	// Resources represents the compute resource requests and limits that have been successfully
	// enacted on the running container after it has been started or has been successfully resized.
	Resources *ResourceRequirementsApplyConfiguration `json:"resources,omitempty"`
	// Status of volume mounts.
	VolumeMounts []VolumeMountStatusApplyConfiguration `json:"volumeMounts,omitempty"`
	// User represents user identity information initially attached to the first process of the container
	User *ContainerUserApplyConfiguration `json:"user,omitempty"`
	// AllocatedResourcesStatus represents the status of various resources
	// allocated for this Pod.
	AllocatedResourcesStatus []ResourceStatusApplyConfiguration `json:"allocatedResourcesStatus,omitempty"`
	// StopSignal reports the effective stop signal for this container
	StopSignal *corev1.Signal `json:"stopSignal,omitempty"`
}

// ContainerStatusApplyConfiguration constructs a declarative configuration of the ContainerStatus type for use with
// apply.
func ContainerStatus() *ContainerStatusApplyConfiguration {
	return &ContainerStatusApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithName(value string) *ContainerStatusApplyConfiguration {
	b.Name = &value
	return b
}

// WithState sets the State field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the State field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithState(value *ContainerStateApplyConfiguration) *ContainerStatusApplyConfiguration {
	b.State = value
	return b
}

// WithLastTerminationState sets the LastTerminationState field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LastTerminationState field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithLastTerminationState(value *ContainerStateApplyConfiguration) *ContainerStatusApplyConfiguration {
	b.LastTerminationState = value
	return b
}

// WithReady sets the Ready field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Ready field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithReady(value bool) *ContainerStatusApplyConfiguration {
	b.Ready = &value
	return b
}

// WithRestartCount sets the RestartCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RestartCount field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithRestartCount(value int32) *ContainerStatusApplyConfiguration {
	b.RestartCount = &value
	return b
}

// WithImage sets the Image field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Image field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithImage(value string) *ContainerStatusApplyConfiguration {
	b.Image = &value
	return b
}

// WithImageID sets the ImageID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ImageID field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithImageID(value string) *ContainerStatusApplyConfiguration {
	b.ImageID = &value
	return b
}

// WithContainerID sets the ContainerID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContainerID field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithContainerID(value string) *ContainerStatusApplyConfiguration {
	b.ContainerID = &value
	return b
}

// WithStarted sets the Started field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Started field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithStarted(value bool) *ContainerStatusApplyConfiguration {
	b.Started = &value
	return b
}

// WithAllocatedResources sets the AllocatedResources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllocatedResources field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithAllocatedResources(value corev1.ResourceList) *ContainerStatusApplyConfiguration {
	b.AllocatedResources = &value
	return b
}

// WithResources sets the Resources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resources field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithResources(value *ResourceRequirementsApplyConfiguration) *ContainerStatusApplyConfiguration {
	b.Resources = value
	return b
}

// WithVolumeMounts adds the given value to the VolumeMounts field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumeMounts field.
func (b *ContainerStatusApplyConfiguration) WithVolumeMounts(values ...*VolumeMountStatusApplyConfiguration) *ContainerStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithVolumeMounts")
		}
		b.VolumeMounts = append(b.VolumeMounts, *values[i])
	}
	return b
}

// WithUser sets the User field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the User field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithUser(value *ContainerUserApplyConfiguration) *ContainerStatusApplyConfiguration {
	b.User = value
	return b
}

// WithAllocatedResourcesStatus adds the given value to the AllocatedResourcesStatus field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AllocatedResourcesStatus field.
func (b *ContainerStatusApplyConfiguration) WithAllocatedResourcesStatus(values ...*ResourceStatusApplyConfiguration) *ContainerStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAllocatedResourcesStatus")
		}
		b.AllocatedResourcesStatus = append(b.AllocatedResourcesStatus, *values[i])
	}
	return b
}

// WithStopSignal sets the StopSignal field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StopSignal field is set to the value of the last call.
func (b *ContainerStatusApplyConfiguration) WithStopSignal(value corev1.Signal) *ContainerStatusApplyConfiguration {
	b.StopSignal = &value
	return b
}
