/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	v1 "k8s.io/client-go/applyconfigurations/core/v1"
)

// ResourceSliceSpecApplyConfiguration represents a declarative configuration of the ResourceSliceSpec type for use
// with apply.
//
// ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
type ResourceSliceSpecApplyConfiguration struct {
	// Driver identifies the DRA driver providing the capacity information.
	// A field selector can be used to list only ResourceSlice
	// objects with a certain driver name.
	//
	// Must be a DNS subdomain and should end with a DNS domain owned by the
	// vendor of the driver. It should use only lower case characters.
	// This field is immutable.
	Driver *string `json:"driver,omitempty"`
	// Pool describes the pool that this ResourceSlice belongs to.
	Pool *ResourcePoolApplyConfiguration `json:"pool,omitempty"`
	// NodeName identifies the node which provides the resources in this pool.
	// A field selector can be used to list only ResourceSlice
	// objects belonging to a certain node.
	//
	// This field can be used to limit access from nodes to ResourceSlices with
	// the same node name. It also indicates to autoscalers that adding
	// new nodes of the same type as some old node might also make new
	// resources available.
	//
	// Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
	// This field is immutable.
	NodeName *string `json:"nodeName,omitempty"`
	// NodeSelector defines which nodes have access to the resources in the pool,
	// when that pool is not limited to a single node.
	//
	// Must use exactly one term.
	//
	// Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
	NodeSelector *v1.NodeSelectorApplyConfiguration `json:"nodeSelector,omitempty"`
	// AllNodes indicates that all nodes have access to the resources in the pool.
	//
	// Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
	AllNodes *bool `json:"allNodes,omitempty"`
	// Devices lists some or all of the devices in this pool.
	//
	// Must not have more than 128 entries. If any device uses taints or consumes counters the limit is 64.
	//
	// Only one of Devices and SharedCounters can be set in a ResourceSlice.
	Devices []DeviceApplyConfiguration `json:"devices,omitempty"`
	// PerDeviceNodeSelection defines whether the access from nodes to
	// resources in the pool is set on the ResourceSlice level or on each
	// device. If it is set to true, every device defined the ResourceSlice
	// must specify this individually.
	//
	// Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
	PerDeviceNodeSelection *bool `json:"perDeviceNodeSelection,omitempty"`
	// SharedCounters defines a list of counter sets, each of which
	// has a name and a list of counters available.
	//
	// The names of the counter sets must be unique in the ResourcePool.
	//
	// Only one of Devices and SharedCounters can be set in a ResourceSlice.
	//
	// The maximum number of counter sets is 8.
	SharedCounters []CounterSetApplyConfiguration `json:"sharedCounters,omitempty"`
}

// ResourceSliceSpecApplyConfiguration constructs a declarative configuration of the ResourceSliceSpec type for use with
// apply.
func ResourceSliceSpec() *ResourceSliceSpecApplyConfiguration {
	return &ResourceSliceSpecApplyConfiguration{}
}

// WithDriver sets the Driver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Driver field is set to the value of the last call.
func (b *ResourceSliceSpecApplyConfiguration) WithDriver(value string) *ResourceSliceSpecApplyConfiguration {
	b.Driver = &value
	return b
}

// WithPool sets the Pool field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Pool field is set to the value of the last call.
func (b *ResourceSliceSpecApplyConfiguration) WithPool(value *ResourcePoolApplyConfiguration) *ResourceSliceSpecApplyConfiguration {
	b.Pool = value
	return b
}

// WithNodeName sets the NodeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeName field is set to the value of the last call.
func (b *ResourceSliceSpecApplyConfiguration) WithNodeName(value string) *ResourceSliceSpecApplyConfiguration {
	b.NodeName = &value
	return b
}

// WithNodeSelector sets the NodeSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeSelector field is set to the value of the last call.
func (b *ResourceSliceSpecApplyConfiguration) WithNodeSelector(value *v1.NodeSelectorApplyConfiguration) *ResourceSliceSpecApplyConfiguration {
	b.NodeSelector = value
	return b
}

// WithAllNodes sets the AllNodes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllNodes field is set to the value of the last call.
func (b *ResourceSliceSpecApplyConfiguration) WithAllNodes(value bool) *ResourceSliceSpecApplyConfiguration {
	b.AllNodes = &value
	return b
}

// WithDevices adds the given value to the Devices field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Devices field.
func (b *ResourceSliceSpecApplyConfiguration) WithDevices(values ...*DeviceApplyConfiguration) *ResourceSliceSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDevices")
		}
		b.Devices = append(b.Devices, *values[i])
	}
	return b
}

// WithPerDeviceNodeSelection sets the PerDeviceNodeSelection field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PerDeviceNodeSelection field is set to the value of the last call.
func (b *ResourceSliceSpecApplyConfiguration) WithPerDeviceNodeSelection(value bool) *ResourceSliceSpecApplyConfiguration {
	b.PerDeviceNodeSelection = &value
	return b
}

// WithSharedCounters adds the given value to the SharedCounters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SharedCounters field.
func (b *ResourceSliceSpecApplyConfiguration) WithSharedCounters(values ...*CounterSetApplyConfiguration) *ResourceSliceSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSharedCounters")
		}
		b.SharedCounters = append(b.SharedCounters, *values[i])
	}
	return b
}
