/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
 

#ifndef signature_cache_ffi_h
#define signature_cache_ffi_h

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. */

#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

/// SignatureCache is a simple least-recently-used cache. The input is a sha512
/// hash representing the parameters defining a signature. A hit in the cache
/// indicates that the signature previously verified successfully.
struct SignatureCache;

/// TrustCache is a simple least-recently-used cache. The input is a sha512
/// hash representing the parameters involved in a certificate trust lookup
/// (trust category (i.e. TLS or email signing), end-entity or CA, policy,
/// etc.), which maps to a mozilla::pkix::TrustLevel value represented as a u8.
struct TrustCache;

extern "C" {

/// Create a new SignatureCache.
SignatureCache *signature_cache_new(uint16_t capacity);

/// Free a SignatureCache.
///
/// # Safety
///
/// This function must only be called with a null pointer or a pointer returned from
/// `signature_cache_new`.
void signature_cache_free(SignatureCache *signature_cache);

/// Look up a signature parameter hash in a SignatureCache.
///
/// # Safety
///
/// This function must only be called with a pointer returned from
/// `signature_cache_new` and a pointer to `SHA512_LENGTH_IN_BYTES` bytes.
bool signature_cache_get(SignatureCache *signature_cache, const uint8_t *sha512_hash);

/// Add a signature parameter hash to a SignatureCache.
///
/// # Safety
///
/// This function must only be called with a pointer returned from
/// `signature_cache_new` and a pointer to `SHA512_LENGTH_IN_BYTES` bytes.
void signature_cache_insert(SignatureCache *signature_cache, const uint8_t *sha512_hash);

/// Create a new TrustCache.
TrustCache *trust_cache_new(uint16_t capacity);

/// Free a TrustCache.
///
/// # Safety
///
/// This function must only be called with a null pointer or a pointer returned from
/// `trust_cache_new`.
void trust_cache_free(TrustCache *trust_cache);

/// Look up a trust hash in a TrustCache.
///
/// # Safety
///
/// This function must only be called with a pointer returned from
/// `trust_cache_new` and a pointer to `SHA512_LENGTH_IN_BYTES` bytes.
bool trust_cache_get(TrustCache *trust_cache, const uint8_t *sha512_hash, uint8_t *trust);

/// Add a trust hash to a TrustCache.
///
/// # Safety
///
/// This function must only be called with a pointer returned from
/// `trust_cache_new` and a pointer to `SHA512_LENGTH_IN_BYTES` bytes.
void trust_cache_insert(TrustCache *trust_cache, const uint8_t *sha512_hash, uint8_t trust);

/// Clear a trust cache, removing all entries.
///
/// # Safety
///
/// This function must only be called with a pointer returned from
/// `trust_cache_new`.
void trust_cache_clear(TrustCache *trust_cache);

}  // extern "C"

#endif  // signature_cache_ffi_h
