//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/comm/mailnews/mime/public/nsIMsgHeaderParser.idl
//


/// `interface msgIAddressObject : nsISupports`
///

/// ```text
/// /**
///  * A structured representation of an address.
///  *
///  * This is meant to correspond to the address production from RFC 5322. As a
///  * result, an instance of this interface is either a single mailbox or a group
///  * of mailboxes. The difference between the two forms is in which attribute is
///  * undefined: mailboxes leave the members attribute undefined while groups leave
///  * the email attribute undefined.
///  *
///  * For example, an address like "John Doe <jdoe@machine.example>" will, when
///  * parsed, result in an instance with the name attribute set to "John Doe", the
///  * email attribute set to "jdoe@machine.example", and the members variable left
///  * undefined.
///  *
///  * A group like "undisclosed-recipients:;" will, when parsed, result in an
///  * instance with the name attribute set to "undisclosed-recipients", the email
///  * attribute left defined, and the members variable set to an empty array.
///  *
///  * In general, the attributes of this interface are always meant to be in a form
///  * suitable for display purposes, and not in a form usable for MIME emission. In
///  * particular, email addresses could be fully internationalized and non-ASCII,
///  * RFC 2047-encoded words may appear in names, and the name or email parameters
///  * are unquoted.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct msgIAddressObject {
    vtable: &'static msgIAddressObjectVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for msgIAddressObject.
unsafe impl XpCom for msgIAddressObject {
    const IID: nsIID = nsID(0xb19f5636, 0xebc4, 0x470e,
        [0xb4, 0x6c, 0x98, 0xb5, 0xfc, 0x7e, 0x88, 0xc9]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for msgIAddressObject {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from msgIAddressObject.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait msgIAddressObjectCoerce {
    /// Cheaply cast a value of this type from a `msgIAddressObject`.
    fn coerce_from(v: &msgIAddressObject) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl msgIAddressObjectCoerce for msgIAddressObject {
    #[inline]
    fn coerce_from(v: &msgIAddressObject) -> &Self {
        v
    }
}

impl msgIAddressObject {
    /// Cast this `msgIAddressObject` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: msgIAddressObjectCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for msgIAddressObject {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> msgIAddressObjectCoerce for T {
    #[inline]
    fn coerce_from(v: &msgIAddressObject) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every msgIAddressObject
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct msgIAddressObjectVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute AString name; */
    pub GetName: unsafe extern "system" fn (this: *const msgIAddressObject, aName: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString email; */
    pub GetEmail: unsafe extern "system" fn (this: *const msgIAddressObject, aEmail: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute jsval group; */
    /// Unable to generate binding because `special type jsval unsupported`
    pub GetGroup: *const ::libc::c_void,

    /* AString toString (); */
    pub ToString: unsafe extern "system" fn (this: *const msgIAddressObject, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl msgIAddressObject {


    /// `readonly attribute AString name;`
    #[inline]
    pub unsafe fn GetName(&self, aName: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetName)(self, aName)
    }



    /// `readonly attribute AString email;`
    #[inline]
    pub unsafe fn GetEmail(&self, aEmail: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetEmail)(self, aEmail)
    }


    /// ```text
    /// /**
    ///    * The member mailboxes of this group, which may be an empty list.
    ///    *
    ///    * Due to the limitations of XPIDL, the type of this attribute cannot be
    ///    * properly reflected. It is actually an array of msgIAddressObject instances,
    ///    * although it is instead undefined if this object does not represent a group.
    ///    */
    /// ```
    ///

    /// `readonly attribute jsval group;`
    const _GetGroup: () = ();


    /// `AString toString ();`
    #[inline]
    pub unsafe fn ToString(&self, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).ToString)(self, _retval)
    }


}


/// `interface nsIMsgHeaderParser : nsISupports`
///

/// ```text
/// /**
///  * A utility service for manipulating addressing headers in email messages.
///  *
///  * This interface is designed primarily for use from JavaScript code; code in
///  * C++ should use the methods in MimeHeaderParser.h instead, as it is better
///  * designed to take advantage of C++'s features, particularly with respect to
///  * arrays.
///  *
///  * There are two methods for parsing MIME headers, one for RFC 2047-decoded
///  * strings, and one for non-RFC 2047-decoded strings.
///  *
///  * In general, this API attempts to preserve the format of addresses as
///  * faithfully as possible. No case normalization is performed at any point.
///  * However, internationalized email addresses generally need extra processing to
///  * work properly, so while this API should handle them without issues, consumers
///  * of this API may fail to work properly when presented with such addresses. To
///  * ease use for such cases, future versions of the API may incorporate necessary
///  * normalization steps to make oblivious consumers more likely to work properly.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIMsgHeaderParser {
    vtable: &'static nsIMsgHeaderParserVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIMsgHeaderParser.
unsafe impl XpCom for nsIMsgHeaderParser {
    const IID: nsIID = nsID(0xaf2f9dd1, 0x0226, 0x4835,
        [0xb9, 0x81, 0xa4, 0xf8, 0x8b, 0x5e, 0x97, 0xcc]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIMsgHeaderParser {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIMsgHeaderParser.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIMsgHeaderParserCoerce {
    /// Cheaply cast a value of this type from a `nsIMsgHeaderParser`.
    fn coerce_from(v: &nsIMsgHeaderParser) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIMsgHeaderParserCoerce for nsIMsgHeaderParser {
    #[inline]
    fn coerce_from(v: &nsIMsgHeaderParser) -> &Self {
        v
    }
}

impl nsIMsgHeaderParser {
    /// Cast this `nsIMsgHeaderParser` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIMsgHeaderParserCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIMsgHeaderParser {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIMsgHeaderParserCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIMsgHeaderParser) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIMsgHeaderParser
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIMsgHeaderParserVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* Array<msgIAddressObject> parseEncodedHeader (in ACString aEncodedHeader, [optional] in string aHeaderCharset, [optional] in boolean aPreserveGroups); */
    pub ParseEncodedHeader: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aEncodedHeader: *const ::nsstring::nsACString, aHeaderCharset: *const libc::c_char, aPreserveGroups: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult,

    /* Array<msgIAddressObject> parseEncodedHeaderW (in AString aEncodedHeader); */
    pub ParseEncodedHeaderW: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aEncodedHeader: *const ::nsstring::nsAString, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult,

    /* Array<msgIAddressObject> parseDecodedHeader (in AString aDecodedHeader, [optional] in boolean aPreserveGroups); */
    pub ParseDecodedHeader: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aDecodedHeader: *const ::nsstring::nsAString, aPreserveGroups: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult,

    /* AString makeMimeHeader (in Array<msgIAddressObject> aAddresses); */
    pub MakeMimeHeader: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aAddresses: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* AString extractFirstName (in AString aDecodedHeader); */
    pub ExtractFirstName: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aDecodedHeader: *const ::nsstring::nsAString, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* AUTF8String removeDuplicateAddresses (in AUTF8String aAddrs, [optional] in AUTF8String aOtherAddrs); */
    pub RemoveDuplicateAddresses: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aAddrs: *const ::nsstring::nsACString, aOtherAddrs: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* msgIAddressObject makeMailboxObject (in AString aName, in AString aEmail); */
    pub MakeMailboxObject: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aName: *const ::nsstring::nsAString, aEmail: *const ::nsstring::nsAString, _retval: *mut *const msgIAddressObject) -> ::nserror::nsresult,

    /* msgIAddressObject makeGroupObject (in AString aName, in Array<msgIAddressObject> aMembers); */
    pub MakeGroupObject: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aName: *const ::nsstring::nsAString, aMembers: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, _retval: *mut *const msgIAddressObject) -> ::nserror::nsresult,

    /* Array<msgIAddressObject> makeFromDisplayAddress (in AString aDisplayAddresses); */
    pub MakeFromDisplayAddress: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aDisplayAddresses: *const ::nsstring::nsAString, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult,

    /* ACString extractHeaderAddressMailboxes (in ACString aLine); */
    pub ExtractHeaderAddressMailboxes: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aLine: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* AString makeMimeAddress (in AString aName, in AString aEmail); */
    pub MakeMimeAddress: unsafe extern "system" fn (this: *const nsIMsgHeaderParser, aName: *const ::nsstring::nsAString, aEmail: *const ::nsstring::nsAString, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIMsgHeaderParser {

    /// ```text
    /// /**
    ///    * Parse an address-based header that has not yet been 2047-decoded.
    ///    *
    ///    * The result of this method is an array of objects described in the above
    ///    * comment. Note that the header is a binary string that will be decoded as if
    ///    * passed into nsIMimeConverter.
    ///    *
    ///    * @param aEncodedHeader  The RFC 2047-encoded header to parse.
    ///    * @param aHeaderCharset  The charset to assume for raw octets.
    ///    * @param aPreserveGroups If false (the default), the result is a flat array
    ///    *                        of mailbox objects, containing no group objects.
    ///    * @return                An array corresponding to the header description.
    ///    */
    /// ```
    ///

    /// `Array<msgIAddressObject> parseEncodedHeader (in ACString aEncodedHeader, [optional] in string aHeaderCharset, [optional] in boolean aPreserveGroups);`
    #[inline]
    pub unsafe fn ParseEncodedHeader(&self, aEncodedHeader: *const ::nsstring::nsACString, aHeaderCharset: *const libc::c_char, aPreserveGroups: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult {
        ((*self.vtable).ParseEncodedHeader)(self, aEncodedHeader, aHeaderCharset, aPreserveGroups, _retval)
    }


    /// ```text
    /// /**
    ///    * Parse an address-based header that has not yet been 2047-decoded and does not
    ///    * contain raw octets but instead wide (UTF-16) characters.
    ///    *
    ///    * @param aEncodedHeader  The RFC 2047-encoded header to parse.
    ///    * @return                An array corresponding to the header description.
    ///    */
    /// ```
    ///

    /// `Array<msgIAddressObject> parseEncodedHeaderW (in AString aEncodedHeader);`
    #[inline]
    pub unsafe fn ParseEncodedHeaderW(&self, aEncodedHeader: *const ::nsstring::nsAString, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult {
        ((*self.vtable).ParseEncodedHeaderW)(self, aEncodedHeader, _retval)
    }


    /// ```text
    /// /**
    ///    * Parse an address-based header that has been 2047-decoded.
    ///    *
    ///    * The result of this method is an array of objects described in the above
    ///    * comment. Note that the header is a binary string that will be decoded as if
    ///    * passed into nsIMimeConverter.
    ///    *
    ///    * @param aDecodedHeader  The non-RFC 2047-encoded header to parse.
    ///    * @param aPreserveGroups If false (the default), the result is a flat array
    ///    *                        of mailbox objects, containing no group objects.
    ///    * @return                An array corresponding to the header description.
    ///    */
    /// ```
    ///

    /// `Array<msgIAddressObject> parseDecodedHeader (in AString aDecodedHeader, [optional] in boolean aPreserveGroups);`
    #[inline]
    pub unsafe fn ParseDecodedHeader(&self, aDecodedHeader: *const ::nsstring::nsAString, aPreserveGroups: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult {
        ((*self.vtable).ParseDecodedHeader)(self, aDecodedHeader, aPreserveGroups, _retval)
    }


    /// ```text
    /// /**
    ///    * Given an array of addresses, make a MIME header suitable for emission.
    ///    *
    ///    * The return value of this method is not directly suitable for use in a MIME
    ///    * message but rather needs to be passed through nsIMimeConverter first to
    ///    * have RFC-2047 encoding applied and the resulting output wrapped to adhere
    ///    * to maximum line length formats.
    ///    *
    ///    * @param aAddresses An array corresponding to the header description.
    ///    * @return           A string that is suitable for writing in a MIME message.
    ///    */
    /// ```
    ///

    /// `AString makeMimeHeader (in Array<msgIAddressObject> aAddresses);`
    #[inline]
    pub unsafe fn MakeMimeHeader(&self, aAddresses: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).MakeMimeHeader)(self, aAddresses, _retval)
    }


    /// ```text
    /// /**
    ///    * Return the first address in the list in a format suitable for display.
    ///    *
    ///    * This is largely a convenience method for handling From headers (or similar),
    ///    * which are expected to only have a single element in them. It is exactly
    ///    * equivalent to saying (parseDecodedHeader(decodedHeader))[0].toString().
    ///    *
    ///    * @param decodedHeader   The non-RFC 2047-encoded header to parse.
    ///    * @return                The first address, suitable for display.
    ///    */
    /// ```
    ///

    /// `AString extractFirstName (in AString aDecodedHeader);`
    #[inline]
    pub unsafe fn ExtractFirstName(&self, aDecodedHeader: *const ::nsstring::nsAString, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).ExtractFirstName)(self, aDecodedHeader, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns a copy of the input which may have had some addresses removed.
    ///    * Addresses are removed if they are already in either of the supplied
    ///    * address lists.
    ///    *
    ///    * Addresses are considered to be the same if they contain the same email
    ///    * part (case-insensitive). Since the email part should never be RFC
    ///    * 2047-encoded, this method should work whether or not the header is
    ///    * RFC 2047-encoded.
    ///    *
    ///    * @param aAddrs      The addresses to remove duplicates from.
    ///    * @param aOtherAddrs Other addresses that the duplicate removal process also
    ///    *                    checks for duplicates against. Addresses in this list
    ///    *                    will not be added to the result.
    ///    * @return            The original header with duplicate addresses removed.
    ///    */
    /// ```
    ///

    /// `AUTF8String removeDuplicateAddresses (in AUTF8String aAddrs, [optional] in AUTF8String aOtherAddrs);`
    #[inline]
    pub unsafe fn RemoveDuplicateAddresses(&self, aAddrs: *const ::nsstring::nsACString, aOtherAddrs: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).RemoveDuplicateAddresses)(self, aAddrs, aOtherAddrs, _retval)
    }



    /// `msgIAddressObject makeMailboxObject (in AString aName, in AString aEmail);`
    #[inline]
    pub unsafe fn MakeMailboxObject(&self, aName: *const ::nsstring::nsAString, aEmail: *const ::nsstring::nsAString, _retval: *mut *const msgIAddressObject) -> ::nserror::nsresult {
        ((*self.vtable).MakeMailboxObject)(self, aName, aEmail, _retval)
    }



    /// `msgIAddressObject makeGroupObject (in AString aName, in Array<msgIAddressObject> aMembers);`
    #[inline]
    pub unsafe fn MakeGroupObject(&self, aName: *const ::nsstring::nsAString, aMembers: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, _retval: *mut *const msgIAddressObject) -> ::nserror::nsresult {
        ((*self.vtable).MakeGroupObject)(self, aName, aMembers, _retval)
    }


    /// ```text
    /// /**
    ///    * Return an array of structured mailbox objects for the given display name
    ///    * string.
    ///    *
    ///    * The string is expected to be a comma-separated sequence of strings that
    ///    * would be produced by msgIAddressObject::toString(). For example, the string
    ///    * "Bond, James <agent007@mi5.invalid>" would produce one address object,
    ///    * while the string "webmaster@nowhere.invalid, child@nowhere.invalid" would
    ///    * produce two address objects.
    ///    */
    /// ```
    ///

    /// `Array<msgIAddressObject> makeFromDisplayAddress (in AString aDisplayAddresses);`
    #[inline]
    pub unsafe fn MakeFromDisplayAddress(&self, aDisplayAddresses: *const ::nsstring::nsAString, _retval: *mut thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>) -> ::nserror::nsresult {
        ((*self.vtable).MakeFromDisplayAddress)(self, aDisplayAddresses, _retval)
    }


    /// ```text
    /// /**
    ///    * Given a string which contains a list of Header addresses, returns a
    ///    * comma-separated list of just the `mailbox' portions.
    ///    *
    ///    * @param aLine          The header line to parse.
    ///    * @return               A comma-separated list of just the mailbox parts
    ///    *                       of the email-addresses.
    ///    */
    /// ```
    ///

    /// `ACString extractHeaderAddressMailboxes (in ACString aLine);`
    #[inline]
    pub unsafe fn ExtractHeaderAddressMailboxes(&self, aLine: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).ExtractHeaderAddressMailboxes)(self, aLine, _retval)
    }


    /// ```text
    /// /**
    ///    * Given a name and email address, produce a string that is suitable for
    ///    * emitting in a MIME header (after applying RFC 2047 encoding).
    ///    */
    /// ```
    ///

    /// `AString makeMimeAddress (in AString aName, in AString aEmail);`
    #[inline]
    pub unsafe fn MakeMimeAddress(&self, aName: *const ::nsstring::nsAString, aEmail: *const ::nsstring::nsAString, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).MakeMimeAddress)(self, aName, aEmail, _retval)
    }


}


