/* THIS FILE IS AUTOGENERATED FROM HTMLOptionsCollection.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "HTMLCollectionBinding.h"
#include "HTMLOptionsCollectionBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/DocGroup.h"
#include "mozilla/dom/HTMLOptGroupElement.h"
#include "mozilla/dom/HTMLOptionElement.h"
#include "mozilla/dom/HTMLOptionsCollection.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsGenericHTMLElement.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace HTMLOptionsCollection_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<HTMLCollection_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLOptionsCollection", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLOptionsCollection*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Length());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLOptionsCollection", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLOptionsCollection*>(void_self);
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLength(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLength(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLOptionsCollection.length setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo length_getterinfo = {
  { get_length },
  { prototypes::id::HTMLOptionsCollection },
  { PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo length_setterinfo = {
  { (JSJitGetterOp)set_length },
  { prototypes::id::HTMLOptionsCollection },
  { PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
add(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "HTMLOptionsCollection.add");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLOptionsCollection", "add", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLOptionsCollection*>(void_self);
  if (!args.requireAtLeast(cx, "HTMLOptionsCollection.add", 1)) {
    return false;
  }
  HTMLOptionElementOrHTMLOptGroupElement arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  Nullable<HTMLElementOrLong > arg1;
  if (!(args.hasDefined(1)) || args[1].isNullOrUndefined()) {
    arg1.SetNull();
  } else {
    if (!arg1.SetValue().Init(cx, args[1], "Argument 2", false)) {
      return false;
    }
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Add(Constify(arg0), Constify(arg1), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Add(Constify(arg0), Constify(arg1), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLOptionsCollection.add"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo add_methodinfo = {
  { (JSJitGetterOp)add },
  { prototypes::id::HTMLOptionsCollection },
  { PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
remove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLOptionsCollection", "remove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLOptionsCollection*>(void_self);
  if (!args.requireAtLeast(cx, "HTMLOptionsCollection.remove", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Remove(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->Remove(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo remove_methodinfo = {
  { (JSJitGetterOp)remove },
  { prototypes::id::HTMLOptionsCollection },
  { PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_selectedIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLOptionsCollection", "selectedIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLOptionsCollection*>(void_self);
  int32_t result(MOZ_KnownLive(self)->SelectedIndex());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_selectedIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLOptionsCollection", "selectedIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLOptionsCollection*>(void_self);
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetSelectedIndex(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetSelectedIndex(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo selectedIndex_getterinfo = {
  { get_selectedIndex },
  { prototypes::id::HTMLOptionsCollection },
  { PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo selectedIndex_setterinfo = {
  { (JSJitGetterOp)set_selectedIndex },
  { prototypes::id::HTMLOptionsCollection },
  { PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("add", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&add_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("remove", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&remove_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_SYM_FNSPEC(iterator, nullptr, nullptr, 0, 0, "$ArrayValues"),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("length", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &length_getterinfo, GenericSetter<NormalThisPolicy>, &length_setterinfo),
  JSPropertySpec::nativeAccessors("selectedIndex", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &selectedIndex_getterinfo, GenericSetter<NormalThisPolicy>, &selectedIndex_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[5];
static PropertyInfo sNativeProperties_propertyInfos[5];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  5,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[3] }
  }
};
static_assert(5 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, mozilla::dom::HTMLOptionsCollection>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  bool
  getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const override;

  bool
  setCustom(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::Value> v, bool* done) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::dom::HTMLOptionsCollection*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::dom::HTMLOptionsCollection*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::HTMLOptionsCollection,
  constructors::id::HTMLOptionsCollection,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  HTMLCollection_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth,
  prototypes::id::HTMLOptionsCollection,
  true,
  0,
  "HTMLOptionsCollection",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "HTMLOptionsCollectionPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::HTMLOptionsCollection,
  PrototypeTraits<prototypes::id::HTMLOptionsCollection>::Depth,
  &sNativePropertyHooks,
  HTMLCollection_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    JS::Rooted<JS::Value> value(cx);
    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!result) {
        value.setNull();
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable, JS::PropertyAttribute::Writable })));
        return true;
      }
      if (!GetOrCreateDOMReflector(cx, result, &value)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable, JS::PropertyAttribute::Writable })));
      return true;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!IsArrayIndex(index) && !ignoreNamedProps) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    callNamedGetter = !hasOnProto;
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!result) {
          value.setNull();
          desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable })));
          return true;
        }
        if (!GetOrCreateDOMReflector(cx, result, &value)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    BindingCallContext cx(cx_, "HTMLOptionsCollection indexed setter");
    *done = true;
    // https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
    // Step 1.1.  The no-indexed-setter case is handled by step 1.2.
    if (!desc.isDataDescriptor()) {
      return opresult.failNotDataDescriptor();
    }

    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    JS::Rooted<JS::Value> rootedValue(cx, desc.value());
    mozilla::dom::HTMLOptionElement* option;
    if (desc.value().isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::HTMLOptionElement, mozilla::dom::HTMLOptionElement>(&rootedValue, option, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned to HTMLOptionsCollection setter", "HTMLOptionElement");
          return false;
        }
      }
    } else if (desc.value().isNullOrUndefined()) {
      option = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned to HTMLOptionsCollection setter");
      return false;
    }
    Maybe<AutoCEReaction> ceReaction;
    DocGroup* docGroup = self->GetDocGroup();
    if (docGroup) {
      ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
    }
    FastErrorResult rv;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(Constify(option)), rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(Constify(option)), rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLOptionsCollection indexed setter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    return opresult.succeed();
  }
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  uint32_t length = UnwrapProxy(proxy)->Length();
  MOZ_ASSERT(int32_t(length) >= 0);
  for (int32_t i = 0; i < int32_t(length); ++i) {
    if (!props.append(JS::PropertyKey::Int(i))) {
      return false;
    }
  }

  if (flags & JSITER_HIDDEN) {
    nsTArray<nsString> names;
    UnwrapProxy(proxy)->GetSupportedNames(names);
    if (!AppendNamedPropertyIds(cx, proxy, names, false, props)) {
      return false;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool found = false;
    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;

    *bp = found;
    return true;
  }


  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool hasOnProto;
  if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
    return false;
  }
  if (!hasOnProto) {
    bool found = false;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }

    *bp = found;
    return true;
  }
  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!result) {
        vp.setNull();
        return true;
      }
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    // Even if we don't have this index, we don't forward the
    // get on to our expando object.
  } else {
    bool expandoHasProp = false;
    { // Scope for expando
      JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
      if (expando) {
        if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
          return false;
        }

        if (expandoHasProp) {
          // Forward the get to the expando object, but our receiver is whatever our
          // receiver is.
          if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
            return false;
          }
        }
      }
    }

    if (expandoHasProp) {
      return true;
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  if (!IsArrayIndex(index)) {
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!result) {
          vp.setNull();
          return true;
        }
        if (!GetOrCreateDOMReflector(cx, result, vp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        return true;
      }
    }
  }

  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "HTMLOptionsCollection";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::dom::HTMLOptionsCollection* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::HTMLOptionsCollection>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::HTMLOptionsCollection>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool deleteSucceeded;
    bool found = false;
    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
    deleteSucceeded = !found;
    return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
  }
  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    tryNamedDelete = !hasOnProto;
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

bool
DOMProxyHandler::getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const
{
  JS::Rooted<JS::Value> temp(cx);
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");

  mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
  uint32_t length = self->Length();
  // Compute the end of the indices we'll get ourselves
  uint32_t ourEnd = std::clamp(length, begin, end);

  for (uint32_t index = begin; index < ourEnd; ++index) {
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    MOZ_ASSERT(found);
    if (!result) {
      temp.setNull();
      if (!adder->append(cx, temp)) return false;
      continue;
    }
    if (!GetOrCreateDOMReflector(cx, result, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!adder->append(cx, temp)) return false;
    continue;
  }

  if (end > ourEnd) {
    JS::Rooted<JSObject*> proto(cx);
    if (!js::GetObjectProto(cx, proxy, &proto)) {
      return false;
    }
    return js::GetElementsWithAdder(cx, proto, proxy, ourEnd, end, adder);
  }

  return true;
}

bool
DOMProxyHandler::setCustom(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::Value> v, bool* done) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    BindingCallContext cx(cx_, "HTMLOptionsCollection indexed setter");
    mozilla::dom::HTMLOptionsCollection* self = UnwrapProxy(proxy);
    JS::Rooted<JS::Value> rootedValue(cx, v);
    mozilla::dom::HTMLOptionElement* option;
    if (v.isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::HTMLOptionElement, mozilla::dom::HTMLOptionElement>(&rootedValue, option, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned to HTMLOptionsCollection setter", "HTMLOptionElement");
          return false;
        }
      }
    } else if (v.isNullOrUndefined()) {
      option = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned to HTMLOptionsCollection setter");
      return false;
    }
    Maybe<AutoCEReaction> ceReaction;
    DocGroup* docGroup = self->GetDocGroup();
    if (docGroup) {
      ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
    }
    FastErrorResult rv;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(Constify(option)), rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(Constify(option)), rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLOptionsCollection indexed setter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    *done = true;
    return true;
  }

  *done = false;
  return true;
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::dom::HTMLOptionsCollection>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("HTMLOptionsCollection",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::HTMLCollection, prototypes::id::HTMLOptionsCollection, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::HTMLOptionsCollection>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::HTMLOptionsCollection>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::HTMLOptionsCollection>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::dom::HTMLOptionsCollection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::HTMLOptionsCollection>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::HTMLOptionsCollection*>);
  MOZ_ASSERT(static_cast<nsIHTMLCollection*>(aObject) ==
             reinterpret_cast<nsIHTMLCollection*>(aObject),
             "Multiple inheritance for nsIHTMLCollection is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::HTMLOptionsCollection> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::HTMLOptionsCollection);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::HTMLOptionsCollection);

  JS::Handle<JSObject*> parentProto(HTMLCollection_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(HTMLCollection_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "HTMLOptionsCollection",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLOptionsCollection,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLOptionsCollection,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace HTMLOptionsCollection_Binding



} // namespace mozilla::dom
