//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PTCPSocketChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/network/TCPSocketChild.h"
#include "mozilla/dom/network/TCPSocketParent.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/net/NeckoMessageUtils.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PTCPSocketChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PTCPSocketChild::PTCPSocketChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PTCPSocketChild);
}

PTCPSocketChild::~PTCPSocketChild()
{
    MOZ_COUNT_DTOR(PTCPSocketChild);
}

auto PTCPSocketChild::ActorAlloc() -> void
{
}

auto PTCPSocketChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PTCPSocketChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PTCPSocketChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PTCPSocketChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PTCPSocketChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PTCPSocketChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PTCPSocketChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PTCPSocketChild::SendOpen(
        const nsAString& host,
        const uint16_t& port,
        const bool& useSSL,
        const bool& useArrayBuffers) -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_Open(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), host);
    // Sentinel = 'host'
    ((&(writer__)))->WriteSentinel(72024511);
    IPC::WriteParam((&(writer__)), port);
    // Sentinel = 'port'
    ((&(writer__)))->WriteSentinel(73990598);
    IPC::WriteParam((&(writer__)), useSSL);
    // Sentinel = 'useSSL'
    ((&(writer__)))->WriteSentinel(142737984);
    IPC::WriteParam((&(writer__)), useArrayBuffers);
    // Sentinel = 'useArrayBuffers'
    ((&(writer__)))->WriteSentinel(815007258);


    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_Open", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::SendData(const SendableData& data) -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_Data(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), data);
    // Sentinel = 'data'
    ((&(writer__)))->WriteSentinel(67109275);


    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_Data", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::SendStartTLS() -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_StartTLS(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_StartTLS", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::SendSuspend() -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_Suspend(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_Suspend", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::SendResume() -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_Resume(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_Resume", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::SendClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_Close(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_Close", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::SendRequestDelete() -> bool
{
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg_RequestDelete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg_RequestDelete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTCPSocketChild::Send__delete__(PTCPSocketChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PTCPSocket::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTCPSocketChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTCPSocket::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PTCPSocketChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PTCPSocketChild::OnMessageReceived(const Message& msg__) -> PTCPSocketChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PTCPSocket::Msg_Callback__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PTCPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PTCPSocket::Msg_Callback", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__type = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__data = IPC::ReadParam<CallbackData>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'CallbackData'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CallbackData'");
                return MsgValueError;
            }
            auto maybe__readyState = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__readyState) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& readyState = *maybe__readyState;
            // Sentinel = 'readyState'
            if ((!(((&(reader__)))->ReadSentinel(377750551)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::TCPSocketChild*>(this))->RecvCallback(std::move(type), std::move(data), std::move(readyState));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PTCPSocket::Msg_UpdateBufferedAmount__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PTCPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PTCPSocket::Msg_UpdateBufferedAmount", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__bufferedAmount = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__bufferedAmount) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& bufferedAmount = *maybe__bufferedAmount;
            // Sentinel = 'bufferedAmount'
            if ((!(((&(reader__)))->ReadSentinel(711919032)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__trackingNumber = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__trackingNumber) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& trackingNumber = *maybe__trackingNumber;
            // Sentinel = 'trackingNumber'
            if ((!(((&(reader__)))->ReadSentinel(726664637)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::TCPSocketChild*>(this))->RecvUpdateBufferedAmount(std::move(bufferedAmount), std::move(trackingNumber));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PTCPSocket::Msg_RequestDelete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PTCPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PTCPSocket::Msg_RequestDelete", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::TCPSocketChild*>(this))->RecvRequestDelete();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PTCPSocket::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PTCPSocket::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PTCPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PTCPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PTCPSocket::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::TCPSocketChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PTCPSocketChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PTCPSocketChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PTCPSocketChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PTCPSocket'
    (aWriter)->WriteSentinel(311296929);
}

auto ParamTraits<::mozilla::net::PTCPSocketChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PTCPSocket actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PTCPSocket'
    if ((!((aReader)->ReadSentinel(311296929)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PTCPSocket actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PTCPSocketMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PTCPSocket)");

        return {};
    }
    return static_cast<::mozilla::net::PTCPSocketChild*>(actor);
}

} // namespace IPC
