struct cs_svg_filter_node_common {
struct Samplers {
 sampler2D_impl sClipMask_impl;
 int sClipMask_slot;
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 sampler2D_impl sColor1_impl;
 int sColor1_slot;
 sampler2D_impl sGpuCache_impl;
 int sGpuCache_slot;
 sampler2D_impl sPrimitiveHeadersF_impl;
 int sPrimitiveHeadersF_slot;
 isampler2D_impl sPrimitiveHeadersI_impl;
 int sPrimitiveHeadersI_slot;
 sampler2D_impl sRenderTasks_impl;
 int sRenderTasks_slot;
 sampler2D_impl sTransformPalette_impl;
 int sTransformPalette_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 7:
   sClipMask_slot = value;
   return true;
  case 8:
   sColor0_slot = value;
   return true;
  case 9:
   sColor1_slot = value;
   return true;
  case 2:
   sGpuCache_slot = value;
   return true;
  case 4:
   sPrimitiveHeadersF_slot = value;
   return true;
  case 5:
   sPrimitiveHeadersI_slot = value;
   return true;
  case 1:
   sRenderTasks_slot = value;
   return true;
  case 3:
   sTransformPalette_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aData = NULL_ATTRIB;
 int aFilterTargetRect = NULL_ATTRIB;
 int aFilterInput1ContentScaleAndOffset = NULL_ATTRIB;
 int aFilterInput2ContentScaleAndOffset = NULL_ATTRIB;
 int aFilterInput1TaskAddress = NULL_ATTRIB;
 int aFilterInput2TaskAddress = NULL_ATTRIB;
 int aFilterKind = NULL_ATTRIB;
 int aFilterInputCount = NULL_ATTRIB;
 int aFilterExtraDataAddress = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aData", name) == 0) { aData = index; return; }
  if (strcmp("aFilterTargetRect", name) == 0) { aFilterTargetRect = index; return; }
  if (strcmp("aFilterInput1ContentScaleAndOffset", name) == 0) { aFilterInput1ContentScaleAndOffset = index; return; }
  if (strcmp("aFilterInput2ContentScaleAndOffset", name) == 0) { aFilterInput2ContentScaleAndOffset = index; return; }
  if (strcmp("aFilterInput1TaskAddress", name) == 0) { aFilterInput1TaskAddress = index; return; }
  if (strcmp("aFilterInput2TaskAddress", name) == 0) { aFilterInput2TaskAddress = index; return; }
  if (strcmp("aFilterKind", name) == 0) { aFilterKind = index; return; }
  if (strcmp("aFilterInputCount", name) == 0) { aFilterInputCount = index; return; }
  if (strcmp("aFilterExtraDataAddress", name) == 0) { aFilterExtraDataAddress = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aData", name) == 0) { return aData != NULL_ATTRIB ? aData : -1; }
  if (strcmp("aFilterTargetRect", name) == 0) { return aFilterTargetRect != NULL_ATTRIB ? aFilterTargetRect : -1; }
  if (strcmp("aFilterInput1ContentScaleAndOffset", name) == 0) { return aFilterInput1ContentScaleAndOffset != NULL_ATTRIB ? aFilterInput1ContentScaleAndOffset : -1; }
  if (strcmp("aFilterInput2ContentScaleAndOffset", name) == 0) { return aFilterInput2ContentScaleAndOffset != NULL_ATTRIB ? aFilterInput2ContentScaleAndOffset : -1; }
  if (strcmp("aFilterInput1TaskAddress", name) == 0) { return aFilterInput1TaskAddress != NULL_ATTRIB ? aFilterInput1TaskAddress : -1; }
  if (strcmp("aFilterInput2TaskAddress", name) == 0) { return aFilterInput2TaskAddress != NULL_ATTRIB ? aFilterInput2TaskAddress : -1; }
  if (strcmp("aFilterKind", name) == 0) { return aFilterKind != NULL_ATTRIB ? aFilterKind : -1; }
  if (strcmp("aFilterInputCount", name) == 0) { return aFilterInputCount != NULL_ATTRIB ? aFilterInputCount : -1; }
  if (strcmp("aFilterExtraDataAddress", name) == 0) { return aFilterExtraDataAddress != NULL_ATTRIB ? aFilterExtraDataAddress : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vTransformBounds;
vec4_scalar vInput1UvRect;
vec4_scalar vInput2UvRect;
ivec4_scalar vData;
vec4_scalar vFilterData0;
ivec2_scalar vFilterInputCountFilterKindVec;
vec2_scalar vFloat0;
mat4_scalar vColorMat;
sampler2D sClipMask;
sampler2D sColor0;
sampler2D sColor1;
sampler2D sGpuCache;
sampler2D sPrimitiveHeadersF;
isampler2D sPrimitiveHeadersI;
sampler2D sRenderTasks;
sampler2D sTransformPalette;
mat4_scalar uTransform;
void bind_textures() {
 sClipMask = lookup_sampler(&samplers.sClipMask_impl, samplers.sClipMask_slot);
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
 sColor1 = lookup_sampler(&samplers.sColor1_impl, samplers.sColor1_slot);
 sGpuCache = lookup_sampler(&samplers.sGpuCache_impl, samplers.sGpuCache_slot);
 sPrimitiveHeadersF = lookup_sampler(&samplers.sPrimitiveHeadersF_impl, samplers.sPrimitiveHeadersF_slot);
 sPrimitiveHeadersI = lookup_isampler(&samplers.sPrimitiveHeadersI_impl, samplers.sPrimitiveHeadersI_slot);
 sRenderTasks = lookup_sampler(&samplers.sRenderTasks_impl, samplers.sRenderTasks_slot);
 sTransformPalette = lookup_sampler(&samplers.sTransformPalette_impl, samplers.sTransformPalette_slot);
}
};
struct cs_svg_filter_node_vert : VertexShaderImpl, cs_svg_filter_node_common {
private:
typedef cs_svg_filter_node_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sRenderTasks;
struct RenderTaskData_scalar {
RectWithEndpoint_scalar task_rect;
vec4_scalar user_data;
RenderTaskData_scalar() = default;
RenderTaskData_scalar(RectWithEndpoint_scalar task_rect, vec4_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct RenderTaskData {
RectWithEndpoint task_rect;
vec4 user_data;
RenderTaskData() = default;
RenderTaskData(RectWithEndpoint task_rect, vec4 user_data) : task_rect(task_rect), user_data(user_data){}
RenderTaskData(RectWithEndpoint_scalar task_rect, vec4_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT RenderTaskData(RenderTaskData_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend RenderTaskData if_then_else(I32 c, RenderTaskData t, RenderTaskData e) { return RenderTaskData(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct PictureTask_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar content_origin;
PictureTask_scalar() = default;
PictureTask_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
};
struct PictureTask {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 content_origin;
PictureTask() = default;
PictureTask(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
PictureTask(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),content_origin(content_origin){
}
IMPLICIT PictureTask(PictureTask_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),content_origin(s.content_origin){
}
friend PictureTask if_then_else(I32 c, PictureTask t, PictureTask e) { return PictureTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.content_origin, e.content_origin));
}};
struct ClipArea_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar screen_origin;
ClipArea_scalar() = default;
ClipArea_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
};
struct ClipArea {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 screen_origin;
ClipArea() = default;
ClipArea(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
ClipArea(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),screen_origin(screen_origin){
}
IMPLICIT ClipArea(ClipArea_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),screen_origin(s.screen_origin){
}
friend ClipArea if_then_else(I32 c, ClipArea t, ClipArea e) { return ClipArea(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.screen_origin, e.screen_origin));
}};
// sampler2D sGpuCache;
struct ImageSource_scalar {
RectWithEndpoint_scalar uv_rect;
vec4_scalar user_data;
ImageSource_scalar() = default;
ImageSource_scalar(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data) : uv_rect(uv_rect), user_data(user_data){}
};
struct ImageSource {
RectWithEndpoint uv_rect;
vec4 user_data;
ImageSource() = default;
ImageSource(RectWithEndpoint uv_rect, vec4 user_data) : uv_rect(uv_rect), user_data(user_data){}
ImageSource(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data):uv_rect(uv_rect),user_data(user_data){
}
IMPLICIT ImageSource(ImageSource_scalar s):uv_rect(s.uv_rect),user_data(s.user_data){
}
friend ImageSource if_then_else(I32 c, ImageSource t, ImageSource e) { return ImageSource(
if_then_else(c, t.uv_rect, e.uv_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct ImageSourceExtra_scalar {
vec4_scalar st_tl;
vec4_scalar st_tr;
vec4_scalar st_bl;
vec4_scalar st_br;
ImageSourceExtra_scalar() = default;
ImageSourceExtra_scalar(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
};
struct ImageSourceExtra {
vec4 st_tl;
vec4 st_tr;
vec4 st_bl;
vec4 st_br;
ImageSourceExtra() = default;
ImageSourceExtra(vec4 st_tl, vec4 st_tr, vec4 st_bl, vec4 st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
ImageSourceExtra(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br):st_tl(st_tl),st_tr(st_tr),st_bl(st_bl),st_br(st_br){
}
IMPLICIT ImageSourceExtra(ImageSourceExtra_scalar s):st_tl(s.st_tl),st_tr(s.st_tr),st_bl(s.st_bl),st_br(s.st_br){
}
friend ImageSourceExtra if_then_else(I32 c, ImageSourceExtra t, ImageSourceExtra e) { return ImageSourceExtra(
if_then_else(c, t.st_tl, e.st_tl), if_then_else(c, t.st_tr, e.st_tr), if_then_else(c, t.st_bl, e.st_bl), if_then_else(c, t.st_br, e.st_br));
}};
// vec4_scalar vTransformBounds;
// sampler2D sTransformPalette;
struct Transform_scalar {
mat4_scalar m;
mat4_scalar inv_m;
bool is_axis_aligned;
Transform_scalar() = default;
Transform_scalar(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
};
struct Transform {
mat4 m;
mat4 inv_m;
Bool is_axis_aligned;
Transform() = default;
Transform(mat4 m, mat4 inv_m, Bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
Transform(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned):m(m),inv_m(inv_m),is_axis_aligned(is_axis_aligned){
}
IMPLICIT Transform(Transform_scalar s):m(s.m),inv_m(s.inv_m),is_axis_aligned(s.is_axis_aligned){
}
friend Transform if_then_else(I32 c, Transform t, Transform e) { return Transform(
if_then_else(c, t.m, e.m), if_then_else(c, t.inv_m, e.inv_m), if_then_else(c, t.is_axis_aligned, e.is_axis_aligned));
}};
// sampler2D sClipMask;
// sampler2D sPrimitiveHeadersF;
// isampler2D sPrimitiveHeadersI;
ivec4_scalar aData;
struct Instance_scalar {
int32_t prim_header_address;
int32_t clip_address;
int32_t segment_index;
int32_t flags;
int32_t resource_address;
int32_t brush_kind;
Instance_scalar() = default;
Instance_scalar(int32_t prim_header_address, int32_t clip_address, int32_t segment_index, int32_t flags, int32_t resource_address, int32_t brush_kind) : prim_header_address(prim_header_address), clip_address(clip_address), segment_index(segment_index), flags(flags), resource_address(resource_address), brush_kind(brush_kind){}
};
struct Instance {
I32 prim_header_address;
I32 clip_address;
I32 segment_index;
I32 flags;
I32 resource_address;
I32 brush_kind;
Instance() = default;
Instance(I32 prim_header_address, I32 clip_address, I32 segment_index, I32 flags, I32 resource_address, I32 brush_kind) : prim_header_address(prim_header_address), clip_address(clip_address), segment_index(segment_index), flags(flags), resource_address(resource_address), brush_kind(brush_kind){}
Instance(int32_t prim_header_address, int32_t clip_address, int32_t segment_index, int32_t flags, int32_t resource_address, int32_t brush_kind):prim_header_address(prim_header_address),clip_address(clip_address),segment_index(segment_index),flags(flags),resource_address(resource_address),brush_kind(brush_kind){
}
IMPLICIT Instance(Instance_scalar s):prim_header_address(s.prim_header_address),clip_address(s.clip_address),segment_index(s.segment_index),flags(s.flags),resource_address(s.resource_address),brush_kind(s.brush_kind){
}
friend Instance if_then_else(I32 c, Instance t, Instance e) { return Instance(
if_then_else(c, t.prim_header_address, e.prim_header_address), if_then_else(c, t.clip_address, e.clip_address), if_then_else(c, t.segment_index, e.segment_index), if_then_else(c, t.flags, e.flags), if_then_else(c, t.resource_address, e.resource_address), if_then_else(c, t.brush_kind, e.brush_kind));
}};
struct PrimitiveHeader_scalar {
RectWithEndpoint_scalar local_rect;
RectWithEndpoint_scalar local_clip_rect;
float z;
int32_t specific_prim_address;
int32_t transform_id;
int32_t picture_task_address;
ivec4_scalar user_data;
PrimitiveHeader_scalar() = default;
PrimitiveHeader_scalar(RectWithEndpoint_scalar local_rect, RectWithEndpoint_scalar local_clip_rect, float z, int32_t specific_prim_address, int32_t transform_id, int32_t picture_task_address, ivec4_scalar user_data) : local_rect(local_rect), local_clip_rect(local_clip_rect), z(z), specific_prim_address(specific_prim_address), transform_id(transform_id), picture_task_address(picture_task_address), user_data(user_data){}
};
struct PrimitiveHeader {
RectWithEndpoint local_rect;
RectWithEndpoint local_clip_rect;
Float z;
I32 specific_prim_address;
I32 transform_id;
I32 picture_task_address;
ivec4 user_data;
PrimitiveHeader() = default;
PrimitiveHeader(RectWithEndpoint local_rect, RectWithEndpoint local_clip_rect, Float z, I32 specific_prim_address, I32 transform_id, I32 picture_task_address, ivec4 user_data) : local_rect(local_rect), local_clip_rect(local_clip_rect), z(z), specific_prim_address(specific_prim_address), transform_id(transform_id), picture_task_address(picture_task_address), user_data(user_data){}
PrimitiveHeader(RectWithEndpoint_scalar local_rect, RectWithEndpoint_scalar local_clip_rect, float z, int32_t specific_prim_address, int32_t transform_id, int32_t picture_task_address, ivec4_scalar user_data):local_rect(local_rect),local_clip_rect(local_clip_rect),z(z),specific_prim_address(specific_prim_address),transform_id(transform_id),picture_task_address(picture_task_address),user_data(user_data){
}
IMPLICIT PrimitiveHeader(PrimitiveHeader_scalar s):local_rect(s.local_rect),local_clip_rect(s.local_clip_rect),z(s.z),specific_prim_address(s.specific_prim_address),transform_id(s.transform_id),picture_task_address(s.picture_task_address),user_data(s.user_data){
}
friend PrimitiveHeader if_then_else(I32 c, PrimitiveHeader t, PrimitiveHeader e) { return PrimitiveHeader(
if_then_else(c, t.local_rect, e.local_rect), if_then_else(c, t.local_clip_rect, e.local_clip_rect), if_then_else(c, t.z, e.z), if_then_else(c, t.specific_prim_address, e.specific_prim_address), if_then_else(c, t.transform_id, e.transform_id), if_then_else(c, t.picture_task_address, e.picture_task_address), if_then_else(c, t.user_data, e.user_data));
}};
struct VertexInfo_scalar {
vec2_scalar local_pos;
vec4_scalar world_pos;
VertexInfo_scalar() = default;
VertexInfo_scalar(vec2_scalar local_pos, vec4_scalar world_pos) : local_pos(local_pos), world_pos(world_pos){}
};
struct VertexInfo {
vec2 local_pos;
vec4 world_pos;
VertexInfo() = default;
VertexInfo(vec2 local_pos, vec4 world_pos) : local_pos(local_pos), world_pos(world_pos){}
VertexInfo(vec2_scalar local_pos, vec4_scalar world_pos):local_pos(local_pos),world_pos(world_pos){
}
IMPLICIT VertexInfo(VertexInfo_scalar s):local_pos(s.local_pos),world_pos(s.world_pos){
}
friend VertexInfo if_then_else(I32 c, VertexInfo t, VertexInfo e) { return VertexInfo(
if_then_else(c, t.local_pos, e.local_pos), if_then_else(c, t.world_pos, e.world_pos));
}};
vec2 vInput1Uv;
vec2 vInput2Uv;
// vec4_scalar vInput1UvRect;
// vec4_scalar vInput2UvRect;
// ivec4_scalar vData;
// vec4_scalar vFilterData0;
// vec4_scalar vFilterData1;
// ivec2_scalar vFilterInputCountFilterKindVec;
// vec2_scalar vFloat0;
// mat4_scalar vColorMat;
// ivec4_scalar vFuncs;
vec4_scalar aFilterTargetRect;
vec4_scalar aFilterInput1ContentScaleAndOffset;
vec4_scalar aFilterInput2ContentScaleAndOffset;
int32_t aFilterInput1TaskAddress;
int32_t aFilterInput2TaskAddress;
int32_t aFilterKind;
int32_t aFilterInputCount;
ivec2_scalar aFilterExtraDataAddress;
RectWithEndpoint_scalar fetch_render_task_rect(int32_t index) {
 ivec2_scalar uv = make_ivec2(make_int((2u)*((make_uint(index))%((1024u)/(2u)))), make_int((make_uint(index))/((1024u)/(2u))));
 auto sRenderTasks_uv_fetch = texelFetchPtr(sRenderTasks, uv, 0, 1, 0, 0);
 vec4_scalar texel0 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 0, 0);
 vec4_scalar texel1 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 1, 0);
 RectWithEndpoint_scalar task_rect = RectWithEndpoint_scalar((texel0).sel(X,Y), (texel0).sel(Z,W));
 return task_rect;
}
vec4_scalar compute_uv_rect(RectWithEndpoint_scalar task_rect, vec2_scalar texture_size) {
 vec4_scalar uvRect = make_vec4(((task_rect).p0)+(make_vec2(0.5f)), ((task_rect).p1)-(make_vec2(0.5f)));
 uvRect /= (texture_size).sel(X,Y,X,Y);
 return uvRect;
}
vec2 compute_uv(RectWithEndpoint_scalar task_rect, vec4_scalar scale_and_offset, vec2_scalar target_size, vec2_scalar texture_size) {
 return ((((task_rect).p0)+((scale_and_offset).sel(Z,W)))+(((scale_and_offset).sel(X,Y))*((aPosition).sel(X,Y))))/((texture_size).sel(X,Y));
}
Array<vec4_scalar,4> fetch_from_gpu_cache_4_direct(ivec2_scalar address) {
 auto sGpuCache_address_fetch = texelFetchPtr(sGpuCache, address, 0, 3, 0, 0);
 return Array<vec4_scalar,4>{{texelFetchUnchecked(sGpuCache, sGpuCache_address_fetch, 0, 0), texelFetchUnchecked(sGpuCache, sGpuCache_address_fetch, 1, 0), texelFetchUnchecked(sGpuCache, sGpuCache_address_fetch, 2, 0), texelFetchUnchecked(sGpuCache, sGpuCache_address_fetch, 3, 0)}};
}
vec4_scalar fetch_from_gpu_cache_1_direct(ivec2_scalar address) {
 return texelFetch(sGpuCache, address, 0);
}
vec3_scalar vertexSrgbToLinear(vec3_scalar color) {
 vec3_scalar c1 = (color)*(make_vec3((1.f)/(12.92f)));
 vec3_scalar c2;
 (c2).x = pow((((color).x)*((1.f)/(1.055f)))+((0.055f)/(1.055f)), 2.4f);
 (c2).y = pow((((color).y)*((1.f)/(1.055f)))+((0.055f)/(1.055f)), 2.4f);
 (c2).z = pow((((color).z)*((1.f)/(1.055f)))+((0.055f)/(1.055f)), 2.4f);
 return mix(c1, c2, step(make_vec3(0.04045f), color));
}
ALWAYS_INLINE void main(void) {
 vec2 pos = mix((aFilterTargetRect).sel(X,Y), (aFilterTargetRect).sel(Z,W), (aPosition).sel(X,Y));
 RectWithEndpoint_scalar input_1_task;
 if ((aFilterInputCount)>(0)) {
  {
   vec2_scalar texture_size = make_vec2((textureSize(sColor0, 0)).sel(X,Y));
   input_1_task = fetch_render_task_rect(aFilterInput1TaskAddress);
   vInput1UvRect = compute_uv_rect(input_1_task, texture_size);
   vInput1Uv = compute_uv(input_1_task, aFilterInput1ContentScaleAndOffset, ((aFilterTargetRect).sel(Z,W))-((aFilterTargetRect).sel(X,Y)), texture_size);
  }
 }
 RectWithEndpoint_scalar input_2_task;
 if ((aFilterInputCount)>(1)) {
  {
   vec2_scalar texture_size = make_vec2((textureSize(sColor1, 0)).sel(X,Y));
   input_2_task = fetch_render_task_rect(aFilterInput2TaskAddress);
   vInput2UvRect = compute_uv_rect(input_2_task, texture_size);
   vInput2Uv = compute_uv(input_2_task, aFilterInput2ContentScaleAndOffset, ((aFilterTargetRect).sel(Z,W))-((aFilterTargetRect).sel(X,Y)), texture_size);
  }
 }
 (vFilterInputCountFilterKindVec).x = aFilterInputCount;
 (vFilterInputCountFilterKindVec).y = aFilterKind;
 switch (aFilterKind) {
  case 0:
  case 1:
   break;
  case 2:
  case 3:
   (vFloat0).x = (aFilterInput2ContentScaleAndOffset).x;
   break;
  case 4:
  case 5:
   break;
  case 6:
  case 7:
  case 8:
  case 9:
  case 10:
  case 11:
  case 12:
  case 13:
  case 14:
  case 15:
  case 16:
  case 17:
  case 18:
  case 19:
  case 20:
  case 21:
  case 22:
  case 23:
  case 24:
  case 25:
  case 26:
  case 27:
  case 28:
  case 29:
  case 30:
  case 31:
  case 32:
  case 33:
  case 34:
  case 35:
  case 36:
  case 37:
   break;
  case 38:
  case 39:
   {
    Array<vec4_scalar,4> mat_data = fetch_from_gpu_cache_4_direct(aFilterExtraDataAddress);
    vColorMat = make_mat4(mat_data[0], mat_data[1], mat_data[2], mat_data[3]);
    vFilterData0 = fetch_from_gpu_cache_1_direct((aFilterExtraDataAddress)+(make_ivec2(4, 0)));
    break;
    }
  case 40:
  case 41:
   vData = make_ivec4(aFilterExtraDataAddress, 0, 0);
   break;
  case 42:
  case 43:
   vFilterData0 = fetch_from_gpu_cache_1_direct(aFilterExtraDataAddress);
   break;
  case 44:
  case 45:
  case 46:
  case 47:
  case 48:
  case 49:
  case 50:
  case 51:
  case 52:
  case 53:
  case 54:
  case 55:
   break;
  case 56:
  case 57:
   break;
  case 58:
  case 59:
   break;
  case 60:
  case 61:
   break;
  case 62:
  case 63:
   break;
  case 64:
  case 65:
   break;
  case 66:
  case 67:
   break;
  case 68:
  case 69:
   break;
  case 70:
   vFilterData0 = fetch_from_gpu_cache_1_direct(aFilterExtraDataAddress);
   (vFilterData0).lsel(R,G,B) = ((vFilterData0).sel(R,G,B))*((vFilterData0).w);
   break;
  case 71:
   vFilterData0 = fetch_from_gpu_cache_1_direct(aFilterExtraDataAddress);
   (vFilterData0).lsel(R,G,B) = vertexSrgbToLinear((vFilterData0).sel(R,G,B));
   (vFilterData0).lsel(R,G,B) = ((vFilterData0).sel(R,G,B))*((vFilterData0).w);
   break;
  case 72:
   vFilterData0 = aFilterInput2ContentScaleAndOffset;
   (vFilterData0).lsel(R,G,B) = ((vFilterData0).sel(R,G,B))*((vFilterData0).w);
   break;
  case 73:
   vFilterData0 = aFilterInput2ContentScaleAndOffset;
   (vFilterData0).lsel(R,G,B) = vertexSrgbToLinear((vFilterData0).sel(R,G,B));
   (vFilterData0).lsel(R,G,B) = ((vFilterData0).sel(R,G,B))*((vFilterData0).w);
   break;
  case 74:
  case 75:
   break;
  case 76:
  case 77:
   break;
  case 80:
  case 81:
  case 82:
  case 83:
   vFilterData0 = aFilterInput2ContentScaleAndOffset;
   break;
  case 86:
  case 87:
   break;
  case 88:
  case 89:
   break;
  case 90:
  case 91:
   break;
  case 92:
  case 93:
   break;
  case 94:
  case 95:
  case 96:
  case 97:
  case 98:
  case 99:
  case 100:
  case 101:
   break;
  default:
   break;
 }
 gl_Position = (uTransform)*(make_vec4(pos, 0.f, 1.f));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 7:
  assert(0); // sClipMask
  break;
 case 8:
  assert(0); // sColor0
  break;
 case 9:
  assert(0); // sColor1
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 4:
  assert(0); // sPrimitiveHeadersF
  break;
 case 5:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 6:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 7:
  assert(0); // sClipMask
  break;
 case 8:
  assert(0); // sColor0
  break;
 case 9:
  assert(0); // sColor1
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 4:
  assert(0); // sPrimitiveHeadersF
  break;
 case 5:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 6:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 7:
  assert(0); // sClipMask
  break;
 case 8:
  assert(0); // sColor0
  break;
 case 9:
  assert(0); // sColor1
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 4:
  assert(0); // sPrimitiveHeadersF
  break;
 case 5:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 6:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aFilterTargetRect, attribs[self->attrib_locations.aFilterTargetRect], start, instance, count);
 load_flat_attrib(self->aFilterInput1ContentScaleAndOffset, attribs[self->attrib_locations.aFilterInput1ContentScaleAndOffset], start, instance, count);
 load_flat_attrib(self->aFilterInput2ContentScaleAndOffset, attribs[self->attrib_locations.aFilterInput2ContentScaleAndOffset], start, instance, count);
 load_flat_attrib(self->aFilterInput1TaskAddress, attribs[self->attrib_locations.aFilterInput1TaskAddress], start, instance, count);
 load_flat_attrib(self->aFilterInput2TaskAddress, attribs[self->attrib_locations.aFilterInput2TaskAddress], start, instance, count);
 load_flat_attrib(self->aFilterKind, attribs[self->attrib_locations.aFilterKind], start, instance, count);
 load_flat_attrib(self->aFilterInputCount, attribs[self->attrib_locations.aFilterInputCount], start, instance, count);
 load_flat_attrib(self->aFilterExtraDataAddress, attribs[self->attrib_locations.aFilterExtraDataAddress], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar vInput1Uv;
vec2_scalar vInput2Uv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vInput1Uv = get_nth(vInput1Uv, n);
    dest->vInput2Uv = get_nth(vInput2Uv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_svg_filter_node_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_svg_filter_node_frag : FragmentShaderImpl, cs_svg_filter_node_vert {
private:
typedef cs_svg_filter_node_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sGpuCache;
// vec4_scalar vTransformBounds;
// sampler2D sClipMask;
struct Fragment_scalar {
vec4_scalar color;
Fragment_scalar() = default;
explicit Fragment_scalar(vec4_scalar color) : color(color){}
};
struct Fragment {
vec4 color;
Fragment() = default;
explicit Fragment(vec4 color) : color(color){}
explicit Fragment(vec4_scalar color):color(color){
}
IMPLICIT Fragment(Fragment_scalar s):color(s.color){
}
friend Fragment if_then_else(I32 c, Fragment t, Fragment e) { return Fragment(
if_then_else(c, t.color, e.color));
}};
vec2 vInput1Uv;
vec2 vInput2Uv;
// vec4_scalar vInput1UvRect;
// vec4_scalar vInput2UvRect;
// ivec4_scalar vData;
// vec4_scalar vFilterData0;
// vec4_scalar vFilterData1;
// ivec2_scalar vFilterInputCountFilterKindVec;
// vec2_scalar vFloat0;
// mat4_scalar vColorMat;
// ivec4_scalar vFuncs;
vec4 sampleInUvRect(sampler2D sampler, vec2 uv, vec4_scalar uvRect) {
 vec2 clamped = clamp((uv).sel(X,Y), (uvRect).sel(X,Y), (uvRect).sel(Z,W));
 return texture(sampler, clamped);
}
vec3 SrgbToLinear(vec3 color) {
 vec3 c1 = (color)/(12.92f);
 vec3 c2 = pow(((color)/(1.055f))+(make_vec3((0.055f)/(1.055f))), make_vec3(2.4f));
 return mix(c2, c1, lessThanEqual(color, make_vec3(0.04045f)));
}
Float Lum(vec3 c) {
 vec3_scalar f = make_vec3(0.3f, 0.59f, 0.11f);
 return dot(c, f);
}
vec3 ClipColor(vec3 C) {
 Float L = Lum(C);
 Float n = min((C).x, min((C).y, (C).z));
 Float x = max((C).x, max((C).y, (C).z));
 auto _c3_ = (n)<(0.f);
 C = if_then_else(_c3_,(L)+((((C)-(L))*(L))/((L)-(n))),C);
 auto _c4_ = (x)>(1.f);
 C = if_then_else(_c4_,(L)+((((C)-(L))*((1.f)-(L)))/((x)-(L))),C);
 return C;
}
vec3 SetLum(vec3 C, Float l) {
 Float d = (l)-(Lum(C));
 return ClipColor((C)+(d));
}
vec3 Color(vec3 Cb, vec3 Cs) {
 return SetLum(Cs, Lum(Cb));
}
Float ColorBurn(Float Cb, Float Cs) {
 I32 ret_mask = ~0;
 Float ret;
 auto _c8_ = (Cb)==(1.f);
 ret = 1.f;
 ret_mask = ~I32(_c8_);
 auto _c9_ = (Cs)==(0.f);
 auto _c10_ = (~(_c8_))&(_c9_);
 ret = if_then_else(ret_mask & I32(_c10_), 0.f, ret);
 ret_mask &= ~I32(_c10_);
 _c9_ = (~(_c8_))&(~(_c9_));
 ret = if_then_else(ret_mask & I32(_c9_), (1.f)-(min(1.f, ((1.f)-(Cb))/(Cs))), ret);
 ret_mask &= ~I32(_c9_);
 return ret;
}
Float ColorDodge(Float Cb, Float Cs) {
 I32 ret_mask = ~0;
 Float ret;
 auto _c14_ = (Cb)==(0.f);
 ret = 0.f;
 ret_mask = ~I32(_c14_);
 auto _c15_ = (Cs)==(1.f);
 auto _c16_ = (~(_c14_))&(_c15_);
 ret = if_then_else(ret_mask & I32(_c16_), 1.f, ret);
 ret_mask &= ~I32(_c16_);
 _c15_ = (~(_c14_))&(~(_c15_));
 ret = if_then_else(ret_mask & I32(_c15_), min(1.f, (Cb)/((1.f)-(Cs))), ret);
 ret_mask &= ~I32(_c15_);
 return ret;
}
vec3 Multiply(vec3 Cb, vec3 Cs) {
 return (Cb)*(Cs);
}
vec3 Screen(vec3 Cb, vec3 Cs) {
 return ((Cb)+(Cs))-((Cb)*(Cs));
}
vec3 HardLight(vec3 Cb, vec3 Cs) {
 vec3 m = Multiply(Cb, (2.f)*(Cs));
 vec3 s = Screen(Cb, ((2.f)*(Cs))-(1.f));
 vec3_scalar edge = make_vec3(0.5f, 0.5f, 0.5f);
 return mix(m, s, step(edge, Cs));
}
void SetSatInner(Float& Cmin, Float& Cmid, Float& Cmax, Float s, I32 _cond_mask_) {
 auto _c37_ = (Cmax)>(Cmin);
 auto _c38_ = (_cond_mask_)&(_c37_);
 {
  Cmid = if_then_else(_c38_,(((Cmid)-(Cmin))*(s))/((Cmax)-(Cmin)),Cmid);
  Cmax = if_then_else(_c38_,s,Cmax);
 }
 _c37_ = (_cond_mask_)&(~(_c37_));
 {
  Cmid = if_then_else(_c37_,0.f,Cmid);
  Cmax = if_then_else(_c37_,0.f,Cmax);
 }
 Cmin = if_then_else(_cond_mask_,0.f,Cmin);
}
vec3 SetSat(vec3 C, Float s) {
 auto _c26_ = ((C).x)<=((C).y);
 {
  auto _c27_ = ((C).y)<=((C).z);
  auto _c28_ = (_c26_)&(_c27_);
  {
   SetSatInner((C).x, (C).y, (C).z, s, _c28_);
  }
  _c27_ = (_c26_)&(~(_c27_));
  {
   auto _c29_ = ((C).x)<=((C).z);
   auto _c30_ = (_c27_)&(_c29_);
   {
    SetSatInner((C).x, (C).z, (C).y, s, _c30_);
   }
   _c29_ = (_c27_)&(~(_c29_));
   {
    SetSatInner((C).z, (C).x, (C).y, s, _c29_);
   }
  }
 }
 {
  auto _c31_ = ((C).x)<=((C).z);
  auto _c32_ = (~(_c26_))&(_c31_);
  {
   SetSatInner((C).y, (C).x, (C).z, s, _c32_);
  }
  _c31_ = (~(_c26_))&(~(_c31_));
  {
   auto _c33_ = ((C).y)<=((C).z);
   auto _c34_ = (_c31_)&(_c33_);
   {
    SetSatInner((C).y, (C).z, (C).x, s, _c34_);
   }
   _c33_ = (_c31_)&(~(_c33_));
   {
    SetSatInner((C).z, (C).y, (C).x, s, _c33_);
   }
  }
 }
 return C;
}
Float Sat(vec3 c) {
 return (max((c).x, max((c).y, (c).z)))-(min((c).x, min((c).y, (c).z)));
}
vec3 Hue(vec3 Cb, vec3 Cs) {
 return SetLum(SetSat(Cs, Sat(Cb)), Lum(Cb));
}
vec3 Luminosity(vec3 Cb, vec3 Cs) {
 return SetLum(Cb, Lum(Cs));
}
vec3 Saturation(vec3 Cb, vec3 Cs) {
 return SetLum(SetSat(Cb, Sat(Cs)), Lum(Cb));
}
Float SoftLight(Float Cb, Float Cs) {
 I32 ret_mask = ~0;
 Float ret;
 auto _c42_ = (Cs)<=(0.5f);
 {
  ret = (Cb)-((((1.f)-((2.f)*(Cs)))*(Cb))*((1.f)-(Cb)));
  ret_mask = ~I32(_c42_);
 }
 {
  Float D;
  auto _c43_ = (Cb)<=(0.25f);
  auto _c44_ = (~(_c42_))&(_c43_);
  D = if_then_else(_c44_,(((((16.f)*(Cb))-(12.f))*(Cb))+(4.f))*(Cb),D);
  _c43_ = (~(_c42_))&(~(_c43_));
  D = if_then_else(_c43_,sqrt(Cb),D);
  ret = if_then_else(ret_mask & I32(~(_c42_)), (Cb)+((((2.f)*(Cs))-(1.f))*((D)-(Cb))), ret);
  ret_mask &= ~I32(~(_c42_));
 }
 return ret;
}
vec4 fetch_from_gpu_cache_1_direct(ivec2 address) {
 return texelFetch(sGpuCache, address, 0);
}
vec2 rect_repeat(vec2 p, vec2_scalar p0, vec2_scalar p1) {
 vec2 r = (p)-(p0);
 vec2_scalar s = (p1)-(p0);
 vec2_scalar is = (1.f)/(max(s, make_vec2(0.000001f)));
 return (p0)+((s)*(fract((is)*(r))));
}
vec3 LinearToSrgb(vec3 color) {
 vec3 c1 = (color)*(12.92f);
 vec3 c2 = ((make_vec3(1.055f))*(pow(color, make_vec3((1.f)/(2.4f)))))-(make_vec3(0.055f));
 return mix(c2, c1, lessThanEqual(color, make_vec3(0.0031308f)));
}
ALWAYS_INLINE void main(void) {
 vec4 Rs = make_vec4(0.f, 0.f, 0.f, 0.f);
 vec4 Rb = make_vec4(0.f, 0.f, 0.f, 0.f);
 vec4 Ns = make_vec4(0.f, 0.f, 0.f, 0.f);
 vec4 Nb = make_vec4(0.f, 0.f, 0.f, 0.f);
 ivec4 k;
 if (((vFilterInputCountFilterKindVec).x)>(0)) {
  {
   Rs = sampleInUvRect(sColor0, vInput1Uv, vInput1UvRect);
   (Ns).lsel(R,G,B) = ((Rs).sel(R,G,B))*((1.f)/(max(0.000001f, (Rs).w)));
   (Ns).w = (Rs).w;
   if ((((vFilterInputCountFilterKindVec).y)&(1))!=(0)) {
    {
     (Ns).lsel(R,G,B) = SrgbToLinear((Ns).sel(R,G,B));
     (Rs).lsel(R,G,B) = ((Ns).sel(R,G,B))*((Rs).w);
    }
   }
  }
 }
 if (((vFilterInputCountFilterKindVec).x)>(1)) {
  {
   Rb = sampleInUvRect(sColor1, vInput2Uv, vInput2UvRect);
   (Nb).lsel(R,G,B) = ((Rb).sel(R,G,B))*((1.f)/(max(0.000001f, (Rb).w)));
   (Nb).w = (Rb).w;
   if ((((vFilterInputCountFilterKindVec).y)&(1))!=(0)) {
    {
     (Nb).lsel(R,G,B) = SrgbToLinear((Nb).sel(R,G,B));
     (Rb).lsel(R,G,B) = ((Nb).sel(R,G,B))*((Rb).w);
    }
   }
  }
 }
 vec4 result = make_vec4(1.f, 0.f, 0.f, 1.f);
 if ((((vFilterInputCountFilterKindVec).y)==(0))||(((vFilterInputCountFilterKindVec).y)==(1))) {
  {
   result = Rs;
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(2))||(((vFilterInputCountFilterKindVec).y)==(3))) {
  {
   result = (Rs)*((vFloat0).x);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(4))||(((vFilterInputCountFilterKindVec).y)==(5))) {
  {
   oFragColor = make_vec4(0.f, 0.f, 0.f, (Rs).w);
   return;
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(6))||(((vFilterInputCountFilterKindVec).y)==(7))) {
  {
   (result).lsel(R,G,B) = Color((Nb).sel(R,G,B), (Ns).sel(R,G,B));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(8))||(((vFilterInputCountFilterKindVec).y)==(9))) {
  {
   (result).lsel(R,G,B) = make_vec3(ColorBurn((Nb).x, (Ns).x), ColorBurn((Nb).y, (Ns).y), ColorBurn((Nb).z, (Ns).z));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(10))||(((vFilterInputCountFilterKindVec).y)==(11))) {
  {
   (result).lsel(R,G,B) = make_vec3(ColorDodge((Nb).x, (Ns).x), ColorDodge((Nb).y, (Ns).y), ColorDodge((Nb).z, (Ns).z));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(12))||(((vFilterInputCountFilterKindVec).y)==(13))) {
  {
   (result).lsel(R,G,B) = (((Rs).sel(R,G,B))+((Rb).sel(R,G,B)))-(max(((Rs).sel(R,G,B))*((Rb).w), ((Rb).sel(R,G,B))*((Rs).w)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(14))||(((vFilterInputCountFilterKindVec).y)==(15))) {
  {
   (result).lsel(R,G,B) = (((Rs).sel(R,G,B))+((Rb).sel(R,G,B)))-((2.f)*(min(((Rs).sel(R,G,B))*((Rb).w), ((Rb).sel(R,G,B))*((Rs).w))));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(16))||(((vFilterInputCountFilterKindVec).y)==(17))) {
  {
   (result).lsel(R,G,B) = (((Rs).sel(R,G,B))+((Rb).sel(R,G,B)))-((2.f)*(((Rs).sel(R,G,B))*((Rb).sel(R,G,B))));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(18))||(((vFilterInputCountFilterKindVec).y)==(19))) {
  {
   (result).lsel(R,G,B) = HardLight((Nb).sel(R,G,B), (Ns).sel(R,G,B));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(20))||(((vFilterInputCountFilterKindVec).y)==(21))) {
  {
   (result).lsel(R,G,B) = Hue((Nb).sel(R,G,B), (Ns).sel(R,G,B));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(22))||(((vFilterInputCountFilterKindVec).y)==(23))) {
  {
   (result).lsel(R,G,B) = (((Rs).sel(R,G,B))+((Rb).sel(R,G,B)))-(min(((Rs).sel(R,G,B))*((Rb).w), ((Rb).sel(R,G,B))*((Rs).w)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(24))||(((vFilterInputCountFilterKindVec).y)==(25))) {
  {
   (result).lsel(R,G,B) = Luminosity((Nb).sel(R,G,B), (Ns).sel(R,G,B));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(26))||(((vFilterInputCountFilterKindVec).y)==(27))) {
  {
   (result).lsel(R,G,B) = ((((Rs).sel(R,G,B))*((1.f)-((Rb).w)))+(((Rb).sel(R,G,B))*((1.f)-((Rs).w))))+(((Rs).sel(R,G,B))*((Rb).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(28))||(((vFilterInputCountFilterKindVec).y)==(29))) {
  {
   result = ((Rb)*((1.f)-((Rs).w)))+(Rs);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(30))||(((vFilterInputCountFilterKindVec).y)==(31))) {
  {
   (result).lsel(R,G,B) = HardLight((Ns).sel(R,G,B), (Nb).sel(R,G,B));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(32))||(((vFilterInputCountFilterKindVec).y)==(33))) {
  {
   (result).lsel(R,G,B) = Saturation((Nb).sel(R,G,B), (Ns).sel(R,G,B));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(34))||(((vFilterInputCountFilterKindVec).y)==(35))) {
  {
   (result).lsel(R,G,B) = (((Rs).sel(R,G,B))+((Rb).sel(R,G,B)))-(((Rs).sel(R,G,B))*((Rb).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(36))||(((vFilterInputCountFilterKindVec).y)==(37))) {
  {
   (result).lsel(R,G,B) = make_vec3(SoftLight((Nb).x, (Ns).x), SoftLight((Nb).y, (Ns).y), SoftLight((Nb).z, (Ns).z));
   (result).lsel(R,G,B) = ((((1.f)-((Rb).w))*((Rs).sel(R,G,B)))+(((1.f)-((Rs).w))*((Rb).sel(R,G,B))))+((((Rs).w)*((Rb).w))*((result).sel(R,G,B)));
   (result).w = (((Rb).w)*((1.f)-((Rs).w)))+((Rs).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(38))||(((vFilterInputCountFilterKindVec).y)==(39))) {
  {
   result = ((vColorMat)*(Ns))+(vFilterData0);
   result = clamp(result, make_vec4(0.f), make_vec4(1.f));
   (result).lsel(R,G,B) = ((result).sel(R,G,B))*((result).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(40))||(((vFilterInputCountFilterKindVec).y)==(41))) {
  {
   result = floor(clamp((Ns)*(255.f), make_vec4(0.f), make_vec4(255.f)));
   k = make_ivec4(make_int((result).x), make_int((result).y), make_int((result).z), make_int((result).w));
   (result).x = (fetch_from_gpu_cache_1_direct(((vData).sel(X,Y))+(make_ivec2((k).x, 0)))).x;
   (result).y = (fetch_from_gpu_cache_1_direct(((vData).sel(X,Y))+(make_ivec2((k).y, 0)))).y;
   (result).z = (fetch_from_gpu_cache_1_direct(((vData).sel(X,Y))+(make_ivec2((k).z, 0)))).z;
   (result).w = (fetch_from_gpu_cache_1_direct(((vData).sel(X,Y))+(make_ivec2((k).w, 0)))).w;
   (result).lsel(R,G,B) = ((result).sel(R,G,B))*((result).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(42))||(((vFilterInputCountFilterKindVec).y)==(43))) {
  {
   result = (((((Rs)*(Rb))*((vFilterData0).x))+((Rs)*((vFilterData0).y)))+((Rb)*((vFilterData0).z)))+(make_vec4((vFilterData0).w));
   result = clamp(result, make_vec4(0.f), make_vec4(1.f));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(44))||(((vFilterInputCountFilterKindVec).y)==(45))) {
  {
   result = ((Rs)*((Rb).w))+((Rb)*((1.f)-((Rs).w)));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(46))||(((vFilterInputCountFilterKindVec).y)==(47))) {
  {
   result = (Rs)*((Rb).w);
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(48))||(((vFilterInputCountFilterKindVec).y)==(49))) {
  {
   result = (Rs)+(Rb);
   result = clamp(result, make_vec4(0.f), make_vec4(1.f));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(50))||(((vFilterInputCountFilterKindVec).y)==(51))) {
  {
   result = (Rs)*((1.f)-((Rb).w));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(52))||(((vFilterInputCountFilterKindVec).y)==(53))) {
  {
   result = (Rs)+((Rb)*((1.f)-((Rs).w)));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(54))||(((vFilterInputCountFilterKindVec).y)==(55))) {
  {
   result = ((Rs)*((1.f)-((Rb).w)))+((Rb)*((1.f)-((Rs).w)));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(56))||(((vFilterInputCountFilterKindVec).y)==(57))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(58))||(((vFilterInputCountFilterKindVec).y)==(59))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(60))||(((vFilterInputCountFilterKindVec).y)==(61))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(62))||(((vFilterInputCountFilterKindVec).y)==(63))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(64))||(((vFilterInputCountFilterKindVec).y)==(65))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(66))||(((vFilterInputCountFilterKindVec).y)==(67))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(68))||(((vFilterInputCountFilterKindVec).y)==(69))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(70))||(((vFilterInputCountFilterKindVec).y)==(71))) {
  {
   result = (Rs)+((vFilterData0)*(((Rb).w)*((1.f)-((Rs).w))));
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(72))||(((vFilterInputCountFilterKindVec).y)==(73))) {
  {
   result = vFilterData0;
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(74))||(((vFilterInputCountFilterKindVec).y)==(75))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(76))||(((vFilterInputCountFilterKindVec).y)==(77))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(80))||(((vFilterInputCountFilterKindVec).y)==(81))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(82))||(((vFilterInputCountFilterKindVec).y)==(83))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(86))||(((vFilterInputCountFilterKindVec).y)==(87))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(88))||(((vFilterInputCountFilterKindVec).y)==(89))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(90))||(((vFilterInputCountFilterKindVec).y)==(91))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(92))||(((vFilterInputCountFilterKindVec).y)==(93))) {
  {
   vec2 tileUv = rect_repeat(vInput1Uv, (vInput1UvRect).sel(X,Y), (vInput1UvRect).sel(Z,W));
   oFragColor = sampleInUvRect(sColor0, tileUv, vInput1UvRect);
   return;
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(94))||(((vFilterInputCountFilterKindVec).y)==(95))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(96))||(((vFilterInputCountFilterKindVec).y)==(97))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(98))||(((vFilterInputCountFilterKindVec).y)==(99))) {
  {
  }
 } else  if ((((vFilterInputCountFilterKindVec).y)==(100))||(((vFilterInputCountFilterKindVec).y)==(101))) {
  {
  }
 }
 if ((((vFilterInputCountFilterKindVec).y)&(1))!=(0)) {
  {
   (result).lsel(R,G,B) = (LinearToSrgb(((result).sel(R,G,B))*((1.f)/(max(0.000001f, (result).w)))))*((result).w);
  }
 }
 oFragColor = result;
}
typedef cs_svg_filter_node_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 vInput1Uv;
vec2 vInput2Uv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vInput1Uv = init_interp(init->vInput1Uv, step->vInput1Uv);
  self->interp_step.vInput1Uv = step->vInput1Uv * 4.0f;
  self->vInput2Uv = init_interp(init->vInput2Uv, step->vInput2Uv);
  self->interp_step.vInput2Uv = step->vInput2Uv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vInput1Uv = init_interp(init->vInput1Uv, step->vInput1Uv);
  self->vInput1Uv = self->interp_perspective.vInput1Uv * w;
  self->interp_step.vInput1Uv = step->vInput1Uv * 4.0f;
  self->interp_perspective.vInput2Uv = init_interp(init->vInput2Uv, step->vInput2Uv);
  self->vInput2Uv = self->interp_perspective.vInput2Uv * w;
  self->interp_step.vInput2Uv = step->vInput2Uv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vInput1Uv += interp_step.vInput1Uv * chunks;
  vInput2Uv += interp_step.vInput2Uv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vInput1Uv += interp_step.vInput1Uv * chunks;
  vInput1Uv = w * interp_perspective.vInput1Uv;
  interp_perspective.vInput2Uv += interp_step.vInput2Uv * chunks;
  vInput2Uv = w * interp_perspective.vInput2Uv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
public:
cs_svg_filter_node_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_svg_filter_node_program : ProgramImpl, cs_svg_filter_node_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sClipMask", name) == 0) { return 7; }
 if (strcmp("sColor0", name) == 0) { return 8; }
 if (strcmp("sColor1", name) == 0) { return 9; }
 if (strcmp("sGpuCache", name) == 0) { return 2; }
 if (strcmp("sPrimitiveHeadersF", name) == 0) { return 4; }
 if (strcmp("sPrimitiveHeadersI", name) == 0) { return 5; }
 if (strcmp("sRenderTasks", name) == 0) { return 1; }
 if (strcmp("sTransformPalette", name) == 0) { return 3; }
 if (strcmp("uTransform", name) == 0) { return 6; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_svg_filter_node"; }
static ProgramImpl* loader() { return new cs_svg_filter_node_program; }
};

