/* FileItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileItem.vala, do not modify */

/*
 * FileItem.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
typedef struct _FileItemPrivate FileItemPrivate;
enum  {
	FILE_ITEM_0_PROPERTY,
	FILE_ITEM_SIZE_PROPERTY,
	FILE_ITEM_NUM_PROPERTIES
};
static GParamSpec* file_item_properties[FILE_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FileItem {
	GObject parent_instance;
	FileItemPrivate * priv;
	gchar* file_name;
	gchar* file_location;
	gchar* file_path;
	gchar* file_path_prefix;
	GFileType file_type;
	GDateTime* modified;
	gchar* permissions;
	gchar* owner_user;
	gchar* owner_group;
	gchar* content_type;
	gchar* file_status;
	gboolean is_selected;
	gboolean is_symlink;
	gchar* symlink_target;
	glong file_count;
	glong dir_count;
	GIcon* icon;
};

struct _FileItemClass {
	GObjectClass parent_class;
};

struct _FileItemPrivate {
	gint64 _size;
};

static gint FileItem_private_offset;
static gpointer file_item_parent_class = NULL;
static GeeComparableIface * file_item_gee_comparable_parent_iface = NULL;

VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN FileItem* file_item_new (const gchar* name);
VALA_EXTERN FileItem* file_item_construct (GType object_type,
                               const gchar* name);
VALA_EXTERN FileItem* file_item_new_from_disk_path_with_basic_info (const gchar* _file_path);
VALA_EXTERN FileItem* file_item_construct_from_disk_path_with_basic_info (GType object_type,
                                                              const gchar* _file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_basename (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN void file_item_query_file_info_basic (FileItem* self);
VALA_EXTERN FileItem* file_item_new_from_path_and_type (const gchar* _file_path,
                                            GFileType _file_type);
VALA_EXTERN FileItem* file_item_construct_from_path_and_type (GType object_type,
                                                  const gchar* _file_path,
                                                  GFileType _file_type);
static gint file_item_real_compare_to (GeeComparable* base,
                                FileItem* b);
VALA_EXTERN void file_item_query_file_info (FileItem* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN GdkPixbuf* file_item_get_icon (FileItem* self,
                               gint icon_size,
                               gboolean add_transparency,
                               gboolean add_emblems);
VALA_EXTERN GdkPixbuf* icon_manager_lookup_gicon (GIcon* gicon,
                                      gint icon_size);
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
VALA_EXTERN gint64 file_item_get_size (FileItem* self);
static void file_item_finalize (GObject * obj);
static GType file_item_get_type_once (void);
static void _vala_file_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
file_item_get_instance_private (FileItem* self)
{
	return G_STRUCT_MEMBER_P (self, FileItem_private_offset);
}

FileItem*
file_item_construct (GType object_type,
                     const gchar* name)
{
	FileItem * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (FileItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->file_name);
	self->file_name = _tmp0_;
	return self;
}

FileItem*
file_item_new (const gchar* name)
{
	return file_item_construct (TYPE_FILE_ITEM, name);
}

FileItem*
file_item_construct_from_disk_path_with_basic_info (GType object_type,
                                                    const gchar* _file_path)
{
	FileItem * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (_file_path != NULL, NULL);
	self = (FileItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (_file_path);
	_g_free0 (self->file_path);
	self->file_path = _tmp0_;
	_tmp1_ = tee_jee_file_system_file_basename (_file_path);
	_g_free0 (self->file_name);
	self->file_name = _tmp1_;
	_tmp2_ = tee_jee_file_system_file_parent (_file_path);
	_g_free0 (self->file_location);
	self->file_location = _tmp2_;
	file_item_query_file_info_basic (self);
	return self;
}

FileItem*
file_item_new_from_disk_path_with_basic_info (const gchar* _file_path)
{
	return file_item_construct_from_disk_path_with_basic_info (TYPE_FILE_ITEM, _file_path);
}

FileItem*
file_item_construct_from_path_and_type (GType object_type,
                                        const gchar* _file_path,
                                        GFileType _file_type)
{
	FileItem * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (_file_path != NULL, NULL);
	self = (FileItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (_file_path);
	_g_free0 (self->file_path);
	self->file_path = _tmp0_;
	_tmp1_ = tee_jee_file_system_file_basename (_file_path);
	_g_free0 (self->file_name);
	self->file_name = _tmp1_;
	_tmp2_ = tee_jee_file_system_file_parent (_file_path);
	_g_free0 (self->file_location);
	self->file_location = _tmp2_;
	self->file_type = _file_type;
	return self;
}

FileItem*
file_item_new_from_path_and_type (const gchar* _file_path,
                                  GFileType _file_type)
{
	return file_item_construct_from_path_and_type (TYPE_FILE_ITEM, _file_path, _file_type);
}

static gint
file_item_real_compare_to (GeeComparable* base,
                           FileItem* b)
{
	FileItem * self;
	gint result;
	self = (FileItem*) base;
	g_return_val_if_fail (b != NULL, 0);
	if (self->file_type != b->file_type) {
		if (self->file_type == G_FILE_TYPE_DIRECTORY) {
			result = -1;
			return result;
		} else {
			result = 1;
			return result;
		}
	} else {
		GCompareFunc _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gint _tmp7_;
		_tmp0_ = ((GCompareFunc) g_strcmp0);
		_tmp1_ = self->file_name;
		_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
		_tmp3_ = _tmp2_;
		_tmp4_ = b->file_name;
		_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
		result = _tmp7_;
		return result;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
file_item_query_file_info (FileItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileInfo* info = NULL;
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp0_ = self->file_path;
		_tmp1_ = g_file_parse_name (_tmp0_);
		file = _tmp1_;
		_tmp2_ = file;
		if (g_file_query_exists (_tmp2_, NULL)) {
			GFileInfo* _tmp3_ = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileType item_file_type = 0;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			GIcon* _tmp12_;
			GIcon* _tmp13_;
			GFileInfo* _tmp18_ = NULL;
			GFile* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			GFileInfo* _tmp22_;
			GFileInfo* _tmp23_;
			GFileInfo* _tmp24_;
			GFileInfo* _tmp28_;
			GFileInfo* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			GFileInfo* _tmp34_;
			GDateTime* _tmp35_;
			GDateTime* _tmp36_;
			GDateTime* _tmp37_;
			GFileInfo* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			GFileInfo* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp4_ = file;
			_tmp5_ = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_file_query_info (_tmp4_, _tmp6_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			_tmp3_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (info);
			info = _tmp9_;
			_tmp10_ = info;
			item_file_type = g_file_info_get_file_type (_tmp10_);
			_tmp11_ = info;
			_tmp12_ = g_file_info_get_icon (_tmp11_);
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (self->icon);
			self->icon = _tmp13_;
			if (item_file_type == G_FILE_TYPE_SYMBOLIC_LINK) {
				GFileInfo* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				self->is_symlink = TRUE;
				_tmp14_ = info;
				_tmp15_ = g_file_info_get_symlink_target (_tmp14_);
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (self->symlink_target);
				self->symlink_target = _tmp16_;
			} else {
				gchar* _tmp17_;
				self->is_symlink = FALSE;
				_tmp17_ = g_strdup ("");
				_g_free0 (self->symlink_target);
				self->symlink_target = _tmp17_;
				if (item_file_type == G_FILE_TYPE_REGULAR) {
				}
			}
			_tmp19_ = file;
			_tmp20_ = g_strdup_printf ("%s,%s,%s,%s,%s,%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_ATTRIBUTE_OWNER_USER, G_FILE_ATTRIBUTE_OWNER_GROUP, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_file_query_info (_tmp19_, _tmp21_, 0, NULL, &_inner_error0_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			_tmp18_ = _tmp23_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			_tmp24_ = _tmp18_;
			_tmp18_ = NULL;
			_g_object_unref0 (info);
			info = _tmp24_;
			if (self->is_symlink) {
				GFileInfo* _tmp25_;
				GIcon* _tmp26_;
				GIcon* _tmp27_;
				_tmp25_ = info;
				_tmp26_ = g_file_info_get_icon (_tmp25_);
				_tmp27_ = _g_object_ref0 (_tmp26_);
				_g_object_unref0 (self->icon);
				self->icon = _tmp27_;
			}
			_tmp28_ = info;
			self->file_type = g_file_info_get_file_type (_tmp28_);
			_tmp29_ = info;
			_tmp30_ = g_file_info_get_content_type (_tmp29_);
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (self->content_type);
			self->content_type = _tmp31_;
			if (!self->is_symlink) {
				_tmp32_ = self->file_type == G_FILE_TYPE_REGULAR;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				GFileInfo* _tmp33_;
				_tmp33_ = info;
				self->priv->_size = g_file_info_get_size (_tmp33_);
			}
			_tmp34_ = info;
			_tmp35_ = g_file_info_get_modification_date_time (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_date_time_to_local (_tmp36_);
			_g_date_time_unref0 (self->modified);
			self->modified = _tmp37_;
			_g_date_time_unref0 (_tmp36_);
			_tmp38_ = info;
			_tmp39_ = g_file_info_get_attribute_string (_tmp38_, G_FILE_ATTRIBUTE_OWNER_USER);
			_tmp40_ = g_strdup (_tmp39_);
			_g_free0 (self->owner_user);
			self->owner_user = _tmp40_;
			_tmp41_ = info;
			_tmp42_ = g_file_info_get_attribute_string (_tmp41_, G_FILE_ATTRIBUTE_OWNER_GROUP);
			_tmp43_ = g_strdup (_tmp42_);
			_g_free0 (self->owner_group);
			self->owner_group = _tmp43_;
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (_tmp3_);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		tee_jee_logging_log_error (_tmp45_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
file_item_query_file_info_basic (FileItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileInfo* info = NULL;
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp0_ = self->file_path;
		_tmp1_ = g_file_parse_name (_tmp0_);
		file = _tmp1_;
		_tmp2_ = file;
		if (g_file_query_exists (_tmp2_, NULL)) {
			GFileInfo* _tmp3_ = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GIcon* _tmp11_;
			GIcon* _tmp12_;
			GFileInfo* _tmp13_;
			_tmp4_ = file;
			_tmp5_ = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_ICON);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_file_query_info (_tmp4_, _tmp6_, 0, NULL, &_inner_error0_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			_tmp3_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (info);
			info = _tmp9_;
			_tmp10_ = info;
			_tmp11_ = g_file_info_get_icon (_tmp10_);
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (self->icon);
			self->icon = _tmp12_;
			_tmp13_ = info;
			self->file_type = g_file_info_get_file_type (_tmp13_);
			_g_object_unref0 (_tmp3_);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		tee_jee_logging_log_error (_tmp15_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GdkPixbuf*
file_item_get_icon (FileItem* self,
                    gint icon_size,
                    gboolean add_transparency,
                    gboolean add_emblems)
{
	GdkPixbuf* pixbuf = NULL;
	GIcon* _tmp0_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	pixbuf = NULL;
	_tmp0_ = self->icon;
	if (_tmp0_ != NULL) {
		GIcon* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = self->icon;
		_tmp2_ = icon_manager_lookup_gicon (_tmp1_, icon_size);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp2_;
	}
	_tmp3_ = pixbuf;
	if (_tmp3_ == NULL) {
		if (self->file_type == G_FILE_TYPE_DIRECTORY) {
			GdkPixbuf* _tmp4_;
			_tmp4_ = icon_manager_lookup ("folder", icon_size, FALSE, FALSE, 1);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp4_;
		} else {
			GdkPixbuf* _tmp5_;
			_tmp5_ = icon_manager_lookup ("text-x-preview", icon_size, FALSE, FALSE, 1);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp5_;
		}
	}
	result = pixbuf;
	return result;
}

gint64
file_item_get_size (FileItem* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_size;
	return result;
}

static void
file_item_class_init (FileItemClass * klass,
                      gpointer klass_data)
{
	file_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_item_get_property;
	G_OBJECT_CLASS (klass)->finalize = file_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_ITEM_SIZE_PROPERTY, file_item_properties[FILE_ITEM_SIZE_PROPERTY] = g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
file_item_gee_comparable_interface_init (GeeComparableIface * iface,
                                         gpointer iface_data)
{
	file_item_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) file_item_real_compare_to;
}

static void
file_item_instance_init (FileItem * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self->priv = file_item_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->file_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->file_location = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->file_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->file_path_prefix = _tmp3_;
	self->file_type = G_FILE_TYPE_REGULAR;
	_tmp4_ = g_strdup ("");
	self->permissions = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->owner_user = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->owner_group = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->content_type = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->file_status = _tmp8_;
	self->is_selected = FALSE;
	self->is_symlink = FALSE;
	_tmp9_ = g_strdup ("");
	self->symlink_target = _tmp9_;
	self->file_count = (glong) 0;
	self->dir_count = (glong) 0;
	self->priv->_size = (gint64) 0;
}

static void
file_item_finalize (GObject * obj)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_ITEM, FileItem);
	_g_free0 (self->file_name);
	_g_free0 (self->file_location);
	_g_free0 (self->file_path);
	_g_free0 (self->file_path_prefix);
	_g_date_time_unref0 (self->modified);
	_g_free0 (self->permissions);
	_g_free0 (self->owner_user);
	_g_free0 (self->owner_group);
	_g_free0 (self->content_type);
	_g_free0 (self->file_status);
	_g_free0 (self->symlink_target);
	_g_object_unref0 (self->icon);
	G_OBJECT_CLASS (file_item_parent_class)->finalize (obj);
}

static GType
file_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileItem), 0, (GInstanceInitFunc) file_item_instance_init, NULL };
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) file_item_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType file_item_type_id;
	file_item_type_id = g_type_register_static (G_TYPE_OBJECT, "FileItem", &g_define_type_info, 0);
	g_type_add_interface_static (file_item_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	FileItem_private_offset = g_type_add_instance_private (file_item_type_id, sizeof (FileItemPrivate));
	return file_item_type_id;
}

GType
file_item_get_type (void)
{
	static volatile gsize file_item_type_id__once = 0;
	if (g_once_init_enter (&file_item_type_id__once)) {
		GType file_item_type_id;
		file_item_type_id = file_item_get_type_once ();
		g_once_init_leave (&file_item_type_id__once, file_item_type_id);
	}
	return file_item_type_id__once;
}

static void
_vala_file_item_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_ITEM, FileItem);
	switch (property_id) {
		case FILE_ITEM_SIZE_PROPERTY:
		g_value_set_int64 (value, file_item_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

