// python wrapper for ttkMorphologicalOperators
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMorphologicalOperators.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMorphologicalOperators(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMorphologicalOperators_ClassNew(); }


static PyObject *
PyttkMorphologicalOperators_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMorphologicalOperators::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMorphologicalOperators::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMorphologicalOperators *tempr = ttkMorphologicalOperators::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMorphologicalOperators *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMorphologicalOperators::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMorphologicalOperators::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMorphologicalOperators::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_SetMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMode(temp0);
    }
    else
    {
      op->ttkMorphologicalOperators::SetMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_GetMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMode() :
      op->ttkMorphologicalOperators::GetMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_SetPivotLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPivotLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPivotLabel(temp0);
    }
    else
    {
      op->ttkMorphologicalOperators::SetPivotLabel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_GetPivotLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPivotLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetPivotLabel() :
      op->ttkMorphologicalOperators::GetPivotLabel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_SetIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIterations(temp0);
    }
    else
    {
      op->ttkMorphologicalOperators::SetIterations(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_GetIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIterations() :
      op->ttkMorphologicalOperators::GetIterations());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_SetGrayscale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGrayscale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGrayscale(temp0);
    }
    else
    {
      op->ttkMorphologicalOperators::SetGrayscale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorphologicalOperators_GetGrayscale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGrayscale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorphologicalOperators *op = static_cast<ttkMorphologicalOperators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGrayscale() :
      op->ttkMorphologicalOperators::GetGrayscale());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMorphologicalOperators_Methods[] = {
  {"IsTypeOf", PyttkMorphologicalOperators_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMorphologicalOperators_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMorphologicalOperators_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMorphologicalOperators\nC++: static ttkMorphologicalOperators *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMorphologicalOperators_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMorphologicalOperators\nC++: ttkMorphologicalOperators *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMorphologicalOperators_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMorphologicalOperators_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetMode", PyttkMorphologicalOperators_SetMode, METH_VARARGS,
   "SetMode(self, _arg:int) -> None\nC++: virtual void SetMode(int _arg)\n\n"},
  {"GetMode", PyttkMorphologicalOperators_GetMode, METH_VARARGS,
   "GetMode(self) -> int\nC++: virtual int GetMode()\n\n"},
  {"SetPivotLabel", PyttkMorphologicalOperators_SetPivotLabel, METH_VARARGS,
   "SetPivotLabel(self, _arg:str) -> None\nC++: virtual void SetPivotLabel(const std::string &_arg)\n\n"},
  {"GetPivotLabel", PyttkMorphologicalOperators_GetPivotLabel, METH_VARARGS,
   "GetPivotLabel(self) -> str\nC++: virtual std::string GetPivotLabel()\n\n"},
  {"SetIterations", PyttkMorphologicalOperators_SetIterations, METH_VARARGS,
   "SetIterations(self, _arg:int) -> None\nC++: virtual void SetIterations(int _arg)\n\n"},
  {"GetIterations", PyttkMorphologicalOperators_GetIterations, METH_VARARGS,
   "GetIterations(self) -> int\nC++: virtual int GetIterations()\n\n"},
  {"SetGrayscale", PyttkMorphologicalOperators_SetGrayscale, METH_VARARGS,
   "SetGrayscale(self, _arg:bool) -> None\nC++: virtual void SetGrayscale(bool _arg)\n\n"},
  {"GetGrayscale", PyttkMorphologicalOperators_GetGrayscale, METH_VARARGS,
   "GetGrayscale(self) -> bool\nC++: virtual bool GetGrayscale()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMorphologicalOperators_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorphologicalOperators_GetMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorphologicalOperators_SetMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorphologicalOperators_SetMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMode/SetMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pivot_label"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorphologicalOperators_GetPivotLabel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorphologicalOperators_SetPivotLabel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorphologicalOperators_SetPivotLabel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPivotLabel/SetPivotLabel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("iterations"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorphologicalOperators_GetIterations(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorphologicalOperators_SetIterations(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorphologicalOperators_SetIterations(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIterations/SetIterations\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grayscale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorphologicalOperators_GetGrayscale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorphologicalOperators_SetGrayscale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorphologicalOperators_SetGrayscale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGrayscale/SetGrayscale\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMorphologicalOperators_Doc =
  "ttkMorphologicalOperators - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk (jl@jluk.de)\\date 01.02.2019\n\n"
  "TTK VTK-filter that dilates or erodes a specified vertex label.\n\n"
  "VTK wrapping code for the ttk::MorphologicalOperators package.\n\n"
  "This filter either a) dilates a specified label by assigning the\n"
  "label of a corresponding vertex to all its neighbors, or b) erodes a\n"
  "specified label by assigning to a corresponding vertex the largest\n"
  "label among its neighbors.\n\n"
  "The input data array that will be dilated or eroded needs to be\n"
  "specified via the standard VTK call SetInputArrayToProcess() with the\n"
  "following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the VTK array)\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMorphologicalOperators_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMorphologicalOperators.ttkMorphologicalOperators", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMorphologicalOperators_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMorphologicalOperators_StaticNew()
{
  return ttkMorphologicalOperators::New();
}

PyObject *PyttkMorphologicalOperators_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMorphologicalOperators_Type, PyttkMorphologicalOperators_Methods,
    "ttkMorphologicalOperators",
 &PyttkMorphologicalOperators_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMorphologicalOperators_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMorphologicalOperators(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMorphologicalOperators_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMorphologicalOperators", o) != 0)
  {
    Py_DECREF(o);
  }

}

