// python wrapper for ttkPersistenceDiagramDistanceMatrix
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkPersistenceDiagramDistanceMatrix.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkPersistenceDiagramDistanceMatrix(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkPersistenceDiagramDistanceMatrix_ClassNew(); }


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkPersistenceDiagramDistanceMatrix::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkPersistenceDiagramDistanceMatrix::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkPersistenceDiagramDistanceMatrix *tempr = ttkPersistenceDiagramDistanceMatrix::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkPersistenceDiagramDistanceMatrix *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkPersistenceDiagramDistanceMatrix::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkPersistenceDiagramDistanceMatrix::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkPersistenceDiagramDistanceMatrix::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetWassersteinMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWassersteinMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWassersteinMetric(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetWassersteinMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetWassersteinMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWassersteinMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetWassersteinMetric() :
      op->ttkPersistenceDiagramDistanceMatrix::GetWassersteinMetric());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetAntiAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAntiAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAntiAlpha(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetAntiAlpha(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAlpha() :
      op->ttkPersistenceDiagramDistanceMatrix::GetAlpha());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetDeltaLim(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaLim");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaLim(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetDeltaLim(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetDeltaLim(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeltaLim");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDeltaLim() :
      op->ttkPersistenceDiagramDistanceMatrix::GetDeltaLim());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetLambda(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLambda");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLambda(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetLambda(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetLambda(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLambda");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLambda() :
      op->ttkPersistenceDiagramDistanceMatrix::GetLambda());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetPairType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPairType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPairType(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetPairType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetPairType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPairType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPairType() :
      op->ttkPersistenceDiagramDistanceMatrix::GetPairType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetConstraint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConstraint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConstraint(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetConstraint(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetConstraint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConstraint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetConstraint() :
      op->ttkPersistenceDiagramDistanceMatrix::GetConstraint());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetMaxNumberOfPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxNumberOfPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxNumberOfPairs(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetMaxNumberOfPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetMaxNumberOfPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxNumberOfPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetMaxNumberOfPairs() :
      op->ttkPersistenceDiagramDistanceMatrix::GetMaxNumberOfPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_SetMinPersistence(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinPersistence");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinPersistence(temp0);
    }
    else
    {
      op->ttkPersistenceDiagramDistanceMatrix::SetMinPersistence(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagramDistanceMatrix_GetMinPersistence(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinPersistence");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagramDistanceMatrix *op = static_cast<ttkPersistenceDiagramDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMinPersistence() :
      op->ttkPersistenceDiagramDistanceMatrix::GetMinPersistence());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkPersistenceDiagramDistanceMatrix_Methods[] = {
  {"IsTypeOf", PyttkPersistenceDiagramDistanceMatrix_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkPersistenceDiagramDistanceMatrix_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkPersistenceDiagramDistanceMatrix_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> ttkPersistenceDiagramDistanceMatrix\nC++: static ttkPersistenceDiagramDistanceMatrix *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkPersistenceDiagramDistanceMatrix_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkPersistenceDiagramDistanceMatrix\nC++: ttkPersistenceDiagramDistanceMatrix *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkPersistenceDiagramDistanceMatrix_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkPersistenceDiagramDistanceMatrix_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWassersteinMetric", PyttkPersistenceDiagramDistanceMatrix_SetWassersteinMetric, METH_VARARGS,
   "SetWassersteinMetric(self, data:str) -> None\nC++: void SetWassersteinMetric(const std::string &data)\n\n"},
  {"GetWassersteinMetric", PyttkPersistenceDiagramDistanceMatrix_GetWassersteinMetric, METH_VARARGS,
   "GetWassersteinMetric(self) -> str\nC++: std::string GetWassersteinMetric()\n\n"},
  {"SetAntiAlpha", PyttkPersistenceDiagramDistanceMatrix_SetAntiAlpha, METH_VARARGS,
   "SetAntiAlpha(self, data:float) -> None\nC++: void SetAntiAlpha(double data)\n\n"},
  {"GetAlpha", PyttkPersistenceDiagramDistanceMatrix_GetAlpha, METH_VARARGS,
   "GetAlpha(self) -> float\nC++: virtual double GetAlpha()\n\n"},
  {"SetDeltaLim", PyttkPersistenceDiagramDistanceMatrix_SetDeltaLim, METH_VARARGS,
   "SetDeltaLim(self, _arg:float) -> None\nC++: virtual void SetDeltaLim(double _arg)\n\n"},
  {"GetDeltaLim", PyttkPersistenceDiagramDistanceMatrix_GetDeltaLim, METH_VARARGS,
   "GetDeltaLim(self) -> float\nC++: virtual double GetDeltaLim()\n\n"},
  {"SetLambda", PyttkPersistenceDiagramDistanceMatrix_SetLambda, METH_VARARGS,
   "SetLambda(self, _arg:float) -> None\nC++: virtual void SetLambda(double _arg)\n\n"},
  {"GetLambda", PyttkPersistenceDiagramDistanceMatrix_GetLambda, METH_VARARGS,
   "GetLambda(self) -> float\nC++: virtual double GetLambda()\n\n"},
  {"SetPairType", PyttkPersistenceDiagramDistanceMatrix_SetPairType, METH_VARARGS,
   "SetPairType(self, data:int) -> None\nC++: void SetPairType(const int data)\n\n"},
  {"GetPairType", PyttkPersistenceDiagramDistanceMatrix_GetPairType, METH_VARARGS,
   "GetPairType(self) -> int\nC++: int GetPairType()\n\n"},
  {"SetConstraint", PyttkPersistenceDiagramDistanceMatrix_SetConstraint, METH_VARARGS,
   "SetConstraint(self, arg_:int) -> None\nC++: void SetConstraint(const int arg_)\n\n"},
  {"GetConstraint", PyttkPersistenceDiagramDistanceMatrix_GetConstraint, METH_VARARGS,
   "GetConstraint(self) -> int\nC++: int GetConstraint()\n\n"},
  {"SetMaxNumberOfPairs", PyttkPersistenceDiagramDistanceMatrix_SetMaxNumberOfPairs, METH_VARARGS,
   "SetMaxNumberOfPairs(self, _arg:int) -> None\nC++: virtual void SetMaxNumberOfPairs(unsigned int _arg)\n\n"},
  {"GetMaxNumberOfPairs", PyttkPersistenceDiagramDistanceMatrix_GetMaxNumberOfPairs, METH_VARARGS,
   "GetMaxNumberOfPairs(self) -> int\nC++: virtual unsigned int GetMaxNumberOfPairs()\n\n"},
  {"SetMinPersistence", PyttkPersistenceDiagramDistanceMatrix_SetMinPersistence, METH_VARARGS,
   "SetMinPersistence(self, _arg:float) -> None\nC++: virtual void SetMinPersistence(double _arg)\n\n"},
  {"GetMinPersistence", PyttkPersistenceDiagramDistanceMatrix_GetMinPersistence, METH_VARARGS,
   "GetMinPersistence(self) -> float\nC++: virtual double GetMinPersistence()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkPersistenceDiagramDistanceMatrix_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("wasserstein_metric"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetWassersteinMetric(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetWassersteinMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetWassersteinMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWassersteinMetric/SetWassersteinMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anti_alpha"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetAntiAlpha(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetAntiAlpha(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAntiAlpha\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_lim"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetDeltaLim(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetDeltaLim(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetDeltaLim(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeltaLim/SetDeltaLim\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lambda"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetLambda(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetLambda(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetLambda(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLambda/SetLambda\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pair_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetPairType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetPairType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetPairType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPairType/SetPairType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("constraint"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetConstraint(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetConstraint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetConstraint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConstraint/SetConstraint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_number_of_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetMaxNumberOfPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetMaxNumberOfPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetMaxNumberOfPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxNumberOfPairs/SetMaxNumberOfPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_persistence"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetMinPersistence(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetMinPersistence(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagramDistanceMatrix_SetMinPersistence(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinPersistence/SetMinPersistence\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("alpha"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagramDistanceMatrix_GetAlpha(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAlpha\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkPersistenceDiagramDistanceMatrix_Doc =
  "ttkPersistenceDiagramDistanceMatrix - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jules Vidal <jules.vidal@lip6.fr>\\author Pierre Guillou\n"
  "<pierre.guillou@lip6.fr>\\date March 2020\n\n"
  "TTK processing package for the computation of a matrix of Wasserstein\n"
  "distances between persistence diagrams.\n\n"
  "Related publication\n\n"
  "\"Progressive Wasserstein Barycenters of Persistence Diagrams\"\n\n"
  "Jules Vidal, Joseph Budin and Julien Tierny\n\n"
  "Proc. of IEEE VIS 2019.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2019.\n\n"
  "\\sa PersistenceDiagramDistanceMatrix\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/clusteringKelvinHelmholtzInstabilities/\"\n"
  "  > Clustering Kelvin Helmholtz Instabilities example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkPersistenceDiagramDistanceMatrix_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkPersistenceDiagramDistanceMatrix.ttkPersistenceDiagramDistanceMatrix", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkPersistenceDiagramDistanceMatrix_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkPersistenceDiagramDistanceMatrix_StaticNew()
{
  return ttkPersistenceDiagramDistanceMatrix::New();
}

PyObject *PyttkPersistenceDiagramDistanceMatrix_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkPersistenceDiagramDistanceMatrix_Type, PyttkPersistenceDiagramDistanceMatrix_Methods,
    "ttkPersistenceDiagramDistanceMatrix",
 &PyttkPersistenceDiagramDistanceMatrix_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkPersistenceDiagramDistanceMatrix_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkPersistenceDiagramDistanceMatrix(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkPersistenceDiagramDistanceMatrix_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkPersistenceDiagramDistanceMatrix", o) != 0)
  {
    Py_DECREF(o);
  }

}

