// python wrapper for ttkReebSpace
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkReebSpace.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkReebSpace(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkReebSpace_ClassNew(); }


static PyObject *
PyttkReebSpace_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkReebSpace::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkReebSpace::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkReebSpace *tempr = ttkReebSpace::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkReebSpace *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkReebSpace::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkReebSpace::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkReebSpace::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkReebSpace::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkReebSpace::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetUseOctreeAcceleration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseOctreeAcceleration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseOctreeAcceleration() :
      op->ttkReebSpace::GetUseOctreeAcceleration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetUseOctreeAcceleration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOctreeAcceleration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOctreeAcceleration(temp0);
    }
    else
    {
      op->ttkReebSpace::SetUseOctreeAcceleration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetZeroSheetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZeroSheetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZeroSheetId() :
      op->ttkReebSpace::GetZeroSheetId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetZeroSheetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZeroSheetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZeroSheetId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetZeroSheetId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetZeroSheetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZeroSheetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZeroSheetType() :
      op->ttkReebSpace::GetZeroSheetType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetZeroSheetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZeroSheetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZeroSheetType(temp0);
    }
    else
    {
      op->ttkReebSpace::SetZeroSheetType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetZeroSheetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZeroSheetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZeroSheetValue() :
      op->ttkReebSpace::GetZeroSheetValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetZeroSheetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZeroSheetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZeroSheetValue(temp0);
    }
    else
    {
      op->ttkReebSpace::SetZeroSheetValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetZeroSheetVertexId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZeroSheetVertexId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZeroSheetVertexId() :
      op->ttkReebSpace::GetZeroSheetVertexId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetZeroSheetVertexId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZeroSheetVertexId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZeroSheetVertexId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetZeroSheetVertexId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetOneSheetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOneSheetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOneSheetId() :
      op->ttkReebSpace::GetOneSheetId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetOneSheetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOneSheetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOneSheetId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetOneSheetId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetOneSheetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOneSheetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOneSheetType() :
      op->ttkReebSpace::GetOneSheetType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetOneSheetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOneSheetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOneSheetType(temp0);
    }
    else
    {
      op->ttkReebSpace::SetOneSheetType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetOneSheetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOneSheetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOneSheetValue() :
      op->ttkReebSpace::GetOneSheetValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetOneSheetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOneSheetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOneSheetValue(temp0);
    }
    else
    {
      op->ttkReebSpace::SetOneSheetValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetOneSheetVertexId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOneSheetVertexId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOneSheetVertexId() :
      op->ttkReebSpace::GetOneSheetVertexId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetOneSheetVertexId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOneSheetVertexId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOneSheetVertexId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetOneSheetVertexId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetOneSheetEdgeId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOneSheetEdgeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOneSheetEdgeId() :
      op->ttkReebSpace::GetOneSheetEdgeId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetOneSheetEdgeId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOneSheetEdgeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOneSheetEdgeId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetOneSheetEdgeId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheets() :
      op->ttkReebSpace::GetTwoSheets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheets(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheets(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetCaseId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetCaseId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetCaseId() :
      op->ttkReebSpace::GetTwoSheetCaseId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetCaseId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetCaseId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetCaseId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetCaseId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetValue() :
      op->ttkReebSpace::GetTwoSheetValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetValue(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetParameterization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetParameterization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetParameterization() :
      op->ttkReebSpace::GetTwoSheetParameterization());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetParameterization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetParameterization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetParameterization(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetParameterization(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetId() :
      op->ttkReebSpace::GetTwoSheetId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetEdgeId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetEdgeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetEdgeId() :
      op->ttkReebSpace::GetTwoSheetEdgeId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetEdgeId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetEdgeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetEdgeId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetEdgeId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetTetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetTetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetTetId() :
      op->ttkReebSpace::GetTwoSheetTetId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetTetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetTetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetTetId(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetTetId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetTwoSheetEdgeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSheetEdgeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSheetEdgeType() :
      op->ttkReebSpace::GetTwoSheetEdgeType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetTwoSheetEdgeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSheetEdgeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSheetEdgeType(temp0);
    }
    else
    {
      op->ttkReebSpace::SetTwoSheetEdgeType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetThreeSheetTetNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreeSheetTetNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThreeSheetTetNumber() :
      op->ttkReebSpace::GetThreeSheetTetNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetThreeSheetTetNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreeSheetTetNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreeSheetTetNumber(temp0);
    }
    else
    {
      op->ttkReebSpace::SetThreeSheetTetNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetThreeSheetVertexNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreeSheetVertexNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThreeSheetVertexNumber() :
      op->ttkReebSpace::GetThreeSheetVertexNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetThreeSheetVertexNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreeSheetVertexNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreeSheetVertexNumber(temp0);
    }
    else
    {
      op->ttkReebSpace::SetThreeSheetVertexNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetThreeSheetExpansion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreeSheetExpansion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThreeSheetExpansion() :
      op->ttkReebSpace::GetThreeSheetExpansion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetThreeSheetExpansion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreeSheetExpansion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreeSheetExpansion(temp0);
    }
    else
    {
      op->ttkReebSpace::SetThreeSheetExpansion(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetThreeSheetDomainVolume(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreeSheetDomainVolume");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThreeSheetDomainVolume() :
      op->ttkReebSpace::GetThreeSheetDomainVolume());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetThreeSheetDomainVolume(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreeSheetDomainVolume");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreeSheetDomainVolume(temp0);
    }
    else
    {
      op->ttkReebSpace::SetThreeSheetDomainVolume(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetThreeSheetRangeArea(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreeSheetRangeArea");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThreeSheetRangeArea() :
      op->ttkReebSpace::GetThreeSheetRangeArea());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetThreeSheetRangeArea(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreeSheetRangeArea");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreeSheetRangeArea(temp0);
    }
    else
    {
      op->ttkReebSpace::SetThreeSheetRangeArea(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetThreeSheetHyperVolume(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreeSheetHyperVolume");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThreeSheetHyperVolume() :
      op->ttkReebSpace::GetThreeSheetHyperVolume());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetThreeSheetHyperVolume(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreeSheetHyperVolume");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreeSheetHyperVolume(temp0);
    }
    else
    {
      op->ttkReebSpace::SetThreeSheetHyperVolume(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetSimplificationThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSimplificationThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSimplificationThreshold() :
      op->ttkReebSpace::GetSimplificationThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetSimplificationThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplificationThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplificationThreshold(temp0);
    }
    else
    {
      op->ttkReebSpace::SetSimplificationThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_GetSimplificationCriterion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSimplificationCriterion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSimplificationCriterion() :
      op->ttkReebSpace::GetSimplificationCriterion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebSpace_SetSimplificationCriterion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplificationCriterion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebSpace *op = static_cast<ttkReebSpace *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplificationCriterion(temp0);
    }
    else
    {
      op->ttkReebSpace::SetSimplificationCriterion(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkReebSpace_Methods[] = {
  {"IsTypeOf", PyttkReebSpace_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkReebSpace_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkReebSpace_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkReebSpace\nC++: static ttkReebSpace *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkReebSpace_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkReebSpace\nC++: ttkReebSpace *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkReebSpace_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkReebSpace_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetForceInputOffsetScalarField", PyttkReebSpace_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkReebSpace_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetUseOctreeAcceleration", PyttkReebSpace_GetUseOctreeAcceleration, METH_VARARGS,
   "GetUseOctreeAcceleration(self) -> bool\nC++: virtual bool GetUseOctreeAcceleration()\n\n"},
  {"SetUseOctreeAcceleration", PyttkReebSpace_SetUseOctreeAcceleration, METH_VARARGS,
   "SetUseOctreeAcceleration(self, _arg:bool) -> None\nC++: virtual void SetUseOctreeAcceleration(bool _arg)\n\n"},
  {"GetZeroSheetId", PyttkReebSpace_GetZeroSheetId, METH_VARARGS,
   "GetZeroSheetId(self) -> bool\nC++: virtual bool GetZeroSheetId()\n\n"},
  {"SetZeroSheetId", PyttkReebSpace_SetZeroSheetId, METH_VARARGS,
   "SetZeroSheetId(self, _arg:bool) -> None\nC++: virtual void SetZeroSheetId(bool _arg)\n\n"},
  {"GetZeroSheetType", PyttkReebSpace_GetZeroSheetType, METH_VARARGS,
   "GetZeroSheetType(self) -> bool\nC++: virtual bool GetZeroSheetType()\n\n"},
  {"SetZeroSheetType", PyttkReebSpace_SetZeroSheetType, METH_VARARGS,
   "SetZeroSheetType(self, _arg:bool) -> None\nC++: virtual void SetZeroSheetType(bool _arg)\n\n"},
  {"GetZeroSheetValue", PyttkReebSpace_GetZeroSheetValue, METH_VARARGS,
   "GetZeroSheetValue(self) -> bool\nC++: virtual bool GetZeroSheetValue()\n\n"},
  {"SetZeroSheetValue", PyttkReebSpace_SetZeroSheetValue, METH_VARARGS,
   "SetZeroSheetValue(self, _arg:bool) -> None\nC++: virtual void SetZeroSheetValue(bool _arg)\n\n"},
  {"GetZeroSheetVertexId", PyttkReebSpace_GetZeroSheetVertexId, METH_VARARGS,
   "GetZeroSheetVertexId(self) -> bool\nC++: virtual bool GetZeroSheetVertexId()\n\n"},
  {"SetZeroSheetVertexId", PyttkReebSpace_SetZeroSheetVertexId, METH_VARARGS,
   "SetZeroSheetVertexId(self, _arg:bool) -> None\nC++: virtual void SetZeroSheetVertexId(bool _arg)\n\n"},
  {"GetOneSheetId", PyttkReebSpace_GetOneSheetId, METH_VARARGS,
   "GetOneSheetId(self) -> bool\nC++: virtual bool GetOneSheetId()\n\n"},
  {"SetOneSheetId", PyttkReebSpace_SetOneSheetId, METH_VARARGS,
   "SetOneSheetId(self, _arg:bool) -> None\nC++: virtual void SetOneSheetId(bool _arg)\n\n"},
  {"GetOneSheetType", PyttkReebSpace_GetOneSheetType, METH_VARARGS,
   "GetOneSheetType(self) -> bool\nC++: virtual bool GetOneSheetType()\n\n"},
  {"SetOneSheetType", PyttkReebSpace_SetOneSheetType, METH_VARARGS,
   "SetOneSheetType(self, _arg:bool) -> None\nC++: virtual void SetOneSheetType(bool _arg)\n\n"},
  {"GetOneSheetValue", PyttkReebSpace_GetOneSheetValue, METH_VARARGS,
   "GetOneSheetValue(self) -> bool\nC++: virtual bool GetOneSheetValue()\n\n"},
  {"SetOneSheetValue", PyttkReebSpace_SetOneSheetValue, METH_VARARGS,
   "SetOneSheetValue(self, _arg:bool) -> None\nC++: virtual void SetOneSheetValue(bool _arg)\n\n"},
  {"GetOneSheetVertexId", PyttkReebSpace_GetOneSheetVertexId, METH_VARARGS,
   "GetOneSheetVertexId(self) -> bool\nC++: virtual bool GetOneSheetVertexId()\n\n"},
  {"SetOneSheetVertexId", PyttkReebSpace_SetOneSheetVertexId, METH_VARARGS,
   "SetOneSheetVertexId(self, _arg:bool) -> None\nC++: virtual void SetOneSheetVertexId(bool _arg)\n\n"},
  {"GetOneSheetEdgeId", PyttkReebSpace_GetOneSheetEdgeId, METH_VARARGS,
   "GetOneSheetEdgeId(self) -> bool\nC++: virtual bool GetOneSheetEdgeId()\n\n"},
  {"SetOneSheetEdgeId", PyttkReebSpace_SetOneSheetEdgeId, METH_VARARGS,
   "SetOneSheetEdgeId(self, _arg:bool) -> None\nC++: virtual void SetOneSheetEdgeId(bool _arg)\n\n"},
  {"GetTwoSheets", PyttkReebSpace_GetTwoSheets, METH_VARARGS,
   "GetTwoSheets(self) -> bool\nC++: virtual bool GetTwoSheets()\n\n"},
  {"SetTwoSheets", PyttkReebSpace_SetTwoSheets, METH_VARARGS,
   "SetTwoSheets(self, _arg:bool) -> None\nC++: virtual void SetTwoSheets(bool _arg)\n\n"},
  {"GetTwoSheetCaseId", PyttkReebSpace_GetTwoSheetCaseId, METH_VARARGS,
   "GetTwoSheetCaseId(self) -> bool\nC++: virtual bool GetTwoSheetCaseId()\n\n"},
  {"SetTwoSheetCaseId", PyttkReebSpace_SetTwoSheetCaseId, METH_VARARGS,
   "SetTwoSheetCaseId(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetCaseId(bool _arg)\n\n"},
  {"GetTwoSheetValue", PyttkReebSpace_GetTwoSheetValue, METH_VARARGS,
   "GetTwoSheetValue(self) -> bool\nC++: virtual bool GetTwoSheetValue()\n\n"},
  {"SetTwoSheetValue", PyttkReebSpace_SetTwoSheetValue, METH_VARARGS,
   "SetTwoSheetValue(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetValue(bool _arg)\n\n"},
  {"GetTwoSheetParameterization", PyttkReebSpace_GetTwoSheetParameterization, METH_VARARGS,
   "GetTwoSheetParameterization(self) -> bool\nC++: virtual bool GetTwoSheetParameterization()\n\n"},
  {"SetTwoSheetParameterization", PyttkReebSpace_SetTwoSheetParameterization, METH_VARARGS,
   "SetTwoSheetParameterization(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetParameterization(bool _arg)\n\n"},
  {"GetTwoSheetId", PyttkReebSpace_GetTwoSheetId, METH_VARARGS,
   "GetTwoSheetId(self) -> bool\nC++: virtual bool GetTwoSheetId()\n\n"},
  {"SetTwoSheetId", PyttkReebSpace_SetTwoSheetId, METH_VARARGS,
   "SetTwoSheetId(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetId(bool _arg)\n\n"},
  {"GetTwoSheetEdgeId", PyttkReebSpace_GetTwoSheetEdgeId, METH_VARARGS,
   "GetTwoSheetEdgeId(self) -> bool\nC++: virtual bool GetTwoSheetEdgeId()\n\n"},
  {"SetTwoSheetEdgeId", PyttkReebSpace_SetTwoSheetEdgeId, METH_VARARGS,
   "SetTwoSheetEdgeId(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetEdgeId(bool _arg)\n\n"},
  {"GetTwoSheetTetId", PyttkReebSpace_GetTwoSheetTetId, METH_VARARGS,
   "GetTwoSheetTetId(self) -> bool\nC++: virtual bool GetTwoSheetTetId()\n\n"},
  {"SetTwoSheetTetId", PyttkReebSpace_SetTwoSheetTetId, METH_VARARGS,
   "SetTwoSheetTetId(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetTetId(bool _arg)\n\n"},
  {"GetTwoSheetEdgeType", PyttkReebSpace_GetTwoSheetEdgeType, METH_VARARGS,
   "GetTwoSheetEdgeType(self) -> bool\nC++: virtual bool GetTwoSheetEdgeType()\n\n"},
  {"SetTwoSheetEdgeType", PyttkReebSpace_SetTwoSheetEdgeType, METH_VARARGS,
   "SetTwoSheetEdgeType(self, _arg:bool) -> None\nC++: virtual void SetTwoSheetEdgeType(bool _arg)\n\n"},
  {"GetThreeSheetTetNumber", PyttkReebSpace_GetThreeSheetTetNumber, METH_VARARGS,
   "GetThreeSheetTetNumber(self) -> bool\nC++: virtual bool GetThreeSheetTetNumber()\n\n"},
  {"SetThreeSheetTetNumber", PyttkReebSpace_SetThreeSheetTetNumber, METH_VARARGS,
   "SetThreeSheetTetNumber(self, _arg:bool) -> None\nC++: virtual void SetThreeSheetTetNumber(bool _arg)\n\n"},
  {"GetThreeSheetVertexNumber", PyttkReebSpace_GetThreeSheetVertexNumber, METH_VARARGS,
   "GetThreeSheetVertexNumber(self) -> bool\nC++: virtual bool GetThreeSheetVertexNumber()\n\n"},
  {"SetThreeSheetVertexNumber", PyttkReebSpace_SetThreeSheetVertexNumber, METH_VARARGS,
   "SetThreeSheetVertexNumber(self, _arg:bool) -> None\nC++: virtual void SetThreeSheetVertexNumber(bool _arg)\n\n"},
  {"GetThreeSheetExpansion", PyttkReebSpace_GetThreeSheetExpansion, METH_VARARGS,
   "GetThreeSheetExpansion(self) -> bool\nC++: virtual bool GetThreeSheetExpansion()\n\n"},
  {"SetThreeSheetExpansion", PyttkReebSpace_SetThreeSheetExpansion, METH_VARARGS,
   "SetThreeSheetExpansion(self, _arg:bool) -> None\nC++: virtual void SetThreeSheetExpansion(bool _arg)\n\n"},
  {"GetThreeSheetDomainVolume", PyttkReebSpace_GetThreeSheetDomainVolume, METH_VARARGS,
   "GetThreeSheetDomainVolume(self) -> bool\nC++: virtual bool GetThreeSheetDomainVolume()\n\n"},
  {"SetThreeSheetDomainVolume", PyttkReebSpace_SetThreeSheetDomainVolume, METH_VARARGS,
   "SetThreeSheetDomainVolume(self, _arg:bool) -> None\nC++: virtual void SetThreeSheetDomainVolume(bool _arg)\n\n"},
  {"GetThreeSheetRangeArea", PyttkReebSpace_GetThreeSheetRangeArea, METH_VARARGS,
   "GetThreeSheetRangeArea(self) -> bool\nC++: virtual bool GetThreeSheetRangeArea()\n\n"},
  {"SetThreeSheetRangeArea", PyttkReebSpace_SetThreeSheetRangeArea, METH_VARARGS,
   "SetThreeSheetRangeArea(self, _arg:bool) -> None\nC++: virtual void SetThreeSheetRangeArea(bool _arg)\n\n"},
  {"GetThreeSheetHyperVolume", PyttkReebSpace_GetThreeSheetHyperVolume, METH_VARARGS,
   "GetThreeSheetHyperVolume(self) -> bool\nC++: virtual bool GetThreeSheetHyperVolume()\n\n"},
  {"SetThreeSheetHyperVolume", PyttkReebSpace_SetThreeSheetHyperVolume, METH_VARARGS,
   "SetThreeSheetHyperVolume(self, _arg:bool) -> None\nC++: virtual void SetThreeSheetHyperVolume(bool _arg)\n\n"},
  {"GetSimplificationThreshold", PyttkReebSpace_GetSimplificationThreshold, METH_VARARGS,
   "GetSimplificationThreshold(self) -> float\nC++: virtual double GetSimplificationThreshold()\n\n"},
  {"SetSimplificationThreshold", PyttkReebSpace_SetSimplificationThreshold, METH_VARARGS,
   "SetSimplificationThreshold(self, _arg:float) -> None\nC++: virtual void SetSimplificationThreshold(double _arg)\n\n"},
  {"GetSimplificationCriterion", PyttkReebSpace_GetSimplificationCriterion, METH_VARARGS,
   "GetSimplificationCriterion(self) -> int\nC++: virtual int GetSimplificationCriterion()\n\n"},
  {"SetSimplificationCriterion", PyttkReebSpace_SetSimplificationCriterion, METH_VARARGS,
   "SetSimplificationCriterion(self, _arg:int) -> None\nC++: virtual void SetSimplificationCriterion(int _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkReebSpace_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_octree_acceleration"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetUseOctreeAcceleration(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetUseOctreeAcceleration(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetUseOctreeAcceleration(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseOctreeAcceleration/SetUseOctreeAcceleration\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zero_sheet_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetZeroSheetId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetZeroSheetId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetZeroSheetId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZeroSheetId/SetZeroSheetId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zero_sheet_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetZeroSheetType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetZeroSheetType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetZeroSheetType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZeroSheetType/SetZeroSheetType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zero_sheet_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetZeroSheetValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetZeroSheetValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetZeroSheetValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZeroSheetValue/SetZeroSheetValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zero_sheet_vertex_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetZeroSheetVertexId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetZeroSheetVertexId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetZeroSheetVertexId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZeroSheetVertexId/SetZeroSheetVertexId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("one_sheet_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetOneSheetId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetOneSheetId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetOneSheetId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOneSheetId/SetOneSheetId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("one_sheet_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetOneSheetType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetOneSheetType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetOneSheetType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOneSheetType/SetOneSheetType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("one_sheet_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetOneSheetValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetOneSheetValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetOneSheetValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOneSheetValue/SetOneSheetValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("one_sheet_vertex_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetOneSheetVertexId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetOneSheetVertexId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetOneSheetVertexId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOneSheetVertexId/SetOneSheetVertexId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("one_sheet_edge_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetOneSheetEdgeId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetOneSheetEdgeId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetOneSheetEdgeId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOneSheetEdgeId/SetOneSheetEdgeId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheets(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheets(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheets/SetTwoSheets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_case_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetCaseId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetCaseId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetCaseId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetCaseId/SetTwoSheetCaseId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetValue/SetTwoSheetValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_parameterization"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetParameterization(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetParameterization(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetParameterization(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetParameterization/SetTwoSheetParameterization\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetId/SetTwoSheetId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_edge_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetEdgeId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetEdgeId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetEdgeId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetEdgeId/SetTwoSheetEdgeId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_tet_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetTetId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetTetId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetTetId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetTetId/SetTwoSheetTetId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sheet_edge_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetTwoSheetEdgeType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetTwoSheetEdgeType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetTwoSheetEdgeType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSheetEdgeType/SetTwoSheetEdgeType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("three_sheet_tet_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetThreeSheetTetNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetThreeSheetTetNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetThreeSheetTetNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreeSheetTetNumber/SetThreeSheetTetNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("three_sheet_vertex_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetThreeSheetVertexNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetThreeSheetVertexNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetThreeSheetVertexNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreeSheetVertexNumber/SetThreeSheetVertexNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("three_sheet_expansion"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetThreeSheetExpansion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetThreeSheetExpansion(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetThreeSheetExpansion(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreeSheetExpansion/SetThreeSheetExpansion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("three_sheet_domain_volume"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetThreeSheetDomainVolume(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetThreeSheetDomainVolume(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetThreeSheetDomainVolume(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreeSheetDomainVolume/SetThreeSheetDomainVolume\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("three_sheet_range_area"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetThreeSheetRangeArea(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetThreeSheetRangeArea(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetThreeSheetRangeArea(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreeSheetRangeArea/SetThreeSheetRangeArea\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("three_sheet_hyper_volume"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetThreeSheetHyperVolume(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetThreeSheetHyperVolume(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetThreeSheetHyperVolume(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreeSheetHyperVolume/SetThreeSheetHyperVolume\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simplification_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetSimplificationThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetSimplificationThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetSimplificationThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSimplificationThreshold/SetSimplificationThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simplification_criterion"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebSpace_GetSimplificationCriterion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebSpace_SetSimplificationCriterion(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebSpace_SetSimplificationCriterion(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSimplificationCriterion/SetSimplificationCriterion\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkReebSpace_Doc =
  "ttkReebSpace - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date October 2015.\n\n"
  "TTK VTK-filter that efficiently computes the Reeb space of\n"
  "bivariate volumetric data.\n\n"
  "The Reeb space is a useful topological abstraction of bivariate\n"
  "scalar fields for data segmentation purposes. Intuitively, it allows\n"
  "the automatic separation of volumetric regions that project to the\n"
  "same areas in the range. This class also implements a simplification\n"
  "heuristic for progressive coarsening. Used in conjunction with\n"
  "continuous scatterplots, this class enables continuous scattterplot\n"
  "peeling for instance.\n\n"
  "The input data must be provided as two independent point data scalar\n"
  "fields defined on the geometry.\n"
  "\\warning Only tetrahedral meshes are supported.\n\n"
  "\\param Input Input bivariate data (vtkUnstructuredGrid)\n"
  "\\param Output0 Output 0-sheets (vtkUnstructuredGrid)\n"
  "\\param Output1 Output 1-sheets (vtkUnstructuredGrid)\n"
  "\\param Output2 Output 2-sheets (vtkUnstructuredGrid)\n"
  "\\param Output3 Output 3-sheets (vtkUnstructuredGrid)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "The input data arrays needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 for the U Component, 1 for the V Component\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The optional offset arrays can be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 2 for the U Offset Field, 3 for the V Offset Field\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the offset array)\n\n"
  "ote: To use this optional array, `ForceInputOffsetScalarField` needs\n"
  "to be\n"
  "enabled with the setter `setForceInputOffsetScalarField()'.\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Jacobi Fiber Surfaces for Bivariate Reeb Space Computation\"\n\n"
  "Julien Tierny, Hamish Carr\n\n"
  "Proc. of IEEE VIS 2016.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2016.\n\n"
  "\\sa vtkContinuousScatterplot\n"
  "\\sa vtkJacobiSet\n"
  "\\sa vtkFiberSurface\n"
  "\\sa vtkRangePolygon\n"
  "\\sa ttk::ReebSpace\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkReebSpace_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkReebSpace.ttkReebSpace", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkReebSpace_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkReebSpace_StaticNew()
{
  return ttkReebSpace::New();
}

PyObject *PyttkReebSpace_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkReebSpace_Type, PyttkReebSpace_Methods,
    "ttkReebSpace",
 &PyttkReebSpace_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkReebSpace_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkReebSpace(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkReebSpace_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkReebSpace", o) != 0)
  {
    Py_DECREF(o);
  }

}

