// python wrapper for ttkRipsComplex
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkRipsComplex.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkRipsComplex(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkRipsComplex_ClassNew(); }


static PyObject *
PyttkRipsComplex_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkRipsComplex::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkRipsComplex::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkRipsComplex *tempr = ttkRipsComplex::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkRipsComplex *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkRipsComplex::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkRipsComplex::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkRipsComplex::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetScalarFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScalarFields(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetScalarFields(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_ClearScalarFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearScalarFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearScalarFields();
    }
    else
    {
      op->ttkRipsComplex::ClearScalarFields();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetOutputDimension(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDimension");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputDimension(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetOutputDimension(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetOutputDimension(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputDimension");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutputDimension() :
      op->ttkRipsComplex::GetOutputDimension());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetEpsilon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetEpsilon(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetEpsilon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon() :
      op->ttkRipsComplex::GetEpsilon());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetKeepAllDataArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepAllDataArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepAllDataArrays(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetKeepAllDataArrays(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetKeepAllDataArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepAllDataArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetKeepAllDataArrays() :
      op->ttkRipsComplex::GetKeepAllDataArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectFieldsWithRegexp(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetSelectFieldsWithRegexp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSelectFieldsWithRegexp() :
      op->ttkRipsComplex::GetSelectFieldsWithRegexp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetStdDev(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStdDev");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStdDev(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetStdDev(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetStdDev(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStdDev");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetStdDev() :
      op->ttkRipsComplex::GetStdDev());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetComputeGaussianDensity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeGaussianDensity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeGaussianDensity(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetComputeGaussianDensity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetComputeGaussianDensity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeGaussianDensity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeGaussianDensity() :
      op->ttkRipsComplex::GetComputeGaussianDensity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRegexpString(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetRegexpString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetRegexpString() :
      op->ttkRipsComplex::GetRegexpString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetXColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXColumn(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetXColumn(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetXColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetXColumn() :
      op->ttkRipsComplex::GetXColumn());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetYColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYColumn(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetYColumn(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetYColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetYColumn() :
      op->ttkRipsComplex::GetYColumn());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_SetZColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZColumn(temp0);
    }
    else
    {
      op->ttkRipsComplex::SetZColumn(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkRipsComplex_GetZColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkRipsComplex *op = static_cast<ttkRipsComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetZColumn() :
      op->ttkRipsComplex::GetZColumn());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkRipsComplex_Methods[] = {
  {"IsTypeOf", PyttkRipsComplex_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkRipsComplex_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkRipsComplex_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkRipsComplex\nC++: static ttkRipsComplex *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkRipsComplex_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkRipsComplex\nC++: ttkRipsComplex *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkRipsComplex_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkRipsComplex_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetScalarFields", PyttkRipsComplex_SetScalarFields, METH_VARARGS,
   "SetScalarFields(self, s:str) -> None\nC++: void SetScalarFields(const std::string &s)\n\n"},
  {"ClearScalarFields", PyttkRipsComplex_ClearScalarFields, METH_VARARGS,
   "ClearScalarFields(self) -> None\nC++: void ClearScalarFields()\n\n"},
  {"SetOutputDimension", PyttkRipsComplex_SetOutputDimension, METH_VARARGS,
   "SetOutputDimension(self, _arg:int) -> None\nC++: virtual void SetOutputDimension(int _arg)\n\n"},
  {"GetOutputDimension", PyttkRipsComplex_GetOutputDimension, METH_VARARGS,
   "GetOutputDimension(self) -> int\nC++: virtual int GetOutputDimension()\n\n"},
  {"SetEpsilon", PyttkRipsComplex_SetEpsilon, METH_VARARGS,
   "SetEpsilon(self, _arg:float) -> None\nC++: virtual void SetEpsilon(double _arg)\n\n"},
  {"GetEpsilon", PyttkRipsComplex_GetEpsilon, METH_VARARGS,
   "GetEpsilon(self) -> float\nC++: virtual double GetEpsilon()\n\n"},
  {"SetKeepAllDataArrays", PyttkRipsComplex_SetKeepAllDataArrays, METH_VARARGS,
   "SetKeepAllDataArrays(self, _arg:bool) -> None\nC++: virtual void SetKeepAllDataArrays(bool _arg)\n\n"},
  {"GetKeepAllDataArrays", PyttkRipsComplex_GetKeepAllDataArrays, METH_VARARGS,
   "GetKeepAllDataArrays(self) -> bool\nC++: virtual bool GetKeepAllDataArrays()\n\n"},
  {"SetSelectFieldsWithRegexp", PyttkRipsComplex_SetSelectFieldsWithRegexp, METH_VARARGS,
   "SetSelectFieldsWithRegexp(self, _arg:bool) -> None\nC++: virtual void SetSelectFieldsWithRegexp(bool _arg)\n\n"},
  {"GetSelectFieldsWithRegexp", PyttkRipsComplex_GetSelectFieldsWithRegexp, METH_VARARGS,
   "GetSelectFieldsWithRegexp(self) -> bool\nC++: virtual bool GetSelectFieldsWithRegexp()\n\n"},
  {"SetStdDev", PyttkRipsComplex_SetStdDev, METH_VARARGS,
   "SetStdDev(self, _arg:float) -> None\nC++: virtual void SetStdDev(double _arg)\n\n"},
  {"GetStdDev", PyttkRipsComplex_GetStdDev, METH_VARARGS,
   "GetStdDev(self) -> float\nC++: virtual double GetStdDev()\n\n"},
  {"SetComputeGaussianDensity", PyttkRipsComplex_SetComputeGaussianDensity, METH_VARARGS,
   "SetComputeGaussianDensity(self, _arg:bool) -> None\nC++: virtual void SetComputeGaussianDensity(bool _arg)\n\n"},
  {"GetComputeGaussianDensity", PyttkRipsComplex_GetComputeGaussianDensity, METH_VARARGS,
   "GetComputeGaussianDensity(self) -> bool\nC++: virtual bool GetComputeGaussianDensity()\n\n"},
  {"SetRegexpString", PyttkRipsComplex_SetRegexpString, METH_VARARGS,
   "SetRegexpString(self, _arg:str) -> None\nC++: virtual void SetRegexpString(const std::string &_arg)\n\n"},
  {"GetRegexpString", PyttkRipsComplex_GetRegexpString, METH_VARARGS,
   "GetRegexpString(self) -> str\nC++: virtual std::string GetRegexpString()\n\n"},
  {"SetXColumn", PyttkRipsComplex_SetXColumn, METH_VARARGS,
   "SetXColumn(self, _arg:str) -> None\nC++: virtual void SetXColumn(const std::string &_arg)\n\n"},
  {"GetXColumn", PyttkRipsComplex_GetXColumn, METH_VARARGS,
   "GetXColumn(self) -> str\nC++: virtual std::string GetXColumn()\n\n"},
  {"SetYColumn", PyttkRipsComplex_SetYColumn, METH_VARARGS,
   "SetYColumn(self, _arg:str) -> None\nC++: virtual void SetYColumn(const std::string &_arg)\n\n"},
  {"GetYColumn", PyttkRipsComplex_GetYColumn, METH_VARARGS,
   "GetYColumn(self) -> str\nC++: virtual std::string GetYColumn()\n\n"},
  {"SetZColumn", PyttkRipsComplex_SetZColumn, METH_VARARGS,
   "SetZColumn(self, _arg:str) -> None\nC++: virtual void SetZColumn(const std::string &_arg)\n\n"},
  {"GetZColumn", PyttkRipsComplex_GetZColumn, METH_VARARGS,
   "GetZColumn(self) -> str\nC++: virtual std::string GetZColumn()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkRipsComplex_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("scalar_fields"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetScalarFields(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetScalarFields(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScalarFields\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_dimension"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetOutputDimension(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetOutputDimension(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetOutputDimension(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputDimension/SetOutputDimension\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetEpsilon(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetEpsilon(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetEpsilon(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon/SetEpsilon\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_all_data_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetKeepAllDataArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetKeepAllDataArrays(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetKeepAllDataArrays(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetKeepAllDataArrays/SetKeepAllDataArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("select_fields_with_regexp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetSelectFieldsWithRegexp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetSelectFieldsWithRegexp(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetSelectFieldsWithRegexp(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectFieldsWithRegexp/SetSelectFieldsWithRegexp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("std_dev"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetStdDev(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetStdDev(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetStdDev(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStdDev/SetStdDev\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_gaussian_density"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetComputeGaussianDensity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetComputeGaussianDensity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetComputeGaussianDensity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeGaussianDensity/SetComputeGaussianDensity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("regexp_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetRegexpString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetRegexpString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetRegexpString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRegexpString/SetRegexpString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_column"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetXColumn(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetXColumn(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetXColumn(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXColumn/SetXColumn\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_column"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetYColumn(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetYColumn(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetYColumn(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetYColumn/SetYColumn\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_column"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkRipsComplex_GetZColumn(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkRipsComplex_SetZColumn(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkRipsComplex_SetZColumn(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZColumn/SetZColumn\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkRipsComplex_Doc =
  "ttkRipsComplex - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Pierre Guillou <pierre.guillou@lip6.fr>\\date January 2022.\n\n"
  "TTK VTK-filter that wraps the ttk::RipsComplex processing\n"
  "package.\n\n"
  "VTK wrapping code for the ttk::RipsComplex package.\n\n"
  "\\param Input Input table (vtkTable)\n"
  "\\param Output Triangulation (vtkUnstructuredGrid)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::RipsComplex\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_householdAnalysis/\"\n"
  "  >Persistent Generators Household Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_periodicPicture/\"\n"
  "  >Persistent Generators Periodic Picture example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkRipsComplex_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkRipsComplex.ttkRipsComplex", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkRipsComplex_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkRipsComplex_StaticNew()
{
  return ttkRipsComplex::New();
}

PyObject *PyttkRipsComplex_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkRipsComplex_Type, PyttkRipsComplex_Methods,
    "ttkRipsComplex",
 &PyttkRipsComplex_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkRipsComplex_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkRipsComplex(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkRipsComplex_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkRipsComplex", o) != 0)
  {
    Py_DECREF(o);
  }

}

