// python wrapper for ttkScalarFieldCriticalPoints
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkScalarFieldCriticalPoints.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkScalarFieldCriticalPoints(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkScalarFieldCriticalPoints_ClassNew(); }


static PyObject *
PyttkScalarFieldCriticalPoints_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkScalarFieldCriticalPoints::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkScalarFieldCriticalPoints::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkScalarFieldCriticalPoints *tempr = ttkScalarFieldCriticalPoints::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkScalarFieldCriticalPoints *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkScalarFieldCriticalPoints::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkScalarFieldCriticalPoints::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkScalarFieldCriticalPoints::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetVertexBoundary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexBoundary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVertexBoundary() :
      op->ttkScalarFieldCriticalPoints::GetVertexBoundary());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetVertexBoundary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVertexBoundary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVertexBoundary(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetVertexBoundary(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetVertexIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVertexIds() :
      op->ttkScalarFieldCriticalPoints::GetVertexIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetVertexIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVertexIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVertexIds(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetVertexIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetVertexScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVertexScalars() :
      op->ttkScalarFieldCriticalPoints::GetVertexScalars());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetVertexScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVertexScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVertexScalars(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetVertexScalars(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkScalarFieldCriticalPoints::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetBackEnd(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackEnd");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackEnd(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetBackEnd(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetStartingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStartingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStartingResolutionLevel() :
      op->ttkScalarFieldCriticalPoints::GetStartingResolutionLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetStartingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStartingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStartingResolutionLevel(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetStartingResolutionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetStoppingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStoppingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStoppingResolutionLevel() :
      op->ttkScalarFieldCriticalPoints::GetStoppingResolutionLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetStoppingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStoppingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStoppingResolutionLevel(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetStoppingResolutionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetIsResumable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsResumable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsResumable() :
      op->ttkScalarFieldCriticalPoints::GetIsResumable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetIsResumable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsResumable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsResumable(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetIsResumable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_GetTimeLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTimeLimit() :
      op->ttkScalarFieldCriticalPoints::GetTimeLimit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldCriticalPoints_SetTimeLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldCriticalPoints *op = static_cast<ttkScalarFieldCriticalPoints *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeLimit(temp0);
    }
    else
    {
      op->ttkScalarFieldCriticalPoints::SetTimeLimit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkScalarFieldCriticalPoints_Methods[] = {
  {"IsTypeOf", PyttkScalarFieldCriticalPoints_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkScalarFieldCriticalPoints_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkScalarFieldCriticalPoints_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkScalarFieldCriticalPoints\nC++: static ttkScalarFieldCriticalPoints *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkScalarFieldCriticalPoints_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkScalarFieldCriticalPoints\nC++: ttkScalarFieldCriticalPoints *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkScalarFieldCriticalPoints_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkScalarFieldCriticalPoints_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetVertexBoundary", PyttkScalarFieldCriticalPoints_GetVertexBoundary, METH_VARARGS,
   "GetVertexBoundary(self) -> bool\nC++: virtual bool GetVertexBoundary()\n\n"},
  {"SetVertexBoundary", PyttkScalarFieldCriticalPoints_SetVertexBoundary, METH_VARARGS,
   "SetVertexBoundary(self, _arg:bool) -> None\nC++: virtual void SetVertexBoundary(bool _arg)\n\n"},
  {"GetVertexIds", PyttkScalarFieldCriticalPoints_GetVertexIds, METH_VARARGS,
   "GetVertexIds(self) -> bool\nC++: virtual bool GetVertexIds()\n\n"},
  {"SetVertexIds", PyttkScalarFieldCriticalPoints_SetVertexIds, METH_VARARGS,
   "SetVertexIds(self, _arg:bool) -> None\nC++: virtual void SetVertexIds(bool _arg)\n\n"},
  {"GetVertexScalars", PyttkScalarFieldCriticalPoints_GetVertexScalars, METH_VARARGS,
   "GetVertexScalars(self) -> bool\nC++: virtual bool GetVertexScalars()\n\n"},
  {"SetVertexScalars", PyttkScalarFieldCriticalPoints_SetVertexScalars, METH_VARARGS,
   "SetVertexScalars(self, _arg:bool) -> None\nC++: virtual void SetVertexScalars(bool _arg)\n\n"},
  {"GetForceInputOffsetScalarField", PyttkScalarFieldCriticalPoints_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkScalarFieldCriticalPoints_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"SetBackEnd", PyttkScalarFieldCriticalPoints_SetBackEnd, METH_VARARGS,
   "SetBackEnd(self, _arg:int) -> None\nC++: virtual void SetBackEnd(int _arg)\n\n"},
  {"GetStartingResolutionLevel", PyttkScalarFieldCriticalPoints_GetStartingResolutionLevel, METH_VARARGS,
   "GetStartingResolutionLevel(self) -> int\nC++: virtual int GetStartingResolutionLevel()\n\n"},
  {"SetStartingResolutionLevel", PyttkScalarFieldCriticalPoints_SetStartingResolutionLevel, METH_VARARGS,
   "SetStartingResolutionLevel(self, _arg:int) -> None\nC++: virtual void SetStartingResolutionLevel(int _arg)\n\n"},
  {"GetStoppingResolutionLevel", PyttkScalarFieldCriticalPoints_GetStoppingResolutionLevel, METH_VARARGS,
   "GetStoppingResolutionLevel(self) -> int\nC++: virtual int GetStoppingResolutionLevel()\n\n"},
  {"SetStoppingResolutionLevel", PyttkScalarFieldCriticalPoints_SetStoppingResolutionLevel, METH_VARARGS,
   "SetStoppingResolutionLevel(self, _arg:int) -> None\nC++: virtual void SetStoppingResolutionLevel(int _arg)\n\n"},
  {"GetIsResumable", PyttkScalarFieldCriticalPoints_GetIsResumable, METH_VARARGS,
   "GetIsResumable(self) -> bool\nC++: virtual bool GetIsResumable()\n\n"},
  {"SetIsResumable", PyttkScalarFieldCriticalPoints_SetIsResumable, METH_VARARGS,
   "SetIsResumable(self, _arg:bool) -> None\nC++: virtual void SetIsResumable(bool _arg)\n\n"},
  {"GetTimeLimit", PyttkScalarFieldCriticalPoints_GetTimeLimit, METH_VARARGS,
   "GetTimeLimit(self) -> float\nC++: virtual double GetTimeLimit()\n\n"},
  {"SetTimeLimit", PyttkScalarFieldCriticalPoints_SetTimeLimit, METH_VARARGS,
   "SetTimeLimit(self, _arg:float) -> None\nC++: virtual void SetTimeLimit(double _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkScalarFieldCriticalPoints_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("vertex_boundary"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetVertexBoundary(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetVertexBoundary(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetVertexBoundary(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVertexBoundary/SetVertexBoundary\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vertex_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetVertexIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetVertexIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetVertexIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVertexIds/SetVertexIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vertex_scalars"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetVertexScalars(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetVertexScalars(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetVertexScalars(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVertexScalars/SetVertexScalars\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("back_end"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetBackEnd(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetBackEnd(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackEnd\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("starting_resolution_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetStartingResolutionLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetStartingResolutionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetStartingResolutionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStartingResolutionLevel/SetStartingResolutionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stopping_resolution_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetStoppingResolutionLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetStoppingResolutionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetStoppingResolutionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStoppingResolutionLevel/SetStoppingResolutionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_resumable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetIsResumable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetIsResumable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetIsResumable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsResumable/SetIsResumable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_limit"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldCriticalPoints_GetTimeLimit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldCriticalPoints_SetTimeLimit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldCriticalPoints_SetTimeLimit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeLimit/SetTimeLimit\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkScalarFieldCriticalPoints_Doc =
  "ttkScalarFieldCriticalPoints - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date June 2015.\n\n"
  "TTK VTK-filter for the computation of critical points in PL\n"
  "scalar fields defined on PL manifolds.\n\n"
  "This filter computes the list of critical points of the input scalar\n"
  "field and classify them according to their type.\n\n"
  "\\param Input Input PL scalar field (vtkDataSet)\n"
  "\\param Output Output critical points (vtkDataSet)\n\n"
  "The input data array needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The optional offset array can be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 1 (FIXED: the second array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the offset array)\n\n"
  "ote: To use this optional array, `ForceInputOffsetScalarField` needs\n"
  "to be\n"
  "enabled with the setter `setForceInputOffsetScalarField()'.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the corresponding standalone program for a usage example:\n"
  "- standalone/ScalarFieldCriticalPoints/main.cpp\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Critical points and curvature for embedded polyhedral surfaces\"\n\n"
  "Thomas Banchoff\n\n"
  "American Mathematical Monthly, 1970.\n\n\n"
  " Progressive Approach used by default\n\n"
  "Related publication\n\n"
  "\"A Progressive Approach to Scalar Field Topology\"\n\n"
  "Jules Vidal, Pierre Guillou, Julien Tierny\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2021\n\n"
  "\\sa ttk::ScalarFieldCriticalPoints\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/BuiltInExample1/\"\n"
  "  > BuiltInExample1\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/compactTriangulation/\"\n"
  "  > Compact Triangulation example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/dragon/\">Dragon\n"
  "  example\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/interactionSites/\"\n"
  "  > Interaction sites\\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/mpiExample/\">\n"
  "  MPI example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/uncertainStartingVortex/\"\n"
  "  > Uncertain Starting Vortex example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkScalarFieldCriticalPoints_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkScalarFieldCriticalPoints.ttkScalarFieldCriticalPoints", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkScalarFieldCriticalPoints_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkScalarFieldCriticalPoints_StaticNew()
{
  return ttkScalarFieldCriticalPoints::New();
}

PyObject *PyttkScalarFieldCriticalPoints_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkScalarFieldCriticalPoints_Type, PyttkScalarFieldCriticalPoints_Methods,
    "ttkScalarFieldCriticalPoints",
 &PyttkScalarFieldCriticalPoints_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkScalarFieldCriticalPoints_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkScalarFieldCriticalPoints(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkScalarFieldCriticalPoints_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkScalarFieldCriticalPoints", o) != 0)
  {
    Py_DECREF(o);
  }

}

