/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_SERVER_PROTOCOL_H
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_foreign_toplevel_manager_v1 The treeland_foreign_toplevel_manager_v1 protocol
 * @section page_ifaces_treeland_foreign_toplevel_manager_v1 Interfaces
 * - @subpage page_iface_treeland_foreign_toplevel_manager_v1 - foreign toplevel manager
 * - @subpage page_iface_treeland_foreign_toplevel_handle_v1 - An opened toplevel
 * - @subpage page_iface_treeland_dock_preview_context_v1 - handle dock preview
 * @section page_copyright_treeland_foreign_toplevel_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_dock_preview_context_v1;
struct treeland_foreign_toplevel_handle_v1;
struct treeland_foreign_toplevel_manager_v1;
struct wl_output;
struct wl_seat;
struct wl_surface;

#ifndef TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_INTERFACE
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_foreign_toplevel_manager_v1 treeland_foreign_toplevel_manager_v1
 * @section page_iface_treeland_foreign_toplevel_manager_v1_desc Description
 *
 * This interface allows a client to get toplevel some info.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_foreign_toplevel_manager_v1_api API
 * See @ref iface_treeland_foreign_toplevel_manager_v1.
 */
/**
 * @defgroup iface_treeland_foreign_toplevel_manager_v1 The treeland_foreign_toplevel_manager_v1 interface
 *
 * This interface allows a client to get toplevel some info.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_foreign_toplevel_manager_v1_interface;
#endif
#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
/**
 * @page page_iface_treeland_foreign_toplevel_handle_v1 treeland_foreign_toplevel_handle_v1
 * @section page_iface_treeland_foreign_toplevel_handle_v1_desc Description
 *
 * A treeland_foreign_toplevel_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_foreign_toplevel_handle_v1_api API
 * See @ref iface_treeland_foreign_toplevel_handle_v1.
 */
/**
 * @defgroup iface_treeland_foreign_toplevel_handle_v1 The treeland_foreign_toplevel_handle_v1 interface
 *
 * A treeland_foreign_toplevel_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_foreign_toplevel_handle_v1_interface;
#endif
#ifndef TREELAND_DOCK_PREVIEW_CONTEXT_V1_INTERFACE
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_dock_preview_context_v1 treeland_dock_preview_context_v1
 * @section page_iface_treeland_dock_preview_context_v1_desc Description
 *
 * This interface allows dock set windows preview.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_dock_preview_context_v1_api API
 * See @ref iface_treeland_dock_preview_context_v1.
 */
/**
 * @defgroup iface_treeland_dock_preview_context_v1 The treeland_dock_preview_context_v1 interface
 *
 * This interface allows dock set windows preview.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_dock_preview_context_v1_interface;
#endif

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 * @struct treeland_foreign_toplevel_manager_v1_interface
 */
struct treeland_foreign_toplevel_manager_v1_interface {
	/**
	 * Stop sending events
	 *
	 * Indicates the client no longer wishes to receive events for
	 * new toplevels. However the compositor may emit further
	 * toplevel_created events, until the finished event is emitted.
	 *
	 * The client must not send any more requests after this one.
	 */
	void (*stop)(struct wl_client *client,
		     struct wl_resource *resource);
	/**
	 */
	void (*get_dock_preview_context)(struct wl_client *client,
					 struct wl_resource *resource,
					 struct wl_resource *relative_surface,
					 uint32_t id);
};

#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL 0
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED 1

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_GET_DOCK_PREVIEW_CONTEXT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 * Sends an toplevel event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_manager_v1_send_toplevel(struct wl_resource *resource_, struct wl_resource *toplevel)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL, toplevel);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_manager_v1_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED);
}

#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * types of states on the toplevel
 *
 * The different states that a toplevel can have. These have the same meaning
 * as the states with the same names defined in xdg-toplevel
 */
enum treeland_foreign_toplevel_handle_v1_state {
	/**
	 * the toplevel is maximized
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MAXIMIZED = 0,
	/**
	 * the toplevel is minimized
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MINIMIZED = 1,
	/**
	 * the toplevel is active
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ACTIVATED = 2,
	/**
	 * the toplevel is fullscreen
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN = 3,
};
#endif /* TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM */

#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM_IS_VALID
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Validate a treeland_foreign_toplevel_handle_v1 state value.
 *
 * @return true on success, false on error.
 * @ref treeland_foreign_toplevel_handle_v1_state
 */
static inline bool
treeland_foreign_toplevel_handle_v1_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MAXIMIZED:
		return version >= 1;
	case TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MINIMIZED:
		return version >= 1;
	case TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ACTIVATED:
		return version >= 1;
	case TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM_IS_VALID */

#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM
enum treeland_foreign_toplevel_handle_v1_error {
	/**
	 * the provided rectangle is invalid
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_INVALID_RECTANGLE = 0,
};
#endif /* TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM */

#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM_IS_VALID
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Validate a treeland_foreign_toplevel_handle_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_foreign_toplevel_handle_v1_error
 */
static inline bool
treeland_foreign_toplevel_handle_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_INVALID_RECTANGLE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * @struct treeland_foreign_toplevel_handle_v1_interface
 */
struct treeland_foreign_toplevel_handle_v1_interface {
	/**
	 * requests that the toplevel be maximized
	 *
	 * Requests that the toplevel be maximized. If the maximized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*set_maximized)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * requests that the toplevel be unmaximized
	 *
	 * Requests that the toplevel be unmaximized. If the maximized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*unset_maximized)(struct wl_client *client,
				struct wl_resource *resource);
	/**
	 * requests that the toplevel be minimized
	 *
	 * Requests that the toplevel be minimized. If the minimized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*set_minimized)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * requests that the toplevel be unminimized
	 *
	 * Requests that the toplevel be unminimized. If the minimized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*unset_minimized)(struct wl_client *client,
				struct wl_resource *resource);
	/**
	 * activate the toplevel
	 *
	 * Request that this toplevel be activated on the given seat.
	 * There is no guarantee the toplevel will be actually activated.
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *seat);
	/**
	 * request that the toplevel be closed
	 *
	 * Send a request to the toplevel to close itself. The compositor
	 * would typically use a shell-specific method to carry out this
	 * request, for example by sending the xdg_toplevel.close event.
	 * However, this gives no guarantees the toplevel will actually be
	 * destroyed. If and when this happens, the
	 * treeland_foreign_toplevel_handle_v1.closed event will be
	 * emitted.
	 */
	void (*close)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * the rectangle which represents the toplevel
	 *
	 * The rectangle of the surface specified in this request
	 * corresponds to the place where the app using this protocol
	 * represents the given toplevel. It can be used by the compositor
	 * as a hint for some operations, e.g minimizing. The client is
	 * however not required to set this, in which case the compositor
	 * is free to decide some default value.
	 *
	 * If the client specifies more than one rectangle, only the last
	 * one is considered.
	 *
	 * The dimensions are given in surface-local coordinates. Setting
	 * width=height=0 removes the already-set rectangle.
	 */
	void (*set_rectangle)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *surface,
			      int32_t x,
			      int32_t y,
			      int32_t width,
			      int32_t height);
	/**
	 * destroy the treeland_foreign_toplevel_handle_v1 object
	 *
	 * Destroys the treeland_foreign_toplevel_handle_v1 object.
	 *
	 * This request should be called either when the client does not
	 * want to use the toplevel anymore or after the closed event to
	 * finalize the destruction of the object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * request that the toplevel be fullscreened
	 *
	 * Requests that the toplevel be fullscreened on the given
	 * output. If the fullscreen state and/or the outputs the toplevel
	 * is visible on actually change, this will be indicated by the
	 * state and output_enter/leave events.
	 *
	 * The output parameter is only a hint to the compositor. Also, if
	 * output is NULL, the compositor should decide which output the
	 * toplevel will be fullscreened on, if at all.
	 */
	void (*set_fullscreen)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *output);
	/**
	 * request that the toplevel be unfullscreened
	 *
	 * Requests that the toplevel be unfullscreened. If the
	 * fullscreen state actually changes, this will be indicated by the
	 * state event.
	 */
	void (*unset_fullscreen)(struct wl_client *client,
				 struct wl_resource *resource);
};

#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PID 0
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE 1
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID 2
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER 3
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER 4
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE 5
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE 6
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DONE 7
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED 8
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT 9

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PID_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_FULLSCREEN_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an pid event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_pid(struct wl_resource *resource_, uint32_t pid)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PID, pid);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an title event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_title(struct wl_resource *resource_, const char *title)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE, title);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an app_id event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_app_id(struct wl_resource *resource_, const char *app_id)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID, app_id);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an identifier event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_identifier(struct wl_resource *resource_, uint32_t identifier)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER, identifier);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an output_enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_output_enter(struct wl_resource *resource_, struct wl_resource *output)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER, output);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an output_leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_output_leave(struct wl_resource *resource_, struct wl_resource *output)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE, output);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an state event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_state(struct wl_resource *resource_, struct wl_array *state)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE, state);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DONE);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an closed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_closed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * Sends an parent event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_foreign_toplevel_handle_v1_send_parent(struct wl_resource *resource_, struct wl_resource *parent)
{
	wl_resource_post_event(resource_, TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT, parent);
}

#ifndef TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * types of direction on the dock preview
 *
 */
enum treeland_dock_preview_context_v1_direction {
	/**
	 * top
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_TOP = 0,
	/**
	 * right
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_RIGHT = 1,
	/**
	 * bottom
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_BOTTOM = 2,
	/**
	 * left
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_LEFT = 3,
};
#endif /* TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM */

#ifndef TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM_IS_VALID
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * Validate a treeland_dock_preview_context_v1 direction value.
 *
 * @return true on success, false on error.
 * @ref treeland_dock_preview_context_v1_direction
 */
static inline bool
treeland_dock_preview_context_v1_direction_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_TOP:
		return version >= 1;
	case TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_RIGHT:
		return version >= 1;
	case TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_BOTTOM:
		return version >= 1;
	case TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_LEFT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * @struct treeland_dock_preview_context_v1_interface
 */
struct treeland_dock_preview_context_v1_interface {
	/**
	 * set preview surfaces
	 *
	 * X and Y are relative to the relative_surface. surfaces
	 * wl_array is identifiers.
	 */
	void (*show)(struct wl_client *client,
		     struct wl_resource *resource,
		     struct wl_array *surfaces,
		     int32_t x,
		     int32_t y,
		     uint32_t direction);
	/**
	 */
	void (*show_tooltip)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *tooltip,
			     int32_t x,
			     int32_t y,
			     uint32_t direction);
	/**
	 * close preview box
	 *
	 * close preview box
	 */
	void (*close)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_ENTER 0
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_LEAVE 1

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_LEAVE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW_TOOLTIP_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * Sends an enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_dock_preview_context_v1_send_enter(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_DOCK_PREVIEW_CONTEXT_V1_ENTER);
}

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * Sends an leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_dock_preview_context_v1_send_leave(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_DOCK_PREVIEW_CONTEXT_V1_LEAVE);
}

#ifdef  __cplusplus
}
#endif

#endif
