// python wrapper for vtkODBCDatabase
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkODBCDatabase.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkODBCDatabase(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkODBCDatabase_ClassNew(); }


static PyObject *
PyvtkODBCDatabase_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkODBCDatabase::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkODBCDatabase::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkODBCDatabase *tempr = vtkODBCDatabase::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkODBCDatabase *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkODBCDatabase::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkODBCDatabase::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkODBCDatabase::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_Open(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Open");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->Open(temp0) :
      op->vtkODBCDatabase::Open(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_Close(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Close");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Close();
    }
    else
    {
      op->vtkODBCDatabase::Close();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_IsOpen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsOpen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsOpen() :
      op->vtkODBCDatabase::IsOpen());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetQueryInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQueryInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSQLQuery *tempr = (ap.IsBound() ?
      op->GetQueryInstance() :
      op->vtkODBCDatabase::GetQueryInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetLastErrorText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastErrorText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLastErrorText() :
      op->vtkODBCDatabase::GetLastErrorText());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetTables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetTables() :
      op->vtkODBCDatabase::GetTables());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetRecord(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRecord");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetRecord(temp0) :
      op->vtkODBCDatabase::GetRecord(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_IsSupported(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSupported");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsSupported(temp0) :
      op->vtkODBCDatabase::IsSupported(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SetDataSourceName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataSourceName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataSourceName(temp0);
    }
    else
    {
      op->vtkODBCDatabase::SetDataSourceName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetDataSourceName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataSourceName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetDataSourceName() :
      op->vtkODBCDatabase::GetDataSourceName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServerPort(temp0);
    }
    else
    {
      op->vtkODBCDatabase::SetServerPort(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHostName(temp0);
    }
    else
    {
      op->vtkODBCDatabase::SetHostName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SetUserName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUserName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUserName(temp0);
    }
    else
    {
      op->vtkODBCDatabase::SetUserName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SetDatabaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDatabaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDatabaseName(temp0);
    }
    else
    {
      op->vtkODBCDatabase::SetDatabaseName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetDatabaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetDatabaseName() :
      op->vtkODBCDatabase::GetDatabaseName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_SetPassword(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassword");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassword(temp0);
    }
    else
    {
      op->vtkODBCDatabase::SetPassword(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_HasError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasError() :
      op->vtkODBCDatabase::HasError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetDatabaseType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabaseType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDatabaseType() :
      op->vtkODBCDatabase::GetDatabaseType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetURL() :
      op->vtkODBCDatabase::GetURL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetColumnSpecification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnSpecification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  vtkSQLDatabaseSchema *temp0 = nullptr;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSQLDatabaseSchema") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetColumnSpecification(temp0, temp1, temp2) :
      op->vtkODBCDatabase::GetColumnSpecification(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_GetIndexSpecification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIndexSpecification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  vtkSQLDatabaseSchema *temp0 = nullptr;
  int temp1;
  int temp2;
  bool temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSQLDatabaseSchema") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetIndexSpecification(temp0, temp1, temp2, temp3) :
      op->vtkODBCDatabase::GetIndexSpecification(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(3, temp3);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_CreateDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->CreateDatabase(temp0, temp1) :
      op->vtkODBCDatabase::CreateDatabase(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_DropDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DropDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->DropDatabase(temp0) :
      op->vtkODBCDatabase::DropDatabase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkODBCDatabase_ParseURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParseURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkODBCDatabase *op = static_cast<vtkODBCDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ParseURL(temp0) :
      op->vtkODBCDatabase::ParseURL(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkODBCDatabase_Methods[] = {
  {"IsTypeOf", PyvtkODBCDatabase_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkODBCDatabase_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkODBCDatabase_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkODBCDatabase\nC++: static vtkODBCDatabase *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkODBCDatabase_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkODBCDatabase\nC++: vtkODBCDatabase *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkODBCDatabase_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkODBCDatabase_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Open", PyvtkODBCDatabase_Open, METH_VARARGS,
   "Open(self, password:str) -> bool\nC++: bool Open(const char *password) override;\n\nOpen a new connection to the database.  You need to set the\nfilename before calling this function.  Returns true if the\ndatabase was opened successfully; false otherwise.\n"},
  {"Close", PyvtkODBCDatabase_Close, METH_VARARGS,
   "Close(self) -> None\nC++: void Close() override;\n\nClose the connection to the database.\n"},
  {"IsOpen", PyvtkODBCDatabase_IsOpen, METH_VARARGS,
   "IsOpen(self) -> bool\nC++: bool IsOpen() override;\n\nReturn whether the database has an open connection\n"},
  {"GetQueryInstance", PyvtkODBCDatabase_GetQueryInstance, METH_VARARGS,
   "GetQueryInstance(self) -> vtkSQLQuery\nC++: vtkSQLQuery *GetQueryInstance() override;\n\nReturn an empty query on this database.\n"},
  {"GetLastErrorText", PyvtkODBCDatabase_GetLastErrorText, METH_VARARGS,
   "GetLastErrorText(self) -> str\nC++: const char *GetLastErrorText() override;\n\nGet the last error text from the database\n"},
  {"GetTables", PyvtkODBCDatabase_GetTables, METH_VARARGS,
   "GetTables(self) -> vtkStringArray\nC++: vtkStringArray *GetTables() override;\n\nGet the list of tables from the database\n"},
  {"GetRecord", PyvtkODBCDatabase_GetRecord, METH_VARARGS,
   "GetRecord(self, table:str) -> vtkStringArray\nC++: vtkStringArray *GetRecord(const char *table) override;\n\nGet the list of fields for a particular table\n"},
  {"IsSupported", PyvtkODBCDatabase_IsSupported, METH_VARARGS,
   "IsSupported(self, feature:int) -> bool\nC++: bool IsSupported(int feature) override;\n\nReturn whether a feature is supported by the database.\n"},
  {"SetDataSourceName", PyvtkODBCDatabase_SetDataSourceName, METH_VARARGS,
   "SetDataSourceName(self, _arg:str) -> None\nC++: virtual void SetDataSourceName(const char *_arg)\n\nSet the data source name.  For ODBC connections this will be\nsomething listed in odbc.ini.  The location of that file varies\nwildly based on system, ODBC library, and installation.  Good\nluck.\n"},
  {"GetDataSourceName", PyvtkODBCDatabase_GetDataSourceName, METH_VARARGS,
   "GetDataSourceName(self) -> str\nC++: virtual char *GetDataSourceName()\n\n"},
  {"SetServerPort", PyvtkODBCDatabase_SetServerPort, METH_VARARGS,
   "SetServerPort(self, _arg:int) -> None\nC++: virtual void SetServerPort(int _arg)\n\n"},
  {"SetHostName", PyvtkODBCDatabase_SetHostName, METH_VARARGS,
   "SetHostName(self, _arg:str) -> None\nC++: virtual void SetHostName(const char *_arg)\n\n"},
  {"SetUserName", PyvtkODBCDatabase_SetUserName, METH_VARARGS,
   "SetUserName(self, _arg:str) -> None\nC++: virtual void SetUserName(const char *_arg)\n\n"},
  {"SetDatabaseName", PyvtkODBCDatabase_SetDatabaseName, METH_VARARGS,
   "SetDatabaseName(self, _arg:str) -> None\nC++: virtual void SetDatabaseName(const char *_arg)\n\n"},
  {"GetDatabaseName", PyvtkODBCDatabase_GetDatabaseName, METH_VARARGS,
   "GetDatabaseName(self) -> str\nC++: virtual char *GetDatabaseName()\n\n"},
  {"SetPassword", PyvtkODBCDatabase_SetPassword, METH_VARARGS,
   "SetPassword(self, _arg:str) -> None\nC++: virtual void SetPassword(const char *_arg)\n\n"},
  {"HasError", PyvtkODBCDatabase_HasError, METH_VARARGS,
   "HasError(self) -> bool\nC++: bool HasError() override;\n\nDid the last operation generate an error\n"},
  {"GetDatabaseType", PyvtkODBCDatabase_GetDatabaseType, METH_VARARGS,
   "GetDatabaseType(self) -> str\nC++: const char *GetDatabaseType() override;\n\nString representing database type (e.g. \"ODBC\").\n"},
  {"GetURL", PyvtkODBCDatabase_GetURL, METH_VARARGS,
   "GetURL(self) -> str\nC++: vtkStdString GetURL() override;\n\nGet the URL of the database.\n"},
  {"GetColumnSpecification", PyvtkODBCDatabase_GetColumnSpecification, METH_VARARGS,
   "GetColumnSpecification(self, schema:vtkSQLDatabaseSchema,\n    tblHandle:int, colHandle:int) -> str\nC++: vtkStdString GetColumnSpecification(\n    vtkSQLDatabaseSchema *schema, int tblHandle, int colHandle)\n    override;\n\nReturn the SQL string with the syntax to create a column inside a \"CREATE\nTABLE\" SQL statement. NB2: if a column has type SERIAL in the\nschema, this will be turned into INT NOT nullptr. Therefore, one\nshould not pass NOT nullptr as an attribute of a column whose\ntype is SERIAL.\n"},
  {"GetIndexSpecification", PyvtkODBCDatabase_GetIndexSpecification, METH_VARARGS,
   "GetIndexSpecification(self, schema:vtkSQLDatabaseSchema,\n    tblHandle:int, idxHandle:int, skipped:bool) -> str\nC++: vtkStdString GetIndexSpecification(\n    vtkSQLDatabaseSchema *schema, int tblHandle, int idxHandle,\n    bool &skipped) override;\n\nReturn the SQL string with the syntax to create an index inside a \"CREATE\nTABLE\" SQL statement.\n"},
  {"CreateDatabase", PyvtkODBCDatabase_CreateDatabase, METH_VARARGS,
   "CreateDatabase(self, dbName:str, dropExisting:bool) -> bool\nC++: bool CreateDatabase(const char *dbName, bool dropExisting)\n\nCreate a new database, optionally dropping any existing database\nof the same name. Returns true when the database is properly\ncreated and false on failure.\n"},
  {"DropDatabase", PyvtkODBCDatabase_DropDatabase, METH_VARARGS,
   "DropDatabase(self, dbName:str) -> bool\nC++: bool DropDatabase(const char *dbName)\n\nDrop a database if it exists. Returns true on success and false\non failure.\n"},
  {"ParseURL", PyvtkODBCDatabase_ParseURL, METH_VARARGS,
   "ParseURL(self, url:str) -> bool\nC++: bool ParseURL(const char *url) override;\n\nThis will only handle URLs of the form\nodbc://[user@]datsourcename[:port]/[dbname].  Anything more\ncomplicated than that needs to be set up manually.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkODBCDatabase_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("data_source_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetDataSourceName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkODBCDatabase_SetDataSourceName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkODBCDatabase_SetDataSourceName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataSourceName/SetDataSourceName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_port"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkODBCDatabase_SetServerPort(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkODBCDatabase_SetServerPort(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetServerPort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("host_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkODBCDatabase_SetHostName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkODBCDatabase_SetHostName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHostName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkODBCDatabase_SetUserName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkODBCDatabase_SetUserName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUserName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("database_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetDatabaseName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkODBCDatabase_SetDatabaseName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkODBCDatabase_SetDatabaseName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDatabaseName/SetDatabaseName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("password"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkODBCDatabase_SetPassword(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkODBCDatabase_SetPassword(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPassword\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_error_text"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetLastErrorText(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastErrorText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("database_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetDatabaseType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDatabaseType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("query_instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetQueryInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetQueryInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tables"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetTables(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTables\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("url"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkODBCDatabase_GetURL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetURL\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkODBCDatabase_Doc =
  "vtkODBCDatabase - maintain an ODBC connection to a SQL database\n\n"
  "Superclass: vtkSQLDatabase\n\n"
  "ODBC is a standard for connecting to an SQL database regardless of\n"
  "vendor or implementation.  In order to make it work you need two\n"
  "separate pices of software: a driver manager and then a\n"
  "database-specific driver.  On Windows, the driver manager is built\n"
  "into the OS.  On Unix platforms, the open-source packages iODBC and\n"
  "unixODBC will do the job.  Mac OS X has its own driver manager and\n"
  "can also use the open-source packages.  Database-specific drivers\n"
  "must be obtained from the entity that makes the database(s) you use.\n\n"
  "Unlike the other VTK database drivers, ODBC can read its parameters\n"
  "from a configuration file (odbc.ini).  That file can define an entire\n"
  "set of connection parameters and give it a single name called a data\n"
  "source name (DSN).  Writing and maintaining odbc.ini files is beyond\n"
  "the scope of this header file.\n\n"
  "@warning\n"
  "The password supplied as an argument to the Open call will override\n"
  "whatever password is set (if any) in the DSN definition.  To use the\n"
  "password from the DSN definition, pass in nullptr for the password\n"
  "argument.\n\n"
  "@warning\n"
  "Also, vtkSQLDatabase::CreateFromURL() will only handle URLs of the\n"
  "following form for ODBC:\n\n"
  "@warning\n"
  "odbc://[user@]datsourcename[:port]/[dbname]\n\n"
  "@warning\n"
  "Anything more complicated than that needs to be set up manually.\n\n"
  "@warning\n"
  "Finally, this class does not yet support the schema API present in\n"
  "the SQLite, MySQL and PostgreSQL drivers.  Those functions will be\n"
  "added once the bare-bones driver has been successfully integrated\n"
  "into VTK.\n\n"
  "@sa\n"
  "vtkODBCQuery\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkODBCDatabase_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOODBC.vtkODBCDatabase", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkODBCDatabase_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkODBCDatabase_StaticNew()
{
  return vtkODBCDatabase::New();
}

PyObject *PyvtkODBCDatabase_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkODBCDatabase_Type, PyvtkODBCDatabase_Methods,
    "vtkODBCDatabase",
 &PyvtkODBCDatabase_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSQLDatabase");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkODBCDatabase_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkODBCDatabase(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkODBCDatabase_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkODBCDatabase", o) != 0)
  {
    Py_DECREF(o);
  }

}

