// python wrapper for vtkPOpenFOAMReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPOpenFOAMReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPOpenFOAMReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPOpenFOAMReader_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPOpenFOAMReader_caseType_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOParallel.vtkPOpenFOAMReader.caseType", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPOpenFOAMReader_caseType_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPOpenFOAMReader_caseType_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPOpenFOAMReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPOpenFOAMReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPOpenFOAMReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPOpenFOAMReader *tempr = vtkPOpenFOAMReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPOpenFOAMReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPOpenFOAMReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPOpenFOAMReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPOpenFOAMReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_SetCaseType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCaseType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCaseType(temp0);
    }
    else
    {
      op->vtkPOpenFOAMReader::SetCaseType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_GetCaseType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCaseType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef vtkPOpenFOAMReader::caseType tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetCaseType() :
      op->vtkPOpenFOAMReader::GetCaseType());

    if (!ap.ErrorOccurred())
    {
      result = PyvtkPOpenFOAMReader_caseType_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_SetReadAllFilesToDetermineStructure(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReadAllFilesToDetermineStructure");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReadAllFilesToDetermineStructure(temp0);
    }
    else
    {
      op->vtkPOpenFOAMReader::SetReadAllFilesToDetermineStructure(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_GetReadAllFilesToDetermineStructure(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReadAllFilesToDetermineStructure");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReadAllFilesToDetermineStructure() :
      op->vtkPOpenFOAMReader::GetReadAllFilesToDetermineStructure());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_ReadAllFilesToDetermineStructureOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadAllFilesToDetermineStructureOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReadAllFilesToDetermineStructureOn();
    }
    else
    {
      op->vtkPOpenFOAMReader::ReadAllFilesToDetermineStructureOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_ReadAllFilesToDetermineStructureOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadAllFilesToDetermineStructureOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReadAllFilesToDetermineStructureOff();
    }
    else
    {
      op->vtkPOpenFOAMReader::ReadAllFilesToDetermineStructureOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkPOpenFOAMReader::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkPOpenFOAMReader::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPOpenFOAMReader_ComputeProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPOpenFOAMReader *op = static_cast<vtkPOpenFOAMReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->ComputeProgress() :
      op->vtkPOpenFOAMReader::ComputeProgress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPOpenFOAMReader_Methods[] = {
  {"IsTypeOf", PyvtkPOpenFOAMReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPOpenFOAMReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPOpenFOAMReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPOpenFOAMReader\nC++: static vtkPOpenFOAMReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPOpenFOAMReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPOpenFOAMReader\nC++: vtkPOpenFOAMReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPOpenFOAMReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPOpenFOAMReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetCaseType", PyvtkPOpenFOAMReader_SetCaseType, METH_VARARGS,
   "SetCaseType(self, t:int) -> None\nC++: void SetCaseType(int t)\n\nSet and get case type. 0 = decomposed case, 1 = reconstructed\ncase.\n"},
  {"GetCaseType", PyvtkPOpenFOAMReader_GetCaseType, METH_VARARGS,
   "GetCaseType(self) -> caseType\nC++: virtual caseType GetCaseType()\n\n"},
  {"SetReadAllFilesToDetermineStructure", PyvtkPOpenFOAMReader_SetReadAllFilesToDetermineStructure, METH_VARARGS,
   "SetReadAllFilesToDetermineStructure(self, __a:bool) -> None\nC++: void SetReadAllFilesToDetermineStructure(bool)\n\nWhen set to false, the reader will read only the first proc\ndirectory to determine the structure, and assume all files have\nthe same structure, i.e. same blocks and arrays.\n\nWhen set to true (default) the reader will read all proc\ndirectories to determine structure of the dataset because some\nfiles might have certain blocks that other files don't have.\n"},
  {"GetReadAllFilesToDetermineStructure", PyvtkPOpenFOAMReader_GetReadAllFilesToDetermineStructure, METH_VARARGS,
   "GetReadAllFilesToDetermineStructure(self) -> bool\nC++: virtual bool GetReadAllFilesToDetermineStructure()\n\n"},
  {"ReadAllFilesToDetermineStructureOn", PyvtkPOpenFOAMReader_ReadAllFilesToDetermineStructureOn, METH_VARARGS,
   "ReadAllFilesToDetermineStructureOn(self) -> None\nC++: virtual void ReadAllFilesToDetermineStructureOn()\n\n"},
  {"ReadAllFilesToDetermineStructureOff", PyvtkPOpenFOAMReader_ReadAllFilesToDetermineStructureOff, METH_VARARGS,
   "ReadAllFilesToDetermineStructureOff(self) -> None\nC++: virtual void ReadAllFilesToDetermineStructureOff()\n\n"},
  {"SetController", PyvtkPOpenFOAMReader_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nSet and get the controller.\n"},
  {"GetController", PyvtkPOpenFOAMReader_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"ComputeProgress", PyvtkPOpenFOAMReader_ComputeProgress, METH_VARARGS,
   "ComputeProgress(self) -> float\nC++: double ComputeProgress() override;\n\nCompute the progress of the reader.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPOpenFOAMReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("case_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPOpenFOAMReader_SetCaseType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPOpenFOAMReader_SetCaseType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCaseType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("read_all_files_to_determine_structure"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPOpenFOAMReader_GetReadAllFilesToDetermineStructure(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPOpenFOAMReader_SetReadAllFilesToDetermineStructure(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPOpenFOAMReader_SetReadAllFilesToDetermineStructure(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReadAllFilesToDetermineStructure/SetReadAllFilesToDetermineStructure\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPOpenFOAMReader_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPOpenFOAMReader_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPOpenFOAMReader_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("case_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPOpenFOAMReader_GetCaseType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCaseType\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPOpenFOAMReader_Doc =
  "vtkPOpenFOAMReader - reads a decomposed dataset in OpenFOAM format\n\n"
  "Superclass: vtkOpenFOAMReader\n\n"
  "vtkPOpenFOAMReader creates a multiblock dataset. It reads\n"
  "parallel-decomposed mesh information and time dependent data.  The\n"
  "polyMesh folders contain mesh information. The time folders contain\n"
  "transient data for the cells. Each folder can contain any number of\n"
  "data files.\n\n"
  "@par Thanks: This class was developed by Takuya Oshima at Niigata\n"
  "University, Japan (oshima@eng.niigata-u.ac.jp).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPOpenFOAMReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOParallel.vtkPOpenFOAMReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPOpenFOAMReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPOpenFOAMReader_StaticNew()
{
  return vtkPOpenFOAMReader::New();
}

PyObject *PyvtkPOpenFOAMReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPOpenFOAMReader_Type, PyvtkPOpenFOAMReader_Methods,
    "vtkPOpenFOAMReader",
 &PyvtkPOpenFOAMReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkOpenFOAMReader");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPOpenFOAMReader_caseType_Type);
  PyVTKEnum_Add(&PyvtkPOpenFOAMReader_caseType_Type, "vtkPOpenFOAMReader.caseType");

  o = (PyObject *)&PyvtkPOpenFOAMReader_caseType_Type;
  if (PyDict_SetItemString(d, "caseType", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkPOpenFOAMReader::caseType cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "DECOMPOSED_CASE", vtkPOpenFOAMReader::DECOMPOSED_CASE },
        { "RECONSTRUCTED_CASE", vtkPOpenFOAMReader::RECONSTRUCTED_CASE },
      };

    o = PyvtkPOpenFOAMReader_caseType_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPOpenFOAMReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPOpenFOAMReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPOpenFOAMReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPOpenFOAMReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

