// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkLineIntegralConvolution2D_EE.h"

const char *vtkLineIntegralConvolution2D_EE =
"//VTK::System::Dec\n"
"\n"
"\n"
"// high-pass filter stage employed by vtkLineIntegralConvolution2D\n"
"// between LIC pass 1 and LIC pass 2. filtered LIC pass 1, becomes\n"
"// noise for pass2.\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"uniform sampler2D texLIC; // most recent lic pass\n"
"uniform float     uDx;    // fragment size\n"
"uniform float     uDy;    // fragment size\n"
"\n"
"in vec2 tcoordVC;\n"
"\n"
"// kernel for simple laplace edge enhancement.\n"
"// p=Laplace(p)+p\n"
"float K[9] = float[9](\n"
"  -1.0, -1.0, -1.0,\n"
"  -1.0,  9.0, -1.0,\n"
"  -1.0, -1.0, -1.0\n"
"  );\n"
"\n"
"// tex coord neighbor offsets\n"
"vec2 fragDx[9] = vec2[9](\n"
"  vec2(-uDx, uDy), vec2(0.0, uDy), vec2(uDx, uDy),\n"
"  vec2(-uDx, 0.0), vec2(0.0, 0.0), vec2(uDx, 0.0),\n"
"  vec2(-uDx,-uDy), vec2(0.0,-uDy), vec2(uDx,-uDy)\n"
"  );\n"
"\n"
"// determine if the fragment was masked\n"
"bool Masked(float val) { return val != 0.0; }\n"
"\n"
"void main(void)\n"
"{\n"
"  vec2 lictc = tcoordVC.st;\n"
"\n"
"  // compute the convolution but don't use convolved values if\n"
"  // any masked fragments on the stencil. Fragments outside\n"
"  // the valid domain are masked during initialization, and\n"
"  // texture wrap parameters are clamp to border with border\n"
"  // color that contains masked flag\n"
"  float conv = 0.0;\n"
"  bool dontUse = false;\n"
"  for (int i=0; i<9; ++i)\n"
"    {\n"
"    vec2 tc = lictc + fragDx[i];\n"
"    vec4 lic = texture2D(texLIC, tc);\n"
"    dontUse = dontUse || Masked(lic.g);\n"
"    conv = conv + K[i] * lic.r;\n"
"    }\n"
"\n"
"  if (dontUse)\n"
"    {\n"
"    gl_FragData[0] = vec4(texture2D(texLIC, lictc).rg, 0.0, 1.0);\n"
"    }\n"
"  else\n"
"    {\n"
"    conv = clamp(conv, 0.0, 1.0);\n"
"    gl_FragData[0] = vec4(conv,texture2D(texLIC, lictc).g, 0.0, 1.0);\n"
"    }\n"
"\n"
"}\n"
"";
