// java wrapper for vtkArchiver object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArchiver.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArchiver_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArchiver",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArchiver_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArchiver_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArchiver_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArchiver_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArchiver_GetArchiveName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArchiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArchiver_SetArchiveName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArchiveName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArchiver_OpenArchive_16(JNIEnv* env, jobject obj)
{

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  op->OpenArchive();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArchiver_CloseArchive_17(JNIEnv* env, jobject obj)
{

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  op->CloseArchive();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArchiver_Contains_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkArchiver* op = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Contains(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkArchiver_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkArchiver::New());
}
