// java wrapper for vtkFrustum object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkFrustum.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkFrustum_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkFrustum",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFrustum_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFrustum_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFrustum_EvaluateFunction_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFrustum_EvaluateGradient_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFrustum_GetNearPlaneDistance_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearPlaneDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFrustum_SetNearPlaneDistance_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNearPlaneDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFrustum_GetHorizontalAngle_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHorizontalAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFrustum_SetHorizontalAngle_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHorizontalAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFrustum_GetVerticalAngle_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFrustum_SetVerticalAngle_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalAngle(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetTopPlane_112(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTopPlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetBottomPlane_113(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBottomPlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetRightPlane_114(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightPlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetLeftPlane_115(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftPlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFrustum_GetNearPlane_116(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearPlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFrustum_EvaluateFunction_117(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFrustum_EvaluateFunction_118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkFrustum* op = static_cast<vtkFrustum*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkFrustum_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkFrustum::New());
}
