// java wrapper for vtkHyperTree object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHyperTree.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHyperTree_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHyperTree",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTree_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTree_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_Initialize_14(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_InitializeForReader_15(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3,jobject id4,jobject id5)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkBitArray * temp3;
  vtkBitArray * temp4;
  vtkBitArray * temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id5));

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeForReader(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_BuildFromBreadthFirstOrderDescriptor_16(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkBitArray * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildFromBreadthFirstOrderDescriptor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_ComputeBreadthFirstOrderDescriptor_17(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2,jobject id3,jobject id4)
{
   unsigned int   temp0;
  vtkBitArray * temp1;
  vtkTypeInt64Array * temp2;
  vtkBitArray * temp3;
  vtkIdList * temp4;
  temp0 = id0;
  temp1 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkTypeInt64Array*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBreadthFirstOrderDescriptor(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_ComputeBreadthFirstOrderDescriptor_18(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3)
{
  vtkBitArray * temp0;
  vtkTypeInt64Array * temp1;
  vtkBitArray * temp2;
  vtkIdList * temp3;
  temp0 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkTypeInt64Array*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBreadthFirstOrderDescriptor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_CopyStructure_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHyperTree * temp0;
  temp0 = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_Freeze_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkHyperTree * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Freeze(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_SetTreeIndex_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTreeIndex(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetTreeIndex_112(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTreeIndex();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTree_GetNumberOfLevels_113(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLevels();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetNumberOfVertices_114(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVertices();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetNumberOfNodes_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetNumberOfLeaves_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLeaves();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTree_GetBranchFactor_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBranchFactor();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTree_GetDimension_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimension();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetNumberOfChildren_119(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfChildren();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_GetScale_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScale(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperTree_GetScale_121(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  double   temp20;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_CreateInstance_122(JNIEnv* env, jobject obj,jbyte id0,jbyte id1)
{
   unsigned char   temp0;
   unsigned char   temp1;
  vtkHyperTree * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateInstance(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetActualMemorySizeBytes_123(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySizeBytes();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTree_GetActualMemorySize_124(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTree_IsGlobalIndexImplicit_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsGlobalIndexImplicit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_SetGlobalIndexStart_126(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalIndexStart(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetGlobalIndexStart_127(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalIndexStart();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_SetGlobalIndexFromLocal_128(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalIndexFromLocal(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetGlobalIndexFromLocal_129(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalIndexFromLocal(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetGlobalNodeIndexMax_130(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalNodeIndexMax();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTree_IsLeaf_131(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLeaf(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTree_SubdivideLeaf_132(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
   unsigned int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SubdivideLeaf(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTree_IsTerminalNode_133(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTerminalNode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTree_GetElderChildIndex_134(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElderChildIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTree_HasScales_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTree* op = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasScales();
  return temp20;

}
