// java wrapper for vtkLandmarkTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLandmarkTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkLinearTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLandmarkTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLandmarkTransform",dType)) { return me; }
  if ((res= vtkLinearTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLandmarkTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLandmarkTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLandmarkTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLandmarkTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_SetSourceLandmarks_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceLandmarks(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_SetTargetLandmarks_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTargetLandmarks(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLandmarkTransform_GetSourceLandmarks_16(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSourceLandmarks();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLandmarkTransform_GetTargetLandmarks_17(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTargetLandmarks();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_SetMode_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_SetModeToRigidBody_19(JNIEnv* env, jobject obj)
{

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModeToRigidBody();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_SetModeToSimilarity_110(JNIEnv* env, jobject obj)
{

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModeToSimilarity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_SetModeToAffine_111(JNIEnv* env, jobject obj)
{

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModeToAffine();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLandmarkTransform_GetMode_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMode();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLandmarkTransform_GetModeAsString_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLandmarkTransform_Inverse_114(JNIEnv* env, jobject obj)
{

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLandmarkTransform_GetMTime_115(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLandmarkTransform_MakeTransform_116(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkLandmarkTransform* op = static_cast<vtkLandmarkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLandmarkTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLandmarkTransform::New());
}
