// java wrapper for vtkWindBladeReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWindBladeReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkStructuredGridAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWindBladeReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWindBladeReader",dType)) { return me; }
  if ((res= vtkStructuredGridAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindBladeReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindBladeReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindBladeReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindBladeReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_SetFilename_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilename(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWindBladeReader_GetFilename_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilename();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_SetWholeExtent_16(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWholeExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_SetWholeExtent_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWholeExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindBladeReader_GetWholeExtent_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWholeExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_SetSubExtent_19(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSubExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_SetSubExtent_110(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSubExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindBladeReader_GetSubExtent_111(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSubExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindBladeReader_GetFieldOutput_112(JNIEnv* env, jobject obj)
{
  vtkStructuredGrid * temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindBladeReader_GetBladeOutput_113(JNIEnv* env, jobject obj)
{
  vtkUnstructuredGrid * temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBladeOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindBladeReader_GetGroundOutput_114(JNIEnv* env, jobject obj)
{
  vtkStructuredGrid * temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGroundOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindBladeReader_GetNumberOfPointArrays_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWindBladeReader_GetPointArrayName_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindBladeReader_GetPointArrayStatus_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_SetPointArrayStatus_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_DisableAllPointArrays_119(JNIEnv* env, jobject obj)
{

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllPointArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindBladeReader_EnableAllPointArrays_120(JNIEnv* env, jobject obj)
{

  vtkWindBladeReader* op = static_cast<vtkWindBladeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllPointArrays();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWindBladeReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWindBladeReader::New());
}
