// java wrapper for vtkIOSSReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkIOSSReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkReaderAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkIOSSReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkIOSSReader",dType)) { return me; }
  if ((res= vtkReaderAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_AddFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ClearFileNames_15(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearFileNames();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSReader_GetFileName_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_GetNumberOfFileNames_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFileNames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetFileName_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetDatabaseTypeOverride_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDatabaseTypeOverride(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSReader_GetDatabaseTypeOverride_110(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseTypeOverride();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetDisplacementMagnitude_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementMagnitude(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIOSSReader_GetDisplacementMagnitude_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementMagnitude();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetGroupNumericVectorFieldComponents_113(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGroupNumericVectorFieldComponents(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetGroupNumericVectorFieldComponents_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGroupNumericVectorFieldComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetFieldSuffixSeparator_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldSuffixSeparator(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSReader_GetFieldSuffixSeparator_116(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldSuffixSeparator();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetScanForRelatedFiles_117(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScanForRelatedFiles(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetScanForRelatedFiles_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScanForRelatedFiles();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ScanForRelatedFilesOn_119(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScanForRelatedFilesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ScanForRelatedFilesOff_120(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScanForRelatedFilesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetFileRange_121(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetFileRange_122(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileRange(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkIOSSReader_GetFileRange_123(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetFileStride_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileStride(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_GetFileStrideMinValue_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileStrideMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_GetFileStrideMaxValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileStrideMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_GetFileStride_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileStride();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetCaching_128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCaching(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetCaching_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCaching();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_CachingOn_130(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CachingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_CachingOff_131(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CachingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetMergeExodusEntityBlocks_132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMergeExodusEntityBlocks(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetMergeExodusEntityBlocks_133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeExodusEntityBlocks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_MergeExodusEntityBlocksOn_134(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergeExodusEntityBlocksOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_MergeExodusEntityBlocksOff_135(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergeExodusEntityBlocksOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetElementAndSideIds_136(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementAndSideIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetElementAndSideIds_137(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementAndSideIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ElementAndSideIdsOn_138(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ElementAndSideIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ElementAndSideIdsOff_139(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ElementAndSideIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetGenerateFileId_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateFileId(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetGenerateFileId_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateFileId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_GenerateFileIdOn_142(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateFileIdOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_GenerateFileIdOff_143(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateFileIdOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetReadIds_144(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetReadIds_145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadIdsOn_146(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadIdsOff_147(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetRemoveUnusedPoints_148(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveUnusedPoints(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetRemoveUnusedPoints_149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveUnusedPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_RemoveUnusedPointsOn_150(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveUnusedPointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_RemoveUnusedPointsOff_151(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveUnusedPointsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetApplyDisplacements_152(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetApplyDisplacements(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetApplyDisplacements_153(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetApplyDisplacements();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ApplyDisplacementsOn_154(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyDisplacementsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ApplyDisplacementsOff_155(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyDisplacementsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetReadGlobalFields_156(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadGlobalFields(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetReadGlobalFields_157(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadGlobalFields();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadGlobalFieldsOn_158(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadGlobalFieldsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadGlobalFieldsOff_159(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadGlobalFieldsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetReadAllFilesToDetermineStructure_160(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllFilesToDetermineStructure(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetReadAllFilesToDetermineStructure_161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllFilesToDetermineStructure();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadAllFilesToDetermineStructureOn_162(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllFilesToDetermineStructureOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadAllFilesToDetermineStructureOff_163(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllFilesToDetermineStructureOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetReadQAAndInformationRecords_164(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadQAAndInformationRecords(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetReadQAAndInformationRecords_165(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadQAAndInformationRecords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadQAAndInformationRecordsOn_166(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadQAAndInformationRecordsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ReadQAAndInformationRecordsOff_167(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadQAAndInformationRecordsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetController_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetController_169(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_AddProperty_170(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddProperty(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_AddProperty_171(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1)
{
  char * temp0;
  double   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddProperty(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_AddProperty_172(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddProperty(temp0,temp1);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_RemoveProperty_173(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveProperty(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ClearProperties_174(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearProperties();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetEntityTypeIsBlock_175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEntityTypeIsBlock(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_GetEntityTypeIsSet_176(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEntityTypeIsSet(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSReader_GetDataAssemblyNodeNameForEntityType_177(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataAssemblyNodeNameForEntityType(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSReader_GetMergedEntityNameForEntityType_178(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergedEntityNameForEntityType(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEntitySelection_179(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataArraySelection * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEntitySelection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNodeBlockSelection_180(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeBlockSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEdgeBlockSelection_181(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFaceBlockSelection_182(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetElementBlockSelection_183(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetStructuredBlockSelection_184(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredBlockSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNodeSetSelection_185(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEdgeSetSelection_186(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFaceSetSelection_187(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetElementSetSelection_188(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetSideSetSelection_189(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFieldSelection_190(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataArraySelection * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldSelection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNodeBlockFieldSelection_191(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEdgeBlockFieldSelection_192(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFaceBlockFieldSelection_193(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetElementBlockFieldSelection_194(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetStructuredBlockFieldSelection_195(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNodeSetFieldSelection_196(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEdgeSetFieldSelection_197(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFaceSetFieldSelection_198(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetElementSetFieldSelection_199(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetSideSetFieldSelection_1100(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_RemoveAllEntitySelections_1101(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllEntitySelections();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_RemoveAllFieldSelections_1102(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllFieldSelections();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_RemoveAllSelections_1103(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllSelections();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEntityIdMapAsString_1104(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkStringArray * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEntityIdMapAsString(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNodeBlockIdMapAsString_1105(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeBlockIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEdgeBlockIdMapAsString_1106(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFaceBlockIdMapAsString_1107(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetElementBlockIdMapAsString_1108(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetStructuredBlockIdMapAsString_1109(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredBlockIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetNodeSetIdMapAsString_1110(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetEdgeSetIdMapAsString_1111(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetFaceSetIdMapAsString_1112(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetElementSetIdMapAsString_1113(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetSideSetIdMapAsString_1114(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetIdMapAsString();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetAssembly_1115(JNIEnv* env, jobject obj)
{
  vtkDataAssembly * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssembly();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_GetAssemblyTag_1116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyTag();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_AddSelector_1117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_ClearSelectors_1118(JNIEnv* env, jobject obj)
{

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSReader_SetSelector_1119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_GetNumberOfSelectors_1120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSReader_GetSelector_1121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_ReadMetaData_1122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadMetaData(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_ReadMesh_1123(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkDataObject * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id4));

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadMesh(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_ReadPoints_1124(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkDataObject * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id4));

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadPoints(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSReader_ReadArrays_1125(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkDataObject * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id4));

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadArrays(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_GetMTime_1126(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSReader_DoTestFilePatternMatching_1127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DoTestFilePatternMatching();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSReader_ENTITY_1ID_1128(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkIOSSReader* op = static_cast<vtkIOSSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ENTITY_ID();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkIOSSReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkIOSSReader::New());
}
