// java wrapper for vtkDICOMImageReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDICOMImageReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDICOMImageReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDICOMImageReader",dType)) { return me; }
  if ((res= vtkImageReader2_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDICOMImageReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDICOMImageReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDICOMImageReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDICOMImageReader_SetDirectoryName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectoryName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetDirectoryName_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectoryName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDICOMImageReader_GetPixelSpacing_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_GetWidth_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWidth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_GetHeight_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeight();
  return temp20;

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDICOMImageReader_GetImagePositionPatient_110(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImagePositionPatient();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDICOMImageReader_GetImageOrientationPatient_111(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageOrientationPatient();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 6);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_GetBitsAllocated_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBitsAllocated();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_GetPixelRepresentation_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelRepresentation();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_GetNumberOfComponents_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponents();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetTransferSyntaxUID_115(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferSyntaxUID();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkDICOMImageReader_GetRescaleSlope_116(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleSlope();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkDICOMImageReader_GetRescaleOffset_117(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleOffset();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetPatientName_118(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetStudyUID_119(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStudyUID();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetStudyID_120(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStudyID();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkDICOMImageReader_GetGantryAngle_121(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGantryAngle();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDICOMImageReader_CanReadFile_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetFileExtensions_123(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDICOMImageReader_GetDescriptiveName_124(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDICOMImageReader* op = static_cast<vtkDICOMImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDICOMImageReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDICOMImageReader::New());
}
