// java wrapper for vtkProp3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkProp3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkProp3D",dType)) { return me; }
  if ((res= vtkProp_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_ShallowCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetPosition_15(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetPosition_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetPosition_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_AddPosition_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_AddPosition_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetOrigin_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetOrigin_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetOrigin_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetScale_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetScale_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetScale_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetScale_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetUserTransform_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLinearTransform * temp0;
  temp0 = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetUserTransform_118(JNIEnv* env, jobject obj)
{
  vtkLinearTransform * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetUserMatrix_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetUserMatrix_120(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_GetMatrix_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_GetMatrix_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);
  env->SetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_GetModelToWorldMatrix_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetModelToWorldMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetPropertiesFromModelToWorldMatrix_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPropertiesFromModelToWorldMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_GetBounds_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetBounds_126(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetCenter_127(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetXRange_128(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetYRange_129(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetZRange_130(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProp3D_GetLength_131(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_RotateX_132(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateX(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_RotateY_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateY(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_RotateZ_134(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateZ(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_RotateWXYZ_135(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetOrientation_136(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetOrientation_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetOrientation_138(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_GetOrientation_139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrientation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp3D_GetOrientationWXYZ_140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationWXYZ();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_AddOrientation_141(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddOrientation(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_AddOrientation_142(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddOrientation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_PokeMatrix_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PokeMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_InitPathTraversal_144(JNIEnv* env, jobject obj)
{

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitPathTraversal();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetMTime_145(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetUserTransformMatrixMTime_146(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserTransformMatrixMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_ComputeMatrix_147(JNIEnv* env, jobject obj)
{

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeMatrix();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetMatrix_148(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp3D_GetIsIdentity_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIsIdentity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetCoordinateSystemToWorld_150(JNIEnv* env, jobject obj)
{

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToWorld();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetCoordinateSystemToPhysical_151(JNIEnv* env, jobject obj)
{

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToPhysical();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetCoordinateSystemToDevice_152(JNIEnv* env, jobject obj)
{

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToDevice();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetCoordinateSystem_153(JNIEnv* env, jobject obj,jint id0)
{
  vtkProp3D::CoordinateSystems   temp0;
  temp0 = static_cast<vtkProp3D::CoordinateSystems>(id0);

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystem(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp3D_GetCoordinateSystem_154(JNIEnv* env, jobject obj)
{
  vtkProp3D::CoordinateSystems   temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystem();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkProp3D_GetCoordinateSystemAsString_155(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystemAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetCoordinateSystemRenderer_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemRenderer(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp3D_GetCoordinateSystemRenderer_157(JNIEnv* env, jobject obj)
{
  vtkRenderer * temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystemRenderer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp3D_SetCoordinateSystemDevice_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemDevice(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp3D_GetCoordinateSystemDevice_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp3D* op = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystemDevice();
  return temp20;

}
