// java wrapper for vtkRenderedGraphRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderedGraphRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderedRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderedGraphRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderedGraphRepresentation",dType)) { return me; }
  if ((res= vtkRenderedRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexLabelArrayName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexLabelArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexLabelArrayName_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexLabelArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexLabelPriorityArrayName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexLabelPriorityArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexLabelPriorityArrayName_17(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexLabelPriorityArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexLabelVisibility_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexLabelVisibility_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_VertexLabelVisibilityOn_110(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->VertexLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_VertexLabelVisibilityOff_111(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->VertexLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexLabelTextProperty_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexLabelTextProperty_113(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexHoverArrayName_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexHoverArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexHoverArrayName_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexHoverArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetHideVertexLabelsOnInteraction_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHideVertexLabelsOnInteraction(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetHideVertexLabelsOnInteraction_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHideVertexLabelsOnInteraction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_HideVertexLabelsOnInteractionOn_118(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideVertexLabelsOnInteractionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_HideVertexLabelsOnInteractionOff_119(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideVertexLabelsOnInteractionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLabelArrayName_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeLabelArrayName_121(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLabelPriorityArrayName_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelPriorityArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeLabelPriorityArrayName_123(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelPriorityArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLabelVisibility_124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeLabelVisibility_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EdgeLabelVisibilityOn_126(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EdgeLabelVisibilityOff_127(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLabelTextProperty_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeLabelTextProperty_129(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeHoverArrayName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeHoverArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeHoverArrayName_131(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeHoverArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetHideEdgeLabelsOnInteraction_132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHideEdgeLabelsOnInteraction(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetHideEdgeLabelsOnInteraction_133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHideEdgeLabelsOnInteraction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_HideEdgeLabelsOnInteractionOn_134(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideEdgeLabelsOnInteractionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_HideEdgeLabelsOnInteractionOff_135(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideEdgeLabelsOnInteractionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconArrayName_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexIconArrayName_137(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexIconArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconPriorityArrayName_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconPriorityArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexIconPriorityArrayName_139(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexIconPriorityArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconVisibility_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexIconVisibility_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexIconVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_VertexIconVisibilityOn_142(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->VertexIconVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_VertexIconVisibilityOff_143(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->VertexIconVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_AddVertexIconType_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddVertexIconType(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ClearVertexIconTypes_145(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearVertexIconTypes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetUseVertexIconTypeMap_146(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseVertexIconTypeMap(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetUseVertexIconTypeMap_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseVertexIconTypeMap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_UseVertexIconTypeMapOn_148(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseVertexIconTypeMapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_UseVertexIconTypeMapOff_149(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseVertexIconTypeMapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconAlignment_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconAlignment(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexIconAlignment_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexIconAlignment();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexSelectedIcon_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexSelectedIcon(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexSelectedIcon_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexSelectedIcon();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexDefaultIcon_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexDefaultIcon(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexDefaultIcon_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexDefaultIcon();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconSelectionMode_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconSelectionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexIconSelectionMode_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexIconSelectionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconSelectionModeToSelectedIcon_158(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconSelectionModeToSelectedIcon();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconSelectionModeToSelectedOffset_159(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconSelectionModeToSelectedOffset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconSelectionModeToAnnotationIcon_160(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconSelectionModeToAnnotationIcon();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexIconSelectionModeToIgnoreSelection_161(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexIconSelectionModeToIgnoreSelection();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeIconArrayName_162(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeIconArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeIconArrayName_163(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeIconArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeIconPriorityArrayName_164(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeIconPriorityArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeIconPriorityArrayName_165(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeIconPriorityArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeIconVisibility_166(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeIconVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeIconVisibility_167(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeIconVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EdgeIconVisibilityOn_168(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeIconVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EdgeIconVisibilityOff_169(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeIconVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_AddEdgeIconType_170(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddEdgeIconType(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ClearEdgeIconTypes_171(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearEdgeIconTypes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetUseEdgeIconTypeMap_172(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseEdgeIconTypeMap(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetUseEdgeIconTypeMap_173(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseEdgeIconTypeMap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_UseEdgeIconTypeMapOn_174(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeIconTypeMapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_UseEdgeIconTypeMapOff_175(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeIconTypeMapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeIconAlignment_176(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeIconAlignment(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeIconAlignment_177(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeIconAlignment();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetColorVerticesByArray_178(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorVerticesByArray(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetColorVerticesByArray_179(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorVerticesByArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ColorVerticesByArrayOn_180(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorVerticesByArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ColorVerticesByArrayOff_181(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorVerticesByArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexColorArrayName_182(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexColorArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexColorArrayName_183(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexColorArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetColorEdgesByArray_184(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorEdgesByArray(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetColorEdgesByArray_185(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorEdgesByArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ColorEdgesByArrayOn_186(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorEdgesByArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ColorEdgesByArrayOff_187(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorEdgesByArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeColorArrayName_188(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColorArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeColorArrayName_189(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeColorArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEnableVerticesByArray_190(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableVerticesByArray(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEnableVerticesByArray_191(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableVerticesByArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EnableVerticesByArrayOn_192(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableVerticesByArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EnableVerticesByArrayOff_193(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableVerticesByArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEnabledVerticesArrayName_194(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabledVerticesArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEnabledVerticesArrayName_195(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnabledVerticesArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEnableEdgesByArray_196(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableEdgesByArray(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEnableEdgesByArray_197(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableEdgesByArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EnableEdgesByArrayOn_198(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableEdgesByArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EnableEdgesByArrayOff_199(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableEdgesByArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEnabledEdgesArrayName_1100(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabledEdgesArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEnabledEdgesArrayName_1101(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnabledEdgesArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeVisibility_1102(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeVisibility_1103(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EdgeVisibilityOn_1104(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_EdgeVisibilityOff_1105(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeSelection_1106(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSelection(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeSelection_1107(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSelection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategy_1108(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraphLayoutStrategy * temp0;
  temp0 = static_cast<vtkGraphLayoutStrategy*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetLayoutStrategy_1109(JNIEnv* env, jobject obj)
{
  vtkGraphLayoutStrategy * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayoutStrategy();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategy_1110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategy(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetLayoutStrategyName_1111(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayoutStrategyName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToRandom_1112(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToRandom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToForceDirected_1113(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToForceDirected();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToSimple2D_1114(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToSimple2D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToClustering2D_1115(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToClustering2D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToCommunity2D_1116(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToCommunity2D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToFast2D_1117(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToFast2D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToPassThrough_1118(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToPassThrough();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToCircular_1119(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToCircular();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToTree_1120(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToTree();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToCosmicTree_1121(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToCosmicTree();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToCone_1122(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToCone();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToSpanTree_1123(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToSpanTree();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToAssignCoordinates_1124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  char * temp0;
  char * temp1;
  char * temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToAssignCoordinates(temp0,temp1,temp2);
  delete[] temp0;
  delete[] temp1;
  delete[] temp2;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToTree_1125(JNIEnv* env, jobject obj,jboolean id0,jdouble id1,jdouble id2,jdouble id3)
{
  bool   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = (id0 != 0) ? true : false;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToTree(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetLayoutStrategyToCosmicTree_1126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1,jint id2,jlong id3)
{
  char * temp0;
  bool   temp1;
  int   temp2;
  long long   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;
  temp2 = id2;
  temp3 = id3;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategyToCosmicTree(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLayoutStrategy_1127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEdgeLayoutStrategy * temp0;
  temp0 = static_cast<vtkEdgeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLayoutStrategy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeLayoutStrategy_1128(JNIEnv* env, jobject obj)
{
  vtkEdgeLayoutStrategy * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLayoutStrategy();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLayoutStrategyToArcParallel_1129(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLayoutStrategyToArcParallel();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLayoutStrategyToPassThrough_1130(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLayoutStrategyToPassThrough();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLayoutStrategyToGeo_1131(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLayoutStrategyToGeo(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeLayoutStrategy_1132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLayoutStrategy(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeLayoutStrategyName_1133(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLayoutStrategyName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ApplyViewTheme_1134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewTheme * temp0;
  temp0 = static_cast<vtkViewTheme*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyViewTheme(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetGlyphType_1135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlyphType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetGlyphType_1136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlyphType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetScaling_1137(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaling(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetScaling_1138(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ScalingOn_1139(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ScalingOff_1140(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetScalingArrayName_1141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalingArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetScalingArrayName_1142(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalingArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetVertexScalarBarVisibility_1143(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexScalarBarVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexScalarBarVisibility_1144(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexScalarBarVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_SetEdgeScalarBarVisibility_1145(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeScalarBarVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeScalarBarVisibility_1146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeScalarBarVisibility();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetVertexScalarBar_1147(JNIEnv* env, jobject obj)
{
  vtkScalarBarWidget * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexScalarBar();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderedGraphRepresentation_GetEdgeScalarBar_1148(JNIEnv* env, jobject obj)
{
  vtkScalarBarWidget * temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeScalarBar();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderedGraphRepresentation_IsLayoutComplete_1149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLayoutComplete();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_UpdateLayout_1150(JNIEnv* env, jobject obj)
{

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateLayout();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderedGraphRepresentation_ComputeSelectedGraphBounds_1151(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkRenderedGraphRepresentation* op = static_cast<vtkRenderedGraphRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeSelectedGraphBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderedGraphRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderedGraphRepresentation::New());
}
