// java wrapper for vtkWebApplication object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWebApplication.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWebApplication_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWebApplication",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebApplication_SetImageEncoding_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageEncoding(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetImageEncodingMinValue_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageEncodingMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetImageEncodingMaxValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageEncodingMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetImageEncoding_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageEncoding();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebApplication_SetImageCompression_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageCompression(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetImageCompressionMinValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageCompressionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetImageCompressionMaxValue_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageCompressionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetImageCompression_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageCompression();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebApplication_SetNumberOfEncoderThreads_112(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfEncoderThreads(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebApplication_GetNumberOfEncoderThreads_113(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEncoderThreads();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_StillRender_114(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkRenderWindow * temp0;
  int   temp1;
  vtkUnsignedCharArray * temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StillRender(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_InteractiveRender_115(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkRenderWindow * temp0;
  int   temp1;
  vtkUnsignedCharArray * temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InteractiveRender(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebApplication_StillRenderToString_116(JNIEnv* env, jobject obj,jobject id0,jlong id1,jint id2)
{
  vtkRenderWindow * temp0;
   unsigned long   temp1;
  int   temp2;
  const char * temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StillRenderToString(temp0,temp1,temp2);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_StillRenderToBuffer_117(JNIEnv* env, jobject obj,jobject id0,jlong id1,jint id2)
{
  vtkRenderWindow * temp0;
   unsigned long   temp1;
  int   temp2;
  vtkUnsignedCharArray * temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StillRenderToBuffer(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebApplication_GetHasImagesBeingProcessed_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasImagesBeingProcessed(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebApplication_HandleInteractionEvent_119(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderWindow * temp0;
  vtkWebInteractionEvent * temp1;
  bool   temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkWebInteractionEvent*>(vtkJavaGetPointerFromObject(env, id1));

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HandleInteractionEvent(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebApplication_InvalidateCache_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  op->InvalidateCache(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_GetLastStillRenderToMTime_121(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastStillRenderToMTime();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebApplication_GetWebGLSceneMetaData_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  const char * temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWebGLSceneMetaData(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebApplication_GetWebGLBinaryData_123(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jint id2)
{
  vtkRenderWindow * temp0;
  char * temp1;
  int   temp2;
  const char * temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWebGLBinaryData(temp0,temp1,temp2);
  delete[] temp1;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebApplication_GetObjectIdMap_124(JNIEnv* env, jobject obj)
{
  vtkObjectIdMap * temp20;

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectIdMap();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebApplication_GetObjectId_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  std::string   temp20;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWebApplication* op = static_cast<vtkWebApplication*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectId(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWebApplication_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWebApplication::New());
}
