/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Automation.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "AutomationProtocolObjects.h"
#include <JavaScriptCore/InspectorBackendDispatcher.h>
#include <tuple>
#include <wtf/Expected.h>
#include <wtf/text/MakeString.h>
#include <wtf/text/WTFString.h>

namespace Inspector {



class AutomationBackendDispatcherHandler {
public:
    virtual void getBrowsingContexts(CommandCallback<Ref<JSON::ArrayOf<Protocol::Automation::BrowsingContext>>>&&) = 0;
    virtual void getBrowsingContext(const String& handle, CommandCallback<Ref<Protocol::Automation::BrowsingContext>>&&) = 0;
    virtual void createBrowsingContext(std::optional<Protocol::Automation::BrowsingContextPresentation>&& opt_presentationHint, CommandCallbackOf<String, Protocol::Automation::BrowsingContextPresentation>&&) = 0;
    virtual void closeBrowsingContext(const String& handle, CommandCallback<void>&&) = 0;
    virtual Inspector::CommandResult<void> deleteSession() = 0;
    virtual void switchToBrowsingContext(const String& browsingContextHandle, const String& opt_frameHandle, CommandCallback<void>&&) = 0;
    virtual void setWindowFrameOfBrowsingContext(const String& handle, RefPtr<JSON::Object>&& opt_origin, RefPtr<JSON::Object>&& opt_size, CommandCallback<void>&&) = 0;
    virtual void maximizeWindowOfBrowsingContext(const String& handle, CommandCallback<void>&&) = 0;
    virtual void hideWindowOfBrowsingContext(const String& handle, CommandCallback<void>&&) = 0;
    virtual void navigateBrowsingContext(const String& handle, const String& url, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, CommandCallback<void>&&) = 0;
    virtual void goBackInBrowsingContext(const String& handle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, CommandCallback<void>&&) = 0;
    virtual void goForwardInBrowsingContext(const String& handle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, CommandCallback<void>&&) = 0;
    virtual void reloadBrowsingContext(const String& handle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, CommandCallback<void>&&) = 0;
    virtual void waitForNavigationToComplete(const String& browsingContextHandle, const String& opt_frameHandle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, CommandCallback<void>&&) = 0;
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    virtual void inspectBrowsingContext(const String& handle, std::optional<bool>&& opt_enableAutoCapturing, CommandCallback<void>&&) = 0;
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    virtual void evaluateJavaScriptFunction(const String& browsingContextHandle, const String& opt_frameHandle, const String& function, Ref<JSON::Array>&& arguments, std::optional<bool>&& opt_expectsImplicitCallbackArgument, std::optional<bool>&& opt_forceUserGesture, std::optional<double>&& opt_callbackTimeout, CommandCallback<String>&&) = 0;
    virtual void performMouseInteraction(const String& handle, Ref<JSON::Object>&& position, Protocol::Automation::MouseButton button, Protocol::Automation::MouseInteraction interaction, Ref<JSON::Array>&& modifiers, CommandCallback<Ref<Protocol::Automation::Point>>&&) = 0;
    virtual void performKeyboardInteractions(const String& handle, Ref<JSON::Array>&& interactions, CommandCallback<void>&&) = 0;
    virtual void performInteractionSequence(const String& handle, const String& opt_frameHandle, Ref<JSON::Array>&& inputSources, Ref<JSON::Array>&& steps, CommandCallback<void>&&) = 0;
    virtual void cancelInteractionSequence(const String& handle, const String& opt_frameHandle, CommandCallback<void>&&) = 0;
    virtual void takeScreenshot(const String& handle, const String& opt_frameHandle, const String& opt_nodeHandle, std::optional<bool>&& opt_scrollIntoViewIfNeeded, std::optional<bool>&& opt_clipToViewport, CommandCallback<String>&&) = 0;
    virtual void resolveChildFrameHandle(const String& browsingContextHandle, const String& opt_frameHandle, std::optional<int>&& opt_ordinal, const String& opt_name, const String& opt_nodeHandle, CommandCallback<String>&&) = 0;
    virtual void resolveParentFrameHandle(const String& browsingContextHandle, const String& frameHandle, CommandCallback<String>&&) = 0;
    virtual void computeElementLayout(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, std::optional<bool>&& opt_scrollIntoViewIfNeeded, Protocol::Automation::CoordinateSystem coordinateSystem, CommandCallbackOf<Ref<Protocol::Automation::Rect>, RefPtr<Protocol::Automation::Point>, bool>&&) = 0;
    virtual void getComputedRole(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, CommandCallback<String>&&) = 0;
    virtual void getComputedLabel(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, CommandCallback<String>&&) = 0;
    virtual void selectOptionElement(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, CommandCallback<void>&&) = 0;
    virtual Inspector::CommandResult<bool /* result */> isShowingJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Inspector::CommandResult<void> dismissCurrentJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Inspector::CommandResult<void> acceptCurrentJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Inspector::CommandResult<String /* message */> messageOfCurrentJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Inspector::CommandResult<void> setUserInputForCurrentJavaScriptPrompt(const String& browsingContextHandle, const String& userInput) = 0;
    virtual Inspector::CommandResult<void> setFilesToSelectForFileUpload(const String& browsingContextHandle, Ref<JSON::Array>&& filenames, RefPtr<JSON::Array>&& opt_fileContents) = 0;
    virtual void setFilesForInputFileUpload(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, Ref<JSON::Array>&& filenames, CommandCallback<void>&&) = 0;
    virtual void getAllCookies(const String& browsingContextHandle, CommandCallback<Ref<JSON::ArrayOf<Protocol::Automation::Cookie>>>&&) = 0;
    virtual void deleteSingleCookie(const String& browsingContextHandle, const String& cookieName, CommandCallback<void>&&) = 0;
    virtual void addSingleCookie(const String& browsingContextHandle, Ref<JSON::Object>&& cookie, CommandCallback<void>&&) = 0;
    virtual Inspector::CommandResult<void> deleteAllCookies(const String& browsingContextHandle) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Automation::SessionPermissionData>> /* permissions */> getSessionPermissions() = 0;
    virtual Inspector::CommandResult<void> setSessionPermissions(Ref<JSON::Array>&& permissions) = 0;
    virtual Inspector::CommandResult<String /* authenticatorId */> addVirtualAuthenticator(const String& browsingContextHandle, Ref<JSON::Object>&& authenticator) = 0;
    virtual Inspector::CommandResult<void> removeVirtualAuthenticator(const String& browsingContextHandle, const String& authenticatorId) = 0;
    virtual Inspector::CommandResult<void> addVirtualAuthenticatorCredential(const String& browsingContextHandle, const String& authenticatorId, Ref<JSON::Object>&& credential) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Automation::VirtualAuthenticatorCredential>> /* credentials */> getVirtualAuthenticatorCredentials(const String& browsingContextHandle, const String& authenticatorId) = 0;
    virtual Inspector::CommandResult<void> removeVirtualAuthenticatorCredential(const String& browsingContextHandle, const String& authenticatorId, const String& credentialId) = 0;
    virtual Inspector::CommandResult<void> removeAllVirtualAuthenticatorCredentials(const String& browsingContextHandle, const String& authenticatorId) = 0;
    virtual Inspector::CommandResult<void> setVirtualAuthenticatorUserVerified(const String& browsingContextHandle, const String& authenticatorId, bool isUserVerified) = 0;
    virtual Inspector::CommandResult<void> generateTestReport(const String& browsingContextHandle, const String& message, const String& group) = 0;
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    virtual void loadWebExtension(Protocol::Automation::WebExtensionResourceOptions type, const String& value, CommandCallback<String>&&) = 0;
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    virtual void unloadWebExtension(const String& identifier, CommandCallback<void>&&) = 0;
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
#if ENABLE(WEBDRIVER_BIDI)
    virtual Inspector::CommandResult<void> processBidiMessage(const String& message) = 0;
#endif // ENABLE(WEBDRIVER_BIDI)
protected:
    virtual ~AutomationBackendDispatcherHandler();
};

class AutomationBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AutomationBackendDispatcher> create(BackendDispatcher&, AutomationBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getBrowsingContexts(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void closeBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteSession(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void switchToBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setWindowFrameOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void maximizeWindowOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideWindowOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void navigateBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void goBackInBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void goForwardInBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void reloadBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void waitForNavigationToComplete(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    void inspectBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    void evaluateJavaScriptFunction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performMouseInteraction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performKeyboardInteractions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performInteractionSequence(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void cancelInteractionSequence(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void takeScreenshot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveChildFrameHandle(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveParentFrameHandle(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void computeElementLayout(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getComputedRole(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getComputedLabel(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void selectOptionElement(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void isShowingJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void dismissCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void acceptCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void messageOfCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setUserInputForCurrentJavaScriptPrompt(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setFilesToSelectForFileUpload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setFilesForInputFileUpload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteSingleCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addSingleCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSessionPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setSessionPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addVirtualAuthenticator(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeVirtualAuthenticator(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addVirtualAuthenticatorCredential(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getVirtualAuthenticatorCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeVirtualAuthenticatorCredential(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeAllVirtualAuthenticatorCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setVirtualAuthenticatorUserVerified(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void generateTestReport(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    void loadWebExtension(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    void unloadWebExtension(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
#if ENABLE(WEBDRIVER_BIDI)
    void processBidiMessage(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // ENABLE(WEBDRIVER_BIDI)
private:
    AutomationBackendDispatcher(BackendDispatcher&, AutomationBackendDispatcherHandler*);
    AutomationBackendDispatcherHandler* m_agent { nullptr };
};

} // namespace Inspector
