/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedWebDriverBidiDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "WebDriverBidiBackendDispatchers.h"

#include <JavaScriptCore/InspectorFrontendRouter.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/text/MakeString.h>

namespace Inspector {

#if ENABLE(WEBDRIVER_BIDI)
BidiBrowserBackendDispatcherHandler::~BidiBrowserBackendDispatcherHandler() { }
#endif // ENABLE(WEBDRIVER_BIDI)
#if ENABLE(WEBDRIVER_BIDI)
BidiBrowsingContextBackendDispatcherHandler::~BidiBrowsingContextBackendDispatcherHandler() { }
#endif // ENABLE(WEBDRIVER_BIDI)
#if ENABLE(WEBDRIVER_BIDI)
BidiScriptBackendDispatcherHandler::~BidiScriptBackendDispatcherHandler() { }
#endif // ENABLE(WEBDRIVER_BIDI)
#if ENABLE(WEBDRIVER_BIDI)
BidiStorageBackendDispatcherHandler::~BidiStorageBackendDispatcherHandler() { }
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
Ref<BidiBrowserBackendDispatcher> BidiBrowserBackendDispatcher::create(BackendDispatcher& backendDispatcher, BidiBrowserBackendDispatcherHandler* agent)
{
    return adoptRef(*new BidiBrowserBackendDispatcher(backendDispatcher, agent));
}

BidiBrowserBackendDispatcher::BidiBrowserBackendDispatcher(BackendDispatcher& backendDispatcher, BidiBrowserBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("browser"_s, this);
}

void BidiBrowserBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<BidiBrowserBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "close"_s) {
        close(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "createUserContext"_s) {
        createUserContext(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "getUserContexts"_s) {
        getUserContexts(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "removeUserContext"_s) {
        removeUserContext(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'browser."_s, protocol_method, "' was not found"_s));
}

void BidiBrowserBackendDispatcher::close(long protocol_requestId, RefPtr<JSON::Object>&&)
{
    auto result = m_agent->close();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void BidiBrowserBackendDispatcher::createUserContext(long protocol_requestId, RefPtr<JSON::Object>&&)
{
    auto result = m_agent->createUserContext();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_userContext = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("userContext"_s, out_userContext);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void BidiBrowserBackendDispatcher::getUserContexts(long protocol_requestId, RefPtr<JSON::Object>&&)
{
    auto result = m_agent->getUserContexts();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_userContexts = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("userContexts"_s, WTFMove(out_userContexts));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void BidiBrowserBackendDispatcher::removeUserContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_userContext = m_backendDispatcher->getString(protocol_parameters.get(), "userContext"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browser.removeUserContext' can't be processed"_s);
        return;
    }

    m_agent->removeUserContext(in_userContext, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
Ref<BidiBrowsingContextBackendDispatcher> BidiBrowsingContextBackendDispatcher::create(BackendDispatcher& backendDispatcher, BidiBrowsingContextBackendDispatcherHandler* agent)
{
    return adoptRef(*new BidiBrowsingContextBackendDispatcher(backendDispatcher, agent));
}

BidiBrowsingContextBackendDispatcher::BidiBrowsingContextBackendDispatcher(BackendDispatcher& backendDispatcher, BidiBrowsingContextBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("browsingContext"_s, this);
}

void BidiBrowsingContextBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<BidiBrowsingContextBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (BidiBrowsingContextBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "activate"_s, &BidiBrowsingContextBackendDispatcher::activate },
        { "close"_s, &BidiBrowsingContextBackendDispatcher::close },
        { "create"_s, &BidiBrowsingContextBackendDispatcher::create },
        { "handleUserPrompt"_s, &BidiBrowsingContextBackendDispatcher::handleUserPrompt },
        { "getTree"_s, &BidiBrowsingContextBackendDispatcher::getTree },
        { "navigate"_s, &BidiBrowsingContextBackendDispatcher::navigate },
        { "reload"_s, &BidiBrowsingContextBackendDispatcher::reload },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'browsingContext."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void BidiBrowsingContextBackendDispatcher::activate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_context = m_backendDispatcher->getString(protocol_parameters.get(), "context"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.activate' can't be processed"_s);
        return;
    }

    m_agent->activate(in_context, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiBrowsingContextBackendDispatcher::close(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_context = m_backendDispatcher->getString(protocol_parameters.get(), "context"_s, true);
    auto in_opt_promptUnload = m_backendDispatcher->getBoolean(protocol_parameters.get(), "promptUnload"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.close' can't be processed"_s);
        return;
    }

    m_agent->close(in_context, WTFMove(in_opt_promptUnload), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiBrowsingContextBackendDispatcher::create(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_type_json = m_backendDispatcher->getString(protocol_parameters.get(), "type"_s, true);
    auto in_opt_referenceContext = m_backendDispatcher->getString(protocol_parameters.get(), "referenceContext"_s, false);
    auto in_opt_background = m_backendDispatcher->getBoolean(protocol_parameters.get(), "background"_s, false);
    auto in_opt_userContext = m_backendDispatcher->getString(protocol_parameters.get(), "userContext"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.create' can't be processed"_s);
        return;
    }

    auto in_type = Protocol::WebDriverBidiHelpers::parseEnumValueFromString<Protocol::BidiBrowsingContext::CreateType>(in_type_json);
    if (!in_type) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown type: "_s, in_type_json));
        return;
    }

    m_agent->create(*in_type, in_opt_referenceContext, WTFMove(in_opt_background), in_opt_userContext, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_context = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("context"_s, out_context);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiBrowsingContextBackendDispatcher::handleUserPrompt(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_context = m_backendDispatcher->getString(protocol_parameters.get(), "context"_s, true);
    auto in_opt_accept = m_backendDispatcher->getBoolean(protocol_parameters.get(), "accept"_s, false);
    auto in_opt_userText = m_backendDispatcher->getString(protocol_parameters.get(), "userText"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.handleUserPrompt' can't be processed"_s);
        return;
    }

    m_agent->handleUserPrompt(in_context, WTFMove(in_opt_accept), in_opt_userText, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiBrowsingContextBackendDispatcher::getTree(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_root = m_backendDispatcher->getString(protocol_parameters.get(), "root"_s, false);
    auto in_opt_maxDepth = m_backendDispatcher->getDouble(protocol_parameters.get(), "maxDepth"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.getTree' can't be processed"_s);
        return;
    }

    m_agent->getTree(in_opt_root, WTFMove(in_opt_maxDepth), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<JSON::ArrayOf<Protocol::BidiBrowsingContext::Info>>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_contexts = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setArray("contexts"_s, WTFMove(out_contexts));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiBrowsingContextBackendDispatcher::navigate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_context = m_backendDispatcher->getString(protocol_parameters.get(), "context"_s, true);
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_opt_wait_json = m_backendDispatcher->getString(protocol_parameters.get(), "wait"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.navigate' can't be processed"_s);
        return;
    }

    auto in_opt_wait = Protocol::WebDriverBidiHelpers::parseEnumValueFromString<Protocol::BidiBrowsingContext::ReadinessState>(in_opt_wait_json);

    m_agent->navigate(in_context, in_url, WTFMove(in_opt_wait), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<String, String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_url, out_opt_navigation] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("url"_s, out_url);
        if (!!out_opt_navigation)
            protocol_jsonMessage->setString("navigation"_s, out_opt_navigation);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiBrowsingContextBackendDispatcher::reload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_context = m_backendDispatcher->getString(protocol_parameters.get(), "context"_s, true);
    auto in_opt_ignoreCache = m_backendDispatcher->getBoolean(protocol_parameters.get(), "ignoreCache"_s, false);
    auto in_opt_wait_json = m_backendDispatcher->getString(protocol_parameters.get(), "wait"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'browsingContext.reload' can't be processed"_s);
        return;
    }

    auto in_opt_wait = Protocol::WebDriverBidiHelpers::parseEnumValueFromString<Protocol::BidiBrowsingContext::ReadinessState>(in_opt_wait_json);

    m_agent->reload(in_context, WTFMove(in_opt_ignoreCache), WTFMove(in_opt_wait), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<String, String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_url, out_opt_navigation] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("url"_s, out_url);
        if (!!out_opt_navigation)
            protocol_jsonMessage->setString("navigation"_s, out_opt_navigation);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
Ref<BidiScriptBackendDispatcher> BidiScriptBackendDispatcher::create(BackendDispatcher& backendDispatcher, BidiScriptBackendDispatcherHandler* agent)
{
    return adoptRef(*new BidiScriptBackendDispatcher(backendDispatcher, agent));
}

BidiScriptBackendDispatcher::BidiScriptBackendDispatcher(BackendDispatcher& backendDispatcher, BidiScriptBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("script"_s, this);
}

void BidiScriptBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<BidiScriptBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "callFunction"_s) {
        callFunction(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "evaluate"_s) {
        evaluate(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'script."_s, protocol_method, "' was not found"_s));
}

void BidiScriptBackendDispatcher::callFunction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_functionDeclaration = m_backendDispatcher->getString(protocol_parameters.get(), "functionDeclaration"_s, true);
    auto in_awaitPromise = m_backendDispatcher->getBoolean(protocol_parameters.get(), "awaitPromise"_s, true);
    auto in_target = m_backendDispatcher->getObject(protocol_parameters.get(), "target"_s, true);
    auto in_opt_arguments = m_backendDispatcher->getArray(protocol_parameters.get(), "arguments"_s, false);
    auto in_opt_resultOwnership_json = m_backendDispatcher->getString(protocol_parameters.get(), "resultOwnership"_s, false);
    auto in_opt_serializationOptions = m_backendDispatcher->getObject(protocol_parameters.get(), "serializationOptions"_s, false);
    auto in_opt_this = m_backendDispatcher->getObject(protocol_parameters.get(), "this"_s, false);
    auto in_opt_userActivation = m_backendDispatcher->getBoolean(protocol_parameters.get(), "userActivation"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'script.callFunction' can't be processed"_s);
        return;
    }

    auto in_opt_resultOwnership = Protocol::WebDriverBidiHelpers::parseEnumValueFromString<Protocol::BidiScript::ResultOwnership>(in_opt_resultOwnership_json);

    m_agent->callFunction(in_functionDeclaration, *in_awaitPromise, in_target.releaseNonNull(), WTFMove(in_opt_arguments), WTFMove(in_opt_resultOwnership), WTFMove(in_opt_serializationOptions), WTFMove(in_opt_this), WTFMove(in_opt_userActivation), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<Protocol::BidiScript::EvaluateResultType, String, RefPtr<Protocol::BidiScript::RemoteValue>, RefPtr<Protocol::BidiScript::ExceptionDetails>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_type, out_realm, out_opt_result, out_opt_exceptionDetails] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("type"_s, Protocol::WebDriverBidiHelpers::getEnumConstantValue(out_type));
        protocol_jsonMessage->setString("realm"_s, out_realm);
        if (!!out_opt_result)
            protocol_jsonMessage->setObject("result"_s, out_opt_result.releaseNonNull());
        if (!!out_opt_exceptionDetails)
            protocol_jsonMessage->setObject("exceptionDetails"_s, out_opt_exceptionDetails.releaseNonNull());
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiScriptBackendDispatcher::evaluate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_expression = m_backendDispatcher->getString(protocol_parameters.get(), "expression"_s, true);
    auto in_awaitPromise = m_backendDispatcher->getBoolean(protocol_parameters.get(), "awaitPromise"_s, true);
    auto in_target = m_backendDispatcher->getObject(protocol_parameters.get(), "target"_s, true);
    auto in_opt_resultOwnership_json = m_backendDispatcher->getString(protocol_parameters.get(), "resultOwnership"_s, false);
    auto in_opt_serializationOptions = m_backendDispatcher->getObject(protocol_parameters.get(), "serializationOptions"_s, false);
    auto in_opt_userActivation = m_backendDispatcher->getBoolean(protocol_parameters.get(), "userActivation"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'script.evaluate' can't be processed"_s);
        return;
    }

    auto in_opt_resultOwnership = Protocol::WebDriverBidiHelpers::parseEnumValueFromString<Protocol::BidiScript::ResultOwnership>(in_opt_resultOwnership_json);

    m_agent->evaluate(in_expression, *in_awaitPromise, in_target.releaseNonNull(), WTFMove(in_opt_resultOwnership), WTFMove(in_opt_serializationOptions), WTFMove(in_opt_userActivation), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<Protocol::BidiScript::EvaluateResultType, String, RefPtr<Protocol::BidiScript::RemoteValue>, RefPtr<Protocol::BidiScript::ExceptionDetails>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_type, out_realm, out_opt_result, out_opt_exceptionDetails] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("type"_s, Protocol::WebDriverBidiHelpers::getEnumConstantValue(out_type));
        protocol_jsonMessage->setString("realm"_s, out_realm);
        if (!!out_opt_result)
            protocol_jsonMessage->setObject("result"_s, out_opt_result.releaseNonNull());
        if (!!out_opt_exceptionDetails)
            protocol_jsonMessage->setObject("exceptionDetails"_s, out_opt_exceptionDetails.releaseNonNull());
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
Ref<BidiStorageBackendDispatcher> BidiStorageBackendDispatcher::create(BackendDispatcher& backendDispatcher, BidiStorageBackendDispatcherHandler* agent)
{
    return adoptRef(*new BidiStorageBackendDispatcher(backendDispatcher, agent));
}

BidiStorageBackendDispatcher::BidiStorageBackendDispatcher(BackendDispatcher& backendDispatcher, BidiStorageBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("storage"_s, this);
}

void BidiStorageBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<BidiStorageBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "getCookies"_s) {
        getCookies(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "setCookie"_s) {
        setCookie(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "deleteCookies"_s) {
        deleteCookies(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'storage."_s, protocol_method, "' was not found"_s));
}

void BidiStorageBackendDispatcher::getCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_filter = m_backendDispatcher->getObject(protocol_parameters.get(), "filter"_s, false);
    auto in_opt_partition = m_backendDispatcher->getObject(protocol_parameters.get(), "partition"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'storage.getCookies' can't be processed"_s);
        return;
    }

    m_agent->getCookies(WTFMove(in_opt_filter), WTFMove(in_opt_partition), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<Ref<JSON::ArrayOf<Protocol::BidiStorage::PartialCookie>>, Ref<Protocol::BidiStorage::PartitionKey>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_cookies, out_partitionKey] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setArray("cookies"_s, WTFMove(out_cookies));
        protocol_jsonMessage->setObject("partitionKey"_s, WTFMove(out_partitionKey));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiStorageBackendDispatcher::setCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_cookie = m_backendDispatcher->getObject(protocol_parameters.get(), "cookie"_s, true);
    auto in_opt_partition = m_backendDispatcher->getObject(protocol_parameters.get(), "partition"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'storage.setCookie' can't be processed"_s);
        return;
    }

    m_agent->setCookie(in_cookie.releaseNonNull(), WTFMove(in_opt_partition), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<Protocol::BidiStorage::PartitionKey>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_partitionKey = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setObject("partitionKey"_s, WTFMove(out_partitionKey));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void BidiStorageBackendDispatcher::deleteCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_filter = m_backendDispatcher->getObject(protocol_parameters.get(), "filter"_s, false);
    auto in_opt_partition = m_backendDispatcher->getObject(protocol_parameters.get(), "partition"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'storage.deleteCookies' can't be processed"_s);
        return;
    }

    m_agent->deleteCookies(WTFMove(in_opt_filter), WTFMove(in_opt_partition), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<Protocol::BidiStorage::PartitionKey>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_partitionKey = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setObject("partitionKey"_s, WTFMove(out_partitionKey));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // ENABLE(WEBDRIVER_BIDI)

} // namespace Inspector
