/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequest.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAbortSignal.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchHeaders.h"
#include "JSFetchReferrerPolicy.h"
#include "JSFetchRequest.h"
#include "JSFetchRequestCache.h"
#include "JSFetchRequestCredentials.h"
#include "JSFetchRequestDestination.h"
#include "JSFetchRequestInit.h"
#include "JSFetchRequestMode.h"
#include "JSFetchRequestRedirect.h"
#include "JSIPAddressSpace.h"
#include "JSReadableStream.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_clone);
static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_arrayBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_blob);
static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_bytes);
static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_formData);
static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_json);
static JSC_DECLARE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_text);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_method);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_url);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_headers);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_destination);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_referrer);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_referrerPolicy);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_mode);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_credentials);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_cache);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_redirect);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_integrity);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_keepalive);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_signal);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_targetAddressSpace);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_body);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchRequest_bodyUsed);

class JSFetchRequestPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFetchRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchRequestPrototype>(vm)) JSFetchRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchRequestPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchRequestPrototype, JSFetchRequestPrototype::Base);

using JSFetchRequestDOMConstructor = JSDOMConstructor<JSFetchRequest>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFetchRequestDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFetchRequestDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Request"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto inputConversionResult = convert<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (inputConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto initConversionResult = convert<IDLDictionary<FetchRequestInit>>(*lexicalGlobalObject, argument1.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = FetchRequest::create(*context, inputConversionResult.releaseReturnValue(), initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FetchRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FetchRequest>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFetchRequestDOMConstructorConstruct, JSFetchRequestDOMConstructor::construct);

template<> const ClassInfo JSFetchRequestDOMConstructor::s_info = { "Request"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchRequestDOMConstructor) };

template<> JSValue JSFetchRequestDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFetchRequestDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Request"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFetchRequest::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 24> JSFetchRequestPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequestConstructor, 0 } },
    HashTableValue { "method"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_method, 0 } },
    HashTableValue { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_url, 0 } },
    HashTableValue { "headers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_headers, 0 } },
    HashTableValue { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_destination, 0 } },
    HashTableValue { "referrer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_referrer, 0 } },
    HashTableValue { "referrerPolicy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_referrerPolicy, 0 } },
    HashTableValue { "mode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_mode, 0 } },
    HashTableValue { "credentials"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_credentials, 0 } },
    HashTableValue { "cache"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_cache, 0 } },
    HashTableValue { "redirect"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_redirect, 0 } },
    HashTableValue { "integrity"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_integrity, 0 } },
    HashTableValue { "keepalive"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_keepalive, 0 } },
    HashTableValue { "signal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_signal, 0 } },
    HashTableValue { "targetAddressSpace"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_targetAddressSpace, 0 } },
    HashTableValue { "body"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_body, 0 } },
    HashTableValue { "bodyUsed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchRequest_bodyUsed, 0 } },
    HashTableValue { "clone"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_clone, 0 } },
    HashTableValue { "arrayBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_arrayBuffer, 0 } },
    HashTableValue { "blob"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_blob, 0 } },
    HashTableValue { "bytes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_bytes, 0 } },
    HashTableValue { "formData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_formData, 0 } },
    HashTableValue { "json"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_json, 0 } },
    HashTableValue { "text"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchRequestPrototypeFunction_text, 0 } },
};

const ClassInfo JSFetchRequestPrototype::s_info = { "Request"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchRequestPrototype) };

void JSFetchRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchRequest::info(), JSFetchRequestPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().localNetworkAccessEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "targetAddressSpace"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFetchRequest::s_info = { "Request"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchRequest) };

JSFetchRequest::JSFetchRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchRequest>&& impl)
    : JSDOMWrapper<FetchRequest>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, FetchRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFetchRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFetchRequestPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFetchRequestPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFetchRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFetchRequest>(vm, globalObject);
}

JSValue JSFetchRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchRequestDOMConstructor, DOMConstructorID::FetchRequest>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFetchRequest::destroy(JSC::JSCell* cell)
{
    JSFetchRequest* thisObject = static_cast<JSFetchRequest*>(cell);
    thisObject->JSFetchRequest::~JSFetchRequest();
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchRequestPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFetchRequest::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFetchRequest_methodGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.method())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_method, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_methodGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_urlGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.urlString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_headersGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<FetchHeaders>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.headers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_headers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_headersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchRequestDestination>>(lexicalGlobalObject, throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_referrerGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.referrer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_referrer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_referrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_referrerPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchReferrerPolicy>>(lexicalGlobalObject, throwScope, impl.referrerPolicy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_referrerPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_referrerPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_modeGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchRequestMode>>(lexicalGlobalObject, throwScope, impl.mode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_mode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_modeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_credentialsGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchRequestCredentials>>(lexicalGlobalObject, throwScope, impl.credentials())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_credentials, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_credentialsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_cacheGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchRequestCache>>(lexicalGlobalObject, throwScope, impl.cache())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_cache, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_cacheGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_redirectGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchRequestRedirect>>(lexicalGlobalObject, throwScope, impl.redirect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_redirect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_redirectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_integrityGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.integrity())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_integrity, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_integrityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_keepaliveGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.keepalive())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_keepalive, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_keepaliveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_signalGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AbortSignal>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.signal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_signal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_signalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_targetAddressSpaceGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<IPAddressSpace>>>(lexicalGlobalObject, throwScope, impl.targetAddressSpace())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_targetAddressSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_targetAddressSpaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_bodyGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ReadableStream>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readableStream(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_body, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_bodyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchRequest_bodyUsedGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.bodyUsed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchRequest_bodyUsed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequest_bodyUsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_cloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFetchRequest>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<FetchRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone())));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_clone, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_cloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_arrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLArrayBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.arrayBuffer(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_arrayBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_arrayBufferBody>(*lexicalGlobalObject, *callFrame, "arrayBuffer");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_blobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<Blob>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.blob(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_blob, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_blobBody>(*lexicalGlobalObject, *callFrame, "blob");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_bytesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUint8Array>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.bytes(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_bytes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_bytesBody>(*lexicalGlobalObject, *callFrame, "bytes");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_formDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<DOMFormData>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.formData(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_formData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_formDataBody>(*lexicalGlobalObject, *callFrame, "formData");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_jsonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.json(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_json, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_jsonBody>(*lexicalGlobalObject, *callFrame, "json");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunction_textBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUSVString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.text(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchRequestPrototypeFunction_text, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunction_textBody>(*lexicalGlobalObject, *callFrame, "text");
}

JSC::GCClient::IsoSubspace* JSFetchRequest::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFetchRequest, UseCustomHeapCellType::No>(vm, "JSFetchRequest"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFetchRequest.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFetchRequest = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFetchRequest.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFetchRequest = std::forward<decltype(space)>(space); }
    );
}

void JSFetchRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFetchRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFetchRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFetchRequest = jsCast<JSFetchRequest*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsFetchRequest->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    FetchRequest* owner = &jsFetchRequest->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from FetchRequest"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSFetchRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFetchRequest = static_cast<JSFetchRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFetchRequest->protectedWrapped().ptr(), jsFetchRequest);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FetchRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12FetchRequestE[]; }
#endif
template<std::same_as<FetchRequest> T>
static inline void verifyVTable(FetchRequest* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FetchRequest@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12FetchRequestE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FetchRequest has subclasses. If FetchRequest has subclasses that get passed
        // to toJS() we currently require FetchRequest you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FetchRequest>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FetchRequest>(impl.ptr());
#endif
    return createWrapper<FetchRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FetchRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FetchRequest* JSFetchRequest::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchRequest*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
