/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemSyncAccessHandle.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<FileSystemSyncAccessHandle::FilesystemReadWriteOptions>> convertDictionary<FileSystemSyncAccessHandle::FilesystemReadWriteOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FileSystemSyncAccessHandle::FilesystemReadWriteOptions result;
    JSValue atValue;
    if (isNullOrUndefined)
        atValue = jsUndefined();
    else {
        atValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "at"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!atValue.isUndefined()) {
        auto atConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, atValue);
        if (atConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.at = atConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_truncate);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_getSize);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_flush);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_read);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_write);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemSyncAccessHandleConstructor);

class JSFileSystemSyncAccessHandlePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemSyncAccessHandlePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemSyncAccessHandlePrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemSyncAccessHandlePrototype>(vm)) JSFileSystemSyncAccessHandlePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemSyncAccessHandlePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemSyncAccessHandlePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemSyncAccessHandlePrototype, JSFileSystemSyncAccessHandlePrototype::Base);

using JSFileSystemSyncAccessHandleDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemSyncAccessHandle>;

template<> const ClassInfo JSFileSystemSyncAccessHandleDOMConstructor::s_info = { "FileSystemSyncAccessHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemSyncAccessHandleDOMConstructor) };

template<> JSValue JSFileSystemSyncAccessHandleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileSystemSyncAccessHandleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemSyncAccessHandle"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemSyncAccessHandle::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 7> JSFileSystemSyncAccessHandlePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemSyncAccessHandleConstructor, 0 } },
    HashTableValue { "truncate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemSyncAccessHandlePrototypeFunction_truncate, 1 } },
    HashTableValue { "getSize"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemSyncAccessHandlePrototypeFunction_getSize, 0 } },
    HashTableValue { "flush"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemSyncAccessHandlePrototypeFunction_flush, 0 } },
    HashTableValue { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemSyncAccessHandlePrototypeFunction_close, 0 } },
    HashTableValue { "read"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemSyncAccessHandlePrototypeFunction_read, 1 } },
    HashTableValue { "write"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemSyncAccessHandlePrototypeFunction_write, 1 } },
};

const ClassInfo JSFileSystemSyncAccessHandlePrototype::s_info = { "FileSystemSyncAccessHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemSyncAccessHandlePrototype) };

void JSFileSystemSyncAccessHandlePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemSyncAccessHandle::info(), JSFileSystemSyncAccessHandlePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemSyncAccessHandle::s_info = { "FileSystemSyncAccessHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemSyncAccessHandle) };

JSFileSystemSyncAccessHandle::JSFileSystemSyncAccessHandle(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemSyncAccessHandle>&& impl)
    : JSDOMWrapper<FileSystemSyncAccessHandle>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemSyncAccessHandle>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemSyncAccessHandle::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemSyncAccessHandlePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFileSystemSyncAccessHandlePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemSyncAccessHandle::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemSyncAccessHandle>(vm, globalObject);
}

JSValue JSFileSystemSyncAccessHandle::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemSyncAccessHandleDOMConstructor, DOMConstructorID::FileSystemSyncAccessHandle>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFileSystemSyncAccessHandle::destroy(JSC::JSCell* cell)
{
    JSFileSystemSyncAccessHandle* thisObject = static_cast<JSFileSystemSyncAccessHandle*>(cell);
    thisObject->JSFileSystemSyncAccessHandle::~JSFileSystemSyncAccessHandle();
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemSyncAccessHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemSyncAccessHandlePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemSyncAccessHandle::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemSyncAccessHandlePrototypeFunction_truncateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemSyncAccessHandle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newSizeConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument0.value());
    if (newSizeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.truncate(newSizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_truncate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemSyncAccessHandle>::call<jsFileSystemSyncAccessHandlePrototypeFunction_truncateBody>(*lexicalGlobalObject, *callFrame, "truncate");
}

static inline JSC::EncodedJSValue jsFileSystemSyncAccessHandlePrototypeFunction_getSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemSyncAccessHandle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.getSize())));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_getSize, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemSyncAccessHandle>::call<jsFileSystemSyncAccessHandlePrototypeFunction_getSizeBody>(*lexicalGlobalObject, *callFrame, "getSize");
}

static inline JSC::EncodedJSValue jsFileSystemSyncAccessHandlePrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemSyncAccessHandle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.flush(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemSyncAccessHandle>::call<jsFileSystemSyncAccessHandlePrototypeFunction_flushBody>(*lexicalGlobalObject, *callFrame, "flush");
}

static inline JSC::EncodedJSValue jsFileSystemSyncAccessHandlePrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemSyncAccessHandle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemSyncAccessHandle>::call<jsFileSystemSyncAccessHandlePrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsFileSystemSyncAccessHandlePrototypeFunction_readBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemSyncAccessHandle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufferConversionResult = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    if (bufferConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<FileSystemSyncAccessHandle::FilesystemReadWriteOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.read(bufferConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_read, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemSyncAccessHandle>::call<jsFileSystemSyncAccessHandlePrototypeFunction_readBody>(*lexicalGlobalObject, *callFrame, "read");
}

static inline JSC::EncodedJSValue jsFileSystemSyncAccessHandlePrototypeFunction_writeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemSyncAccessHandle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufferConversionResult = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    if (bufferConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<FileSystemSyncAccessHandle::FilesystemReadWriteOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.write(bufferConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemSyncAccessHandlePrototypeFunction_write, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemSyncAccessHandle>::call<jsFileSystemSyncAccessHandlePrototypeFunction_writeBody>(*lexicalGlobalObject, *callFrame, "write");
}

JSC::GCClient::IsoSubspace* JSFileSystemSyncAccessHandle::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemSyncAccessHandle, UseCustomHeapCellType::No>(vm, "JSFileSystemSyncAccessHandle"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemSyncAccessHandle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemSyncAccessHandle = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemSyncAccessHandle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemSyncAccessHandle = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemSyncAccessHandle::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemSyncAccessHandle*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemSyncAccessHandleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFileSystemSyncAccessHandle = jsCast<JSFileSystemSyncAccessHandle*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsFileSystemSyncAccessHandle->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemSyncAccessHandleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemSyncAccessHandle = static_cast<JSFileSystemSyncAccessHandle*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileSystemSyncAccessHandle->protectedWrapped().ptr(), jsFileSystemSyncAccessHandle);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileSystemSyncAccessHandle@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26FileSystemSyncAccessHandleE[]; }
#endif
template<std::same_as<FileSystemSyncAccessHandle> T>
static inline void verifyVTable(FileSystemSyncAccessHandle* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FileSystemSyncAccessHandle@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26FileSystemSyncAccessHandleE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FileSystemSyncAccessHandle has subclasses. If FileSystemSyncAccessHandle has subclasses that get passed
        // to toJS() we currently require FileSystemSyncAccessHandle you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FileSystemSyncAccessHandle>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FileSystemSyncAccessHandle>(impl.ptr());
#endif
    return createWrapper<FileSystemSyncAccessHandle>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FileSystemSyncAccessHandle& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FileSystemSyncAccessHandle* JSFileSystemSyncAccessHandle::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileSystemSyncAccessHandle*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
