/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPanningModelType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(PanningModelType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("equalpower"),
        MAKE_STATIC_STRING_IMPL("HRTF"),
    };
    static_assert(static_cast<size_t>(PanningModelType::Equalpower) == 0, "PanningModelType::Equalpower is not 0 as expected");
    static_assert(static_cast<size_t>(PanningModelType::HRTF) == 1, "PanningModelType::HRTF is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, PanningModelType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<PanningModelType> parseEnumerationFromString<PanningModelType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, PanningModelType>, 2> mappings {
        std::pair<ComparableASCIILiteral, PanningModelType> { "HRTF"_s, PanningModelType::HRTF },
        std::pair<ComparableASCIILiteral, PanningModelType> { "equalpower"_s, PanningModelType::Equalpower },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<PanningModelType> parseEnumeration<PanningModelType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<PanningModelType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<PanningModelType>()
{
    return "\"equalpower\", \"HRTF\""_s;
}

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
